/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.utils.core.parser;

import eu.fbk.eclipse.standardtools.utils.core.parser.StringInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class LazyStringInputStream
extends InputStream {
    private InputStream delegate;
    private String string;
    private String encoding;

    public LazyStringInputStream(String string) {
        this(string, Charset.defaultCharset().name());
    }

    public LazyStringInputStream(String string, Charset encoding) {
        this(string, encoding.name());
    }

    public LazyStringInputStream(String string, String encoding) {
        this.string = string;
        this.encoding = encoding;
    }

    @Override
    public int read() throws IOException {
        return this.delegate().read();
    }

    private InputStream delegate() throws IOException {
        if (this.delegate == null) {
            this.delegate = new StringInputStream(this.string, this.encoding);
        }
        return this.delegate;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.delegate().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate().read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate().skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate().available();
    }

    @Override
    public void close() throws IOException {
        this.delegate().close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.delegate().mark(readlimit);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.delegate().reset();
    }

    @Override
    public boolean markSupported() {
        try {
            return this.delegate().markSupported();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String toString() {
        return this.string;
    }

    public String getString() {
        return this.string;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

