/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.utils.ui.utils;

import eu.fbk.eclipse.standardtools.utils.Activator;
import eu.fbk.eclipse.standardtools.utils.core.exceptions.NoProjectException;
import java.io.File;
import java.util.Arrays;
import java.util.Random;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class DirectoryUtil {
    private static DirectoryUtil directoryUtilInstance;
    private static final Logger logger;
    IProject currentProject = null;

    static {
        logger = Logger.getLogger(DirectoryUtil.class);
    }

    public static DirectoryUtil getInstance() {
        if (directoryUtilInstance == null) {
            directoryUtilInstance = new DirectoryUtil();
        }
        return directoryUtilInstance;
    }

    public String getCurrentProjectDir() throws Exception {
        IProject currentProject = this.getCurrentProject();
        IPath location = currentProject.getLocation();
        logger.debug((Object)("getCurrentProjectDir: " + location.toFile().getPath()));
        return location.toFile().getPath();
    }

    public String getTempDir() {
        Random randomGenerator = new Random();
        IPath location = Activator.getDefault().getStateLocation();
        File workspaceDir = new File(location.toFile(), Long.toHexString(randomGenerator.nextLong()));
        workspaceDir.mkdir();
        logger.debug((Object)("getTempDir: " + workspaceDir.getPath()));
        return workspaceDir.getPath();
    }

    public String getCurrentProjectName() throws Exception {
        return this.getCurrentProject().getName();
    }

    private IProject[] getOpenProjects() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] allProjects = root.getProjects();
        return (IProject[])Arrays.stream(allProjects).filter(IProject::isOpen).toArray(IProject[]::new);
    }

    public IProject getCurrentProject() throws Exception {
        if (PlatformUI.isWorkbenchRunning()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page;
                    IEditorPart editor;
                    if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && (editor = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).getActiveEditor()).getEditorInput() instanceof IFileEditorInput) {
                        IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
                        IFile file = input.getFile();
                        DirectoryUtil.this.currentProject = file.getProject();
                    }
                }
            });
        } else {
            IProject[] projects = this.getOpenProjects();
            if (projects.length > 1) {
                logger.warn((Object)("More than one project is open, returning the first one: " + projects[0]));
                this.currentProject = projects[0];
            } else {
                this.currentProject = projects.length == 1 ? projects[0] : null;
            }
        }
        if (this.currentProject == null) {
            throw new NoProjectException();
        }
        return this.currentProject;
    }
}

