/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.utils.ui.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ErrorsDialogUtil {
    private static String pluginID = "eu.fbk.eclipse.standardtools.ModelTranslatorToOcra";
    private static ErrorsDialogUtil errorsDialogUtil;

    public static ErrorsDialogUtil getInstance() {
        if (errorsDialogUtil == null) {
            errorsDialogUtil = new ErrorsDialogUtil();
        }
        return errorsDialogUtil;
    }

    public void showMessage_RuntimeErrors(final String fileName, String[] errors, boolean showNoErrorPopup) {
        if (errors != null) {
            final MultiStatus info = new MultiStatus(pluginID, 1, "Some runtime errors were found. Click on \"Details\" or see the \"Problems View\" for details.", null);
            String[] stringArray = errors;
            int n = errors.length;
            int n2 = 0;
            while (n2 < n) {
                String err = stringArray[n2];
                info.add((IStatus)new Status(1, pluginID, 1, err, null));
                ++n2;
            }
            final Display defaultDisplay = Display.getDefault();
            defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell currShell = defaultDisplay.getActiveShell();
                    ErrorDialog.openError((Shell)currShell, (String)"Runtime Errors occurred", (String)("The file " + fileName + " is not correct."), (IStatus)info);
                }
            });
        } else if (showNoErrorPopup) {
            final Display defaultDisplay = Display.getDefault();
            defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell currShell = defaultDisplay.getActiveShell();
                    MessageDialog.openInformation((Shell)currShell, (String)"Info", (String)("No runtime errors were detected in the file " + fileName + "."));
                }
            });
        }
    }

    public void showMessage_NoErrors(final String fileName) {
        final Display defaultDisplay = Display.getDefault();
        defaultDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell currShell = defaultDisplay.getActiveShell();
                MessageDialog.openInformation((Shell)currShell, (String)"Info", (String)("The file " + fileName + " has no errors."));
            }
        });
    }

    public void showMessage_GenericError(final String message) {
        final Display defaultDisplay = Display.getDefault();
        if (!defaultDisplay.isDisposed()) {
            defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell currShell = defaultDisplay.getActiveShell();
                    if (currShell != null && !currShell.isDisposed()) {
                        MessageDialog.openError((Shell)currShell, (String)"Error", (String)message);
                    }
                }
            });
        }
    }
}

