/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardTools.XSapExecService.services;

import eu.fbk.eclipse.standardtools.utils.core.utils.EATAUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.CommandBuilder;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.OssToSmvExpressionConverter;
import java.util.StringJoiner;

public class XSapExecService {
    private static XSapExecService xSapExecService;

    public static XSapExecService getInstance() {
        if (xSapExecService == null) {
            xSapExecService = new XSapExecService();
        }
        return xSapExecService;
    }

    public boolean extendModel(String behaviorModel, String faultExtensions, String faultMode, String result, boolean internalExecution) {
        Object objectResult;
        block3: {
            try {
                CommandBuilder extender = CommandBuilder.build((String)"eu.fbk.tools.adapter.ui.commands.safety.ExtendModelCommand");
                extender.setParameter("fault_extensions", faultExtensions);
                extender.setParameter("behaviour_model", behaviorModel);
                extender.setParameter("result_file", result);
                extender.setParameter("fault_modes", faultMode);
                extender.setParameter("internal_execution", String.valueOf(internalExecution));
                objectResult = extender.execute();
                if (internalExecution) break block3;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return EATAUtil.isResponseAvailable((Object)objectResult);
    }

    public boolean expandFaultExtensions(String faultExtensions, String result, boolean internalExecution) {
        Object objectResult;
        block3: {
            try {
                CommandBuilder expandFault = CommandBuilder.build((String)"eu.fbk.tools.adapter.ui.commands.safety.ExpandFeiCommand");
                expandFault.setParameter("fault_extensions", faultExtensions);
                expandFault.setParameter("internal_execution", String.valueOf(internalExecution));
                expandFault.setParameter("result_file", result);
                objectResult = expandFault.execute();
                if (internalExecution) break block3;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return EATAUtil.isResponseAvailable((Object)objectResult);
    }

    public boolean computeFt(String extendedBehaviorModel, String faultMode, String ossProperties, String result, boolean internalExecution, String context) {
        return this.computeFt(extendedBehaviorModel, faultMode, ossProperties, result, internalExecution, context, "msat", 0);
    }

    public boolean computeFt(String extendedBehaviorModel, String faultMode, String ossProperties, String result, boolean internalExecution, String context, String engine, int bmcLength) {
        Object objectResult;
        block5: {
            try {
                CommandBuilder computeFt = CommandBuilder.build((String)"eu.fbk.tools.adapter.ui.commands.safety.ComputeFaultTreeCommand");
                computeFt.setParameter("behaviour_model", extendedBehaviorModel);
                computeFt.setParameter("fault_modes", faultMode);
                String properties = new OssToSmvExpressionConverter(OssToSmvExpressionConverter.OutputLanguage.SMV, context).doGenerate(ossProperties);
                computeFt.setParameter("properties", properties);
                computeFt.setParameter("result_file", result);
                if (engine != null) {
                    computeFt.setParameter("algorithm_type", engine);
                }
                if (bmcLength != 0) {
                    computeFt.setParameter("bound_length", String.valueOf(bmcLength));
                }
                computeFt.setParameter("compute_probability", String.valueOf(true));
                computeFt.setParameter("internal_execution", String.valueOf(internalExecution));
                objectResult = computeFt.execute();
                if (internalExecution) break block5;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return EATAUtil.isResponseAvailable((Object)objectResult);
    }

    public boolean computeFmea(String extendedBehaviorModel, String faultMode, String ossProperties, String result, boolean internalExecution, String context) {
        return this.computeFmea(extendedBehaviorModel, faultMode, ossProperties, result, internalExecution, context, "msat", 0, 1);
    }

    public boolean computeFmea(String extendedBehaviorModel, String faultMode, String ossProperties, String result, boolean internalExecution, String context, String engine, int bmcLength, int cardinality) {
        Object objectResult;
        block7: {
            try {
                CommandBuilder computeFmea = CommandBuilder.build((String)"eu.fbk.tools.adapter.ui.commands.safety.ComputeFmeaTableCommand");
                computeFmea.setParameter("behaviour_model", extendedBehaviorModel);
                computeFmea.setParameter("fault_modes", faultMode);
                StringJoiner properties = new StringJoiner(" ");
                String[] stringArray = ossProperties.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String condition = stringArray[n2];
                    String property = new OssToSmvExpressionConverter(OssToSmvExpressionConverter.OutputLanguage.SMV, context).doGenerate(condition);
                    properties.add("\"" + property + "\"");
                    ++n2;
                }
                computeFmea.setParameter("properties", properties.toString());
                computeFmea.setParameter("result_file", result);
                if (engine != null) {
                    computeFmea.setParameter("algorithm_type", engine);
                }
                if (bmcLength != 0) {
                    computeFmea.setParameter("bound_length", String.valueOf(bmcLength));
                }
                if (cardinality != 0) {
                    computeFmea.setParameter("cardinality", String.valueOf(cardinality));
                }
                computeFmea.setParameter("internal_execution", String.valueOf(internalExecution));
                objectResult = computeFmea.execute();
                if (internalExecution) break block7;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return EATAUtil.isResponseAvailable((Object)objectResult);
    }

    public boolean checkDiagnosability(String extendedBehaviorModel, String engine, int bmcLength, String alarmPattern, String alarmPath, String observablesPath, String condition, int delayBound, String context, boolean needMsat, boolean internalExecution) {
        Object objectResult;
        block12: {
            try {
                CommandBuilder checkDiagnosability = CommandBuilder.build((String)"eu.fbk.tools.adapter.ui.commands.safety.CheckDiagnosabilityCommand");
                if (extendedBehaviorModel != null) {
                    checkDiagnosability.setParameter("behaviour_model", extendedBehaviorModel);
                }
                if (engine != null) {
                    checkDiagnosability.setParameter("algorithm_type", engine);
                }
                if (alarmPattern != null) {
                    checkDiagnosability.setParameter("alarm_pattern", alarmPattern);
                }
                if (alarmPath != null) {
                    checkDiagnosability.setParameter("alarm_path", alarmPath);
                }
                if (observablesPath != null) {
                    checkDiagnosability.setParameter("observables", observablesPath);
                }
                if (condition != null) {
                    checkDiagnosability.setParameter("condition", condition);
                }
                if (delayBound != 0) {
                    checkDiagnosability.setParameter("delay_bound", String.valueOf(delayBound));
                }
                if (context != null) {
                    checkDiagnosability.setParameter("context", context);
                }
                checkDiagnosability.setParameter("internal_execution", String.valueOf(internalExecution));
                checkDiagnosability.setParameter("need_msat", String.valueOf(needMsat));
                if (bmcLength != 0) {
                    checkDiagnosability.setParameter("bmc_length", String.valueOf(bmcLength));
                }
                objectResult = checkDiagnosability.execute();
                if (internalExecution) break block12;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return EATAUtil.isResponseAvailable((Object)objectResult);
    }

    public boolean optimizeObservables(String extendedBehaviorModel, String engine, int bmcLength, String alarmPattern, String alarmPath, String observablesPath, String condition, int delayBound, String context, boolean needMsat, boolean internalExecution) {
        Object objectResult;
        block12: {
            try {
                CommandBuilder optimizeObservables = CommandBuilder.build((String)"eu.fbk.tools.adapter.ui.commands.safety.OptimizeObservablesCommand");
                if (extendedBehaviorModel != null) {
                    optimizeObservables.setParameter("behaviour_model", extendedBehaviorModel);
                }
                if (engine != null) {
                    optimizeObservables.setParameter("algorithm_type", engine);
                }
                if (alarmPattern != null) {
                    optimizeObservables.setParameter("alarm_pattern", alarmPattern);
                }
                if (alarmPath != null) {
                    optimizeObservables.setParameter("alarm_path", alarmPath);
                }
                if (observablesPath != null) {
                    optimizeObservables.setParameter("observables", observablesPath);
                }
                if (condition != null) {
                    optimizeObservables.setParameter("condition", condition);
                }
                if (delayBound != 0) {
                    optimizeObservables.setParameter("delay_bound", String.valueOf(delayBound));
                }
                if (context != null) {
                    optimizeObservables.setParameter("context", context);
                }
                optimizeObservables.setParameter("internal_execution", String.valueOf(internalExecution));
                optimizeObservables.setParameter("need_msat", String.valueOf(needMsat));
                if (bmcLength != 0) {
                    optimizeObservables.setParameter("bmc_length", String.valueOf(bmcLength));
                }
                objectResult = optimizeObservables.execute();
                if (internalExecution) break block12;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return EATAUtil.isResponseAvailable((Object)objectResult);
    }

    public boolean synthesizeFd(String extendedBehaviorModel, String alarmPath, String observablesPath, String outputFilePath, String compositionSemantics, boolean standAlone, boolean noDag, boolean internalExecution) {
        Object objectResult;
        block8: {
            try {
                CommandBuilder synthesizeFd = CommandBuilder.build((String)"eu.fbk.tools.adapter.ui.commands.safety.SynthesizeFdCommand");
                if (extendedBehaviorModel != null) {
                    synthesizeFd.setParameter("behaviour_model", extendedBehaviorModel);
                }
                if (alarmPath != null) {
                    synthesizeFd.setParameter("alarm_path", alarmPath);
                }
                if (observablesPath != null) {
                    synthesizeFd.setParameter("observables", observablesPath);
                }
                if (outputFilePath != null) {
                    synthesizeFd.setParameter("output_file", outputFilePath);
                }
                if (compositionSemantics != null) {
                    synthesizeFd.setParameter("composition_semantics", compositionSemantics);
                }
                synthesizeFd.setParameter("stand_alone", String.valueOf(standAlone));
                synthesizeFd.setParameter("no_dag", String.valueOf(noDag));
                synthesizeFd.setParameter("internal_execution", String.valueOf(internalExecution));
                objectResult = synthesizeFd.execute();
                if (internalExecution) break block8;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return EATAUtil.isResponseAvailable((Object)objectResult);
    }
}

