/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.sysmlv2.scoping;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class CompositeScope
implements IScope {
    protected final IScope[] childScopes;

    public static final IScope create(IScope ... scopes) {
        if (scopes.length == 0) {
            return IScope.NULLSCOPE;
        }
        return new CompositeScope(scopes);
    }

    public static final IScope create(List<IScope> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            return IScope.NULLSCOPE;
        }
        IScope[] arrayScopes = new IScope[scopes.size()];
        scopes.toArray(arrayScopes);
        return new CompositeScope(arrayScopes);
    }

    protected CompositeScope(IScope ... scopes) {
        this.childScopes = scopes;
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        IScope[] iScopeArray = this.childScopes;
        int n = this.childScopes.length;
        int n2 = 0;
        while (n2 < n) {
            IScope currScope = iScopeArray[n2];
            IEObjectDescription currResult = currScope.getSingleElement(name);
            if (currResult != null) {
                return currResult;
            }
            ++n2;
        }
        return null;
    }

    public IEObjectDescription getSingleElement(EObject object) {
        IScope[] iScopeArray = this.childScopes;
        int n = this.childScopes.length;
        int n2 = 0;
        while (n2 < n) {
            IScope currScope = iScopeArray[n2];
            IEObjectDescription currResult = currScope.getSingleElement(object);
            if (currResult != null) {
                return currResult;
            }
            ++n2;
        }
        return null;
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        return Iterables.concat(Arrays.stream(this.childScopes).map(currScope -> currScope.getElements(name)).toList());
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        return Iterables.concat(Arrays.stream(this.childScopes).map(currScope -> currScope.getElements(object)).toList());
    }

    public Iterable<IEObjectDescription> getAllElements() {
        return Iterables.concat(Arrays.stream(this.childScopes).map(IScope::getAllElements).toList());
    }
}

