/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.sysmlv2.scoping;

import com.google.inject.Inject;
import eu.fbk.sysmlv2.naming.SysMLv2QualifiedNameConverter;
import eu.fbk.sysmlv2.scoping.SysMLv2ImportNormalizer;
import eu.fbk.sysmlv2.services.SysMLv2ValueConverter;
import eu.fbk.sysmlv2.sysMLv2.Import;
import eu.fbk.sysmlv2.sysMLv2.ImportType;
import eu.fbk.sysmlv2.sysMLv2.PortDefinition;
import eu.fbk.sysmlv2.sysMLv2.SysMLv2Package;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportedNamespaceAwareLocalScopeProvider;

public class SysMLv2ImportedNamespaceAwareLocalScopeProvider
extends ImportedNamespaceAwareLocalScopeProvider {
    @Inject
    private IResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private SysMLv2QualifiedNameConverter qualifiedNameConverter;
    @Inject
    private SysMLv2ValueConverter valueConverter;
    private boolean isRootCall = true;

    protected List<ImportNormalizer> getImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        return EcoreUtil2.typeSelect((List)context.eContents(), Import.class).stream().filter(importStatement -> this.isRootCall || importStatement.getType().equals((Object)ImportType.PUBLIC)).map(importStatement -> this.createImportedNamespaceResolver(this.getImportedNamespace((EObject)importStatement), ignoreCase)).filter(Objects::nonNull).toList();
    }

    private void recursivelyComputeTransitiveImports(EObject context, boolean ignoreCase, Set<ImportNormalizer> intermediate) {
        List<ImportNormalizer> importNormalizers = this.getImportedNamespaceResolvers(context, ignoreCase);
        intermediate.addAll(importNormalizers);
        ArrayList importedEObjects = new ArrayList();
        ResourceSet resourceSet = EcoreUtil2.getResourceSet((Notifier)context);
        importNormalizers.forEach(normalizer -> {
            QualifiedName importedName = normalizer.getImportedNamespacePrefix();
            Iterator descriptions = this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet).getExportedObjects(SysMLv2Package.Literals.PACKAGE_MEMBER, importedName, ignoreCase).iterator();
            if (!descriptions.hasNext()) {
                return;
            }
            IEObjectDescription description = (IEObjectDescription)descriptions.next();
            EObject eObject = description.getEObjectOrProxy();
            if (eObject.eIsProxy()) {
                eObject = EcoreUtil.resolve((EObject)eObject, (ResourceSet)resourceSet);
            }
            if (eObject instanceof PortDefinition) {
                PortDefinition portDefinition = (PortDefinition)eObject;
                String conjugatedName = "~" + portDefinition.getName();
                QualifiedName conjugateQualifiedName = importedName.skipLast(1).append(conjugatedName);
                SysMLv2ImportNormalizer conjugateNormalizer = new SysMLv2ImportNormalizer(conjugateQualifiedName, false, ignoreCase);
                intermediate.add(conjugateNormalizer);
            }
            importedEObjects.add(eObject);
        });
        this.isRootCall = false;
        importedEObjects.forEach(e -> this.recursivelyComputeTransitiveImports((EObject)e, ignoreCase, intermediate));
    }

    protected String getImportedNamespace(EObject context) {
        if (context instanceof Import) {
            Import importStatement = (Import)context;
            QualifiedName qualifiedName = null;
            List nodes = NodeModelUtils.findNodesForFeature((EObject)importStatement, (EStructuralFeature)SysMLv2Package.Literals.IMPORT__IMPORTED_NAMESPACE);
            if (!nodes.isEmpty()) {
                String importedNamespaceString = NodeModelUtils.getTokenText((INode)((INode)nodes.get(0)));
                importedNamespaceString = (String)this.valueConverter.QualifiedName().toValue(importedNamespaceString, null);
                if (!importedNamespaceString.isEmpty()) {
                    qualifiedName = this.qualifiedNameConverter.toQualifiedName(importedNamespaceString);
                }
            }
            if (qualifiedName != null) {
                String wildcardSegment = this.qualifiedNameConverter.getDelimiter() + this.getWildCard();
                return importStatement.isWildcard() ? this.qualifiedNameConverter.toString(qualifiedName) + wildcardSegment : this.qualifiedNameConverter.toString(qualifiedName);
            }
        }
        return null;
    }

    protected IScope getLocalElementsScope(IScope parent, EObject context, EReference reference) {
        ImportNormalizer localNormalizer;
        IScope result = parent;
        ISelectable allDescriptions = this.getAllDescriptions(context.eResource());
        QualifiedName name = this.getQualifiedNameOfLocalElement(context);
        boolean ignoreCase = this.isIgnoreCase(reference);
        this.isRootCall = true;
        HashSet<ImportNormalizer> intermediate = new HashSet<ImportNormalizer>();
        this.recursivelyComputeTransitiveImports(context, ignoreCase, intermediate);
        ArrayList<ImportNormalizer> namespaceResolvers = new ArrayList<ImportNormalizer>(intermediate);
        if (!namespaceResolvers.isEmpty()) {
            if (this.isRelativeImport() && name != null && !name.isEmpty()) {
                localNormalizer = this.doCreateImportNormalizer(name, true, ignoreCase);
                result = this.createImportScope(result, Collections.singletonList(localNormalizer), allDescriptions, reference.getEReferenceType(), ignoreCase);
            }
            result = this.createImportScope(result, namespaceResolvers, null, reference.getEReferenceType(), ignoreCase);
        }
        if (name != null) {
            localNormalizer = this.doCreateImportNormalizer(name, true, ignoreCase);
            result = this.createImportScope(result, Collections.singletonList(localNormalizer), allDescriptions, reference.getEReferenceType(), ignoreCase);
        }
        return result;
    }

    protected ImportNormalizer doCreateImportNormalizer(QualifiedName importedNamespace, boolean wildcard, boolean ignoreCase) {
        return new SysMLv2ImportNormalizer(importedNamespace, wildcard, ignoreCase);
    }
}

