/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.sysmlv2.scoping;

import com.google.common.base.Function;
import com.google.common.collect.Streams;
import com.google.inject.Inject;
import eu.fbk.sysmlv2.scoping.AbstractSysMLv2ScopeProvider;
import eu.fbk.sysmlv2.scoping.CompositeScope;
import eu.fbk.sysmlv2.sysMLv2.ActionUsage;
import eu.fbk.sysmlv2.sysMLv2.AssertionAction;
import eu.fbk.sysmlv2.sysMLv2.Definition;
import eu.fbk.sysmlv2.sysMLv2.FeatureSpecialization;
import eu.fbk.sysmlv2.sysMLv2.NamedElement;
import eu.fbk.sysmlv2.sysMLv2.QualifiedNameExpression;
import eu.fbk.sysmlv2.sysMLv2.Redefinition;
import eu.fbk.sysmlv2.sysMLv2.ReferenceExpression;
import eu.fbk.sysmlv2.sysMLv2.Specialization;
import eu.fbk.sysmlv2.sysMLv2.StateUsage;
import eu.fbk.sysmlv2.sysMLv2.Subsetting;
import eu.fbk.sysmlv2.sysMLv2.SysMLv2Package;
import eu.fbk.sysmlv2.sysMLv2.Transition;
import eu.fbk.sysmlv2.sysMLv2.TriggerAction;
import eu.fbk.sysmlv2.sysMLv2.Typing;
import eu.fbk.sysmlv2.sysMLv2.Usage;
import eu.fbk.sysmlv2.sysMLv2.UsageChainExpression;
import eu.fbk.sysmlv2.sysMLv2.UsageReferenceExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.FilteringScope;

public class SysMLv2ScopeProvider
extends AbstractSysMLv2ScopeProvider {
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    private IScope getScopeForMembers(EObject object) {
        return Scopes.scopeFor((Iterable)EcoreUtil2.typeSelect((List)object.eContents(), NamedElement.class), (Function)QualifiedName.wrapper(element -> {
            QualifiedName qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)element);
            if (qualifiedName == null) {
                return null;
            }
            return qualifiedName.getLastSegment();
        }), (IScope)IScope.NULLSCOPE);
    }

    private List<IScope> recursivelyTraverseSpecializations(EObject object, boolean includeDirectChilds) {
        List specializations = EcoreUtil2.typeSelect((List)object.eContents(), FeatureSpecialization.class);
        ArrayList<IScope> scopes = new ArrayList<IScope>();
        if (includeDirectChilds) {
            scopes.add(this.getScopeForMembers(object));
        }
        specializations.stream().flatMap(s -> s.getReferences().stream().map(ReferenceExpression::getReferencedElement)).forEach(r -> {
            boolean bl = scopes.addAll(this.recursivelyTraverseSpecializations((EObject)r, true));
        });
        return scopes;
    }

    private IScope buildScopeForElement(EObject object, boolean includeDirectChilds) {
        return CompositeScope.create(this.recursivelyTraverseSpecializations(object, includeDirectChilds));
    }

    private static IScope filterObjectsInScopeKeeping(IScope scope, Class<?> ... typesToKeep) {
        return new FilteringScope(scope, description -> Arrays.stream(typesToKeep).anyMatch(t -> t.isInstance(description.getEObjectOrProxy())));
    }

    private IScope getEnrichedXtextScope(EObject context, EReference reference) {
        EObject contextContainer = context.eContainer();
        ArrayList<IScope> scopes = new ArrayList<IScope>();
        EcoreUtil2.getAllContainers((EObject)contextContainer).forEach(container -> {
            boolean bl = scopes.addAll(this.recursivelyTraverseSpecializations((EObject)container, true));
        });
        scopes.add(super.getScope(context, reference));
        return CompositeScope.create(scopes);
    }

    public IScope getScope(EObject context, EReference reference) {
        EObject eObject;
        if (context instanceof Redefinition) {
            Usage redefiningUsage = (Usage)context.eContainer();
            EObject eObject2 = redefiningUsage.eContainer();
            if (eObject2 instanceof AssertionAction) {
                AssertionAction assertionAction = (AssertionAction)eObject2;
                return this.buildScopeForElement(assertionAction.eContainer(), false);
            }
            return this.buildScopeForElement(redefiningUsage.eContainer(), false);
        }
        if (context instanceof Typing || context instanceof Specialization) {
            return SysMLv2ScopeProvider.filterObjectsInScopeKeeping(this.getEnrichedXtextScope(context, reference), Definition.class);
        }
        if (context instanceof Subsetting) {
            return SysMLv2ScopeProvider.filterObjectsInScopeKeeping(this.getEnrichedXtextScope(context, reference), Usage.class);
        }
        if (context instanceof UsageChainExpression) {
            EObject eObject3;
            ActionUsage action;
            UsageChainExpression expression = (UsageChainExpression)context;
            NamedElement body = expression.getBody().getReferencedElement();
            if (body instanceof ActionUsage && (action = (ActionUsage)body).getMembers().size() == 1 && (eObject3 = (EObject)action.getMembers().get(0)) instanceof TriggerAction) {
                TriggerAction triggerAction = (TriggerAction)eObject3;
                return Scopes.scopeFor(List.of(triggerAction.getPayload()));
            }
            return this.buildScopeForElement(body, true);
        }
        if (context instanceof UsageReferenceExpression) {
            UsageReferenceExpression ure = (UsageReferenceExpression)context;
            if (Streams.stream((Iterable)EcoreUtil2.getAllContainers((EObject)ure)).anyMatch(FeatureSpecialization.class::isInstance)) {
                return this.buildScopeForElement(((EObject)Streams.stream((Iterable)EcoreUtil2.getAllContainers((EObject)ure)).filter(FeatureSpecialization.class::isInstance).findFirst().orElse(null)).eContainer().eContainer(), true);
            }
        }
        if (context instanceof QualifiedNameExpression && (eObject = context.eContainer()) instanceof FeatureSpecialization) {
            FeatureSpecialization featureSpecialization = (FeatureSpecialization)eObject;
            return this.getScope(featureSpecialization, reference);
        }
        if (context instanceof Transition) {
            Transition transition = (Transition)context;
            if (reference == SysMLv2Package.Literals.TRANSITION__DESTINATION || reference == SysMLv2Package.Literals.TRANSITION__SOURCE) {
                StateUsage stateMachine = (StateUsage)EcoreUtil2.getContainerOfType((EObject)transition, StateUsage.class);
                return Scopes.scopeFor((Iterable)EcoreUtil2.typeSelect((List)stateMachine.getMembers(), StateUsage.class));
            }
        }
        return this.getEnrichedXtextScope(context, reference);
    }
}

