/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.sysmlv2.services;

import eu.fbk.sysmlv2.sysMLv2.Container;
import eu.fbk.sysmlv2.sysMLv2.DirectedElement;
import eu.fbk.sysmlv2.sysMLv2.Direction;
import eu.fbk.sysmlv2.sysMLv2.EntryTransition;
import eu.fbk.sysmlv2.sysMLv2.PortDefinition;
import eu.fbk.sysmlv2.sysMLv2.StateUsage;
import eu.fbk.sysmlv2.sysMLv2.SysMLv2Package;
import eu.fbk.sysmlv2.util.SysMLv2Util;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IDerivedStateComputer;

public class SysMLv2DerivedStateComputer
implements IDerivedStateComputer {
    public void installDerivedState(DerivedStateAwareResource resource, boolean preLinkingPhase) {
        this.installConjugatedPortDefinitions(resource);
        this.installEntryTransitions(resource);
    }

    public void discardDerivedState(DerivedStateAwareResource resource) {
        this.discardConjugatedPortDefinitions(resource);
        this.discardEntryTransitions(resource);
    }

    private void installConjugatedPortDefinitions(DerivedStateAwareResource resource) {
        SysMLv2DerivedStateComputer.getExplicitPortDefinitions(resource).forEach(portDefinition -> {
            PortDefinition conjugated = (PortDefinition)EcoreUtil.copy((EObject)portDefinition);
            conjugated.setName("~" + portDefinition.getName());
            EcoreUtil2.typeSelect((List)conjugated.getMembers(), DirectedElement.class).forEach(member -> {
                if (Direction.IN.equals((Object)member.getDirection())) {
                    member.setDirection(Direction.OUT);
                } else if (Direction.OUT.equals((Object)member.getDirection())) {
                    member.setDirection(Direction.IN);
                }
            });
            portDefinition.setConjugatedPortDefinition(conjugated);
            conjugated.setConjugatedPortDefinition((PortDefinition)portDefinition);
            Container container = (Container)portDefinition.eContainer();
            container.getMembers().add((Object)conjugated);
        });
    }

    private void installEntryTransitions(DerivedStateAwareResource resource) {
        EcoreUtil2.typeSelect((List)EcoreUtil2.eAllContentsAsList((Resource)resource), StateUsage.class).forEach(stateUsage -> EcoreUtil2.getAllContentsOfType((EObject)stateUsage, EntryTransition.class).forEach(transition -> transition.setSource((StateUsage)stateUsage)));
    }

    private void discardConjugatedPortDefinitions(DerivedStateAwareResource resource) {
        SysMLv2DerivedStateComputer.getExplicitPortDefinitions(resource).forEach(portDefinition -> {
            Container container = (Container)portDefinition.eContainer();
            container.getMembers().removeIf(eObject -> {
                PortDefinition portDef;
                return eObject instanceof PortDefinition && SysMLv2Util.isConjugatedPort(portDef = (PortDefinition)eObject);
            });
            portDefinition.eUnset((EStructuralFeature)SysMLv2Package.Literals.PORT_DEFINITION__CONJUGATED_PORT_DEFINITION);
        });
    }

    private void discardEntryTransitions(DerivedStateAwareResource resource) {
        EcoreUtil2.typeSelect((List)EcoreUtil2.eAllContentsAsList((Resource)resource), EntryTransition.class).stream().forEach(transition -> transition.setSource(null));
    }

    private static Stream<PortDefinition> getExplicitPortDefinitions(DerivedStateAwareResource resource) {
        return EcoreUtil2.typeSelect((List)EcoreUtil2.eAllContentsAsList((Resource)resource), PortDefinition.class).stream().filter(Predicate.not(SysMLv2Util::isConjugatedPort));
    }
}

