/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.sysmlv2.services;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.xtext.common.services.DefaultTerminalConverters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;

public class SysMLv2ValueConverter
extends DefaultTerminalConverters {
    private final IValueConverter<String> nameValueConverter = new IValueConverter<String>(){

        public String toValue(String string, INode node) {
            if (string != null && string.startsWith("'") && !string.contains(" ")) {
                return string.substring(1, string.length() - 1);
            }
            return string;
        }

        public String toString(String value) {
            if (value != null && !value.startsWith("'") && value.contains(" ")) {
                return "'" + value + "'";
            }
            return value;
        }
    };

    @ValueConverter(rule="Name")
    public IValueConverter<String> Name() {
        return this.nameValueConverter;
    }

    @ValueConverter(rule="QualifiedName")
    public IValueConverter<String> QualifiedName() {
        return new IValueConverter<String>(){

            public String toValue(String string, INode node) {
                return Arrays.stream(string.split("::")).map(name -> (String)SysMLv2ValueConverter.this.nameValueConverter.toValue(name, node)).collect(Collectors.joining("::"));
            }

            public String toString(String value) {
                return Arrays.stream(value.split("::")).map(arg_0 -> SysMLv2ValueConverter.this.nameValueConverter.toString(arg_0)).collect(Collectors.joining("::"));
            }
        };
    }

    @ValueConverter(rule="MultiplicityBound")
    public IValueConverter<Integer> MultiplicityBound() {
        return new IValueConverter<Integer>(){
            private static final String WILDCARD = "*";

            public Integer toValue(String string, INode node) throws ValueConverterException {
                if (string == null) {
                    return null;
                }
                if (WILDCARD.equals(string.trim())) {
                    return -1;
                }
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException e) {
                    throw new ValueConverterException("Couldn't convert \"" + string + "\" to int", node, (Exception)e);
                }
            }

            public String toString(Integer value) {
                if (value == -1) {
                    return WILDCARD;
                }
                return Integer.toString(value);
            }
        };
    }

    @ValueConverter(rule="STRING_VALUE")
    public IValueConverter<String> STRING_VALUE() {
        return new IValueConverter<String>(){

            public String toValue(String string, INode node) {
                if (string == null) {
                    return null;
                }
                return string.substring(1, string.length() - 1);
            }

            public String toString(String value) {
                if (value == null) {
                    return null;
                }
                return "\"" + value + "\"";
            }
        };
    }

    static /* synthetic */ IValueConverter access$0(SysMLv2ValueConverter sysMLv2ValueConverter) {
        return sysMLv2ValueConverter.nameValueConverter;
    }
}

