/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.sysmlv2.sysMLv2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ImportType implements Enumerator
{
    PRIVATE(0, "PRIVATE", "private"),
    PUBLIC(1, "PUBLIC", "public");

    public static final int PRIVATE_VALUE = 0;
    public static final int PUBLIC_VALUE = 1;
    private static final ImportType[] VALUES_ARRAY;
    public static final List<ImportType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ImportType[]{PRIVATE, PUBLIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ImportType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ImportType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ImportType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ImportType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ImportType get(int value) {
        switch (value) {
            case 0: {
                return PRIVATE;
            }
            case 1: {
                return PUBLIC;
            }
        }
        return null;
    }

    private ImportType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

