/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.sysmlv2.util;

import eu.fbk.sysmlv2.sysMLv2.ActionUsage;
import eu.fbk.sysmlv2.sysMLv2.AttributeUsage;
import eu.fbk.sysmlv2.sysMLv2.Container;
import eu.fbk.sysmlv2.sysMLv2.Definition;
import eu.fbk.sysmlv2.sysMLv2.DirectedElement;
import eu.fbk.sysmlv2.sysMLv2.ItemDefinition;
import eu.fbk.sysmlv2.sysMLv2.ItemUsage;
import eu.fbk.sysmlv2.sysMLv2.MetadataUsage;
import eu.fbk.sysmlv2.sysMLv2.Model;
import eu.fbk.sysmlv2.sysMLv2.NamedElement;
import eu.fbk.sysmlv2.sysMLv2.Package;
import eu.fbk.sysmlv2.sysMLv2.PackageMember;
import eu.fbk.sysmlv2.sysMLv2.PartDefinition;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.sysmlv2.sysMLv2.PortDefinition;
import eu.fbk.sysmlv2.sysMLv2.PortUsage;
import eu.fbk.sysmlv2.sysMLv2.ReferenceExpression;
import eu.fbk.sysmlv2.sysMLv2.StateUsage;
import eu.fbk.sysmlv2.sysMLv2.Transition;
import eu.fbk.sysmlv2.sysMLv2.TypedElement;
import eu.fbk.sysmlv2.sysMLv2.Usage;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;

public class SysMLv2Util {
    private static final String SYSTEM_COMPONENT = "SystemComponent";
    private static final String DURATIVE_TRANSITION = "DurativeTransition";
    private static final String ACTIVITY = "Activity";
    private static final String SUBSYSTEM = "Subsystem";
    private static final String EVENT = "Event";
    private static final String IS_OBSERVABLE = "IsObservable";

    private SysMLv2Util() {
        throw new AssertionError();
    }

    public static boolean isDurative(Transition transition) {
        Definition type = SysMLv2Util.getType(transition);
        return type != null && DURATIVE_TRANSITION.equals(type.getName());
    }

    public static boolean isConjugatedPort(PortDefinition portDefinition) {
        return portDefinition.getName() != null && portDefinition.getName().startsWith("~");
    }

    public static <T extends NamedElement> T getMemberByName(Container container, Class<T> type, String name) {
        return (T)((NamedElement)EcoreUtil2.typeSelect(container.getMembers(), type).stream().filter(element -> name.equals(element.getName())).findAny().orElse(null));
    }

    public static String getSpecializedDefinitionName(Definition definition) {
        if (definition.getSpecialization() != null && !definition.getSpecialization().getReferences().isEmpty() && ((ReferenceExpression)definition.getSpecialization().getReferences().get(0)).getReferencedElement() != null) {
            return ((ReferenceExpression)definition.getSpecialization().getReferences().get(0)).getReferencedElement().getName();
        }
        return null;
    }

    public static boolean partDefinitionIsActivity(PartDefinition partDefinition) {
        return ACTIVITY.equals(SysMLv2Util.getSpecializedDefinitionName(partDefinition));
    }

    public static boolean partDefinitionIsSubsystem(PartDefinition partDefinition) {
        return SUBSYSTEM.equals(SysMLv2Util.getSpecializedDefinitionName(partDefinition));
    }

    public static boolean itemDefinitionIsEvent(ItemDefinition itemDefinition) {
        return EVENT.equals(SysMLv2Util.getSpecializedDefinitionName(itemDefinition));
    }

    public static boolean itemUsageIsEvent(ItemUsage itemUsage) {
        ItemDefinition itemDefinition = (ItemDefinition)SysMLv2Util.getType(itemUsage);
        return EVENT.equals(itemDefinition.getName()) || SysMLv2Util.itemDefinitionIsEvent(itemDefinition);
    }

    public static List<Definition> getAllTypes(TypedElement element) {
        if (element.getTyping() != null) {
            return EcoreUtil2.typeSelect(element.getTyping().getReferences().stream().map(ReferenceExpression::getReferencedElement).toList(), Definition.class);
        }
        return List.of();
    }

    public static Definition getType(TypedElement element) {
        List<Definition> allTypes = SysMLv2Util.getAllTypes(element);
        return !allTypes.isEmpty() ? allTypes.get(0) : null;
    }

    public static boolean isStateMachine(StateUsage stateUsage) {
        return stateUsage.getMembers().stream().anyMatch(StateUsage.class::isInstance);
    }

    public static boolean isEvent(Usage usage) {
        return SysMLv2Util.isEventDefinition(SysMLv2Util.getType(usage));
    }

    public static boolean isEventDefinition(Definition definition) {
        if (definition instanceof ItemDefinition) {
            ItemDefinition itemDefinition = (ItemDefinition)definition;
            if (itemDefinition.getName().equals(EVENT)) {
                return true;
            }
            return EVENT.equals(SysMLv2Util.getSpecializedDefinitionName(itemDefinition));
        }
        return false;
    }

    public static DirectedElement getDataMemberFromPort(PortUsage portUsage) {
        PortDefinition portDefinition = (PortDefinition)SysMLv2Util.getType(portUsage);
        return portDefinition.getMembers().stream().filter(DirectedElement.class::isInstance).map(DirectedElement.class::cast).filter(Predicate.not(SysMLv2Util::isEvent)).findAny().orElseThrow(() -> new RuntimeException("No data type member in port definition " + portDefinition.getName()));
    }

    public static DirectedElement getEventMemberFromPort(PortUsage portUsage) {
        PortDefinition portDefinition = (PortDefinition)SysMLv2Util.getType(portUsage);
        return portDefinition.getMembers().stream().filter(DirectedElement.class::isInstance).map(DirectedElement.class::cast).filter(SysMLv2Util::isEvent).findAny().orElseThrow(() -> new RuntimeException("No event type member in port definition " + portDefinition.getName()));
    }

    public static boolean resourceBelongsToLibrary(Resource resource) {
        Package pkg;
        Model model;
        PackageMember packageMember;
        EObject eObject = (EObject)resource.getContents().get(0);
        return eObject instanceof Model && (packageMember = (PackageMember)(model = (Model)eObject).getMembers().get(0)) instanceof Package && (pkg = (Package)packageMember).isLibrary();
    }

    public static boolean containsMetadataUsagesOfType(Container container, String typeName) {
        return EcoreUtil2.typeSelect(container.getMembers(), MetadataUsage.class).stream().anyMatch(metadata -> typeName.equals(SysMLv2Util.getType(metadata).getName()));
    }

    public static boolean isObservableVariable(AttributeUsage variable) {
        return SysMLv2Util.containsMetadataUsagesOfType(variable, IS_OBSERVABLE);
    }

    private static boolean isTypeSystemComponent(Definition definition) {
        return SYSTEM_COMPONENT.equals(definition.getName()) || SYSTEM_COMPONENT.equals(SysMLv2Util.getSpecializedDefinitionName(definition));
    }

    public static boolean isSystemPartUsage(PartUsage partUsage) {
        return SysMLv2Util.getAllTypes(partUsage).stream().anyMatch(SysMLv2Util::isTypeSystemComponent);
    }

    public static boolean isSetterAction(ActionUsage actionUsage) {
        Definition type = SysMLv2Util.getType(actionUsage);
        return type != null && "Setter".equals(type.getName());
    }
}

