/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.sysmlv2.validation;

import eu.fbk.sysmlv2.sysMLv2.ActionUsage;
import eu.fbk.sysmlv2.sysMLv2.Assignment;
import eu.fbk.sysmlv2.sysMLv2.AttributeUsage;
import eu.fbk.sysmlv2.sysMLv2.Binding;
import eu.fbk.sysmlv2.sysMLv2.Calculation;
import eu.fbk.sysmlv2.sysMLv2.ConnectionUsage;
import eu.fbk.sysmlv2.sysMLv2.Definition;
import eu.fbk.sysmlv2.sysMLv2.DirectedElement;
import eu.fbk.sysmlv2.sysMLv2.Direction;
import eu.fbk.sysmlv2.sysMLv2.EnumDefinition;
import eu.fbk.sysmlv2.sysMLv2.EnumUsage;
import eu.fbk.sysmlv2.sysMLv2.Expression;
import eu.fbk.sysmlv2.sysMLv2.Feature;
import eu.fbk.sysmlv2.sysMLv2.Multiplicity;
import eu.fbk.sysmlv2.sysMLv2.NamedElement;
import eu.fbk.sysmlv2.sysMLv2.Package;
import eu.fbk.sysmlv2.sysMLv2.PartDefinition;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.sysmlv2.sysMLv2.PortUsage;
import eu.fbk.sysmlv2.sysMLv2.ReferenceExpression;
import eu.fbk.sysmlv2.sysMLv2.SendUsage;
import eu.fbk.sysmlv2.sysMLv2.Specialization;
import eu.fbk.sysmlv2.sysMLv2.Subsetting;
import eu.fbk.sysmlv2.sysMLv2.SuccessionNode;
import eu.fbk.sysmlv2.sysMLv2.SysMLv2Package;
import eu.fbk.sysmlv2.sysMLv2.Transition;
import eu.fbk.sysmlv2.sysMLv2.TriggerAction;
import eu.fbk.sysmlv2.sysMLv2.Typing;
import eu.fbk.sysmlv2.sysMLv2.Usage;
import eu.fbk.sysmlv2.util.SysMLv2Util;
import eu.fbk.sysmlv2.validation.AbstractSysMLv2Validator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;

public class SysMLv2Validator
extends AbstractSysMLv2Validator {
    public static final String INVALID_ASTERISK_IN_MULTIPLICITY = "invalidAsteriskInMultiplicity";
    public static final String INVALID_SPECIALIZATION = "invalidSpecialization";
    public static final String INVALID_SUBSETTING = "invalidSubsetting";
    public static final String INVALID_TYPING = "invalidTyping";
    public static final String INVALID_ASSIGNMENT = "invalidAssignment";
    public static final String INVALID_CONNECTION_USAGE_SOURCE_DIRECTION = "invalidConnectionUsageSourceDirection";
    public static final String INVALID_CONNECTION_USAGE_TARGET_DIRECTION = "invalidConnectionUsageTargetDirection";
    public static final String INVALID_BINDING_SOURCE = "invalidBindingSource";
    public static final String INVALID_BINDING_TARGET = "invalidBindingSource";
    public static final String INVALID_BINDING_DIRECTIONS = "invalidBindingDirections";
    public static final String INVALID_ASSIGNMENT_TO_INPUT_FEATURE = "invalidAssignmentToInputFeature";
    public static final String INVALID_SEND_USAGE_TRANSPORT = "invalidSendUsageTransport";
    public static final String UNSUPPORTED_ENUM_DEFINITION_IN_CALCULATION = "unsupportedEnumDefinitionInCalculation";
    public static final String INVALID_DURATIVE_TRANSITION = "invalidDurativeTransition";
    public static final String INVALID_SETTER_ACTION = "invalidSetterAction";

    @Check
    private void checkAsteriskInMultiplicity(Multiplicity multiplicity) {
        int lowerBound = multiplicity.getLowerBound();
        if (lowerBound == -1 && multiplicity.getUpperBound() != null) {
            this.error("Invalid asterisk usage in multiplicity.", multiplicity.eContainer(), (EStructuralFeature)SysMLv2Package.Literals.USAGE__MULTIPLICITY, INVALID_ASTERISK_IN_MULTIPLICITY, new String[0]);
        }
    }

    @Check
    private void checkSpecialization(Specialization specialization) {
        specialization.getReferences().stream().map(ReferenceExpression::getReferencedElement).forEach(r -> {
            if (!(r instanceof Definition)) {
                this.error("A definition may only specialize other definitions.", specialization.eContainer(), (EStructuralFeature)SysMLv2Package.Literals.DEFINITION__SPECIALIZATION, INVALID_SPECIALIZATION, new String[0]);
            }
        });
    }

    @Check
    private void checkSubsetting(Subsetting subsetting) {
        subsetting.getReferences().stream().map(ReferenceExpression::getReferencedElement).forEach(r -> {
            if (!(r instanceof Usage)) {
                this.error("A usage may only subset other usages.", subsetting.eContainer(), (EStructuralFeature)SysMLv2Package.Literals.USAGE__SUBSETTING, INVALID_SUBSETTING, new String[0]);
            }
        });
    }

    @Check
    private void invalidTyping(Typing typing) {
        typing.getReferences().stream().map(ReferenceExpression::getReferencedElement).forEach(r -> {
            if (!(r instanceof Definition)) {
                this.error("A usage may only be defined by a definition.", typing.eContainer(), (EStructuralFeature)SysMLv2Package.Literals.TYPED_ELEMENT__TYPING, INVALID_SUBSETTING, new String[0]);
            }
        });
    }

    @Check
    private void checkAssignment(Assignment assignment) {
        if (assignment.getValue().isBinding()) {
            this.error("An assignment cannot specify a binding. Only the assignment (':=') operator is allowed.", assignment.getValue(), (EStructuralFeature)SysMLv2Package.Literals.VALUE__BINDING, INVALID_ASSIGNMENT, new String[0]);
        } else if (assignment.getValue().isDefault()) {
            this.error("An assignment cannot specify a default value. Only the assignment (':=') operator is allowed.", assignment.getValue(), (EStructuralFeature)SysMLv2Package.Literals.VALUE__DEFAULT, INVALID_ASSIGNMENT, new String[0]);
        }
    }

    @Check
    private void checkConnectionUsageSourceDirection(ConnectionUsage connectionUsage) {
        DirectedElement sourceAsDirectedElement;
        ReferenceExpression reference;
        NamedElement source;
        Package pkg = (Package)EcoreUtil2.getContainerOfType((EObject)connectionUsage, Package.class);
        if (pkg.isStandard()) {
            return;
        }
        Expression expression = connectionUsage.getSource();
        if (expression instanceof ReferenceExpression && (source = (reference = (ReferenceExpression)expression).getReferencedElement()) instanceof DirectedElement && !Direction.OUT.equals((Object)(sourceAsDirectedElement = (DirectedElement)source).getDirection())) {
            this.error("The source of a connection usage shall be an output element.", (EStructuralFeature)SysMLv2Package.Literals.CONNECTION_ELEMENT__SOURCE, INVALID_CONNECTION_USAGE_SOURCE_DIRECTION, new String[0]);
        }
    }

    @Check
    private void checkConnectionUsageTargetDirection(ConnectionUsage connectionUsage) {
        DirectedElement targetAsDirectedElement;
        Package pkg = (Package)EcoreUtil2.getContainerOfType((EObject)connectionUsage, Package.class);
        if (pkg.isStandard()) {
            return;
        }
        NamedElement target = connectionUsage.getTarget().getReferencedElement();
        if (target instanceof DirectedElement && !Direction.IN.equals((Object)(targetAsDirectedElement = (DirectedElement)target).getDirection())) {
            this.error("The target of a connection usage shall be an input element.", (EStructuralFeature)SysMLv2Package.Literals.CONNECTION_ELEMENT__TARGET, INVALID_CONNECTION_USAGE_TARGET_DIRECTION, new String[0]);
        }
    }

    @Check
    private void checkBindingSource(Binding binding) {
        ReferenceExpression reference;
        Package pkg = (Package)EcoreUtil2.getContainerOfType((EObject)binding, Package.class);
        if (pkg.isStandard()) {
            return;
        }
        Expression expression = binding.getSource();
        if (!(expression instanceof ReferenceExpression) || !((reference = (ReferenceExpression)expression).getReferencedElement() instanceof AttributeUsage) && !(reference.getReferencedElement() instanceof Feature) && !(reference.getReferencedElement() instanceof PortUsage)) {
            this.error("A binding's source shall only be an attribute, feature or port usage.", (EStructuralFeature)SysMLv2Package.Literals.CONNECTION_ELEMENT__SOURCE);
        }
    }

    @Check
    private void checkBindingTarget(Binding binding) {
        Package pkg = (Package)EcoreUtil2.getContainerOfType((EObject)binding, Package.class);
        if (pkg.isStandard()) {
            return;
        }
        ReferenceExpression reference = binding.getTarget();
        if (!(reference.getReferencedElement() instanceof AttributeUsage || reference.getReferencedElement() instanceof Feature || reference.getReferencedElement() instanceof PortUsage)) {
            this.error("A binding's target shall only be an attribute, feature or port usage.", (EStructuralFeature)SysMLv2Package.Literals.CONNECTION_ELEMENT__TARGET);
        }
    }

    @Check
    private void checkBindingDirections(Binding binding) {
        ReferenceExpression sourceReference;
        NamedElement namedElement;
        Package pkg = (Package)EcoreUtil2.getContainerOfType((EObject)binding, Package.class);
        if (pkg.isStandard()) {
            return;
        }
        Expression expression = binding.getSource();
        if (expression instanceof ReferenceExpression && (namedElement = (sourceReference = (ReferenceExpression)expression).getReferencedElement()) instanceof DirectedElement) {
            DirectedElement source = (DirectedElement)namedElement;
            NamedElement namedElement2 = binding.getTarget().getReferencedElement();
            if (namedElement2 instanceof DirectedElement) {
                DirectedElement target = (DirectedElement)namedElement2;
                if (!source.getDirection().equals((Object)target.getDirection())) {
                    this.error("Source and target of a binding shall have the same direction", (EStructuralFeature)SysMLv2Package.Literals.CONNECTION_ELEMENT__SOURCE);
                    this.error("Source and target of a binding shall have the same direction", (EStructuralFeature)SysMLv2Package.Literals.CONNECTION_ELEMENT__TARGET);
                }
            }
        }
    }

    @Check
    private void checkAssignedFeature(Assignment assignment) {
        DirectedElement directedElement;
        NamedElement namedElement = assignment.getElement().getReferencedElement();
        if (namedElement instanceof DirectedElement && Direction.IN.equals((Object)(directedElement = (DirectedElement)namedElement).getDirection())) {
            this.error("Cannot assign a value to an input feature.", (EStructuralFeature)SysMLv2Package.Literals.ASSIGNMENT__ELEMENT);
        }
    }

    @Check
    private void checkSendUsageTransport(SendUsage sendUsage) {
        if (!(sendUsage.getTransport().getReferencedElement() instanceof PortUsage)) {
            this.error("A SendUsage must specify a PortUsage as its transport.", (EStructuralFeature)SysMLv2Package.Literals.SEND_USAGE__TRANSPORT);
        }
    }

    @Check
    private void checkEnumDefinitionInCalculation(Calculation calculation) {
        calculation.getMembers().stream().filter(DirectedElement.class::isInstance).map(DirectedElement.class::cast).filter(parameter -> Direction.IN.equals((Object)parameter.getDirection())).map(SysMLv2Util::getType).filter(EnumDefinition.class::isInstance).map(EnumDefinition.class::cast).forEach(enumDefinition -> enumDefinition.getMembers().stream().filter(EnumUsage.class::isInstance).map(EnumUsage.class::cast).filter(enumUsage -> enumUsage.getValue() == null).forEach(enumUsage -> this.warning("This enum should be bound to an integer value using the '=' operator.", (EObject)enumUsage, (EStructuralFeature)SysMLv2Package.Literals.NAMED_ELEMENT__NAME)));
    }

    @Check
    private void checkDurativeTransition(Transition transition) {
        if (SysMLv2Util.isDurative(transition)) {
            PartUsage partUsage;
            ReferenceExpression referenceExpression;
            NamedElement namedElement;
            Expression expression;
            Usage actFeature = SysMLv2Util.getMemberByName(transition, Usage.class, "act");
            if (actFeature == null) {
                this.error("A durative transition shall contain a feature named 'act'.", (EStructuralFeature)SysMLv2Package.Literals.CONTAINER__MEMBERS);
            } else if (!(actFeature.getValue() != null && (expression = actFeature.getValue().getExpression()) instanceof ReferenceExpression && (namedElement = (referenceExpression = (ReferenceExpression)expression).getReferencedElement()) instanceof PartUsage && SysMLv2Util.partDefinitionIsActivity((PartDefinition)SysMLv2Util.getType(partUsage = (PartUsage)namedElement)))) {
                this.error("The 'act' feature in a durative transition shall be bound with the '=' operator to a PartUsage representing an activity.", actFeature, (EStructuralFeature)SysMLv2Package.Literals.USAGE__VALUE);
            }
        }
    }

    @Check
    private void checkSetterAction(ActionUsage actionUsage) {
        Package pkg = (Package)EcoreUtil2.getContainerOfType((EObject)actionUsage, Package.class);
        if (pkg.isLibrary()) {
            return;
        }
        Definition type = SysMLv2Util.getType(actionUsage);
        if (type != null && type.getName().equals("Setter")) {
            if (actionUsage.getMembers().size() == 0 || !(actionUsage.getMembers().get(0) instanceof ActionUsage)) {
                this.error("A Setter action shall contain an action usage as its first member.", (EStructuralFeature)SysMLv2Package.Literals.CONTAINER__MEMBERS);
                return;
            }
            ActionUsage action = (ActionUsage)actionUsage.getMembers().get(0);
            if (action.getMembers().isEmpty() || !(action.getMembers().get(0) instanceof TriggerAction)) {
                this.error("A Setter action shall contain an action usage containing a trigger ('accept' action) as its first member.", action, (EStructuralFeature)SysMLv2Package.Literals.CONTAINER__MEMBERS);
                return;
            }
            if (actionUsage.getMembers().size() == 1 || !(actionUsage.getMembers().get(1) instanceof SuccessionNode) || !(((SuccessionNode)actionUsage.getMembers().get(1)).getNode() instanceof Assignment)) {
                this.error("A Setter action shall contain a succession with an assignment ('then assign') as its second member.", (EStructuralFeature)SysMLv2Package.Literals.CONTAINER__MEMBERS);
                return;
            }
        }
    }
}

