/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services;

import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.dialogs.ValidationAssertionPropertyParametersDialog;
import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.dialogs.ValidationContractPropertyParametersDialog;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.services.OSSModelFactory;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.services.OSSTranslatorServiceAPI;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.utils.OSSModelUtil;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.ui.services.OSSTranslatorServiceUI;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.core.utils.EATAUtil;
import eu.fbk.eclipse.standardtools.utils.core.utils.FileSystemUtil;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.CommandBuilder;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADirectoryUtil;
import eu.fbk.tools.editor.oss.oss.OSS;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.widgets.Display;

public class OCRAExecService {
    private static OCRAExecService ocraServiceInstance;
    private static final Logger logger;
    private final String default_alg_type = "ic3";
    private final String default_USE_OLD_MODEL = "false";
    private AbstractSystemModel abstractSystemModel;
    private OCRADialogUtil ocraDialogUtil = OCRADialogUtil.getInstance();
    private OCRADirectoryUtil ocraDirectoryUtil = OCRADirectoryUtil.getInstance();
    private OSSTranslatorServiceUI ossTranslatorServiceUI;
    private OSSTranslatorServiceAPI ossTranslatorServiceAPI;
    private OSSModelUtil ocraModelUtil = OSSModelUtil.getInstance();
    private OSSModelFactory ossModelFactory = OSSModelFactory.getInstance();
    ValidationContractPropertyParametersDialog contractValidationDialog;
    ValidationAssertionPropertyParametersDialog assertionValidationDialog;

    static {
        logger = Logger.getLogger(OCRAExecService.class);
    }

    public static OCRAExecService getInstance(AbstractSystemModel abstractSystemModel) {
        if (ocraServiceInstance == null) {
            ocraServiceInstance = new OCRAExecService(abstractSystemModel);
        }
        return ocraServiceInstance;
    }

    private OCRAExecService(AbstractSystemModel abstractSystemModel) {
        this.abstractSystemModel = abstractSystemModel;
        this.ossTranslatorServiceUI = OSSTranslatorServiceUI.getInstance((AbstractSystemModel)abstractSystemModel);
        this.ossTranslatorServiceAPI = OSSTranslatorServiceAPI.getInstance((AbstractSystemModel)abstractSystemModel);
    }

    public void executeCheckContractImplementation(IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Checking Contract Implementation on oss file", 1);
        File ossFile = this.ocraDialogUtil.getOssFileFromFileDialog();
        File smvFile = this.ocraDialogUtil.getSmvFileFromFileDialog();
        int timeSpecification = MessageTimeModelDialog.openQuestion((boolean)true);
        logger.debug((Object)("ossFile: " + ossFile));
        logger.debug((Object)("smvFile: " + smvFile));
        String resultFile = this.ocraDirectoryUtil.getCommandCheckImplementationResultPath("File_" + ossFile.getName());
        boolean internalExecution = false;
        this.executeCheckContractImplementation(ossFile.getPath(), smvFile.getPath(), resultFile, timeSpecification, internalExecution, false);
        monitor.done();
    }

    public boolean executeCheckContractImplementation(Object umlSelectedComponent, Object instantiatedArchitectureConfiguration, Resource umlSelectedResource, String smvFilePath, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, boolean internalExecution, IProgressMonitor monitor) throws Exception {
        return this.executeCheckContractImplementation(umlSelectedComponent, instantiatedArchitectureConfiguration, umlSelectedResource, smvFilePath, timeSpecification, isAsyncCommunication, usexTextValidation, showPopups, ossFilepath, resultFilePath, internalExecution, monitor, false);
    }

    public boolean executeCheckContractImplementation(Object umlSelectedComponent, Object instantiatedArchitectureConfiguration, Resource umlSelectedResource, String smvFilePath, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, boolean internalExecution, IProgressMonitor monitor, boolean disableAsyncContraints) throws Exception {
        File ossFile = this.ossTranslatorServiceUI.exportRootComponentToOssFile(umlSelectedComponent, umlSelectedResource, timeSpecification, isAsyncCommunication, usexTextValidation, showPopups, ossFilepath, monitor);
        if (instantiatedArchitectureConfiguration != null) {
            EList parametersList = this.abstractSystemModel.getParametersListFromInstantiatedArchitectureConfiguration(instantiatedArchitectureConfiguration);
            String configurationName = this.abstractSystemModel.getInstantiatedArchitectureConfigurationName(instantiatedArchitectureConfiguration);
            File parametersValuesFile = this.prepareParameterValuesFile((EList<String>)parametersList, ossFile.getName());
            ossFile = this.executeInstantiateArchitecture(configurationName, ossFile, parametersValuesFile, 1, timeSpecification, monitor);
        }
        return this.executeCheckContractImplementation(ossFile.getPath(), smvFilePath, resultFilePath, timeSpecification, internalExecution, disableAsyncContraints);
    }

    public boolean executeCheckCompositeContractImplementation(Object umlSelectedComponent, Resource umlSelectedResource, HashMap<String, String> smvPathComponentNameMap, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossDirPath, String mapDirPath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution) throws Exception {
        return this.executeCheckCompositeContractImplementation(umlSelectedComponent, umlSelectedResource, smvPathComponentNameMap, timeSpecification, isAsyncCommunication, usexTextValidation, showPopups, ossDirPath, mapDirPath, resultFilePath, monitor, internalExecution, false);
    }

    public boolean executeCheckCompositeContractImplementation(Object umlSelectedComponent, Resource umlSelectedResource, HashMap<String, String> smvPathComponentNameMap, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossDirPath, String mapDirPath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution, boolean disableAsyncContraints) throws Exception {
        File ossFile = this.ossTranslatorServiceUI.exportRootComponentToOssFile(umlSelectedComponent, umlSelectedResource, timeSpecification, isAsyncCommunication, usexTextValidation, showPopups, ossDirPath, monitor);
        File smvMapFile = FileSystemUtil.createSmvMapFile((String)"map", (String)mapDirPath, smvPathComponentNameMap);
        return this.executeCheckCompositeImplementation(ossFile, smvMapFile, resultFilePath, timeSpecification, internalExecution, disableAsyncContraints);
    }

    public boolean createMonolithicSMV(Object umlSelectedComponent, Resource umlSelectedResource, HashMap<String, String> smvPathComponentNameMap, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossDirPath, String smvMapDirPath, String resultFilePath, boolean internalExecution, IProgressMonitor monitor) throws Exception {
        return this.createMonolithicSMV(umlSelectedComponent, umlSelectedResource, smvPathComponentNameMap, timeSpecification, isAsyncCommunication, usexTextValidation, showPopups, ossDirPath, smvMapDirPath, resultFilePath, internalExecution, monitor, false);
    }

    public boolean createMonolithicSMV(Object umlSelectedComponent, Resource umlSelectedResource, HashMap<String, String> smvPathComponentNameMap, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossDirPath, String smvMapDirPath, String resultFilePath, boolean internalExecution, IProgressMonitor monitor, boolean disableAsyncContraints) throws Exception {
        logger.debug((Object)"exportModelToOssFile");
        File ossFile = this.ossTranslatorServiceUI.exportRootComponentToOssFile(umlSelectedComponent, umlSelectedResource, timeSpecification, isAsyncCommunication, usexTextValidation, showPopups, ossDirPath, monitor);
        logger.debug((Object)"exportModelToOssFile done");
        File smvMapFile = FileSystemUtil.createSmvMapFile((String)"map", (String)smvMapDirPath, smvPathComponentNameMap);
        return this.executePrintSystemImplementation(ossFile, smvMapFile, resultFilePath, timeSpecification, internalExecution, disableAsyncContraints);
    }

    public void executeCheckContractRefinement(IProgressMonitor monitor) throws Exception {
        File ossFile = this.ocraDialogUtil.getOssFileFromFileDialog();
        int timeSpecification = MessageTimeModelDialog.openQuestion((boolean)false);
        String resultFile = this.ocraDirectoryUtil.getCommandCheckRefinementResultPath("File_" + ossFile.getName());
        this.executeCheckContractRefinement(ossFile, null, timeSpecification, resultFile, monitor, false, false, false);
        logger.debug((Object)("resultFile: " + resultFile));
    }

    public boolean executeCheckContractRefinement(Object umlSelectedComponent, Object selectedInstantiatedArchitectureConfiguration, Resource umlSelectedResource, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution) throws Exception {
        return this.executeCheckContractRefinement(umlSelectedComponent, null, selectedInstantiatedArchitectureConfiguration, umlSelectedResource, timeSpecification, isAsyncCommunication, usexTextValidation, showPopups, ossFilepath, resultFilePath, monitor, internalExecution, false, false);
    }

    public boolean executeCheckContractRefinement(Object umlSelectedComponent, String contractName, Object selectedInstantiatedArchitectureConfiguration, Resource umlSelectedResource, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution, boolean wholeArchitecture, boolean disableAsyncContraints) throws Exception {
        File ossFile = this.ossTranslatorServiceUI.exportRootComponentToOssFile(umlSelectedComponent, umlSelectedResource, timeSpecification, isAsyncCommunication, usexTextValidation, showPopups, ossFilepath, monitor);
        if (selectedInstantiatedArchitectureConfiguration != null) {
            String configurationName = this.abstractSystemModel.getInstantiatedArchitectureConfigurationName(selectedInstantiatedArchitectureConfiguration);
            EList parametersList = this.abstractSystemModel.getParametersListFromInstantiatedArchitectureConfiguration(selectedInstantiatedArchitectureConfiguration);
            File parametersValuesFile = this.prepareParameterValuesFile((EList<String>)parametersList, ossFile.getName());
            ossFile = this.executeInstantiateArchitecture(configurationName, ossFile, parametersValuesFile, 1, timeSpecification, monitor);
        }
        return this.executeCheckContractRefinement(ossFile, contractName, timeSpecification, resultFilePath, monitor, internalExecution, wholeArchitecture, disableAsyncContraints);
    }

    public void executeValidationProperty(int timeSpecification, List<?> contextList, IProgressMonitor monitor) throws Exception {
        File ossFile = this.ocraDialogUtil.getOssFileFromFileDialog();
        OSS ossModel = this.ossModelFactory.createOssModel(ossFile);
        String[] componentTypes = this.ocraModelUtil.getComponentTypes(ossModel);
        ValidationContractPropertyParametersDialog dialog = new ValidationContractPropertyParametersDialog(componentTypes, ossModel, this.abstractSystemModel, contextList);
        dialog.open();
        if (dialog.goAhead()) {
            String resultFile = this.ocraDirectoryUtil.getCommandCheckPropertyResultPath("File_" + ossFile.getName());
            this.executeValidationProperty(ossFile, dialog.getSelectedButton(), dialog.getPropertyType(), dialog.getComponent(), dialog.getProperty(), dialog.getExpression(), timeSpecification, resultFile, monitor, false, false, false);
        }
    }

    public boolean executeValidationContractProperty(Object umlSelectedComponent, Object selectedInstantiatedArchitectureConfiguration, Resource umlSelectedResource, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution, String[] expression, List<?> contextList) throws Exception {
        return this.executeValidationContractProperty(umlSelectedComponent, selectedInstantiatedArchitectureConfiguration, umlSelectedResource, timeSpecification, isAsyncCommunication, usexTextValidation, showPopups, ossFilepath, resultFilePath, monitor, internalExecution, expression, contextList, false);
    }

    public boolean executeValidationContractProperty(Object umlSelectedComponent, Object selectedInstantiatedArchitectureConfiguration, Resource umlSelectedResource, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution, String[] expression, final List<?> contextList, boolean disableAsyncContraints) throws Exception {
        final OSS ossModel = this.ossTranslatorServiceAPI.exportRootComponentToOssModel(umlSelectedComponent, timeSpecification, isAsyncCommunication, monitor);
        File ossFile = this.ossTranslatorServiceUI.exportOSSModelToOSSFile((Object)ossModel, umlSelectedResource, this.abstractSystemModel.getComponentName(umlSelectedComponent), ossFilepath, usexTextValidation, showPopups, monitor);
        if (ossFile != null) {
            if (selectedInstantiatedArchitectureConfiguration != null) {
                EList parametersList = this.abstractSystemModel.getParametersListFromInstantiatedArchitectureConfiguration(selectedInstantiatedArchitectureConfiguration);
                String configurationName = this.abstractSystemModel.getInstantiatedArchitectureConfigurationName(selectedInstantiatedArchitectureConfiguration);
                File parametersValuesFile = this.prepareParameterValuesFile((EList<String>)parametersList, ossFile.getName());
                ossFile = this.executeInstantiateArchitecture(configurationName, ossFile, parametersValuesFile, 1, timeSpecification, monitor);
            }
            final String[] componentTypes = this.ocraModelUtil.getComponentTypes(ossModel);
            Display defaultDisplay = Display.getDefault();
            defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    OCRAExecService.this.contractValidationDialog = new ValidationContractPropertyParametersDialog(componentTypes, ossModel, OCRAExecService.this.abstractSystemModel, contextList);
                    OCRAExecService.this.contractValidationDialog.open();
                }
            });
            if (this.contractValidationDialog.goAhead()) {
                if (expression != null) {
                    expression[0] = this.contractValidationDialog.getPropertyType();
                    expression[0] = String.valueOf(expression[0]) + "#" + this.contractValidationDialog.getComponent();
                    expression[0] = !this.contractValidationDialog.getProperty().equals("") ? String.valueOf(expression[0]) + "#" + this.contractValidationDialog.getProperty() : String.valueOf(expression[0]) + "#ALL";
                    if (!this.contractValidationDialog.getExpression().equals("") && !this.contractValidationDialog.getPropertyType().equals("consistency")) {
                        expression[0] = String.valueOf(expression[0]) + "#" + this.contractValidationDialog.getExpression();
                    }
                }
                return this.executeValidationProperty(ossFile, this.contractValidationDialog.getSelectedButton(), this.contractValidationDialog.getPropertyType(), this.contractValidationDialog.getComponent(), this.contractValidationDialog.getProperty(), this.contractValidationDialog.getExpression(), timeSpecification, resultFilePath, monitor, internalExecution, disableAsyncContraints, false);
            }
        }
        return false;
    }

    public boolean executeValidationAssertionProperty(Object umlSelectedComponent, Object selectedInstantiatedArchitectureConfiguration, Resource umlSelectedResource, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution, String[] expression, List<?> contextList) throws Exception {
        return this.executeValidationAssertionProperty(umlSelectedComponent, selectedInstantiatedArchitectureConfiguration, umlSelectedResource, timeSpecification, isAsyncCommunication, usexTextValidation, showPopups, ossFilepath, resultFilePath, monitor, internalExecution, expression, contextList, false);
    }

    public boolean executeValidationAssertionProperty(Object umlSelectedComponent, Object selectedInstantiatedArchitectureConfiguration, Resource umlSelectedResource, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution, String[] expression, final List<?> contextList, boolean disableAsyncContraints) throws Exception {
        final OSS ossModel = this.ossTranslatorServiceAPI.exportRootComponentToOssModel(umlSelectedComponent, timeSpecification, isAsyncCommunication, monitor);
        File ossFile = this.ossTranslatorServiceUI.exportOSSModelToOSSFile((Object)ossModel, umlSelectedResource, this.abstractSystemModel.getComponentName(umlSelectedComponent), ossFilepath, usexTextValidation, showPopups, monitor);
        if (ossFile != null) {
            if (selectedInstantiatedArchitectureConfiguration != null) {
                EList parametersList = this.abstractSystemModel.getParametersListFromInstantiatedArchitectureConfiguration(selectedInstantiatedArchitectureConfiguration);
                String configurationName = this.abstractSystemModel.getInstantiatedArchitectureConfigurationName(selectedInstantiatedArchitectureConfiguration);
                File parametersValuesFile = this.prepareParameterValuesFile((EList<String>)parametersList, ossFile.getName());
                ossFile = this.executeInstantiateArchitecture(configurationName, ossFile, parametersValuesFile, 1, timeSpecification, monitor);
            }
            final String[] componentTypes = this.ocraModelUtil.getComponentTypes(ossModel);
            Display defaultDisplay = Display.getDefault();
            defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    OCRAExecService.this.assertionValidationDialog = new ValidationAssertionPropertyParametersDialog(componentTypes, ossModel, OCRAExecService.this.abstractSystemModel, contextList);
                    OCRAExecService.this.assertionValidationDialog.open();
                }
            });
            if (this.assertionValidationDialog.goAhead()) {
                if (expression != null) {
                    expression[0] = this.assertionValidationDialog.getPropertyType();
                    expression[0] = String.valueOf(expression[0]) + "#" + this.assertionValidationDialog.getComponent();
                    expression[0] = !this.assertionValidationDialog.getProperties().equals("") ? String.valueOf(expression[0]) + "#" + this.assertionValidationDialog.getProperties() : String.valueOf(expression[0]) + "#ALL";
                    if (!this.assertionValidationDialog.getExpression().equals("") && !this.assertionValidationDialog.getPropertyType().equals("consistency")) {
                        expression[0] = String.valueOf(expression[0]) + "#" + this.assertionValidationDialog.getExpression();
                    }
                }
                return this.executeValidationProperty(ossFile, this.assertionValidationDialog.getSelectedButton(), this.assertionValidationDialog.getPropertyType(), this.assertionValidationDialog.getComponent(), this.assertionValidationDialog.getProperties(), this.assertionValidationDialog.getExpression(), timeSpecification, resultFilePath, monitor, internalExecution, disableAsyncContraints, false);
            }
        }
        return false;
    }

    public void executeComputeFaultTree(int timeSpecification, IProgressMonitor monitor) throws Exception {
        File ossFile = this.ocraDialogUtil.getOssFileFromFileDialog();
        String resultFile = this.ocraDirectoryUtil.getCommandFaultTreeGenResultPath("File_" + ossFile.getName());
        this.executeComputeFaultTree(ossFile, timeSpecification, resultFile, monitor, false, false);
    }

    public boolean executeComputeFaultTree(Object umlSelectedComponent, Object selectedInstantiatedArchitectureConfiguration, Resource umlSelectedResource, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution) throws Exception {
        return this.executeComputeFaultTree(umlSelectedComponent, selectedInstantiatedArchitectureConfiguration, umlSelectedResource, timeSpecification, isAsyncCommunication, usexTextValidation, showPopups, ossFilepath, resultFilePath, monitor, internalExecution, false);
    }

    public boolean executeComputeFaultTree(Object umlSelectedComponent, Object selectedInstantiatedArchitectureConfiguration, Resource umlSelectedResource, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution, boolean disableAsyncContraints) throws Exception {
        File ossFile = this.ossTranslatorServiceUI.exportRootComponentToOssFile(umlSelectedComponent, umlSelectedResource, timeSpecification, isAsyncCommunication, usexTextValidation, showPopups, ossFilepath, monitor);
        if (selectedInstantiatedArchitectureConfiguration != null) {
            String configurationName = this.abstractSystemModel.getInstantiatedArchitectureConfigurationName(selectedInstantiatedArchitectureConfiguration);
            EList parametersList = this.abstractSystemModel.getParametersListFromInstantiatedArchitectureConfiguration(selectedInstantiatedArchitectureConfiguration);
            File parametersValuesFile = this.prepareParameterValuesFile((EList<String>)parametersList, ossFile.getName());
            ossFile = this.executeInstantiateArchitecture(configurationName, ossFile, parametersValuesFile, 1, timeSpecification, monitor);
        }
        return this.executeComputeFaultTree(ossFile, timeSpecification, resultFilePath, monitor, internalExecution, disableAsyncContraints);
    }

    public boolean executeCheckContractRefinement(File ossFile, int timeSpecification, String resultPath, IProgressMonitor monitor, boolean internalExecution) throws Exception {
        return this.executeCheckContractRefinement(ossFile, null, timeSpecification, resultPath, monitor, internalExecution, false, false);
    }

    public boolean executeCheckContractRefinement(File ossFile, String contractName, int timeSpecification, String resultPath, IProgressMonitor monitor, boolean internalExecution, boolean wholeArchitecture, boolean disableAsyncContraints) throws Exception {
        monitor.beginTask("Checking Contract Refinement on oss file", 1);
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.CheckContractRefinement";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_PARAMETER_ALG_TYPE = "algorithm_type";
        String ID_INTERNAL_EXECUTION = "internal_execution";
        String ID_WHOLE_ARCHITECTURE = "whole_architecture";
        String ID_PARAMETER_CONTRACT_NAME = "contract_name";
        String ID_DISABLE_ASYNC_CONSTRAINTS = "disable_async_constraints";
        if (ossFile != null) {
            String model_time = "discrete";
            switch (timeSpecification) {
                case 0: {
                    logger.debug((Object)"hybrid");
                    model_time = "hybrid";
                    break;
                }
                case 1: {
                    logger.debug((Object)"discrete");
                    model_time = "discrete";
                    break;
                }
                case 2: {
                    logger.debug((Object)"timed");
                    model_time = "timed";
                }
            }
            if (disableAsyncContraints) {
                logger.debug((Object)"disable async constraints");
            }
            String filePath = "\"" + ossFile.getPath() + "\"";
            logger.debug((Object)("ossFile.getPath(): " + filePath));
            CommandBuilder checkContractrefinement = CommandBuilder.build((String)ID_COMMAND);
            checkContractrefinement.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, filePath);
            checkContractrefinement.setParameter(ID_PARAMETER_MODEL_TIME, model_time);
            checkContractrefinement.setParameter(ID_PARAMETER_ALG_TYPE, "ic3");
            checkContractrefinement.setParameter(ID_INTERNAL_EXECUTION, String.valueOf(internalExecution));
            checkContractrefinement.setParameter(ID_WHOLE_ARCHITECTURE, String.valueOf(wholeArchitecture));
            checkContractrefinement.setParameter(ID_PARAMETER_RESULT_FILE, resultPath);
            if (contractName != null) {
                if (contractName.contains(" ")) {
                    checkContractrefinement.setParameter(ID_PARAMETER_CONTRACT_NAME, "'\"" + contractName + "\"'");
                } else {
                    checkContractrefinement.setParameter(ID_PARAMETER_CONTRACT_NAME, contractName);
                }
            }
            checkContractrefinement.setParameter(ID_DISABLE_ASYNC_CONSTRAINTS, String.valueOf(disableAsyncContraints));
            Object objectResult = checkContractrefinement.execute();
            if (!internalExecution) {
                monitor.done();
                return true;
            }
            if (EATAUtil.isTimeout((Object)objectResult)) {
                monitor.done();
                throw new TimeoutException();
            }
            if (EATAUtil.isResponseAvailable((Object)objectResult)) {
                monitor.done();
                return true;
            }
            throw new ExecutionException("No response available");
        }
        monitor.done();
        throw new FileNotFoundException();
    }

    public boolean executeCheckContractImplementation(String ossFilePath, String smvFilePath, String outputFilePath, int timeSpecification, boolean internalExecution) throws Exception {
        return this.executeCheckContractImplementation(ossFilePath, smvFilePath, outputFilePath, timeSpecification, internalExecution, false);
    }

    public boolean executeCheckContractImplementation(String ossFilePath, String smvFilePath, String outputFilePath, int timeSpecification, boolean internalExecution, boolean disableAsyncContraints) throws Exception {
        logger.debug((Object)"executeCheckContractImplementation");
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.CheckContractImplementation";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_BEHAVIOUR_FILE_SMV_PATH = "behaviour_model";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_PARAMETER_USE_OLD_MODEL = "old_model_format";
        String ID_PARAMETER_ALG_TYPE = "algorithm_type";
        String ID_DISABLE_ASYNC_CONSTRAINTS = "disable_async_constraints";
        String model_time = "discrete";
        if (ossFilePath != null && smvFilePath != null) {
            switch (timeSpecification) {
                case 0: {
                    logger.debug((Object)"hybrid");
                    model_time = "hybrid";
                    break;
                }
                case 1: {
                    logger.debug((Object)"discrete");
                    model_time = "discrete";
                    break;
                }
                case 2: {
                    logger.debug((Object)"timed");
                    model_time = "timed";
                }
            }
            if (disableAsyncContraints) {
                logger.debug((Object)"disable async constraints");
            }
            CommandBuilder checkContractImplementation = CommandBuilder.build((String)ID_COMMAND);
            checkContractImplementation.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, ossFilePath);
            checkContractImplementation.setParameter(ID_PARAMETER_BEHAVIOUR_FILE_SMV_PATH, smvFilePath);
            checkContractImplementation.setParameter(ID_PARAMETER_MODEL_TIME, model_time);
            checkContractImplementation.setParameter(ID_PARAMETER_USE_OLD_MODEL, "false");
            checkContractImplementation.setParameter(ID_PARAMETER_ALG_TYPE, "ic3");
            checkContractImplementation.setParameter(ID_PARAMETER_RESULT_FILE, outputFilePath);
            checkContractImplementation.setParameter(ID_DISABLE_ASYNC_CONSTRAINTS, String.valueOf(disableAsyncContraints));
            Object objectResult = checkContractImplementation.execute();
            if (!internalExecution) {
                return true;
            }
            if (EATAUtil.isTimeout((Object)objectResult)) {
                throw new TimeoutException();
            }
            if (EATAUtil.isResponseAvailable((Object)objectResult)) {
                return true;
            }
            throw new ExecutionException("No response available");
        }
        throw new FileNotFoundException();
    }

    public boolean executeCheckCompositeImplementation(File ossFile, File mapFile, String outputFilePath, int timeSpecification, boolean internalExecution) throws Exception {
        return this.executeCheckCompositeImplementation(ossFile, mapFile, outputFilePath, timeSpecification, internalExecution, false);
    }

    public boolean executeCheckCompositeImplementation(File ossFile, File mapFile, String outputFilePath, int timeSpecification, boolean internalExecution, boolean disableAsyncContraints) throws Exception {
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.CheckContractCompositeImplementationCommand";
        String ID_PARAMETER_MAP_FILE_PATH = "map_file";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_PARAMETER_USE_OLD_MODEL = "old_model_format";
        String ID_PARAMETER_ALG_TYPE = "algorithm_type";
        String ID_INTERNAL_EXECUTION = "internal_execution";
        String ID_DISABLE_ASYNC_CONSTRAINTS = "disable_async_constraints";
        String model_time = "discrete";
        if (ossFile != null && mapFile != null) {
            String ossFilePath = ossFile.getPath();
            String smvMapFilePath = mapFile.getPath();
            switch (timeSpecification) {
                case 0: {
                    logger.debug((Object)"hybrid");
                    model_time = "hybrid";
                    break;
                }
                case 1: {
                    logger.debug((Object)"discrete");
                    model_time = "discrete";
                    break;
                }
                case 2: {
                    logger.debug((Object)"timed");
                    model_time = "timed";
                }
            }
            if (disableAsyncContraints) {
                logger.debug((Object)"disable async constraints");
            }
            CommandBuilder checkContractImplementation = CommandBuilder.build((String)ID_COMMAND);
            checkContractImplementation.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, ossFilePath);
            checkContractImplementation.setParameter(ID_PARAMETER_MAP_FILE_PATH, smvMapFilePath);
            checkContractImplementation.setParameter(ID_PARAMETER_MODEL_TIME, model_time);
            checkContractImplementation.setParameter(ID_PARAMETER_USE_OLD_MODEL, "false");
            checkContractImplementation.setParameter(ID_PARAMETER_ALG_TYPE, "ic3");
            checkContractImplementation.setParameter(ID_INTERNAL_EXECUTION, String.valueOf(internalExecution));
            checkContractImplementation.setParameter(ID_PARAMETER_RESULT_FILE, outputFilePath);
            checkContractImplementation.setParameter(ID_DISABLE_ASYNC_CONSTRAINTS, String.valueOf(disableAsyncContraints));
            Object objectResult = checkContractImplementation.execute();
            if (!internalExecution) {
                return true;
            }
            if (EATAUtil.isTimeout((Object)objectResult)) {
                throw new TimeoutException();
            }
            if (EATAUtil.isResponseAvailable((Object)objectResult)) {
                return true;
            }
            throw new ExecutionException("No response available");
        }
        throw new FileNotFoundException();
    }

    public boolean executePrintSystemImplementation(File ossFile, File mapFile, String outputFilePath, int timeSpecification, boolean internalExecution) throws Exception {
        return this.executePrintSystemImplementation(ossFile, mapFile, outputFilePath, timeSpecification, internalExecution, false);
    }

    public boolean executePrintSystemImplementation(File ossFile, File mapFile, String outputFilePath, int timeSpecification, boolean internalExecution, boolean disableAsyncContraints) throws Exception {
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.PrintSystemImplementation";
        String ID_PARAMETER_MAP_FILE_PATH = "map_file";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_PARAMETER_USE_OLD_MODEL = "old_model_format";
        String ID_INTERNAL_EXECUTION = "internal_execution";
        String ID_DISABLE_ASYNC_CONSTRAINTS = "disable_async_constraints";
        String model_time = "discrete";
        if (ossFile != null && mapFile != null) {
            String ossFilePath = ossFile.getPath();
            String smvMapFilePath = mapFile.getPath();
            switch (timeSpecification) {
                case 0: {
                    logger.debug((Object)"hybrid");
                    model_time = "hybrid";
                    break;
                }
                case 1: {
                    logger.debug((Object)"discrete");
                    model_time = "discrete";
                    break;
                }
                case 2: {
                    logger.debug((Object)"timed");
                    model_time = "timed";
                }
            }
            if (disableAsyncContraints) {
                logger.debug((Object)"disable async constraints");
            }
            CommandBuilder printSystemImplementation = CommandBuilder.build((String)ID_COMMAND);
            printSystemImplementation.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, ossFilePath);
            printSystemImplementation.setParameter(ID_PARAMETER_MAP_FILE_PATH, smvMapFilePath);
            printSystemImplementation.setParameter(ID_PARAMETER_MODEL_TIME, model_time);
            printSystemImplementation.setParameter(ID_PARAMETER_USE_OLD_MODEL, "false");
            printSystemImplementation.setParameter(ID_INTERNAL_EXECUTION, String.valueOf(internalExecution));
            printSystemImplementation.setParameter(ID_PARAMETER_RESULT_FILE, outputFilePath);
            printSystemImplementation.setParameter(ID_DISABLE_ASYNC_CONSTRAINTS, String.valueOf(disableAsyncContraints));
            Object objectResult = printSystemImplementation.execute();
            if (!internalExecution) {
                return true;
            }
            if (EATAUtil.isTimeout((Object)objectResult)) {
                throw new TimeoutException();
            }
            if (EATAUtil.isResponseAvailable((Object)objectResult)) {
                return true;
            }
            throw new ExecutionException("No response available");
        }
        throw new FileNotFoundException();
    }

    public boolean executeComputeFaultTree(File ossFile, int timeSpecification, String outputFilePath, IProgressMonitor monitor, boolean internalExecution) throws Exception {
        return this.executeComputeFaultTree(ossFile, timeSpecification, outputFilePath, monitor, internalExecution, false);
    }

    public boolean executeComputeFaultTree(File ossFile, int timeSpecification, String outputFilePath, IProgressMonitor monitor, boolean internalExecution, boolean disableAsyncContraints) throws Exception {
        monitor.beginTask("Compute the contract-based Fault Tree on oss file", 1);
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.ComputeFaultTree";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_INTERNAL_EXECUTION = "internal_execution";
        String ID_DISABLE_ASYNC_CONSTRAINTS = "disable_async_constraints";
        if (ossFile != null) {
            logger.debug((Object)("ossFile.getPath(): " + ossFile.getPath()));
            String model_time = "discrete";
            switch (timeSpecification) {
                case 0: {
                    logger.debug((Object)"hybrid");
                    model_time = "hybrid";
                    break;
                }
                case 1: {
                    logger.debug((Object)"discrete");
                    model_time = "discrete";
                    break;
                }
                case 2: {
                    logger.debug((Object)"timed");
                    model_time = "timed";
                }
            }
            if (disableAsyncContraints) {
                logger.debug((Object)"disable async constraints");
            }
            CommandBuilder computeFaultTree = CommandBuilder.build((String)ID_COMMAND);
            computeFaultTree.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, ossFile.getPath());
            computeFaultTree.setParameter(ID_PARAMETER_MODEL_TIME, model_time);
            computeFaultTree.setParameter(ID_INTERNAL_EXECUTION, String.valueOf(internalExecution));
            computeFaultTree.setParameter(ID_PARAMETER_RESULT_FILE, outputFilePath);
            computeFaultTree.setParameter(ID_DISABLE_ASYNC_CONSTRAINTS, String.valueOf(disableAsyncContraints));
            Object objectResult = computeFaultTree.execute();
            logger.debug((Object)("in executeComputeFaultTree, outputFilePath: " + outputFilePath));
            if (!internalExecution) {
                monitor.done();
                return true;
            }
            if (EATAUtil.isTimeout((Object)objectResult)) {
                monitor.done();
                throw new TimeoutException();
            }
            if (EATAUtil.isResponseAvailable((Object)objectResult)) {
                monitor.done();
                return true;
            }
            throw new ExecutionException("No response available");
        }
        monitor.done();
        throw new FileNotFoundException();
    }

    public boolean executeValidationProperty(File ossFile, ValidationType selectedValidationType, String propertyType, String componentName, String properties, String expression, int timeSpecification, String outputFilePath, IProgressMonitor monitor, boolean internalExecution) throws Exception {
        return this.executeValidationProperty(ossFile, selectedValidationType, propertyType, componentName, properties, expression, timeSpecification, outputFilePath, monitor, internalExecution, false, false);
    }

    public boolean executeValidationProperty(File ossFile, ValidationType selectedValidationType, String propertyType, String componentName, String properties, String expression, int timeSpecification, String outputFilePath, IProgressMonitor monitor, boolean internalExecution, boolean disableAsyncContraints, boolean wholeArchitecture) throws Exception {
        monitor.beginTask("Check Validation Property on oss file", 1);
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.CheckValidationProperty";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_VALIDATION_TYPE = "property_validation_type";
        String ID_PARAMETER_COMPONENT_NAME = "component_name";
        String ID_PARAMETER_PROPERTIES = "properties";
        String ID_PARAMETER_EXPRESSION = "possibility";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_INTERNAL_EXECUTION = "internal_execution";
        String ID_DISABLE_ASYNC_CONSTRAINTS = "disable_async_constraints";
        String ID_WHOLE_ARCHITECTURE = "whole_architecture";
        String timeModel = "discrete";
        switch (timeSpecification) {
            case 0: {
                logger.debug((Object)"hybrid");
                timeModel = "hybrid";
                break;
            }
            case 1: {
                logger.debug((Object)"discrete");
                timeModel = "discrete";
                break;
            }
            case 2: {
                logger.debug((Object)"timed");
                timeModel = "timed";
            }
        }
        String ossFilePath = ossFile.getPath();
        if (disableAsyncContraints) {
            logger.debug((Object)"disable async constraints");
        }
        if (ossFile != null) {
            CommandBuilder checkValidationProperty = CommandBuilder.build((String)ID_COMMAND);
            checkValidationProperty.setParameter(ID_PARAMETER_MODEL_TIME, timeModel);
            checkValidationProperty.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, ossFilePath);
            checkValidationProperty.setParameter(ID_VALIDATION_TYPE, propertyType);
            checkValidationProperty.setParameter(ID_INTERNAL_EXECUTION, String.valueOf(internalExecution));
            checkValidationProperty.setParameter(ID_WHOLE_ARCHITECTURE, String.valueOf(wholeArchitecture));
            checkValidationProperty.setParameter(ID_PARAMETER_RESULT_FILE, outputFilePath);
            checkValidationProperty.setParameter(ID_DISABLE_ASYNC_CONSTRAINTS, String.valueOf(disableAsyncContraints));
            if (componentName.compareTo("") != 0) {
                checkValidationProperty.setParameter(ID_PARAMETER_COMPONENT_NAME, componentName);
                if (componentName.compareTo("ALL") == 0) {
                    properties = "ALL";
                }
            }
            if (properties.compareTo("") != 0) {
                checkValidationProperty.setParameter(ID_PARAMETER_PROPERTIES, properties);
            }
            if ((selectedValidationType == ValidationType.POSSIBILITY || selectedValidationType == ValidationType.ENTAILMENT) && expression.compareTo("") != 0) {
                checkValidationProperty.setParameter(ID_PARAMETER_EXPRESSION, "'" + expression + "'");
            }
            Object objectResult = checkValidationProperty.execute();
            if (!internalExecution) {
                monitor.done();
                return true;
            }
            if (EATAUtil.isTimeout((Object)objectResult)) {
                monitor.done();
                throw new TimeoutException();
            }
            if (EATAUtil.isResponseAvailable((Object)objectResult)) {
                monitor.done();
                return true;
            }
            throw new ExecutionException("No response available");
        }
        monitor.done();
        throw new FileNotFoundException();
    }

    public Map<String, String> executeGetParameters(File ossFile, int timeSpecification, IProgressMonitor monitor) throws Exception {
        return this.executeGetParameters(ossFile, timeSpecification, monitor, false);
    }

    public Map<String, String> executeGetParameters(File ossFile, int timeSpecification, IProgressMonitor monitor, boolean disableAsyncContraints) throws Exception {
        String parameterListResultFilePath = this.ocraDirectoryUtil.getParametersResultFilePath(ossFile.getName());
        this.executeGetParameters(ossFile, parameterListResultFilePath, timeSpecification, monitor, disableAsyncContraints);
        return this.parseParametersFileAsMap(new File(parameterListResultFilePath));
    }

    public void executeGetParameters(File ossFile, String parameterListResultFilePath, int timeSpecification, IProgressMonitor monitor) throws NotDefinedException, ExecutionException, NotEnabledException, NotHandledException {
        this.executeGetParameters(ossFile, parameterListResultFilePath, timeSpecification, monitor, false);
    }

    public void executeGetParameters(File ossFile, String parameterListResultFilePath, int timeSpecification, IProgressMonitor monitor, boolean disableAsyncContraints) throws NotDefinedException, ExecutionException, NotEnabledException, NotHandledException {
        monitor.beginTask("Retriving List of parameters to set", 1);
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.getParametersFromParamArchitecture";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_INTERNAL_EXE = "internal_execution";
        String ID_DISABLE_ASYNC_CONSTRAINTS = "disable_async_constraints";
        if (ossFile != null) {
            String model_time = "discrete";
            switch (timeSpecification) {
                case 0: {
                    logger.debug((Object)"hybrid");
                    model_time = "hybrid";
                    break;
                }
                case 1: {
                    logger.debug((Object)"discrete");
                    model_time = "discrete";
                    break;
                }
                case 2: {
                    logger.debug((Object)"timed");
                    model_time = "timed";
                }
            }
            if (disableAsyncContraints) {
                logger.debug((Object)"disable async constraints");
            }
            String filePath = "\"" + ossFile.getPath() + "\"";
            logger.debug((Object)("ossFile.getPath(): " + filePath));
            CommandBuilder getParametersCommand = CommandBuilder.build((String)ID_COMMAND);
            getParametersCommand.setParameter(ID_INTERNAL_EXE, "true");
            getParametersCommand.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, filePath);
            getParametersCommand.setParameter(ID_PARAMETER_MODEL_TIME, model_time);
            getParametersCommand.setParameter(ID_PARAMETER_RESULT_FILE, parameterListResultFilePath);
            getParametersCommand.setParameter(ID_DISABLE_ASYNC_CONSTRAINTS, String.valueOf(disableAsyncContraints));
            getParametersCommand.execute();
        }
        monitor.done();
    }

    public File executeInstantiateArchitecture(String originalOssFileName, File ossFile, File parametersValuesFile, int numIstantiation, int timeSpecification, IProgressMonitor monitor) throws Exception {
        return this.executeInstantiateArchitecture(originalOssFileName, ossFile, parametersValuesFile, numIstantiation, timeSpecification, monitor, false);
    }

    public File executeInstantiateArchitecture(String originalOssFileName, File ossFile, File parametersValuesFile, int numIstantiation, int timeSpecification, IProgressMonitor monitor, boolean disableAsyncContraints) throws Exception {
        String resultOssFilePath = this.ocraDirectoryUtil.getCommandInstantiateParamArchResultPath(originalOssFileName, numIstantiation);
        logger.debug((Object)("executeInstantiateArchitecture resultOssFilePath: " + resultOssFilePath));
        this.executeInstantiateParamArch(ossFile, parametersValuesFile, timeSpecification, resultOssFilePath, monitor, disableAsyncContraints);
        File outputFile = new File(resultOssFilePath);
        if (!outputFile.exists()) {
            throw new Exception("executeInstantiateArchitecture. output not created: " + outputFile.getPath());
        }
        return outputFile;
    }

    public File prepareParameterValuesFile(EList<String> parametersList, String ossFileName) throws Exception {
        String inputParamFilePath = this.ocraDirectoryUtil.getInputParametersFilePath(ossFileName);
        logger.debug((Object)("executeInstantiateArchitecture inputParamFilePath: " + inputParamFilePath));
        return this.createParameterValuesFile(parametersList, inputParamFilePath);
    }

    public File createParameterValuesFile(EList<String> parametersList, String inputParamFilePath) throws Exception {
        int numLines = 1;
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(inputParamFilePath), "utf-8"));){
            for (String parameter : parametersList) {
                logger.debug((Object)("prepareParameterValuesFile parameter: " + parameter));
                writer.write(parameter);
                if (numLines != parametersList.size()) {
                    writer.write(",");
                }
                ++numLines;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new File(inputParamFilePath);
    }

    public File prepareFinalParameterValuesFile(EList<EList<String>> parametersList, String ossFileName) throws Exception {
        String inputParamFilePath = this.ocraDirectoryUtil.getInputParametersFilePath(ossFileName);
        logger.debug((Object)("executeInstantiateArchitecture inputParamFilePath: " + inputParamFilePath));
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(inputParamFilePath), "utf-8"));){
            for (EList parameters : parametersList) {
                for (String parameter : parameters) {
                    writer.write(parameter);
                    ((Writer)writer).write(10);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new File(inputParamFilePath);
    }

    public Map<String, String> parseParametersFileAsMap(File parametersListFile) throws FileNotFoundException {
        Scanner s = new Scanner(parametersListFile);
        s.useDelimiter(",|\\n|\\r");
        LinkedHashMap<String, String> parametersList = new LinkedHashMap<String, String>();
        while (s.hasNext()) {
            String currParam = s.next();
            if (currParam.isEmpty()) continue;
            logger.debug((Object)("currParam: " + currParam));
            parametersList.put(currParam.trim(), "");
        }
        s.close();
        return parametersList;
    }

    public ArrayList<String> parseParametersFileAsArray(File parametersListFile) throws FileNotFoundException {
        Scanner s = new Scanner(parametersListFile);
        ArrayList<String> parametersList = new ArrayList<String>();
        while (s.hasNext()) {
            parametersList.add(s.next());
        }
        s.close();
        return parametersList;
    }

    public void executeInstantiateParamArch(File ossFile, File parametersValuesFile, int timeSpecification, String resultFilePath, IProgressMonitor monitor) throws Exception {
        this.executeInstantiateParamArch(ossFile, parametersValuesFile, timeSpecification, resultFilePath, monitor, false);
    }

    public void executeInstantiateParamArch(File ossFile, File parametersValuesFile, int timeSpecification, String resultFilePath, IProgressMonitor monitor, boolean disableAsyncContraints) throws Exception {
        monitor.beginTask("Instantiating Parameterized Architecture on oss file", 1);
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.InstantiateParamArchitecture";
        String ID_INTERNAL_EXE = "internal_execution";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_LIST_FILE_OSS_PATH = "param_list";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_DISABLE_ASYNC_CONSTRAINTS = "disable_async_constraints";
        if (ossFile != null) {
            String model_time = "discrete";
            switch (timeSpecification) {
                case 0: {
                    logger.debug((Object)"hybrid");
                    model_time = "hybrid";
                    break;
                }
                case 1: {
                    logger.debug((Object)"discrete");
                    model_time = "discrete";
                    break;
                }
                case 2: {
                    logger.debug((Object)"timed");
                    model_time = "timed";
                }
            }
            if (disableAsyncContraints) {
                logger.debug((Object)"disable async constraints");
            }
            String filePath = "\"" + ossFile.getPath() + "\"";
            String parametersValuesFilePath = "\"" + parametersValuesFile.getPath() + "\"";
            logger.debug((Object)("filePath: " + filePath));
            logger.debug((Object)("parametersValuesFilePath: " + parametersValuesFilePath));
            logger.debug((Object)("model_time: " + model_time));
            logger.debug((Object)("resultFilePath: " + resultFilePath));
            CommandBuilder instantiateParamArchCommand = CommandBuilder.build((String)ID_COMMAND);
            instantiateParamArchCommand.setParameter(ID_INTERNAL_EXE, "true");
            instantiateParamArchCommand.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, filePath);
            instantiateParamArchCommand.setParameter(ID_PARAMETER_LIST_FILE_OSS_PATH, parametersValuesFilePath);
            instantiateParamArchCommand.setParameter(ID_PARAMETER_MODEL_TIME, model_time);
            instantiateParamArchCommand.setParameter(ID_PARAMETER_RESULT_FILE, resultFilePath);
            instantiateParamArchCommand.setParameter(ID_DISABLE_ASYNC_CONSTRAINTS, String.valueOf(disableAsyncContraints));
            instantiateParamArchCommand.execute();
        }
        monitor.done();
    }

    public static enum ValidationType {
        CONSISTENCY,
        POSSIBILITY,
        ENTAILMENT;

    }
}

