/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseCommand
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseCommand.class);
    private final String commandDescription;
    protected Shell activeShell = null;

    public AbstractBaseCommand(String commandDescription) {
        this.commandDescription = commandDescription;
    }

    protected boolean initialize() {
        return true;
    }

    protected boolean preprocessEvent(ExecutionEvent event) {
        this.activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        return true;
    }

    public String getCommandDescription() {
        return this.commandDescription;
    }

    protected void displayError(String title, String errorMsg) {
        if (PlatformUI.isWorkbenchRunning()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(() -> MessageDialog.openError((Shell)this.activeShell, (String)title, (String)errorMsg));
        } else {
            logger.error(errorMsg);
        }
    }

    protected String getFileNameParameter(ExecutionEvent event, String parameterName, String fileExtension, String askMessage) {
        IWorkbenchPage activePage;
        ISelection selection;
        String fileName = null;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window != null && (selection = (activePage = window.getActivePage()).getSelection()) != null && selection instanceof IStructuredSelection && selection instanceof ITreeSelection) {
            TreePath[] paths;
            TreePath[] treePathArray = paths = ((ITreeSelection)selection).getPaths();
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                TreePath path = treePathArray[n2];
                Object item = path.getLastSegment();
                if (item instanceof IFile && (file = (IFile)item).getFullPath().getFileExtension().equals(fileExtension)) {
                    fileName = file.getLocation().toOSString();
                    break;
                }
                ++n2;
            }
        }
        if (StringUtils.isBlank(fileName)) {
            fileName = event.getParameter(parameterName);
        }
        if (StringUtils.isBlank(fileName)) {
            if (this.activeShell == null) {
                this.activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            }
            FileDialog fd = new FileDialog(this.activeShell, 4096);
            fd.setText(askMessage);
            String[] filterExt = new String[]{"*." + fileExtension};
            fd.setFilterExtensions(filterExt);
            fileName = fd.open();
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        if (!new File(fileName = fileName.replace("\"", "")).exists()) {
            String errMsg = "The provided file " + fileName + " not exists";
            logger.error(errMsg);
            return null;
        }
        return fileName;
    }
}

