/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.contract;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ocra.CheckContractCompositeImplementation;
import eu.fbk.tools.adapter.ocra.OcraFunction;
import eu.fbk.tools.adapter.ui.commands.contract.AbstractCheckContractCommand;
import eu.fbk.tools.adapter.ui.dialog.contract.ContractCompositeImplementationParametersDialog;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckContractCompositeImplementationCommand
extends AbstractCheckContractCommand {
    private static final Logger logger = LoggerFactory.getLogger(CheckContractCompositeImplementationCommand.class);
    private CheckContractCompositeImplementation function;
    private String mapFileName;

    public CheckContractCompositeImplementationCommand() {
        super("Check Contract Composite Implementation");
    }

    @Override
    protected boolean initialize() {
        this.function = new CheckContractCompositeImplementation();
        this.mapFileName = null;
        return super.initialize();
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        String oldModelFormat;
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setContractModel(FileUtils.stringToURI((String)this.contractFileName));
        this.mapFileName = this.getFileNameParameter(event, "map_file", "txt", "Choose the map file");
        if (StringUtils.isBlank((CharSequence)this.mapFileName)) {
            this.displayError(this.getCommandDescription(), "Map file has not been specified, can't execute the command.");
            logger.error("Map file has not been specified, can't execute the command.");
            return false;
        }
        logger.debug("Set component to model mapping filename to " + this.mapFileName);
        this.function.setComponentsMapping(FileUtils.stringToURI((String)this.mapFileName));
        this.function.setTimeModel(this.timeModel);
        this.function.setDisableAsyncConstraints(this.disableAsyncConstraints);
        String algorithmType = event.getParameter("algorithm_type");
        if (!StringUtils.isBlank((CharSequence)algorithmType)) {
            try {
                this.function.setAlgorithmType(OcraFunction.AlgorithmType.valueOf((String)algorithmType));
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid algorithm type parameter value, can't execute the command.");
                logger.error("Invalid algorithm type parameter value: " + algorithmType);
                return false;
            }
            logger.debug("Set algorithm type to " + this.function.getAlgorithmType().name());
        }
        if (!StringUtils.isBlank((CharSequence)(oldModelFormat = event.getParameter("old_model_format")))) {
            try {
                this.function.setOldSmvFormat(Boolean.valueOf(oldModelFormat));
            }
            catch (Exception exception) {
                logger.error("Invalid old model parameter value: " + oldModelFormat);
            }
        }
        this.function.setBoundLength(Integer.valueOf(10));
        if (this.isDevelopmentModeEnabled()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ContractCompositeImplementationParametersDialog dialog = new ContractCompositeImplementationParametersDialog(CheckContractCompositeImplementationCommand.this.activeShell, CheckContractCompositeImplementationCommand.this.function, CheckContractCompositeImplementationCommand.this.asyncExecution, CheckContractCompositeImplementationCommand.this.disableAsyncConstraints);
                    dialog.open();
                    if (dialog.goAhead()) {
                        CheckContractCompositeImplementationCommand.this.asyncExecution = dialog.getAsyncExecution();
                        CheckContractCompositeImplementationCommand.this.function.setDisableAsyncConstraints(dialog.getDisableAsyncConstraints());
                    }
                }
            };
            display.syncExec(runnable);
        }
        return true;
    }
}

