/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.contract;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ocra.CheckValidationProperty;
import eu.fbk.tools.adapter.ui.commands.contract.AbstractCheckContractCommand;
import eu.fbk.tools.adapter.ui.dialog.contract.ValidationPropertyParametersDialog;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckValidationPropertyCommand
extends AbstractCheckContractCommand {
    private static final Logger logger = LoggerFactory.getLogger(CheckValidationPropertyCommand.class);
    private CheckValidationProperty function;
    private Boolean wholeArchitecture;

    public CheckValidationPropertyCommand() {
        super("Check Validation Property");
    }

    @Override
    protected boolean initialize() {
        this.function = new CheckValidationProperty();
        return super.initialize();
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setContractModel(FileUtils.stringToURI((String)this.contractFileName));
        this.function.setTimeModel(this.timeModel);
        this.function.setDisableAsyncConstraints(this.disableAsyncConstraints);
        this.function.setComponentName(event.getParameter("component_name"));
        this.function.setPropertyName(event.getParameter("property_name"));
        this.function.setPossibility(event.getParameter("possibility"));
        this.function.setProperties(event.getParameter("properties"));
        this.wholeArchitecture = Boolean.valueOf(event.getParameter("whole_architecture"));
        this.function.setWholeArchitecture(this.wholeArchitecture);
        String propertyValidationType = event.getParameter("property_validation_type");
        if (propertyValidationType != null) {
            try {
                this.function.setPropertyValidationType(CheckValidationProperty.PropertyValidationType.valueOf((String)propertyValidationType));
                logger.debug("Set property validation type to: " + this.function.getPropertyValidationType().name());
            }
            catch (Exception e) {
                this.displayError(this.getCommandDescription(), "Internal error: unexpected value of property_validation_type parameter, can't execute the command.");
                logger.error("Unexpected value of property_validation_type parameter: " + propertyValidationType + " . Allowed values are: " + this.function.getPropertyValidationType().toString(), (Throwable)e);
                return false;
            }
        }
        logger.debug("Consider the whole architecture: " + this.function.getWholeArchitecture());
        if (this.isDevelopmentModeEnabled()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ValidationPropertyParametersDialog dialog = new ValidationPropertyParametersDialog(CheckValidationPropertyCommand.this.activeShell, CheckValidationPropertyCommand.this.function, CheckValidationPropertyCommand.this.asyncExecution, CheckValidationPropertyCommand.this.wholeArchitecture, CheckValidationPropertyCommand.this.disableAsyncConstraints);
                    dialog.open();
                    if (dialog.goAhead()) {
                        CheckValidationPropertyCommand.this.asyncExecution = dialog.getAsyncExecution();
                        CheckValidationPropertyCommand.this.function.setWholeArchitecture(dialog.getWholeArchitecture());
                        CheckValidationPropertyCommand.this.function.setDisableAsyncConstraints(dialog.getDisableAsyncConstraints());
                    }
                }
            };
            display.syncExec(runnable);
        }
        return true;
    }
}

