/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.software;

import eu.fbk.tools.adapter.ui.commands.AbstractToolCommand;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCheckSwModelCommand
extends AbstractToolCommand {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCheckSwModelCommand.class);
    protected String softwareModelFileName = null;

    public AbstractCheckSwModelCommand(String commandDescription) {
        super("kratos", commandDescription, "tools.kratos.executable", "tools.kratos.timeout");
    }

    @Override
    protected boolean initialize() {
        this.softwareModelFileName = null;
        return super.initialize();
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.softwareModelFileName = this.getFileNameParameter(event, "software_model", "k2", "Choose the software model file");
        if (StringUtils.isBlank((CharSequence)this.softwareModelFileName)) {
            this.displayError(this.getCommandDescription(), "Sotware model has not been specified, can't execute the command.");
            logger.error("Sotware model has not been specified, can't execute the command.");
            return false;
        }
        logger.debug("Set software model to " + this.softwareModelFileName);
        return true;
    }
}

