/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.dialog.behaviour;

import eu.fbk.tools.adapter.nuxmv.CheckModel;
import eu.fbk.tools.adapter.nuxmv.NuxmvFunction;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ModelCheckingParametersDialog
extends Dialog {
    protected CheckModel function;
    protected Button timedDomainCheckBox;
    protected Combo comboCheckType;
    protected Combo comboAlgorithmType;
    protected Text propertyText;
    protected Button asyncCheckBox;
    protected String[] checkTypes = new String[]{"invar", "ltlspec", "ctlspec"};
    protected String[] algorithmTypes = new String[]{"", "bmc", "ic3"};
    protected Boolean asyncExecution = false;
    private String title = "nuXmv parameters";
    protected boolean goAhead = false;

    public ModelCheckingParametersDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(32);
    }

    public ModelCheckingParametersDialog(Shell parentShell, CheckModel function, Boolean asyncExecution) {
        this(parentShell);
        this.function = function;
        this.asyncExecution = asyncExecution == null ? false : asyncExecution;
    }

    public ModelCheckingParametersDialog(Shell parentShell, String title, CheckModel function, Boolean asyncExecution) {
        this(parentShell);
        this.title = title;
        this.function = function;
        this.asyncExecution = asyncExecution == null ? false : asyncExecution;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected void okPressed() {
        this.function.setTimed(this.timedDomainCheckBox.getSelection());
        try {
            this.function.setCheckType(NuxmvFunction.CheckType.valueOf((String)this.comboCheckType.getItems()[this.comboCheckType.getSelectionIndex()]));
        }
        catch (Exception exception) {}
        try {
            this.function.setAlgorithmType(NuxmvFunction.AlgorithmType.valueOf((String)this.comboAlgorithmType.getItems()[this.comboAlgorithmType.getSelectionIndex()]));
        }
        catch (Exception exception) {}
        this.function.setFormula(this.propertyText.getText());
        this.asyncExecution = this.asyncCheckBox.getSelection();
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        this.timedDomainCheckBox = new Button(container, 32);
        this.timedDomainCheckBox.setText("Timed Domain");
        this.timedDomainCheckBox.setSelection(this.function.isTimed());
        Composite container2 = new Composite(container, 0);
        container2.setLayout((Layout)new GridLayout(2, false));
        GridData gd_container2 = new GridData(4, 4, false, false);
        gd_container2.widthHint = 405;
        gd_container2.heightHint = 228;
        container2.setLayoutData((Object)gd_container2);
        Label lblCheck = new Label(container2, 0);
        lblCheck.setText("Check Type");
        GridData gd_comboCheckType = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_comboCheckType.widthHint = 289;
        this.comboCheckType = new Combo(container2, 8);
        this.comboCheckType.setLayoutData((Object)gd_comboCheckType);
        this.setComboValues(this.comboCheckType, this.checkTypes, this.function.getCheckType() == null ? "" : this.function.getCheckType().name());
        Label lblAlgorithm = new Label(container2, 0);
        lblAlgorithm.setText("Algorithm Type");
        GridData gd_comboAlgorithmType = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_comboAlgorithmType.widthHint = 286;
        this.comboAlgorithmType = new Combo(container2, 8);
        this.comboAlgorithmType.setLayoutData((Object)gd_comboAlgorithmType);
        this.setComboValues(this.comboAlgorithmType, this.algorithmTypes, this.function.getAlgorithmType() == null ? "" : this.function.getAlgorithmType().name());
        Label lblProperty = new Label(container2, 0);
        lblProperty.setText("Property");
        this.propertyText = new Text(container2, 2626);
        this.propertyText.setLayoutData((Object)new GridData(1808));
        if (!StringUtils.isBlank((CharSequence)this.function.getFormula())) {
            this.propertyText.setText(this.function.getFormula());
        }
        this.asyncCheckBox = new Button(container, 32);
        this.asyncCheckBox.setText("OSLC Asynchronous Execution");
        this.asyncCheckBox.setSelection(this.asyncExecution.booleanValue());
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Composite container3 = new Composite(container, 0);
        GridLayout gl_container3 = new GridLayout(1, false);
        container3.setLayout((Layout)gl_container3);
        container3.setLayoutData((Object)new GridData(4, 4, false, false));
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public Boolean getAsyncExecution() {
        return this.asyncExecution;
    }

    protected void setComboValues(Combo combo, String[] admittedValues, String currentValue) {
        combo.setItems(admittedValues);
        combo.select(0);
        if (currentValue != null) {
            int i = 0;
            while (i < admittedValues.length) {
                if (admittedValues[i].equals(currentValue)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }
    }
}

