/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.dialog.contract;

import eu.fbk.tools.adapter.ocra.CheckValidationProperty;
import eu.fbk.tools.adapter.ocra.OcraFunction;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ValidationPropertyParametersDialog
extends Dialog {
    private CheckValidationProperty function;
    private Combo timeModelCombo;
    private Text componentNameText;
    private Text propertyNameText;
    private Text possibilityText;
    private Text propertiesText;
    private Combo propertyValidationTypeCombo;
    private Button asyncCheckBox;
    private Button wholeArchitectureBox;
    private Button disableAsyncConstraintsBox;
    private Boolean asyncExecution = false;
    private Boolean wholeArchitecture = false;
    private Boolean disableAsyncConstraints = false;
    private String[] timeModels = new String[]{OcraFunction.TimeModel.discrete.name(), OcraFunction.TimeModel.hybrid.name(), OcraFunction.TimeModel.timed.name()};
    private String[] propertyValidationTypes = new String[]{"", CheckValidationProperty.PropertyValidationType.consistency.name(), CheckValidationProperty.PropertyValidationType.entailment.name(), CheckValidationProperty.PropertyValidationType.possibility.name()};
    private boolean goAhead = false;

    public ValidationPropertyParametersDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(32);
    }

    public ValidationPropertyParametersDialog(Shell parentShell, CheckValidationProperty function, Boolean asyncExecution, Boolean wholeArchitecture, Boolean disableAsyncConstraints) {
        this(parentShell);
        this.function = function;
        this.asyncExecution = asyncExecution == null ? false : asyncExecution;
        this.wholeArchitecture = wholeArchitecture == null ? false : wholeArchitecture;
        this.disableAsyncConstraints = disableAsyncConstraints == null ? false : disableAsyncConstraints;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Validation Property Parameters");
    }

    protected void okPressed() {
        try {
            this.function.setTimeModel(OcraFunction.TimeModel.valueOf((String)this.timeModelCombo.getItems()[this.timeModelCombo.getSelectionIndex()]));
        }
        catch (Exception exception) {}
        this.function.setComponentName(this.componentNameText.getText());
        this.function.setPropertyName(this.propertyNameText.getText());
        this.function.setPossibility(this.possibilityText.getText());
        this.function.setProperties(this.propertiesText.getText());
        try {
            this.function.setPropertyValidationType(CheckValidationProperty.PropertyValidationType.valueOf((String)this.propertyValidationTypeCombo.getItems()[this.propertyValidationTypeCombo.getSelectionIndex()]));
        }
        catch (Exception exception) {}
        this.asyncExecution = this.asyncCheckBox.getSelection();
        this.wholeArchitecture = this.wholeArchitectureBox.getSelection();
        this.disableAsyncConstraints = this.disableAsyncConstraintsBox.getSelection();
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite container2 = new Composite(container, 0);
        container2.setLayout((Layout)new GridLayout(2, false));
        GridData gd_combo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 200;
        Label lblTimeModel = new Label(container2, 0);
        lblTimeModel.setText("Time Model");
        this.timeModelCombo = new Combo(container2, 8);
        this.timeModelCombo.setLayoutData((Object)gd_combo);
        this.setComboValues(this.timeModelCombo, this.timeModels, this.function.getTimeModel() == null ? "" : this.function.getTimeModel().name());
        Label lblComponentName = new Label(container2, 0);
        lblComponentName.setText("Component Name");
        this.componentNameText = new Text(container2, 2052);
        this.componentNameText.setLayoutData((Object)new GridData(768));
        this.componentNameText.setText(StringUtils.isBlank((CharSequence)this.function.getComponentName()) ? "" : this.function.getComponentName());
        Label lblPropertyName = new Label(container2, 0);
        lblPropertyName.setText("Property Name");
        this.propertyNameText = new Text(container2, 2052);
        this.propertyNameText.setLayoutData((Object)new GridData(768));
        this.propertyNameText.setText(StringUtils.isBlank((CharSequence)this.function.getPropertyName()) ? "" : this.function.getPropertyName());
        Label lblPossibilityName = new Label(container2, 0);
        lblPossibilityName.setText("Possibility");
        this.possibilityText = new Text(container2, 2052);
        this.possibilityText.setLayoutData((Object)new GridData(768));
        this.possibilityText.setText(StringUtils.isBlank((CharSequence)this.function.getPossibility()) ? "" : this.function.getPossibility());
        Label lblProperties = new Label(container2, 0);
        lblProperties.setText("Properties");
        this.propertiesText = new Text(container2, 2052);
        this.propertiesText.setLayoutData((Object)new GridData(768));
        this.propertiesText.setText(StringUtils.isBlank((CharSequence)this.function.getProperties()) ? "" : this.function.getProperties());
        Label lblPropertyValidationType = new Label(container2, 0);
        lblPropertyValidationType.setText("Property Validation Type");
        this.propertyValidationTypeCombo = new Combo(container2, 8);
        this.propertyValidationTypeCombo.setLayoutData((Object)gd_combo);
        this.setComboValues(this.propertyValidationTypeCombo, this.propertyValidationTypes, this.function.getPropertyValidationType() == null ? "" : this.function.getPropertyValidationType().name());
        this.wholeArchitectureBox = new Button(container, 32);
        this.wholeArchitectureBox.setText("Consider the whole architecture");
        this.wholeArchitectureBox.setSelection(this.wholeArchitecture.booleanValue());
        this.disableAsyncConstraintsBox = new Button(container, 32);
        this.disableAsyncConstraintsBox.setText("Disable Async Constraints");
        this.disableAsyncConstraintsBox.setSelection(this.disableAsyncConstraints.booleanValue());
        this.asyncCheckBox = new Button(container, 32);
        this.asyncCheckBox.setText("OSLC Asynchronous Execution");
        this.asyncCheckBox.setSelection(this.asyncExecution.booleanValue());
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(400, 350);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public Boolean getAsyncExecution() {
        return this.asyncExecution;
    }

    public Boolean getWholeArchitecture() {
        return this.wholeArchitecture;
    }

    public Boolean getDisableAsyncConstraints() {
        return this.disableAsyncConstraints;
    }

    private void setComboValues(Combo combo, String[] admittedValues, String currentValue) {
        combo.setItems(admittedValues);
        combo.select(0);
        if (currentValue != null) {
            int i = 0;
            while (i < admittedValues.length) {
                if (admittedValues[i].equals(currentValue)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }
    }
}

