/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.result;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ResultProcessor.class);
    protected final String functionName;
    protected File resultFile;
    protected File extResultFile;

    public ResultProcessor(String functionName) {
        this.functionName = functionName;
    }

    public File getResultFile() {
        return this.resultFile;
    }

    public void setResultFile(File resultFile) {
        this.resultFile = resultFile;
    }

    public File getExtResultFile() {
        return this.extResultFile;
    }

    public void setExtResultFile(File extResultFile) {
        this.extResultFile = extResultFile;
    }

    public boolean resultFileExists() {
        return this.resultFile != null && this.resultFile.exists();
    }

    public boolean processResult() {
        return true;
    }

    public void displayResult() {
        if (!this.resultFileExists()) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(() -> {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(this.resultFile.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException e) {
                logger.error("Error ", (Object)e.getMessage());
            }
        });
    }

    protected void displayError(final String title, final String errorMsg) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)title, (String)errorMsg);
            }
        };
        display.syncExec(runnable);
    }

    public void mapValues(String mapFile) throws Exception {
    }
}

