/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.result.behaviour;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.fbk.tools.adapter.nusmv.CounterExample;
import eu.fbk.tools.adapter.nuxmv.CheckBehaviourResultBuilder;
import eu.fbk.tools.adapter.results.ModelCheckResult;
import eu.fbk.tools.adapter.ui.result.ResultProcessor;
import eu.fbk.tools.adapter.ui.views.trace.TraceViewPart;
import eu.fbk.tools.adapter.ui.views.trace.behaviour.BehaviourTraceViewer;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckModelResultProcessor
extends ResultProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CheckModelResultProcessor.class);
    private ModelCheckResult behaviourCheckResult;

    public CheckModelResultProcessor(String functionName) {
        super(functionName);
    }

    @Override
    public boolean processResult() {
        this.behaviourCheckResult = null;
        CheckBehaviourResultBuilder resultBuilder = new CheckBehaviourResultBuilder();
        if (this.resultFileExists()) {
            CounterExample counterExample = resultBuilder.unmarshalResult(this.resultFile);
            if (counterExample == null || counterExample.getDesc() == null || counterExample.getId() == null || counterExample.getNode() == null) {
                this.displayError(this.functionName, "Internal error while processing the result. For more info see the console");
                return false;
            }
            this.behaviourCheckResult = resultBuilder.buildResult(this.functionName, "", counterExample);
        } else {
            this.behaviourCheckResult = resultBuilder.buildResult(this.functionName, "");
        }
        if (this.behaviourCheckResult == null) {
            this.displayError(this.functionName, "Internal error while processing the result. For more info see the console");
            return false;
        }
        return true;
    }

    @Override
    public void mapValues(String mapFile) throws Exception {
        Map<String, Map<String, String>> mappings = this.parseMappingFile(mapFile);
        this.behaviourCheckResult.getBehaviourCheckResults().stream().flatMap(bcr -> bcr.getCheckResults().stream()).flatMap(cr -> cr.getTraces().stream()).flatMap(trace -> trace.getStates().stream()).flatMap(state -> state.getSections().stream()).flatMap(section -> section.getAssignments().stream()).forEach(assignment -> {
            String newValue;
            Map innerMap = (Map)mappings.get(assignment.getVariable());
            if (innerMap != null && (newValue = (String)innerMap.get(assignment.getValue())) != null) {
                assignment.setValue(newValue);
            }
        });
    }

    private Map<String, Map<String, String>> parseMappingFile(String mapFile) throws Exception {
        Gson gson = new Gson();
        Type mapType = new TypeToken<Map<String, Map<String, String>>>(){}.getType();
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileReader reader = new FileReader(mapFile);){
            return (Map)gson.fromJson((Reader)reader, mapType);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void displayResult() {
        if (this.behaviourCheckResult == null) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(() -> {
            try {
                BehaviourTraceViewer traceViewPart = (BehaviourTraceViewer)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.fbk.tools.adapter.ui.views.trace.behaviour.BehaviourTraceViewer", null, 2);
                if (traceViewPart != null) {
                    TreeViewer treeViewer = ((TraceViewPart)traceViewPart).getTreeViewer();
                    IContentProvider provider = treeViewer.getContentProvider();
                    if (provider == null) {
                        return;
                    }
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)traceViewPart);
                    provider.inputChanged((Viewer)treeViewer, null, (Object)this.behaviourCheckResult);
                    ((TraceViewPart)traceViewPart).refresh();
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        });
    }
}

