/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ossimporter.core;

import eu.fbk.eclipse.explodtwin.ossimporter.utils.OssModelUtil;
import eu.fbk.eclipse.standardtools.utils.core.visitors.ITreeGenericVisitorAction;
import eu.fbk.tools.editor.basetype.baseType.EnumType;
import eu.fbk.tools.editor.basetype.baseType.Identifier;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;

public class OssEnumVisitorAction
implements ITreeGenericVisitorAction {
    private static final String ENUM_PREFIX = "Enum_";
    private int enumeratorCounter;
    private EMap<String, Set<String>> enumeratorsCache = new BasicEMap();
    private EMap<String, String> enumPortsCache = new BasicEMap();

    private void action(EnumType o) throws Exception {
        this.addEnumerator(o);
    }

    private void addEnumerator(EnumType enumType) {
        LinkedHashSet<String> enumValuesNames = new LinkedHashSet<String>();
        for (EObject object : enumType.getValues()) {
            enumValuesNames.add(((Identifier)object).getValue());
        }
        Object enumName = null;
        for (Map.Entry entry : this.enumeratorsCache) {
            if (!((Set)entry.getValue()).equals(enumValuesNames)) continue;
            enumName = (String)entry.getKey();
        }
        if (enumName == null) {
            enumName = ENUM_PREFIX + ++this.enumeratorCounter;
            this.enumeratorsCache.put(enumName, enumValuesNames);
        }
        String componentName = OssModelUtil.getOwnerComponentName((EObject)enumType);
        String port = OssModelUtil.getPortNameForEnum(enumType);
        if (port != null) {
            this.enumPortsCache.put((Object)(componentName + "." + port), enumName);
        }
    }

    public void genericAction(EObject o) throws Exception {
        if (o instanceof EnumType) {
            this.action((EnumType)o);
        }
    }

    public EMap<String, Set<String>> getEnumeratorsCache() {
        return this.enumeratorsCache;
    }

    public EMap<String, String> getEnumPortsCache() {
        return this.enumPortsCache;
    }
}

