/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ossimporter.core;

import eu.fbk.eclipse.explodtwin.ossimporter.core.OssEnumVisitorAction;
import eu.fbk.eclipse.explodtwin.ossimporter.core.OssVisitorAction;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.services.OSSModelFactory;
import eu.fbk.eclipse.standardtools.utils.core.utils.FileSystemUtil;
import eu.fbk.eclipse.standardtools.utils.core.visitors.ITreeGenericVisitorAction;
import eu.fbk.eclipse.standardtools.utils.core.visitors.TreeVisitor;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADialogUtil;
import eu.fbk.tools.editor.oss.oss.OSS;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class OssModelImporter {
    private static final Logger logger = Logger.getLogger(OssModelImporter.class);
    private static final String SYSML_SUFFIX = "sysml";
    public OCRADialogUtil ocraDialogUtil = OCRADialogUtil.getInstance();
    public OSSModelFactory ossModelFactory = OSSModelFactory.getInstance();
    public DialogUtil dialogUtil = DialogUtil.getInstance();
    public DirectoryUtil directoryUtil = DirectoryUtil.getInstance();

    public File processModel(File ossFile, String targetPath) throws Exception {
        OSS ossModel = this.ossModelFactory.createOssModel(ossFile);
        if (!Character.isUpperCase(ossModel.getSystem().getType().charAt(0))) {
            logger.warn((Object)"The root component is not written in uppercase, fixing it");
            ossModel.getSystem().setType(StringUtils.capitalize((String)ossModel.getSystem().getType()));
        }
        OssEnumVisitorAction enumVisitorAction = new OssEnumVisitorAction();
        TreeVisitor enumVisitor = new TreeVisitor((ITreeGenericVisitorAction)enumVisitorAction, TreeVisitor.Order.POSTORDER);
        enumVisitor.run((EObject)ossModel);
        OssVisitorAction visitorAction = new OssVisitorAction(enumVisitorAction);
        TreeVisitor visitor = new TreeVisitor((ITreeGenericVisitorAction)visitorAction, TreeVisitor.Order.POSTORDER);
        visitor.run((EObject)ossModel);
        String outputText = (String)visitorAction.getOutputObject((EObject)ossModel);
        String modelName = ossModel.getSystem().getType();
        File sysMLFile = targetPath != null ? new File(targetPath + File.separator + modelName + ".sysml") : new File(this.directoryUtil.getCurrentProjectDir() + File.separator + modelName + ".sysml");
        FileSystemUtil.writeFile((File)sysMLFile, (String)outputText);
        logger.debug((Object)("PATH = " + sysMLFile.getAbsolutePath()));
        logger.debug((Object)("MODEL = \n" + outputText));
        return sysMLFile;
    }
}

