/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ossimporter.core;

import com.google.common.primitives.Ints;
import eu.fbk.eclipse.explodtwin.ossimporter.core.IOssVisitorAction;
import eu.fbk.eclipse.explodtwin.ossimporter.core.OssEnumVisitorAction;
import eu.fbk.eclipse.explodtwin.ossimporter.utils.OssModelUtil;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.utils.OSSModelUtil;
import eu.fbk.eclipse.standardtools.utils.core.utils.Pair;
import eu.fbk.eclipse.standardtools.utils.core.visitors.ICachedTreeVisitorSupport;
import eu.fbk.tools.editor.basetype.baseType.BooleanLiteral;
import eu.fbk.tools.editor.basetype.baseType.BooleanType;
import eu.fbk.tools.editor.basetype.baseType.ClockType;
import eu.fbk.tools.editor.basetype.baseType.ContinuousType;
import eu.fbk.tools.editor.basetype.baseType.EnumType;
import eu.fbk.tools.editor.basetype.baseType.EqualityOperator;
import eu.fbk.tools.editor.basetype.baseType.EventType;
import eu.fbk.tools.editor.basetype.baseType.Expression;
import eu.fbk.tools.editor.basetype.baseType.Identifier;
import eu.fbk.tools.editor.basetype.baseType.IntegerLiteral;
import eu.fbk.tools.editor.basetype.baseType.IntegerType;
import eu.fbk.tools.editor.basetype.baseType.LogicalAndOperator;
import eu.fbk.tools.editor.basetype.baseType.LogicalOrOperator;
import eu.fbk.tools.editor.basetype.baseType.Operator;
import eu.fbk.tools.editor.basetype.baseType.RangeType;
import eu.fbk.tools.editor.basetype.baseType.RealLiteral;
import eu.fbk.tools.editor.basetype.baseType.RealType;
import eu.fbk.tools.editor.basetype.baseType.RelationalOperator;
import eu.fbk.tools.editor.basetype.baseType.UnaryLogicalOperator;
import eu.fbk.tools.editor.contract.contract.Assumption;
import eu.fbk.tools.editor.contract.contract.Contract;
import eu.fbk.tools.editor.contract.contract.Guarantee;
import eu.fbk.tools.editor.contract.expression.expression.AddSubExpression;
import eu.fbk.tools.editor.contract.expression.expression.Bound;
import eu.fbk.tools.editor.contract.expression.expression.BoundedExpression;
import eu.fbk.tools.editor.contract.expression.expression.ChangeFunction;
import eu.fbk.tools.editor.contract.expression.expression.ComponentId;
import eu.fbk.tools.editor.contract.expression.expression.CountFunction;
import eu.fbk.tools.editor.contract.expression.expression.DerivativeFunction;
import eu.fbk.tools.editor.contract.expression.expression.EqualityExpression;
import eu.fbk.tools.editor.contract.expression.expression.ExtendedLogicalOperator;
import eu.fbk.tools.editor.contract.expression.expression.FallRiseFunction;
import eu.fbk.tools.editor.contract.expression.expression.FullPortId;
import eu.fbk.tools.editor.contract.expression.expression.FullVariableId;
import eu.fbk.tools.editor.contract.expression.expression.LogicalExpression;
import eu.fbk.tools.editor.contract.expression.expression.NextFunction;
import eu.fbk.tools.editor.contract.expression.expression.ParameterId;
import eu.fbk.tools.editor.contract.expression.expression.PortId;
import eu.fbk.tools.editor.contract.expression.expression.RelationalExpression;
import eu.fbk.tools.editor.contract.expression.expression.TemporalExpression;
import eu.fbk.tools.editor.contract.expression.expression.TimeSinceUntilFunction;
import eu.fbk.tools.editor.contract.expression.expression.UnaryAlgebraicExpression;
import eu.fbk.tools.editor.contract.expression.expression.UnaryLogicalExpression;
import eu.fbk.tools.editor.contract.expression.expression.UnaryTemporalExpression;
import eu.fbk.tools.editor.contract.expression.expression.VariableId;
import eu.fbk.tools.editor.oss.oss.AbstractComponent;
import eu.fbk.tools.editor.oss.oss.Assertion;
import eu.fbk.tools.editor.oss.oss.ComplexType;
import eu.fbk.tools.editor.oss.oss.Component;
import eu.fbk.tools.editor.oss.oss.Connection;
import eu.fbk.tools.editor.oss.oss.Define;
import eu.fbk.tools.editor.oss.oss.FullContractIdList;
import eu.fbk.tools.editor.oss.oss.InputPort;
import eu.fbk.tools.editor.oss.oss.Interface;
import eu.fbk.tools.editor.oss.oss.InterfaceInstance;
import eu.fbk.tools.editor.oss.oss.InvarBehaviour;
import eu.fbk.tools.editor.oss.oss.IterativeCondition;
import eu.fbk.tools.editor.oss.oss.OSS;
import eu.fbk.tools.editor.oss.oss.OutputPort;
import eu.fbk.tools.editor.oss.oss.Parameter;
import eu.fbk.tools.editor.oss.oss.Port;
import eu.fbk.tools.editor.oss.oss.RefinedBy;
import eu.fbk.tools.editor.oss.oss.Refinement;
import eu.fbk.tools.editor.oss.oss.RefinementInstance;
import eu.fbk.tools.editor.oss.oss.SubComponent;
import eu.fbk.tools.editor.oss.oss.SubComponentType;
import eu.fbk.tools.editor.oss.oss.SystemComponent;
import eu.fbk.tools.editor.oss.oss.TimeAnnotation;
import eu.fbk.tools.editor.oss.oss.Variable;
import eu.fbk.tools.editor.oss.validation.ModelUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class OssVisitorAction
implements IOssVisitorAction,
ICachedTreeVisitorSupport {
    private static final Logger logger = Logger.getLogger(OssVisitorAction.class);
    protected static final String RESERVED_SUFFIX = "_v";
    protected static final String RANGE_PREFIX = "Bounded";
    protected static final String IFF = " iff ";
    protected static final String NOT = " not ";
    protected static final String IMPLIES = " implies ";
    protected OSSModelUtil ossModelUtil = OSSModelUtil.getInstance();
    protected boolean importContracts;
    protected boolean importLogicFunctions;
    protected boolean importScalarValues;
    protected boolean importMathFunctions;
    protected boolean importExtraTypes;
    protected boolean importTimeModes;
    protected boolean importLTLSpec;
    protected boolean importLTLFunction;
    protected boolean importExploDTwinMetadata;
    protected boolean importExploDTwinTypes;
    protected Set<String> reservedKeywords = new HashSet<String>(Arrays.asList("about", "abstract", "accept", "action", "actor", "after", "alias", "all", "allocate", "allocation", "analysis", "and", "as", "assert", "assign", "assoc", "assume", "at", "attribute", "behavior", "bind", "binding", "block", "bool", "by", "calc", "case", "chains", "class", "classifier", "comment", "composite", "concern", "conjugate", "conjugates", "conjugation", "connect", "connection", "connector", "constraint", "datatype", "decide", "def", "default", "defined", "dependency", "derived", "differences", "disjoining", "disjoint", "do", "doc", "element", "else", "end", "entry", "enum", "event", "exhibit", "exit", "expose", "expr", "false", "feature", "featured", "featuring", "filter", "first", "flow", "for", "fork", "frame", "from", "function", "hastype", "if", "implies", "import", "in", "include", "individual", "inout", "interaction", "interface", "intersects", "inv", "inverse", "inverting", "istype", "item", "join", "language", "loop", "member", "merge", "message", "metaclass", "metadata", "multiplicity", "namespace", "nonunique", "not", "null", "objective", "occurrence", "of", "or", "ordered", "out", "package", "parallel", "part", "perform", "port", "portion", "predicate", "private", "protected", "public", "readonly", "redefines", "redefinition", "ref", "references", "relationship", "render", "rendering", "rep", "require", "requirement", "return", "satisfy", "send", "snapshot", "specialization", "specializes", "stakeholder", "state", "step", "struct", "subclassifier", "subject", "subset", "subsets", "subtype", "succession", "then", "timeslice", "to", "transition", "true", "type", "typed", "typing", "unions", "until", "use", "variant", "variation", "verification", "verify", "via", "view", "viewpoint", "when", "while", "xor"));
    protected EMap<String, Set<String>> enumeratorsCache;
    protected EMap<String, String> enumPortsCache;
    protected EMap<String, Set<String>> componentPortsCache = new BasicEMap();
    protected EMap<String, Pair<String, String>> portsCache = new BasicEMap();
    protected EMap<String, Pair<Number, Number>> rangeTypeCache = new BasicEMap();
    protected EMap<String, String> rangePortsCache = new BasicEMap();
    protected EMap<String, InterpretedFunctionBody> interpretedFunctions = new BasicEMap();

    public OssVisitorAction() {
        translatorCache.clear();
    }

    public OssVisitorAction(OssEnumVisitorAction enumVisitorAction) {
        this();
        this.enumeratorsCache = enumVisitorAction.getEnumeratorsCache();
        this.enumPortsCache = enumVisitorAction.getEnumPortsCache();
    }

    @Override
    public void action(Assumption o) throws Exception {
        this.putOutputObject((EObject)o, this.getOutputObject((EObject)o.getConstraint()));
    }

    @Override
    public void action(Guarantee o) throws Exception {
        this.putOutputObject((EObject)o, this.getOutputObject((EObject)o.getConstraint()));
    }

    @Override
    public void action(TemporalExpression o) throws Exception {
        this.putOutputObject((EObject)o, String.valueOf(this.getOutputObject((EObject)o.getOp())) + " ( { " + this.removeParenthesis(o.getLeft()) + " }, { " + this.removeParenthesis(o.getRight()) + " } ) ");
    }

    @Override
    public void action(TimeAnnotation o) throws Exception {
    }

    @Override
    public void action(RealType o) throws Exception {
        this.putOutputObject((EObject)o, "Real");
        this.importScalarValues = true;
    }

    @Override
    public void action(RealLiteral o) throws Exception {
        this.putOutputObject((EObject)o, o.getValue());
    }

    @Override
    public void action(IntegerType o) throws Exception {
        this.putOutputObject((EObject)o, "Integer");
        this.importScalarValues = true;
    }

    @Override
    public void action(ContinuousType o) throws Exception {
        this.putOutputObject((EObject)o, "Continuous");
        this.importContracts = true;
    }

    @Override
    public void action(ComplexType o) throws Exception {
        this.putOutputObject((EObject)o, this.getOutputObject(o.getComplexType()));
    }

    @Override
    public void action(InputPort o) throws Exception {
        this.addPortToCache((Port)o);
        this.portsCache.put((Object)((String)this.getOutputObject((EObject)o.getId())), (Object)new Pair((Object)"in", (Object)((String)this.getOutputObject((EObject)o.getType()))));
    }

    @Override
    public void action(OutputPort o) throws Exception {
        this.addPortToCache((Port)o);
        this.portsCache.put((Object)((String)this.getOutputObject((EObject)o.getId())), (Object)new Pair((Object)"out", (Object)((String)this.getOutputObject((EObject)o.getType()))));
    }

    private void addPortToCache(Port port) throws Exception {
        String componentName = OssModelUtil.getOwnerComponentName((EObject)port);
        HashSet<String> ports = (HashSet<String>)this.componentPortsCache.get((Object)componentName);
        if (ports == null) {
            ports = new HashSet<String>();
        }
        ports.add((String)this.getOutputObject((EObject)port.getId()));
        this.componentPortsCache.put((Object)componentName, ports);
    }

    @Override
    public void action(InterfaceInstance o) throws Exception {
        if (o.getVariable() == null && o.getContract() == null && o.getDefine() == null) {
            if (o.getAssertion() != null) {
                this.putOutputObject((EObject)o, this.getOutputObject((EObject)o.getAssertion()));
            } else {
                throw new Exception("ParameterAssumption element not handled");
            }
        }
    }

    @Override
    public void action(BooleanType o) throws Exception {
        this.putOutputObject((EObject)o, "Boolean");
        this.importScalarValues = true;
    }

    @Override
    public void action(EventType o) throws Exception {
        this.putOutputObject((EObject)o, "event");
        this.importExploDTwinTypes = true;
    }

    @Override
    public void action(PortId o) throws Exception {
        if (this.reservedKeywords.contains(o.getName())) {
            o.setName(o.getName() + RESERVED_SUFFIX);
            logger.warn((Object)"A reserved key is used, adding _v suffix.");
        }
        this.putOutputObject((EObject)o, o.getName());
    }

    @Override
    public void action(Identifier o) throws Exception {
        this.putOutputObject((EObject)o, o.getValue());
    }

    @Override
    public void action(BooleanLiteral o) throws Exception {
        this.putOutputObject((EObject)o, o.getValue().toLowerCase());
    }

    @Override
    public void action(EnumType o) throws Exception {
        String componentName = OssModelUtil.getOwnerComponentName((EObject)o);
        String ownerPort = OssModelUtil.getPortNameForEnum(o);
        String enumName = (String)this.enumPortsCache.get((Object)(componentName + "." + ownerPort));
        this.putOutputObject((EObject)o, enumName);
    }

    @Override
    public void action(FullPortId o) throws Exception {
        this.putOutputObject((EObject)o, this.ossModelUtil.getFullPortIdToString(o, false));
    }

    @Override
    public void action(EqualityOperator o) throws Exception {
        if (o.getName().equals("=")) {
            this.putOutputObject((EObject)o, " == ");
        } else {
            this.putOutputObject((EObject)o, " != ");
        }
    }

    @Override
    public void action(IntegerLiteral o) throws Exception {
        this.putOutputObject((EObject)o, o.getValue());
    }

    @Override
    public void action(EqualityExpression o) throws Exception {
        String leftEnum;
        String rightEnum = this.getEnum(o.getRight());
        if (rightEnum != null) {
            FullPortId port = this.getFullPortIdFromExpression(o.getLeft());
            String enumDef = this.getPortEnumeration(port);
            this.putOutputObject((EObject)o.getRight(), enumDef + "::" + rightEnum);
        }
        if ((leftEnum = this.getEnum(o.getLeft())) != null) {
            FullPortId port = this.getFullPortIdFromExpression(o.getLeft());
            String enumDef = this.getPortEnumeration(port);
            this.putOutputObject((EObject)o.getLeft(), enumDef + "::" + leftEnum);
        }
        this.putOutputObject((EObject)o, (String)this.getOutputObject((EObject)o.getLeft()) + String.valueOf(this.getOutputObject((EObject)o.getOp())) + String.valueOf(this.getOutputObject((EObject)o.getRight())));
    }

    private String getPortEnumeration(FullPortId port) throws Exception {
        String portId = this.getPortOfFullPortId(port);
        String owner = this.getPortOwnerTypeName(port);
        String enumDef = (String)this.enumPortsCache.get((Object)(owner + "." + portId));
        return enumDef;
    }

    private String getPortOwnerTypeName(FullPortId port) throws Exception {
        String owner = this.getComponentsOfFullPortId(port);
        owner = owner == null ? OssModelUtil.getOwnerComponentName((EObject)port) : OssModelUtil.getSubComponentType((Expression)port, owner);
        return owner;
    }

    private FullPortId getFullPortIdFromExpression(Expression expr) {
        if (expr instanceof FullPortId) {
            return (FullPortId)expr;
        }
        return (FullPortId)EcoreUtil2.getAllContentsOfType((EObject)expr, FullPortId.class).get(0);
    }

    private String getEnum(Expression expr) throws Exception {
        if (OssModelUtil.isSimplePortId(expr)) {
            FullPortId port = (FullPortId)expr;
            String portId = this.getPortOfFullPortId(port);
            String owner = OssModelUtil.getOwnerComponentName((EObject)port);
            if (!OssModelUtil.isValue(portId) && !this.isRegularPort(owner, portId)) {
                return portId;
            }
        }
        return null;
    }

    private boolean isRegularPort(String owner, String port) {
        Set ports = (Set)this.componentPortsCache.get((Object)owner);
        return ports != null ? ports.contains(port) : false;
    }

    private String getComponentsOfFullPortId(FullPortId id) throws Exception {
        if (id.getFullComponentIds() != null && !id.getFullComponentIds().isEmpty()) {
            StringJoiner joiner = new StringJoiner(".");
            for (ComponentId comp : id.getFullComponentIds()) {
                joiner.add((String)this.getOutputObject((EObject)comp));
            }
            return joiner.toString();
        }
        return null;
    }

    private String getPortOfFullPortId(FullPortId id) throws Exception {
        return (String)this.getOutputObject((EObject)id.getId());
    }

    @Override
    public void action(BoundedExpression o) throws Exception {
        this.putOutputObject((EObject)o, " ( " + String.valueOf(this.getOutputObject((EObject)o.getExpression())) + " ) ");
    }

    @Override
    public void action(LogicalOrOperator o) throws Exception {
        this.putOutputObject((EObject)o, " or ");
    }

    @Override
    public void action(LogicalAndOperator o) throws Exception {
        this.putOutputObject((EObject)o, " and ");
    }

    @Override
    public void action(LogicalExpression o) throws Exception {
        if (this.getOutputObject((EObject)o.getOp()).equals(IFF)) {
            this.putOutputObject((EObject)o, " iff ( { " + this.removeParenthesis(o.getLeft()) + " }, { " + this.removeParenthesis(o.getRight()) + " } ) ");
        } else {
            this.putOutputObject((EObject)o, (String)this.getOutputObject((EObject)o.getLeft()) + String.valueOf(this.getOutputObject((EObject)o.getOp())) + String.valueOf(this.getOutputObject((EObject)o.getRight())));
        }
    }

    @Override
    public void action(Operator o) throws Exception {
        String operator = switch (o.getName()) {
            case "in the future" -> "in_the_future";
            case "in the past" -> "in_the_past";
            case "at next" -> "at_next";
            case "at last" -> "at_last";
            default -> o.getName();
        };
        this.putOutputObject((EObject)o, " " + operator + " ");
    }

    @Override
    public void action(NextFunction o) throws Exception {
        this.putOutputObject((EObject)o, o.getName() + " ( { " + this.removeParenthesis(o.getArgument()) + " } ) ");
    }

    @Override
    public void action(ExtendedLogicalOperator o) throws Exception {
        String operatorName = o.getName();
        if (operatorName.equals("iff") || operatorName.equals("<->")) {
            this.putOutputObject((EObject)o, IFF);
            this.importLogicFunctions = true;
        } else if (operatorName.equals("implies") || operatorName.equals("->")) {
            this.putOutputObject((EObject)o, IMPLIES);
        }
    }

    @Override
    public void action(UnaryTemporalExpression o) throws Exception {
        this.putOutputObject((EObject)o, String.valueOf(this.getOutputObject((EObject)o.getOperator())) + " ( { " + this.removeParenthesis(o.getOperand()) + " } ) ");
    }

    @Override
    public void action(UnaryLogicalOperator o) throws Exception {
        this.putOutputObject((EObject)o, NOT);
    }

    @Override
    public void action(Contract o) throws Exception {
        this.importContracts = true;
        this.importLTLFunction = true;
    }

    @Override
    public void action(ChangeFunction o) throws Exception {
        this.putOutputObject((EObject)o, o.getName() + " ( { " + this.removeParenthesis(o.getArgument()) + " } ) ");
    }

    @Override
    public void action(FallRiseFunction o) throws Exception {
        this.putOutputObject((EObject)o, o.getName() + " ( { " + this.removeParenthesis(o.getArgument()) + " } ) ");
    }

    @Override
    public void action(TimeSinceUntilFunction o) throws Exception {
        this.putOutputObject((EObject)o, o.getName() + " ( { " + this.removeParenthesis(o.getArgument()) + " } ) ");
    }

    @Override
    public void action(UnaryLogicalExpression o) throws Exception {
        this.putOutputObject((EObject)o, (String)this.getOutputObject((EObject)o.getOperator()) + String.valueOf(this.getOutputObject((EObject)o.getOperand())));
    }

    private String removeParenthesis(Expression expr) throws Exception {
        if (expr instanceof BoundedExpression) {
            return ((String)this.getOutputObject((EObject)expr)).replaceAll("^\\s*\\(\\s*|\\s*\\)\\s*$", "");
        }
        return (String)this.getOutputObject((EObject)expr);
    }

    @Override
    public void action(Interface o) throws Exception {
    }

    @Override
    public void action(SystemComponent o) throws Exception {
        String systemComponentName = o.getType() == null ? "System" : o.getType();
        this.putOutputObject((EObject)o, this.createBody((AbstractComponent)o, systemComponentName));
    }

    @Override
    public void action(OSS o) throws Exception {
        SystemComponent system = o.getSystem();
        String systemName = system.getType();
        String top = "package " + systemName + " {";
        top = top + System.lineSeparator() + "\tprivate import Hierarchy::*;";
        if (this.importContracts) {
            top = top + System.lineSeparator() + "\tprivate import Contracts::*;";
        }
        if (this.importScalarValues) {
            top = top + System.lineSeparator() + "\tprivate import ScalarValues::*;";
        }
        if (this.importLogicFunctions) {
            top = top + System.lineSeparator() + "\tprivate import LogicFunctions::*;";
        }
        if (this.importMathFunctions) {
            top = top + System.lineSeparator() + "\tprivate import MathFunctions::*;";
        }
        if (this.importExtraTypes) {
            top = top + System.lineSeparator() + "\tprivate import ExtraTypes::*;";
        }
        if (this.importTimeModes) {
            top = top + System.lineSeparator() + "\tprivate import TimeModes::*;";
        }
        if (this.importLTLSpec) {
            top = top + System.lineSeparator() + "\tprivate import LTLSpec::*;";
        }
        if (this.importLTLFunction) {
            top = top + System.lineSeparator() + "\tprivate import LTLFunctions::*;";
        }
        if (this.importExploDTwinMetadata) {
            top = top + System.lineSeparator() + "\tprivate import ExploDTwinMetadata::*;";
        }
        top = top + System.lineSeparator();
        if (this.importExploDTwinTypes) {
            top = top + System.lineSeparator() + "\tabstract item def Event;";
            top = top + System.lineSeparator() + "\titem def event :> Event;";
            top = top + System.lineSeparator();
        }
        for (Map.Entry enumerator : this.enumeratorsCache) {
            String enumDef = System.lineSeparator() + "\tenum def " + (String)enumerator.getKey() + " {";
            for (String value : (Set)enumerator.getValue()) {
                enumDef = enumDef + System.lineSeparator() + "\t\tenum " + value + ";";
            }
            enumDef = enumDef + System.lineSeparator() + "\t}";
            top = top + enumDef + System.lineSeparator();
        }
        for (Map.Entry rangeType : this.rangeTypeCache) {
            String rangeDef = System.lineSeparator() + "\tattribute def " + (String)rangeType.getKey();
            rangeDef = ((Pair)rangeType.getValue()).getLeft() instanceof Integer ? rangeDef + " :> BoundedInt {" : rangeDef + " :> BoundedReal {";
            rangeDef = rangeDef + System.lineSeparator() + "\t\tattribute :>> minValue = " + String.valueOf(((Pair)rangeType.getValue()).getLeft()) + ";";
            rangeDef = rangeDef + System.lineSeparator() + "\t\tattribute :>> maxValue = " + String.valueOf(((Pair)rangeType.getValue()).getRight()) + ";";
            rangeDef = rangeDef + System.lineSeparator() + "\t}";
            top = top + rangeDef + System.lineSeparator();
        }
        for (String function : this.interpretedFunctions.keySet()) {
            String define = System.lineSeparator() + "\tcalc def " + function + " {";
            InterpretedFunctionBody body = (InterpretedFunctionBody)this.interpretedFunctions.get((Object)function);
            for (InterpretedFunctionParameter param : body.parameters) {
                define = define + System.lineSeparator() + "\t\t" + param.name + " : " + param.type + ";";
            }
            define = define + System.lineSeparator() + "\t\t" + body.body;
            define = define + System.lineSeparator() + "\t}";
            top = top + define + System.lineSeparator();
        }
        top = top + String.valueOf(this.getOutputObject((EObject)system));
        for (Component component : o.getComponents()) {
            top = top + String.valueOf(this.getOutputObject((EObject)component));
        }
        top = top + System.lineSeparator() + "\tpart " + StringUtils.uncapitalize((String)systemName) + " : " + systemName + ", SystemComponent {";
        top = top + System.lineSeparator() + "\t}";
        top = top + System.lineSeparator() + "}";
        this.putOutputObject((EObject)o, top);
    }

    @Override
    public void action(ComponentId o) throws Exception {
        this.putOutputObject((EObject)o, o.getName());
    }

    @Override
    public void action(SubComponentType o) throws Exception {
    }

    @Override
    public void action(SubComponent o) throws Exception {
    }

    @Override
    public void action(RefinementInstance o) throws Exception {
    }

    @Override
    public void action(IterativeCondition o) throws Exception {
        if (o.getConstraint() != null || o.getIteratorBounds() != null) {
            throw new Exception("IterativeCondition in connections is not supported yet");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void action(InvarBehaviour o) throws Exception {
        RelationalExpression right;
        Expression expression;
        RelationalExpression left;
        Expression expression2;
        LogicalExpression logicalExpression;
        List ports = EcoreUtil2.getAllContentsOfType((EObject)o, FullPortId.class);
        if (ports.size() != 2 || !((FullPortId)ports.get(0)).getId().getName().equals(((FullPortId)ports.get(1)).getId().getName())) throw new Exception("Cannot handle this type of InvarBehaviour");
        String portName = ((FullPortId)ports.get(0)).getId().getName();
        Expression expression3 = o.getConstraint();
        if (!(expression3 instanceof LogicalExpression) || !((logicalExpression = (LogicalExpression)expression3).getOp() instanceof LogicalAndOperator) || !((expression2 = logicalExpression.getLeft()) instanceof RelationalExpression) || !((left = (RelationalExpression)expression2).getOp() instanceof RelationalOperator) || !((expression = logicalExpression.getRight()) instanceof RelationalExpression) || !((right = (RelationalExpression)expression).getOp() instanceof RelationalOperator)) return;
        ArrayList bounds = new ArrayList();
        bounds.addAll(EcoreUtil2.getAllContentsOfType((EObject)logicalExpression, IntegerLiteral.class));
        bounds.addAll(EcoreUtil2.getAllContentsOfType((EObject)logicalExpression, RealLiteral.class));
        if (bounds.size() != 2) throw new Exception("Cannot handle this type of bounded element");
        String rangeName = this.createRangeType((EObject)bounds.get(0), (EObject)bounds.get(1));
        this.rangePortsCache.put((Object)portName, (Object)rangeName);
    }

    @Override
    public void action(Connection o) throws Exception {
    }

    @Override
    public void action(AddSubExpression o) throws Exception {
        this.putOutputObject((EObject)o, (String)this.getOutputObject((EObject)o.getLeft()) + String.valueOf(this.getOutputObject((EObject)o.getOp())) + String.valueOf(this.getOutputObject((EObject)o.getRight())));
    }

    @Override
    public void action(RelationalExpression o) throws Exception {
        this.putOutputObject((EObject)o, (String)this.getOutputObject((EObject)o.getLeft()) + String.valueOf(this.getOutputObject((EObject)o.getOp())) + String.valueOf(this.getOutputObject((EObject)o.getRight())));
    }

    @Override
    public void action(UnaryAlgebraicExpression o) throws Exception {
        this.putOutputObject((EObject)o, (String)this.getOutputObject((EObject)o.getOperator()) + String.valueOf(this.getOutputObject((EObject)o.getOperand())));
    }

    @Override
    public void action(Component o) throws Exception {
        String componentName = o.getType();
        this.putOutputObject((EObject)o, this.createBody((AbstractComponent)o, componentName));
    }

    private String createBody(AbstractComponent o, String componentName) throws Exception {
        String body = System.lineSeparator() + "\tpart def " + componentName + " {";
        body = body + this.handleInterface(o.getInterface());
        body = body + this.handleRefinement(o.getRefinement());
        body = body + System.lineSeparator() + "\t}" + System.lineSeparator();
        this.portsCache.clear();
        this.rangePortsCache.clear();
        return body;
    }

    private String handleInterface(Interface interfaceElement) throws Exception {
        Object body = "";
        for (Map.Entry port : this.portsCache) {
            String portName = (String)port.getKey();
            String direction = (String)((Pair)port.getValue()).getLeft();
            String portType = (String)this.rangePortsCache.get((Object)portName);
            if (portType == null) {
                portType = (String)((Pair)port.getValue()).getRight();
            }
            body = (String)body + System.lineSeparator() + "\t\t" + direction + " attribute " + portName + " : " + portType + ";";
        }
        body = (String)body + System.lineSeparator();
        for (InterfaceInstance interfaceInstance : interfaceElement.getInterfaces()) {
            if (interfaceInstance.getContract() != null) {
                String refinement;
                Contract ctr = interfaceInstance.getContract();
                String contract = "attribute " + ctr.getName() + " : Contract {";
                if (ctr.getAssumption() != null) {
                    contract = contract + System.lineSeparator() + "\t\t\tassert constraint :>> assumption {";
                    contract = contract + System.lineSeparator() + "\t\t\t\t" + this.ossModelUtil.getCleanExpression((String)this.getOutputObject((EObject)ctr.getAssumption()));
                    contract = contract + System.lineSeparator() + "\t\t\t}";
                }
                if (ctr.getGuarantee() != null) {
                    contract = contract + System.lineSeparator() + "\t\t\tassert constraint :>> guarantee {";
                    contract = contract + System.lineSeparator() + "\t\t\t\t" + this.ossModelUtil.getCleanExpression((String)this.getOutputObject((EObject)ctr.getGuarantee()));
                    contract = contract + System.lineSeparator() + "\t\t\t}";
                }
                if ((refinement = this.findContractRefinement(ctr)) != null) {
                    contract = contract + System.lineSeparator() + "\t\t\t" + refinement;
                }
                contract = contract + System.lineSeparator() + "\t\t}";
                body = (String)body + System.lineSeparator() + "\t\t" + contract;
                continue;
            }
            if (interfaceInstance.getDefine() != null) {
                this.handleDefine(interfaceInstance.getDefine());
                continue;
            }
            if (interfaceInstance.getVariable() != null) continue;
            body = (String)body + System.lineSeparator() + "\t\t" + String.valueOf(this.getOutputObject((EObject)interfaceInstance));
        }
        return body;
    }

    private void handleDefine(Define define) throws Exception {
        String functionName = define.getName();
        if (!this.interpretedFunctions.containsKey((Object)functionName)) {
            String body = (String)this.getOutputObject((EObject)define.getConstraint());
            ArrayList<InterpretedFunctionParameter> parameters = new ArrayList();
            parameters = this.computeParameters(define);
            InterpretedFunctionBody functionBody = new InterpretedFunctionBody(body, parameters);
            this.interpretedFunctions.put((Object)functionName, (Object)functionBody);
        }
    }

    private List<InterpretedFunctionParameter> computeParameters(Define define) throws Exception {
        ArrayList<InterpretedFunctionParameter> parameters = new ArrayList<InterpretedFunctionParameter>();
        Interface iface = ModelUtil.getParentComponentType((EObject)define).getInterface();
        for (FullPortId port : EcoreUtil2.getAllContentsOfType((EObject)define, FullPortId.class)) {
            String portName = this.getPortOfFullPortId(port);
            for (InterfaceInstance instance : iface.getInterfaces()) {
                Variable var;
                if (instance.getVariable() == null || !(var = instance.getVariable()).getId().getName().equals(portName)) continue;
                InterpretedFunctionParameter parameter = new InterpretedFunctionParameter(portName, (String)this.getOutputObject(((Port)var).getType().getComplexType()));
                parameters.add(parameter);
            }
        }
        return parameters;
    }

    private String findContractRefinement(Contract contract) throws Exception {
        AbstractComponent owner = ModelUtil.getParentComponentType((EObject)contract);
        Refinement refinement = owner.getRefinement();
        if (refinement != null) {
            for (RefinementInstance ref : refinement.getRefinements()) {
                RefinedBy refined;
                if (ref.getRefinedby() == null || !(refined = ref.getRefinedby()).getName().equals(contract.getName())) continue;
                return (String)this.getOutputObject((EObject)refined);
            }
        }
        return null;
    }

    private String handleRefinement(Refinement refinement) throws Exception {
        Object composition = "";
        if (refinement != null) {
            for (RefinementInstance refinementInstance : refinement.getRefinements()) {
                if (refinementInstance.getSubcomponent() != null) {
                    SubComponent subComp = refinementInstance.getSubcomponent();
                    String subCompName = subComp.getName().getName();
                    String subCompType = subComp.getType().getComponentTypeName();
                    composition = (String)composition + System.lineSeparator() + "\t\tpart " + subCompName + " : " + subCompType + ";";
                    continue;
                }
                if (refinementInstance.getConnection() != null) {
                    Connection connection = refinementInstance.getConnection();
                    FullVariableId var = connection.getVariable();
                    String variable = (String)this.getOutputObject((EObject)var);
                    Expression expr = connection.getConstraint();
                    String expression = (String)this.getOutputObject((EObject)expr);
                    if (expr instanceof FullPortId) {
                        if (var instanceof FullPortId) {
                            String enumDef = this.getPortEnumeration((FullPortId)var);
                            String enumLiteral = this.getEnum(expr);
                            if (enumDef != null && enumLiteral != null) {
                                composition = (String)composition + System.lineSeparator() + "\t\t:>> " + variable + " = " + enumDef + "::" + expression + ";";
                                continue;
                            }
                            if (this.getComponentsOfFullPortId((FullPortId)var) == null || this.getComponentsOfFullPortId((FullPortId)expr) == null) {
                                composition = (String)composition + System.lineSeparator() + "\t\tbind " + expression + " = " + variable + ";";
                                continue;
                            }
                            composition = (String)composition + System.lineSeparator() + "\t\tconnect " + expression + " to " + variable + ";";
                            continue;
                        }
                        throw new Exception("Not supported variable type: " + String.valueOf(var));
                    }
                    composition = (String)composition + System.lineSeparator() + "\t\t:>> " + variable + " = " + expression + ";";
                    this.importLTLSpec = true;
                    this.importLTLFunction = true;
                    continue;
                }
                if (refinementInstance.getRefinedby() != null) continue;
                if (refinementInstance.getAssertion() != null) {
                    Assertion assertion = refinementInstance.getAssertion();
                    composition = (String)composition + String.valueOf(this.getOutputObject((EObject)assertion));
                    continue;
                }
                if (refinementInstance.getBehaviour() != null) {
                    if (refinementInstance.getBehaviour() instanceof InvarBehaviour) continue;
                    throw new Exception("Refinement element not handled: " + String.valueOf(refinementInstance));
                }
                throw new Exception("Refinement element not handled: " + String.valueOf(refinementInstance));
            }
        }
        return composition;
    }

    @Override
    public void action(Refinement o) throws Exception {
    }

    @Override
    public void action(RangeType o) throws Exception {
        if (o.getLowerBound() instanceof Identifier || o.getUpperBound() instanceof Identifier) {
            throw new Exception("Identifier element not supported in RangeType");
        }
        String rangeName = this.createRangeType(o.getLowerBound(), o.getUpperBound());
        this.putOutputObject((EObject)o, rangeName);
    }

    private String createRangeType(EObject bound1, EObject bound2) throws Exception {
        String rangeName = null;
        this.importExtraTypes = true;
        String value1 = this.extractLiteralValue(bound1);
        String value2 = this.extractLiteralValue(bound2);
        Number lowerBound = null;
        Number upperBound = null;
        Integer i1 = Ints.tryParse((String)value1);
        Integer i2 = Ints.tryParse((String)value2);
        if (i1 != null && i2 != null) {
            if (i1 < i2) {
                lowerBound = i1;
                upperBound = i2;
            } else {
                lowerBound = i2;
                upperBound = i1;
            }
        } else {
            try {
                float f1 = Float.parseFloat(value1);
                float f2 = Float.parseFloat(value2);
                if (f1 < f2) {
                    lowerBound = Float.valueOf(f1);
                    upperBound = Float.valueOf(f2);
                } else {
                    lowerBound = Float.valueOf(f2);
                    upperBound = Float.valueOf(f1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("Error: One of the ranges is not a valid number.");
            }
        }
        Pair newPair = new Pair((Object)lowerBound, (Object)upperBound);
        for (Map.Entry entry : this.rangeTypeCache) {
            if (!((Pair)entry.getValue()).equals((Object)newPair)) continue;
            rangeName = (String)entry.getKey();
        }
        if (rangeName == null) {
            rangeName = OssVisitorAction.createRangeName(lowerBound, upperBound);
            this.rangeTypeCache.put((Object)rangeName, (Object)newPair);
        }
        return rangeName;
    }

    public static String createRangeName(Number lower, Number upper) {
        String lowerStr = OssVisitorAction.formatNumberForVariable(lower);
        String upperStr = OssVisitorAction.formatNumberForVariable(upper);
        return String.format("%s__%s__%s", RANGE_PREFIX, lowerStr, upperStr);
    }

    private static String formatNumberForVariable(Number num) {
        Object s = String.valueOf(num);
        if (((String)s).startsWith("-")) {
            s = "neg" + ((String)s).substring(1);
        }
        return ((String)s).replace('.', '_');
    }

    private String extractLiteralValue(EObject bound) {
        if (bound instanceof IntegerLiteral) {
            IntegerLiteral b = (IntegerLiteral)bound;
            return b.getValue();
        }
        if (bound instanceof RealLiteral) {
            RealLiteral b = (RealLiteral)bound;
            return b.getValue();
        }
        return null;
    }

    @Override
    public void action(FullContractIdList o) throws Exception {
        this.putOutputObject((EObject)o, this.ossModelUtil.getFullContractIdAsString(o, false));
    }

    @Override
    public void action(Define o) throws Exception {
    }

    @Override
    public void action(Assertion o) throws Exception {
        String assertion = "attribute " + this.ossModelUtil.getAssertionName(o) + " : LTLSpec {" + System.lineSeparator();
        assertion = assertion + "\t\t\tconstraint :>> formula = { ";
        assertion = assertion + String.valueOf(this.getOutputObject((EObject)o.getConstraint())) + "};";
        assertion = assertion + System.lineSeparator() + "\t\t}";
        this.putOutputObject((EObject)o, assertion);
        this.importLTLSpec = true;
        this.importLTLFunction = true;
    }

    @Override
    public void action(DerivativeFunction o) throws Exception {
        this.putOutputObject((EObject)o, o.getName() + " ( " + String.valueOf(this.getOutputObject((EObject)o.getArgument())) + " ) ");
    }

    @Override
    public void action(RefinedBy o) throws Exception {
        Object refinement = ":>> refinedBy = ";
        StringJoiner joiner = new StringJoiner(", ", "(", ");");
        for (FullContractIdList idList : o.getFullContractIds()) {
            joiner.add((String)this.getOutputObject((EObject)idList));
        }
        refinement = (String)refinement + joiner.toString();
        this.putOutputObject((EObject)o, refinement);
    }

    @Override
    public void action(CountFunction o) throws Exception {
        this.importMathFunctions = true;
        String count = " " + o.getName() + " ";
        StringJoiner joiner = new StringJoiner(", ", "( ", " ) ");
        for (Expression arg : o.getArguments()) {
            joiner.add((String)this.getOutputObject((EObject)arg));
        }
        count = count + joiner.toString();
        this.putOutputObject((EObject)o, count);
    }

    @Override
    public void action(ClockType o) throws Exception {
        this.putOutputObject((EObject)o, "Clock");
        this.importTimeModes = true;
    }

    @Override
    public void action(Parameter o) throws Exception {
        String parameter = null;
        if (o.getParameters().size() != 0) {
            parameter = System.lineSeparator() + "\t\tcalc def " + String.valueOf(this.getOutputObject((EObject)o.getId())) + " {" + System.lineSeparator();
            parameter = parameter + "\t\t\t@UninterpretedFunction;" + System.lineSeparator();
            int counter = 0;
            for (ComplexType param : o.getParameters()) {
                parameter = parameter + "\t\t\tin attribute in" + counter++ + ": " + String.valueOf(this.getOutputObject((EObject)param)) + ";" + System.lineSeparator();
            }
            parameter = parameter + "\t\t\treturn : " + String.valueOf(this.getOutputObject((EObject)o.getType())) + ";" + System.lineSeparator() + "\t\t}";
        } else {
            parameter = "attribute " + String.valueOf(this.getOutputObject((EObject)o.getId())) + " : " + String.valueOf(this.getOutputObject((EObject)o.getType())) + ";";
        }
        this.importExploDTwinMetadata = true;
        this.putOutputObject((EObject)o, parameter);
    }

    @Override
    public void action(ParameterId o) throws Exception {
        this.putOutputObject((EObject)o, this.ossModelUtil.getVariableIdAsString((VariableId)o, false));
    }

    @Override
    public void action(Bound o) throws Exception {
        throw new Exception("Bounds on LTL operators are not supported yet");
    }

    protected record InterpretedFunctionBody(String body, List<InterpretedFunctionParameter> parameters) {
    }

    protected record InterpretedFunctionParameter(String name, String type) {
    }
}

