/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ossimporter.ui.commands;

import eu.fbk.eclipse.explodtwin.ossimporter.core.OssModelImporter;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADialogUtil;
import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class ImportOssFileCommand
extends AbstractHandler {
    private OCRADialogUtil ocraDialogUtil = OCRADialogUtil.getInstance();
    private DialogUtil dialogUtil = DialogUtil.getInstance();
    private OssModelImporter ossModelImporter = new OssModelImporter();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            File ossFile = this.ocraDialogUtil.getOssFileFromFileDialog();
            if (ossFile != null) {
                File sysMLFile = this.ossModelImporter.processModel(ossFile, null);
                String message = "SysML file is stored as: " + sysMLFile.getAbsolutePath();
                this.dialogUtil.showMessage_GenericMessage("SysMLv2 Generation", message);
            }
        }
        catch (Exception e) {
            this.dialogUtil.showMessage_ExceptionError(e);
            e.printStackTrace();
        }
        return null;
    }
}

