/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.oss.formatting2;

import com.google.inject.Inject;
import eu.fbk.tools.editor.basetype.baseType.BoundedArrayType;
import eu.fbk.tools.editor.basetype.baseType.EnumType;
import eu.fbk.tools.editor.contract.contract.Assumption;
import eu.fbk.tools.editor.contract.contract.Contract;
import eu.fbk.tools.editor.contract.contract.Contracts;
import eu.fbk.tools.editor.contract.contract.Guarantee;
import eu.fbk.tools.editor.contract.expression.expression.ArrayIndex;
import eu.fbk.tools.editor.contract.expression.expression.ComponentId;
import eu.fbk.tools.editor.contract.expression.expression.FullParameterId;
import eu.fbk.tools.editor.contract.expression.expression.FullPortId;
import eu.fbk.tools.editor.contract.expression.expression.IteratorBound;
import eu.fbk.tools.editor.contract.expression.expression.IteratorBounds;
import eu.fbk.tools.editor.contract.expression.expression.LogicalExpression;
import eu.fbk.tools.editor.contract.expression.expression.ParameterId;
import eu.fbk.tools.editor.contract.expression.expression.PortId;
import eu.fbk.tools.editor.contract.expression.expression.TemporalExpression;
import eu.fbk.tools.editor.contract.formatting2.ContractFormatter;
import eu.fbk.tools.editor.oss.oss.Assertion;
import eu.fbk.tools.editor.oss.oss.Behaviour;
import eu.fbk.tools.editor.oss.oss.Component;
import eu.fbk.tools.editor.oss.oss.Connection;
import eu.fbk.tools.editor.oss.oss.Define;
import eu.fbk.tools.editor.oss.oss.FormulaConstraint;
import eu.fbk.tools.editor.oss.oss.FullContractIdList;
import eu.fbk.tools.editor.oss.oss.InputPort;
import eu.fbk.tools.editor.oss.oss.Interface;
import eu.fbk.tools.editor.oss.oss.InterfaceInstance;
import eu.fbk.tools.editor.oss.oss.IterativeCondition;
import eu.fbk.tools.editor.oss.oss.OSS;
import eu.fbk.tools.editor.oss.oss.OutputPort;
import eu.fbk.tools.editor.oss.oss.Parameter;
import eu.fbk.tools.editor.oss.oss.PreprocessorDirective;
import eu.fbk.tools.editor.oss.oss.RefinedBy;
import eu.fbk.tools.editor.oss.oss.Refinement;
import eu.fbk.tools.editor.oss.oss.RefinementInstance;
import eu.fbk.tools.editor.oss.oss.SubComponent;
import eu.fbk.tools.editor.oss.oss.SystemComponent;
import eu.fbk.tools.editor.oss.oss.TimeAnnotation;
import eu.fbk.tools.editor.oss.oss.Variable;
import eu.fbk.tools.editor.oss.services.OssGrammarAccess;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;

public class OssFormatter
extends ContractFormatter {
    @Inject
    @Extension
    private OssGrammarAccess grammarAccess;

    protected void _format(OSS oSS, @Extension IFormattableDocument document) {
        EList<PreprocessorDirective> _preDirectives = oSS.getPreDirectives();
        for (PreprocessorDirective preprocessorDirective : _preDirectives) {
            document.format((Object)preprocessorDirective);
        }
        document.format((Object)oSS.getAnnotation());
        document.format((Object)oSS.getSystem());
        EList<Component> _components = oSS.getComponents();
        for (Component component : _components) {
            Procedures.Procedure1 _function = it -> it.newLine();
            document.format((Object)((Component)document.prepend((EObject)component, _function)));
            document.format((Object)component.getInterface());
        }
    }

    protected void _format(SystemComponent systemComponent, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend(this.textRegionExtensions.allRegionsFor((EObject)systemComponent).keyword("COMPONENT"), _function);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)systemComponent).keyword("system"), _function_1);
        document.format((Object)systemComponent.getInterface());
        document.format((Object)systemComponent.getRefinement());
    }

    protected void _format(Interface inter, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.surround(this.textRegionExtensions.allRegionsFor((EObject)inter).keyword("INTERFACE"), _function);
        EList<InterfaceInstance> _interfaces = inter.getInterfaces();
        for (InterfaceInstance interface_ : _interfaces) {
            Contract _contract;
            boolean _tripleNotEquals_3;
            Define _define;
            boolean _tripleNotEquals_2;
            Assertion _assertion;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            Variable _variable = interface_.getVariable();
            boolean bl = _tripleNotEquals = _variable != null;
            if (_tripleNotEquals) {
                document.format((Object)interface_.getVariable());
            }
            boolean bl2 = _tripleNotEquals_1 = (_assertion = interface_.getAssertion()) != null;
            if (_tripleNotEquals_1) {
                document.format((Object)interface_.getAssertion());
            }
            boolean bl3 = _tripleNotEquals_2 = (_define = interface_.getDefine()) != null;
            if (_tripleNotEquals_2) {
                document.format((Object)interface_.getDefine());
            }
            boolean bl4 = _tripleNotEquals_3 = (_contract = interface_.getContract()) != null;
            if (!_tripleNotEquals_3) continue;
            document.format((Object)interface_.getContract());
        }
    }

    protected void _format(Component component, @Extension IFormattableDocument document) {
        document.format((Object)component.getRefinement());
    }

    protected void _format(TimeAnnotation annotation, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.surround((EObject)annotation, _function);
    }

    protected void _format(InputPort port, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)port).ruleCall(this.grammarAccess.getInputPortAccess().getSEMICOLONTerminalRuleCall_5()), _function);
    }

    protected void _format(OutputPort port, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)port).ruleCall(this.grammarAccess.getOutputPortAccess().getSEMICOLONTerminalRuleCall_5()), _function);
    }

    protected void _format(Parameter parameter, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)parameter).ruleCall(this.grammarAccess.getParameterAccess().getSEMICOLONTerminalRuleCall_5()), _function);
    }

    protected void _format(Connection connection, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)connection).ruleCall(this.grammarAccess.getConnectionAccess().getSEMICOLONTerminalRuleCall_5()), _function);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        document.surround(this.textRegionExtensions.allRegionsFor((EObject)connection).ruleCall(this.grammarAccess.getFullPortIdAccess().getDOTTerminalRuleCall_1_1()), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        document.surround(this.textRegionExtensions.allRegionsFor((EObject)connection).ruleCall(this.grammarAccess.getFullParameterIdAccess().getDOTTerminalRuleCall_1_1()), _function_2);
        document.format((Object)connection.getVariable());
        document.format((Object)connection.getConstraint());
        document.format((Object)connection.getIterativeCondition());
    }

    protected void _format(IterativeCondition iterativeCondition, @Extension IFormattableDocument document) {
        document.format((Object)iterativeCondition.getConstraint());
        document.format((Object)iterativeCondition.getIteratorBounds());
    }

    protected void _format(SubComponent component, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)component).ruleCall(this.grammarAccess.getSubComponentAccess().getSEMICOLONTerminalRuleCall_4()), _function);
        document.format((Object)component.getName());
    }

    protected void _format(Contract contract, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend(this.textRegionExtensions.allRegionsFor((EObject)contract).keyword("CONTRACT"), _function);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.allRegionsFor((EObject)contract).keyword("assume"), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.allRegionsFor((EObject)contract).keyword("guarantee"), _function_2);
        document.format((Object)contract.getAssumption());
        document.format((Object)contract.getGuarantee());
    }

    protected void _format(Refinement refinement, @Extension IFormattableDocument document) {
        boolean _tripleNotEquals;
        String _type = refinement.getType();
        boolean bl = _tripleNotEquals = _type != null;
        if (_tripleNotEquals) {
            Procedures.Procedure1 _function = it -> it.newLine();
            document.prepend(this.textRegionExtensions.allRegionsFor((EObject)refinement).keyword("ASYNC"), _function);
            Procedures.Procedure1 _function_1 = it -> it.setSpace(" ");
            document.append(this.textRegionExtensions.allRegionsFor((EObject)refinement).keyword("ASYNC"), _function_1);
        } else {
            Procedures.Procedure1 _function_2 = it -> it.newLine();
            document.prepend(this.textRegionExtensions.allRegionsFor((EObject)refinement).keyword("REFINEMENT"), _function_2);
        }
        Procedures.Procedure1 _function_3 = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)refinement).keyword("REFINEMENT"), _function_3);
        EList<RefinementInstance> _refinements = refinement.getRefinements();
        for (RefinementInstance refinementInstance : _refinements) {
            document.format((Object)refinementInstance);
        }
    }

    protected void _format(RefinementInstance refinementInstance, @Extension IFormattableDocument document) {
        document.format((Object)refinementInstance.getConnection());
        document.format((Object)refinementInstance.getFormula());
        document.format((Object)refinementInstance.getRefinedby());
        document.format((Object)refinementInstance.getProp());
        document.format((Object)refinementInstance.getSubcomponent());
        document.format((Object)refinementInstance.getAssertion());
        document.format((Object)refinementInstance.getBehaviour());
    }

    protected void _format(Assertion assertion, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)assertion).ruleCall(this.grammarAccess.getAssertionAccess().getSEMICOLONTerminalRuleCall_5()), _function);
        document.format((Object)assertion.getConstraint());
    }

    protected void _format(Behaviour behaviour, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)behaviour).ruleCall(this.grammarAccess.getBehaviourAccess().getSEMICOLONTerminalRuleCall_0_3()), _function);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)behaviour).ruleCall(this.grammarAccess.getBehaviourAccess().getSEMICOLONTerminalRuleCall_1_5()), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)behaviour).ruleCall(this.grammarAccess.getBehaviourAccess().getSEMICOLONTerminalRuleCall_2_3()), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)behaviour).ruleCall(this.grammarAccess.getBehaviourAccess().getSEMICOLONTerminalRuleCall_3_3()), _function_3);
        Procedures.Procedure1 _function_4 = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)behaviour).ruleCall(this.grammarAccess.getBehaviourAccess().getSEMICOLONTerminalRuleCall_4_3()), _function_4);
    }

    protected void _format(Define define, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)define).ruleCall(this.grammarAccess.getDefineAccess().getSEMICOLONTerminalRuleCall_4()), _function);
        document.format((Object)define.getConstraint());
    }

    protected void _format(FormulaConstraint constraint, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(this.textRegionExtensions.allRegionsFor((EObject)constraint).ruleCall(this.grammarAccess.getFormulaConstraintAccess().getSEMICOLONTerminalRuleCall_2()), _function);
        document.format((Object)constraint.getConstraint());
    }

    protected void _format(RefinedBy refinement, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.setSpace(" ");
        document.prepend(this.textRegionExtensions.allRegionsFor((EObject)refinement).keyword("REFINEDBY"), _function);
        EList<FullContractIdList> _fullContractIds = refinement.getFullContractIds();
        for (FullContractIdList contractId : _fullContractIds) {
            document.format((Object)contractId);
        }
    }

    protected void _format(FullContractIdList id, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = k -> {
            Procedures.Procedure1 _function_1 = it -> it.noSpace();
            document.surround(k, _function_1);
        };
        this.textRegionExtensions.allRegionsFor((EObject)id).ruleCalls(new RuleCall[]{this.grammarAccess.getFullContractIdListAccess().getDOTTerminalRuleCall_0_1()}).forEach(_function);
        EList<ComponentId> _fullComponentIds = id.getFullComponentIds();
        for (ComponentId fullComponentId : _fullComponentIds) {
            document.format((Object)fullComponentId);
        }
    }

    public void format(Object port, IFormattableDocument document) {
        if (port instanceof BoundedArrayType) {
            this._format((BoundedArrayType)port, document);
            return;
        }
        if (port instanceof FullParameterId) {
            this._format((FullParameterId)port, document);
            return;
        }
        if (port instanceof FullPortId) {
            this._format((FullPortId)port, document);
            return;
        }
        if (port instanceof EnumType) {
            this._format((EnumType)port, document);
            return;
        }
        if (port instanceof LogicalExpression) {
            this._format((LogicalExpression)port, document);
            return;
        }
        if (port instanceof TemporalExpression) {
            this._format((TemporalExpression)port, document);
            return;
        }
        if (port instanceof InputPort) {
            this._format((InputPort)port, document);
            return;
        }
        if (port instanceof OutputPort) {
            this._format((OutputPort)port, document);
            return;
        }
        if (port instanceof XtextResource) {
            this._format((XtextResource)port, document);
            return;
        }
        if (port instanceof ParameterId) {
            this._format((ParameterId)port, document);
            return;
        }
        if (port instanceof PortId) {
            this._format((PortId)port, document);
            return;
        }
        if (port instanceof Component) {
            this._format((Component)port, document);
            return;
        }
        if (port instanceof Parameter) {
            this._format((Parameter)port, document);
            return;
        }
        if (port instanceof SystemComponent) {
            this._format((SystemComponent)port, document);
            return;
        }
        if (port instanceof Assumption) {
            this._format((Assumption)port, document);
            return;
        }
        if (port instanceof Contract) {
            this._format((Contract)port, document);
            return;
        }
        if (port instanceof Contracts) {
            this._format((Contracts)port, document);
            return;
        }
        if (port instanceof Guarantee) {
            this._format((Guarantee)port, document);
            return;
        }
        if (port instanceof ArrayIndex) {
            this._format((ArrayIndex)port, document);
            return;
        }
        if (port instanceof ComponentId) {
            this._format((ComponentId)port, document);
            return;
        }
        if (port instanceof IteratorBound) {
            this._format((IteratorBound)port, document);
            return;
        }
        if (port instanceof IteratorBounds) {
            this._format((IteratorBounds)port, document);
            return;
        }
        if (port instanceof Assertion) {
            this._format((Assertion)port, document);
            return;
        }
        if (port instanceof Behaviour) {
            this._format((Behaviour)port, document);
            return;
        }
        if (port instanceof Connection) {
            this._format((Connection)port, document);
            return;
        }
        if (port instanceof Define) {
            this._format((Define)port, document);
            return;
        }
        if (port instanceof FormulaConstraint) {
            this._format((FormulaConstraint)port, document);
            return;
        }
        if (port instanceof FullContractIdList) {
            this._format((FullContractIdList)port, document);
            return;
        }
        if (port instanceof Interface) {
            this._format((Interface)port, document);
            return;
        }
        if (port instanceof IterativeCondition) {
            this._format((IterativeCondition)port, document);
            return;
        }
        if (port instanceof OSS) {
            this._format((OSS)port, document);
            return;
        }
        if (port instanceof RefinedBy) {
            this._format((RefinedBy)port, document);
            return;
        }
        if (port instanceof Refinement) {
            this._format((Refinement)port, document);
            return;
        }
        if (port instanceof RefinementInstance) {
            this._format((RefinementInstance)port, document);
            return;
        }
        if (port instanceof SubComponent) {
            this._format((SubComponent)port, document);
            return;
        }
        if (port instanceof TimeAnnotation) {
            this._format((TimeAnnotation)port, document);
            return;
        }
        if (port instanceof EObject) {
            this._format((EObject)port, document);
            return;
        }
        if (port == null) {
            this._format(null, document);
            return;
        }
        if (port != null) {
            this._format(port, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(port, document).toString());
    }
}

