/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FreeMarkerUtil {
    private static final String K2_TEMPLATES_DIR = "templates/templates_k2";
    private static final String PY_TEMPLATES_DIR = "templates/templates_py";
    private static final String FEI_TEMPLATES_DIR = "templates/templates_fei";
    private static final Logger logger = Logger.getLogger(FreeMarkerUtil.class);

    public Template init(String templateModelName, SupportedLanguage outputLang) {
        Template template;
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_22);
        logger.debug((Object)("before load TemplateLoader: " + cfg.toString()));
        String encoding = "UTF-8";
        try {
            ClassTemplateLoader classTemplateLoader = null;
            if (outputLang.equals((Object)SupportedLanguage.K2)) {
                classTemplateLoader = new ClassTemplateLoader(this.getClass(), K2_TEMPLATES_DIR);
            } else if (outputLang.equals((Object)SupportedLanguage.PYTHON)) {
                classTemplateLoader = new ClassTemplateLoader(this.getClass(), PY_TEMPLATES_DIR);
            } else if (outputLang.equals((Object)SupportedLanguage.FEI)) {
                classTemplateLoader = new ClassTemplateLoader(this.getClass(), FEI_TEMPLATES_DIR);
            }
            if (classTemplateLoader != null) {
                cfg.setTemplateLoader((TemplateLoader)classTemplateLoader);
                logger.debug((Object)("Load TemplateLoader: " + cfg.getTemplateLoader().toString()));
            }
            logger.debug((Object)("Load TemplateLoader: " + cfg.getTemplateLoader().toString()));
            template = cfg.getTemplate(templateModelName, encoding);
        }
        catch (IOException e) {
            logger.error((Object)e);
            return null;
        }
        cfg.setDefaultEncoding(encoding);
        cfg.setEncoding(cfg.getLocale(), encoding);
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        return template;
    }

    public static enum SupportedLanguage {
        K2,
        PYTHON,
        FEI;

    }
}

