/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator;

import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.visitors.ast2smv.ASTToSmvExpr;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.visitors.cleanC2ast.CleanCExprToAST;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.visitors.cleanC2ast.CleanCStmtToAST;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.utils.SmvModelUtil;
import eu.fbk.eclipse.standardtools.ast.visitors.ast.AstVisitor;
import eu.fbk.eclipse.standardtools.ast.visitors.ast.IAstGenericVisitorAction;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.core.utils.SysMLElementExtractor;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XTextResourceUtil;
import eu.fbk.tools.editor.basetype.baseType.BaseTypeFactory;
import eu.fbk.tools.editor.basetype.baseType.BooleanLiteral;
import eu.fbk.tools.editor.basetype.baseType.BooleanType;
import eu.fbk.tools.editor.basetype.baseType.ClockType;
import eu.fbk.tools.editor.basetype.baseType.EnumType;
import eu.fbk.tools.editor.basetype.baseType.EqualityOperator;
import eu.fbk.tools.editor.basetype.baseType.Identifier;
import eu.fbk.tools.editor.basetype.baseType.IntegerLiteral;
import eu.fbk.tools.editor.basetype.baseType.IntegerType;
import eu.fbk.tools.editor.basetype.baseType.LogicalAndOperator;
import eu.fbk.tools.editor.basetype.baseType.LogicalOperator;
import eu.fbk.tools.editor.basetype.baseType.Operator;
import eu.fbk.tools.editor.basetype.baseType.RangeType;
import eu.fbk.tools.editor.basetype.baseType.RealType;
import eu.fbk.tools.editor.basetype.baseType.SimpleType;
import eu.fbk.tools.editor.c.expression.expression.Expression;
import eu.fbk.tools.editor.c.statement.statement.Statement;
import eu.fbk.tools.editor.c.visitor.CleanCVisitor;
import eu.fbk.tools.editor.c.visitor.ICleanCVisitorAction;
import eu.fbk.tools.editor.nusmv.smv.AssignBody;
import eu.fbk.tools.editor.nusmv.smv.AssignDeclaration;
import eu.fbk.tools.editor.nusmv.smv.BoundedExpression;
import eu.fbk.tools.editor.nusmv.smv.CaseBody;
import eu.fbk.tools.editor.nusmv.smv.CaseExpression;
import eu.fbk.tools.editor.nusmv.smv.ComplexIdentifier;
import eu.fbk.tools.editor.nusmv.smv.DefineBody;
import eu.fbk.tools.editor.nusmv.smv.DefineDeclaration;
import eu.fbk.tools.editor.nusmv.smv.EqualityExpression;
import eu.fbk.tools.editor.nusmv.smv.FrozenVariableDeclaration;
import eu.fbk.tools.editor.nusmv.smv.FunBody;
import eu.fbk.tools.editor.nusmv.smv.FunctionDeclaration;
import eu.fbk.tools.editor.nusmv.smv.IVariableDeclaration;
import eu.fbk.tools.editor.nusmv.smv.ImpliesExpression;
import eu.fbk.tools.editor.nusmv.smv.InitBody;
import eu.fbk.tools.editor.nusmv.smv.InitConstraint;
import eu.fbk.tools.editor.nusmv.smv.InvarConstraint;
import eu.fbk.tools.editor.nusmv.smv.LogicalAndExpression;
import eu.fbk.tools.editor.nusmv.smv.LtlSpecification;
import eu.fbk.tools.editor.nusmv.smv.Model;
import eu.fbk.tools.editor.nusmv.smv.Module;
import eu.fbk.tools.editor.nusmv.smv.ModuleParameter;
import eu.fbk.tools.editor.nusmv.smv.ModuleType;
import eu.fbk.tools.editor.nusmv.smv.NextBody;
import eu.fbk.tools.editor.nusmv.smv.NextExpression;
import eu.fbk.tools.editor.nusmv.smv.SmvFactory;
import eu.fbk.tools.editor.nusmv.smv.TimeAnnotation;
import eu.fbk.tools.editor.nusmv.smv.TransConstraint;
import eu.fbk.tools.editor.nusmv.smv.VarBody;
import eu.fbk.tools.editor.nusmv.smv.VarBodyAssign;
import eu.fbk.tools.editor.nusmv.smv.VariableDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class StateMachineModelToSmvModelTranslator {
    private final String language = "CleanC";
    private final String ltlLanguage = "LTLSMV";
    private final SmvFactory smvFactory = SmvFactory.eINSTANCE;
    private final BaseTypeFactory baseTypeFactory = BaseTypeFactory.eINSTANCE;
    private static final Logger logger = Logger.getLogger(StateMachineModelToSmvModelTranslator.class);
    private static String STATE_ENUM_VAR = "State";
    private static String TRANSITION_ENUM_VAR = "Transition";
    private static String INIT_TRANSITION_ENUM_VAR = "InitTransition";
    private static String INIT_STATE = "t";
    private HashMap<String, Object> transMapCleanCEffect;
    private HashMap<String, Object> initTransMapCleanCEffect;
    private HashMap<String, Object> transMapCleanCGuard;
    private XTextResourceUtil xtextResourceUtil = XTextResourceUtil.getInstance();
    private SmvModelUtil smvModelUtil = SmvModelUtil.getInstance();
    private AbstractStateMachineModel abstractStateMachineModel;
    private AbstractSystemModel abstractSystemModel;
    private CleanCExprToAST exprToASTTranslator;
    private CleanCStmtToAST stmtToASTTranslator;
    private SysMLElementExtractor elementExtractor;
    private static StateMachineModelToSmvModelTranslator stateMachineModelToSmvModelTranslator;

    public static StateMachineModelToSmvModelTranslator getInstance(AbstractStateMachineModel abstractStateMachineModel, AbstractSystemModel abstractSystemModel) {
        if (stateMachineModelToSmvModelTranslator == null) {
            stateMachineModelToSmvModelTranslator = new StateMachineModelToSmvModelTranslator(abstractStateMachineModel, abstractSystemModel);
        }
        return stateMachineModelToSmvModelTranslator;
    }

    private StateMachineModelToSmvModelTranslator(AbstractStateMachineModel abstractStateMachineModel, AbstractSystemModel abstractSystemModel) {
        this.abstractStateMachineModel = abstractStateMachineModel;
        this.abstractSystemModel = abstractSystemModel;
    }

    private VariableDeclaration createOrEnrichSmvVariableDeclarationModule(VariableDeclaration varDeclaration, EList<String> statesNameList, EList<?> ownerVariables) throws Exception {
        EList<VarBody> varBodies;
        VarBody stateBody;
        if (varDeclaration == null) {
            varDeclaration = this.smvFactory.createVariableDeclaration();
        }
        if (statesNameList != null && (stateBody = this.createSmvStates(statesNameList)) != null) {
            varDeclaration.getVariables().add((Object)stateBody);
        }
        if (ownerVariables != null && (varBodies = this.createSMVVaribles(ownerVariables)).size() != 0) {
            varDeclaration.getVariables().addAll(varBodies);
        }
        return varDeclaration;
    }

    private VarBody createSmvStates(EList<String> statesNameList) throws Exception {
        logger.debug((Object)"createSmvStates");
        VarBody states = null;
        if (statesNameList != null) {
            statesNameList.add((Object)this.getTState());
            states = this.smvFactory.createVarBody();
            states.setIdentifier(this.createComplexIdentifier(STATE_ENUM_VAR));
            EnumType stateType = this.createEnumType(statesNameList);
            states.setType((EObject)stateType);
        }
        return states;
    }

    private EnumType createEnumType(EList<String> values) throws Exception {
        logger.debug((Object)"createEnumType");
        if (values == null || values.size() == 0) {
            throw new Exception("No values of enumType");
        }
        for (String v : values) {
            logger.debug((Object)("values enum: " + v));
        }
        EnumType stateType = this.baseTypeFactory.createEnumType();
        for (String value : values) {
            if (value.contains(" ")) {
                throw new Exception("The name '" + value + "' contains blank spaces");
            }
            try {
                Integer.parseInt(value);
                stateType.getValues().add((Object)this.createIntegerLiteral(value));
            }
            catch (NumberFormatException numberFormatException) {
                stateType.getValues().add((Object)this.createIdentifier(value));
            }
        }
        return stateType;
    }

    private String getTState() {
        return INIT_STATE;
    }

    private VarBody createSmvTransitions(EList<String> transitionsNameList) throws Exception {
        logger.debug((Object)"createSmvTransitions");
        VarBody transitions = null;
        if (transitionsNameList != null) {
            transitions = this.smvFactory.createVarBody();
            transitions.setIdentifier(this.createComplexIdentifier(TRANSITION_ENUM_VAR));
            EnumType TransitionType = this.createEnumType(transitionsNameList);
            transitions.setType((EObject)TransitionType);
        }
        return transitions;
    }

    private VarBody createSmvInitTransitions(EList<String> initTransitionsNameList) throws Exception {
        logger.debug((Object)"createSmvInitTransitions");
        VarBody transitions = null;
        if (initTransitionsNameList != null) {
            transitions = this.smvFactory.createVarBody();
            transitions.setIdentifier(this.createComplexIdentifier(INIT_TRANSITION_ENUM_VAR));
            EnumType TransitionType = this.createEnumType(initTransitionsNameList);
            transitions.setType((EObject)TransitionType);
        }
        return transitions;
    }

    private EList<VarBody> createSMVVaribles(EList<?> attributes) throws Exception {
        BasicEList varBodies = new BasicEList();
        if (attributes.size() != 0) {
            for (Object attribute : attributes) {
                VarBody inputVar = this.createAttributeBody(attribute);
                varBodies.add((Object)inputVar);
            }
        }
        return varBodies;
    }

    private VarBody createAttributeBody(Object attribute) throws Exception {
        VarBody inputVar = this.smvFactory.createVarBody();
        String inputVarName = this.abstractStateMachineModel.getAttributeName(attribute);
        logger.debug((Object)("inputVarName: " + inputVarName));
        inputVar.setIdentifier(this.createComplexIdentifier(inputVarName));
        Object portType = this.abstractStateMachineModel.getAttributeType(attribute);
        inputVar.setType(this.getSmvType(portType));
        return inputVar;
    }

    private EObject getSmvType(Object type) throws Exception {
        logger.debug((Object)("getSmvType: " + type));
        if (this.abstractStateMachineModel.isBooleanType(type)) {
            BooleanType bool = this.baseTypeFactory.createBooleanType();
            return bool;
        }
        if (this.abstractStateMachineModel.isIntegerType(type)) {
            IntegerType integer = this.baseTypeFactory.createIntegerType();
            return integer;
        }
        if (this.abstractStateMachineModel.isRealType(type)) {
            RealType real = this.baseTypeFactory.createRealType();
            return real;
        }
        if (this.abstractStateMachineModel.isIntervalType(type)) {
            RangeType intervalType = this.baseTypeFactory.createRangeType();
            String[] lowHighInterval = this.abstractStateMachineModel.getLowHighIntervalType(type);
            logger.debug((Object)("lowHighInterval[1]): " + lowHighInterval[1]));
            logger.debug((Object)("lowLowerInterval[0]): " + lowHighInterval[0]));
            intervalType.setUpperBound(this.stringToBaseTypeElement(lowHighInterval[1]));
            intervalType.setLowerBound(this.stringToBaseTypeElement(lowHighInterval[0]));
            return intervalType;
        }
        if (this.abstractStateMachineModel.isEnumType(type)) {
            logger.debug((Object)("isEnumType: " + type));
            EList enumValues = this.abstractStateMachineModel.getEnumValues(type);
            EnumType enumType = this.createEnumType((EList<String>)enumValues);
            return enumType;
        }
        if (this.abstractStateMachineModel.isIdealClockType(type)) {
            ClockType clock = this.baseTypeFactory.createClockType();
            return clock;
        }
        throw new Exception("Type " + type + " not supported.");
    }

    private eu.fbk.tools.editor.basetype.baseType.Expression createAndExpr(EList<eu.fbk.tools.editor.basetype.baseType.Expression> exprList) {
        eu.fbk.tools.editor.basetype.baseType.Expression finalExpr = null;
        boolean isFirstTrans = true;
        for (eu.fbk.tools.editor.basetype.baseType.Expression currExpr : exprList) {
            if (isFirstTrans) {
                finalExpr = currExpr;
                isFirstTrans = false;
                continue;
            }
            finalExpr = this.createAndExpr(finalExpr, currExpr);
        }
        return finalExpr;
    }

    private LogicalAndExpression createAndExpr(eu.fbk.tools.editor.basetype.baseType.Expression simpleExpr, eu.fbk.tools.editor.basetype.baseType.Expression existingExpr) {
        LogicalAndExpression newAndExpr = this.smvFactory.createLogicalAndExpression();
        newAndExpr.setLeft(simpleExpr);
        newAndExpr.setRight(existingExpr);
        LogicalAndOperator logicalOp = this.baseTypeFactory.createLogicalAndOperator();
        logicalOp.setName("&");
        newAndExpr.setOp((LogicalOperator)logicalOp);
        return newAndExpr;
    }

    private ImpliesExpression createInitTransitionExpression(Object transition) throws Exception {
        String transName = this.abstractStateMachineModel.getTransitionName(transition);
        String targetStateName = this.abstractStateMachineModel.getTransitionNextStateName(transition);
        EqualityExpression transComp = this.createEqualComparisonExpression(INIT_TRANSITION_ENUM_VAR, transName);
        EqualityExpression stateComp = this.createEqualComparisonExpression(STATE_ENUM_VAR, targetStateName);
        ImpliesExpression impliesExpr = this.createImpliesExpr((eu.fbk.tools.editor.basetype.baseType.Expression)transComp, (eu.fbk.tools.editor.basetype.baseType.Expression)stateComp);
        return impliesExpr;
    }

    private EList<TransConstraint> createSmvTransConstraintModules(EList<?> nonStartTransitions) throws Exception {
        BasicEList transConstraints = null;
        if (nonStartTransitions != null) {
            transConstraints = new BasicEList();
            for (Object transition : nonStartTransitions) {
                TransConstraint transCons = this.createTransConstraint(transition);
                if (transCons == null) continue;
                transConstraints.add((Object)transCons);
            }
        }
        return transConstraints;
    }

    private TransConstraint createTransConstraint(Object transition) throws Exception {
        String nextStateName;
        TransConstraint transCons = null;
        String transName = this.abstractStateMachineModel.getTransitionName(transition);
        String startStateName = this.abstractStateMachineModel.getTransitionStartStateName(transition);
        EList guardEventNames = this.abstractStateMachineModel.getTransitionEventsName(transition);
        if (transName != null & startStateName != null & (nextStateName = this.abstractStateMachineModel.getTransitionNextStateName(transition)) != null) {
            logger.debug((Object)"createTransContraint");
            logger.debug((Object)("-transName: " + transName));
            logger.debug((Object)("-startStateName: " + startStateName));
            logger.debug((Object)("-nextStateName: " + nextStateName));
            transCons = this.smvFactory.createTransConstraint();
            if (this.abstractStateMachineModel.isFinalTransition(transition)) {
                nextStateName = this.getTState();
            }
            EqualityExpression transNameComp = this.createEqualComparisonExpression(TRANSITION_ENUM_VAR, transName);
            BasicEList compExprList = new BasicEList();
            if (this.transMapCleanCGuard.containsKey(transName)) {
                eu.fbk.tools.editor.basetype.baseType.Expression guardComp = null;
                try {
                    guardComp = (eu.fbk.tools.editor.basetype.baseType.Expression)EcoreUtil.copy((EObject)((eu.fbk.tools.editor.basetype.baseType.Expression)this.transMapCleanCGuard.get(transName)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Exception("In " + this.abstractSystemModel.getComponentName(this.elementExtractor.getCurrBlock()) + " of " + transName + ": \n" + e.getMessage(), e.getCause());
                }
                if (guardComp != null) {
                    logger.debug((Object)("guardComp: " + guardComp));
                    compExprList.add((Object)guardComp);
                }
            }
            EqualityExpression stateComp = this.createEqualComparisonExpression(STATE_ENUM_VAR, startStateName);
            compExprList.add((Object)stateComp);
            if (guardEventNames != null) {
                EList<ComplexIdentifier> eventValueExpression = this.createEventExpressions((EList<String>)guardEventNames);
                compExprList.addAll(eventValueExpression);
            }
            EqualityExpression nextEventComp = this.createNextEqualComparisonExpression(STATE_ENUM_VAR, nextStateName);
            compExprList.add((Object)nextEventComp);
            eu.fbk.tools.editor.basetype.baseType.Expression transCond = this.createAndExpr((EList<eu.fbk.tools.editor.basetype.baseType.Expression>)compExprList);
            BoundedExpression transCondWithParentheses = this.addParentheses(transCond);
            ImpliesExpression implExpr = this.createImpliesExpr((eu.fbk.tools.editor.basetype.baseType.Expression)transNameComp, (eu.fbk.tools.editor.basetype.baseType.Expression)transCondWithParentheses);
            transCons.setExpression((eu.fbk.tools.editor.basetype.baseType.Expression)implExpr);
        }
        return transCons;
    }

    private BoundedExpression addParentheses(eu.fbk.tools.editor.basetype.baseType.Expression expression) {
        BoundedExpression exprWithParentheses = this.smvFactory.createBoundedExpression();
        exprWithParentheses.setExpression(expression);
        return exprWithParentheses;
    }

    private String addParentheses(String expression) {
        return "(" + expression + ")";
    }

    private eu.fbk.tools.editor.basetype.baseType.Expression getAssignedVariableExpr(String variableName, EList<AssignBody> assignBodies) throws Exception {
        logger.debug((Object)("getAssignedVariableExpr per " + variableName));
        eu.fbk.tools.editor.basetype.baseType.Expression assignment = null;
        if (assignBodies != null) {
            for (AssignBody assignBody : assignBodies) {
                logger.debug((Object)("assignBody " + assignBody));
                if (!(assignBody instanceof VarBodyAssign)) continue;
                ComplexIdentifier assigningVariable = assignBody.getVariable();
                String assigningVariableStr = this.smvModelUtil.getSmvElementAsString((EObject)assigningVariable, false, true);
                logger.debug((Object)("assigningVariableStr: " + assigningVariableStr));
                if (assigningVariableStr.compareTo(variableName) != 0) continue;
                logger.debug((Object)"return something");
                assignment = assignBody.getExpression();
                logger.debug((Object)("assignment: " + this.smvModelUtil.getSmvElementAsString((EObject)assignment, false, true)));
            }
        } else {
            logger.debug((Object)"getAssignedVariableExpr==NULL");
        }
        return assignment;
    }

    private eu.fbk.tools.editor.basetype.baseType.Expression createSimpleExpressionFromString(String expression) throws Exception {
        logger.debug((Object)("createSimpleExpressionFromString: " + expression));
        String simpleSmvModel = "MODULE basicModule\nDEFINE\nv:=" + expression + ";";
        Model smvModel = this.xtextResourceUtil.deserializeSmvModel(simpleSmvModel);
        eu.fbk.tools.editor.basetype.baseType.Expression simpleExpr = ((DefineBody)((DefineDeclaration)((Module)smvModel.getModules().get(0)).getModuleElements().get(0)).getBodies().get(0)).getExpression();
        if (simpleExpr == null) {
            logger.debug((Object)"createSimpleExpressionFromString simpleexpression = null");
        }
        return simpleExpr;
    }

    private eu.fbk.tools.editor.basetype.baseType.Expression createSimpleExpressionFromCleanCString(String expression) throws Exception {
        logger.debug((Object)("createSimpleExpressionFromCleanCString: " + expression));
        if (expression == null) {
            BooleanLiteral res = this.baseTypeFactory.createBooleanLiteral();
            res.setValue("TRUE");
            return res;
        }
        expression = this.addParentheses(expression);
        Expression cleanCGuardExpr = this.xtextResourceUtil.deserializeCleanCExpression(expression);
        logger.debug((Object)("c Expression: " + cleanCGuardExpr));
        if (cleanCGuardExpr != null) {
            CleanCVisitor exprVisitor = new CleanCVisitor((ICleanCVisitorAction)this.exprToASTTranslator);
            exprVisitor.run((EObject)cleanCGuardExpr);
            EObject astGuard = this.exprToASTTranslator.getTransitionGuard((EObject)cleanCGuardExpr);
            ASTToSmvExpr astToSmvExpr = new ASTToSmvExpr();
            AstVisitor astVisitor = new AstVisitor((IAstGenericVisitorAction)astToSmvExpr);
            astVisitor.run(astGuard);
            return (eu.fbk.tools.editor.basetype.baseType.Expression)astToSmvExpr.getOutputObject(astGuard);
        }
        BooleanLiteral res = this.baseTypeFactory.createBooleanLiteral();
        res.setValue("TRUE");
        return res;
    }

    private EList<ComplexIdentifier> createEventExpressions(EList<String> eventsName) {
        BasicEList eventExpressions = new BasicEList();
        for (String eventName : eventsName) {
            ComplexIdentifier eventExpression = this.createComplexIdentifier(eventName);
            eventExpressions.add((Object)eventExpression);
        }
        return eventExpressions;
    }

    private ImpliesExpression createImpliesExpr(eu.fbk.tools.editor.basetype.baseType.Expression left, eu.fbk.tools.editor.basetype.baseType.Expression right) {
        ImpliesExpression implExpr = this.smvFactory.createImpliesExpression();
        implExpr.setLeft(left);
        implExpr.setRight(right);
        return implExpr;
    }

    private InitBody createAssignBodyInit(String variableName, CaseExpression caseExpr) {
        InitBody assignBodyInit = this.smvFactory.createInitBody();
        assignBodyInit.setVariable(this.createComplexIdentifier(variableName));
        assignBodyInit.setExpression((eu.fbk.tools.editor.basetype.baseType.Expression)caseExpr);
        return assignBodyInit;
    }

    private NextBody createNextBody(String variableName, CaseExpression nextExpr) {
        logger.debug((Object)"createNextBody");
        NextBody nextBody = this.smvFactory.createNextBody();
        nextBody.setVariable(this.createComplexIdentifier(variableName));
        nextBody.setExpression((eu.fbk.tools.editor.basetype.baseType.Expression)nextExpr);
        return nextBody;
    }

    private AssignDeclaration createSmvAssignConstraintModule(EList<Object> variables, EList<?> initTransitions, EList<?> nonInitTransitions) throws Exception {
        AssignDeclaration assignConstraintElement = null;
        this.computeTransCleanCEffects(initTransitions, this.initTransMapCleanCEffect);
        this.computeTransCleanCEffects(nonInitTransitions, this.transMapCleanCEffect);
        if (variables != null && variables.size() != 0) {
            assignConstraintElement = this.smvFactory.createAssignDeclaration();
            BasicEList assignBodiesInit = new BasicEList();
            BasicEList nextBodies = new BasicEList();
            logger.debug((Object)("variables size: " + variables.size()));
            for (Object variable : variables) {
                CaseExpression nextExpr;
                String variableName = this.abstractStateMachineModel.getAttributeName(variable);
                logger.debug((Object)("variableName: " + variableName));
                if (this.abstractStateMachineModel.isInputPort(variable)) continue;
                logger.debug((Object)("variableName not input port: " + variableName));
                CaseExpression caseExpr = this.createCaseForInitTransitions(variableName, initTransitions);
                if (caseExpr != null) {
                    assignBodiesInit.add((Object)this.createAssignBodyInit(variableName, caseExpr));
                }
                if ((nextExpr = this.createCaseForNonInitTransitions(variableName, nonInitTransitions)) == null) continue;
                nextBodies.add((Object)this.createNextBody(variableName, nextExpr));
            }
            logger.debug((Object)("assignBodiesInit.size: " + assignBodiesInit.size()));
            logger.debug((Object)("nextBodies.size: " + nextBodies.size()));
            assignConstraintElement.getBodies().addAll((Collection)assignBodiesInit);
            assignConstraintElement.getBodies().addAll((Collection)nextBodies);
        }
        return assignConstraintElement;
    }

    private CaseExpression createCaseForInitTransitions(String variableName, EList<?> transitions) throws Exception {
        CaseExpression caseExpr = this.smvFactory.createCaseExpression();
        for (Object transition : transitions) {
            String transitionName = this.abstractStateMachineModel.getTransitionName(transition);
            EList assignBodies = (EList)this.initTransMapCleanCEffect.get(transitionName);
            eu.fbk.tools.editor.basetype.baseType.Expression assignExpression = this.getAssignedVariableExpr(variableName, (EList<AssignBody>)assignBodies);
            if (assignExpression == null) continue;
            CaseBody caseAssignmentExpr = this.createInitTransitionAssignementExpression(transitionName, assignExpression);
            caseExpr.getBodies().add((Object)caseAssignmentExpr);
        }
        if (caseExpr.getBodies().size() > 0) {
            return caseExpr;
        }
        return null;
    }

    private CaseBody createInitTransitionAssignementExpression(String transitionName, eu.fbk.tools.editor.basetype.baseType.Expression assignExpression) throws Exception {
        CaseBody caseAssignmentExpr = this.smvFactory.createCaseBody();
        EqualityExpression comparisonExpr = this.createEqualComparisonExpression(INIT_TRANSITION_ENUM_VAR, transitionName);
        caseAssignmentExpr.setCase((eu.fbk.tools.editor.basetype.baseType.Expression)comparisonExpr);
        caseAssignmentExpr.setAssignment(assignExpression);
        return caseAssignmentExpr;
    }

    private CaseBody createNonInitTransitionAssignementExpression(String transitionName, eu.fbk.tools.editor.basetype.baseType.Expression assignExpression) throws Exception {
        logger.debug((Object)("transitionName: " + transitionName));
        CaseBody caseAssignmentExpr = this.smvFactory.createCaseBody();
        EqualityExpression comparisonExpr = this.createEqualComparisonExpression(TRANSITION_ENUM_VAR, transitionName);
        caseAssignmentExpr.setCase((eu.fbk.tools.editor.basetype.baseType.Expression)comparisonExpr);
        caseAssignmentExpr.setAssignment(assignExpression);
        return caseAssignmentExpr;
    }

    private void computeTransCleanCEffects(EList<?> transitions, HashMap<String, Object> transMap) throws Exception {
        transMap.clear();
        for (Object transition : transitions) {
            String transitionEffect = this.abstractStateMachineModel.getTransitionEffectText(transition, "CleanC");
            String transitionName = this.abstractStateMachineModel.getTransitionName(transition);
            EList<AssignBody> assignBodies = this.computeAssignBodies(transitionEffect);
            transMap.put(transitionName, assignBodies);
        }
    }

    private void computeTransCleanCGuards(EList<?> transitions, HashMap<String, Object> transMap) throws Exception {
        transMap.clear();
        for (Object transition : transitions) {
            String transitionGuard = this.abstractStateMachineModel.getTransitionGuardCondition(transition, "CleanC");
            String transitionName = this.abstractStateMachineModel.getTransitionName(transition);
            eu.fbk.tools.editor.basetype.baseType.Expression guardExpr = this.createSimpleExpressionFromCleanCString(transitionGuard);
            logger.debug((Object)("XXXX: " + transitionName + " -> " + transitionGuard));
            transMap.put(transitionName, guardExpr);
        }
    }

    private EList<AssignBody> computeAssignBodies(String transitionEffect) throws Exception {
        Statement cleanCEffectStmt = this.xtextResourceUtil.deserializeCleanCStatement(transitionEffect);
        logger.debug((Object)("c statement: " + cleanCEffectStmt));
        if (cleanCEffectStmt != null) {
            CleanCVisitor exprVisitor = new CleanCVisitor((ICleanCVisitorAction)this.stmtToASTTranslator);
            exprVisitor.run((EObject)cleanCEffectStmt);
            EObject astEffect = this.stmtToASTTranslator.getTransitionEffect((EObject)cleanCEffectStmt);
            ASTToSmvExpr astToSmv = new ASTToSmvExpr();
            AstVisitor astVisitor = new AstVisitor((IAstGenericVisitorAction)astToSmv);
            astVisitor.run(astEffect);
            Object smvEffect = astToSmv.getOutputObject(astEffect);
            logger.debug((Object)("smvEffect: " + smvEffect));
            return (EList)smvEffect;
        }
        return new BasicEList();
    }

    private CaseExpression createCaseForNonInitTransitions(String variableName, EList<?> transitions) throws Exception {
        CaseExpression caseExpr = this.smvFactory.createCaseExpression();
        for (Object transition : transitions) {
            String transitionName = this.abstractStateMachineModel.getTransitionName(transition);
            EList assignBodies = (EList)this.transMapCleanCEffect.get(transitionName);
            eu.fbk.tools.editor.basetype.baseType.Expression assignExpression = this.getAssignedVariableExpr(variableName, (EList<AssignBody>)assignBodies);
            if (assignExpression == null) continue;
            logger.debug((Object)"createCaseSimpleAssignementExpression");
            CaseBody caseAssignmentExpr = this.createNonInitTransitionAssignementExpression(transitionName, assignExpression);
            caseExpr.getBodies().add((Object)caseAssignmentExpr);
        }
        caseExpr.getBodies().add((Object)this.createDefaultCaseAssignentExpr(variableName));
        return caseExpr;
    }

    private CaseBody createDefaultCaseAssignentExpr(String variableName) throws Exception {
        CaseBody caseAssignmentExpr = this.smvFactory.createCaseBody();
        BooleanLiteral booleanLiteral = this.baseTypeFactory.createBooleanLiteral();
        booleanLiteral.setValue("TRUE");
        caseAssignmentExpr.setCase((eu.fbk.tools.editor.basetype.baseType.Expression)booleanLiteral);
        logger.debug((Object)("createDefaultCaseAssignentExpr variableName: " + variableName));
        caseAssignmentExpr.setAssignment((eu.fbk.tools.editor.basetype.baseType.Expression)this.createComplexIdentifier(variableName));
        return caseAssignmentExpr;
    }

    private EqualityExpression createEqualComparisonExpression(String varName, String value) throws Exception {
        return (EqualityExpression)this.createSimpleExpressionFromString(String.valueOf(varName) + " = " + value);
    }

    private EqualityExpression createNextEqualComparisonExpression(String varName, String value) throws Exception {
        EqualityExpression compExpr = this.smvFactory.createEqualityExpression();
        EqualityOperator equalityOperator = this.baseTypeFactory.createEqualityOperator();
        equalityOperator.setName("=");
        compExpr.setOp((Operator)equalityOperator);
        ComplexIdentifier leftComparison = this.createComplexIdentifier(varName);
        NextExpression nextExpr = this.smvFactory.createNextExpression();
        nextExpr.setExpression((eu.fbk.tools.editor.basetype.baseType.Expression)leftComparison);
        compExpr.setLeft((eu.fbk.tools.editor.basetype.baseType.Expression)nextExpr);
        eu.fbk.tools.editor.basetype.baseType.Expression rightComparison = this.createSimpleExpressionFromString(value);
        compExpr.setRight(rightComparison);
        return compExpr;
    }

    private EList<eu.fbk.tools.editor.basetype.baseType.Expression> getInvariants(Object stateMachine) throws Exception {
        String[] invariants;
        EList states = this.abstractStateMachineModel.getNonInitStates(stateMachine);
        BasicEList invariantList = new BasicEList();
        if (states != null) {
            for (Object state : states) {
                if (this.abstractStateMachineModel.getStateInvariant(state, "CleanC") == null) continue;
                EqualityExpression exprLeft = this.createEqualComparisonExpression("State", this.abstractSystemModel.getName(state));
                String invariantSpecification = this.abstractStateMachineModel.getStateInvariant(state, "CleanC");
                eu.fbk.tools.editor.basetype.baseType.Expression exprRight = this.createSimpleExpressionFromCleanCString(invariantSpecification);
                ImpliesExpression exprFinal = this.createImpliesExpr((eu.fbk.tools.editor.basetype.baseType.Expression)exprLeft, exprRight);
                invariantList.add((Object)exprFinal);
            }
        }
        String[] stringArray = invariants = this.abstractSystemModel.getComponentInvariants(this.abstractStateMachineModel.getStateMachineOwner(stateMachine), "CleanC");
        int n = invariants.length;
        int n2 = 0;
        while (n2 < n) {
            String invar = stringArray[n2];
            invariantList.add((Object)this.createSimpleExpressionFromCleanCString(invar));
            ++n2;
        }
        return invariantList;
    }

    public String getFileName(Object stateMachine) {
        return String.valueOf(this.abstractStateMachineModel.getStateMachineOwnerName(stateMachine)) + "_" + this.abstractStateMachineModel.getStateMachineName(stateMachine);
    }

    public boolean hasTimedAttribute(EList<?> ownerAttributes) {
        for (Object var : ownerAttributes) {
            if (!this.abstractStateMachineModel.isIdealClockType(this.abstractStateMachineModel.getAttributeType(var))) continue;
            return true;
        }
        return false;
    }

    public Object exportStateMachineAsSmvModel(Object stateMachine, IProgressMonitor monitor, int timeSpecification) throws Exception {
        AssignDeclaration smvAssignModule;
        EList initTransitions;
        EList<InitConstraint> smvInitModules;
        EList<eu.fbk.tools.editor.basetype.baseType.Expression> invariants;
        IVariableDeclaration smvComponentIVarModule;
        EList ltlSpecs;
        EList<LtlSpecification> ltlSpecModules;
        FrozenVariableDeclaration smvCompVarModule;
        VariableDeclaration smvCompVarModule2;
        boolean useOldSmvModel = false;
        Object nearestOwnerComponent = this.abstractSystemModel.getNearestOwnerComponent(stateMachine);
        this.elementExtractor = new SysMLElementExtractor(this.abstractSystemModel, this.abstractStateMachineModel, nearestOwnerComponent, stateMachine, null);
        this.exprToASTTranslator = new CleanCExprToAST(this.elementExtractor);
        this.stmtToASTTranslator = new CleanCStmtToAST(this.elementExtractor);
        this.transMapCleanCEffect = new HashMap();
        this.initTransMapCleanCEffect = new HashMap();
        this.transMapCleanCGuard = new HashMap();
        Model smvModel = this.xtextResourceUtil.deserializeSmvModel("MODULE dummy\n");
        smvModel.getModules().clear();
        String componentName = this.abstractStateMachineModel.getStateMachineOwnerName(stateMachine);
        EList ownerOutputPorts = this.abstractStateMachineModel.getOwnerOutputPortsExceptEvents(stateMachine);
        EList ownerInputPorts = this.abstractStateMachineModel.getOwnerInputPortsExceptEvents(stateMachine);
        EList ownerOutputEvents = this.abstractStateMachineModel.getOwnerOutputEvents(stateMachine);
        EList ownerInputEvents = this.abstractStateMachineModel.getOwnerInputEvents(stateMachine);
        EList ownerAttributes = this.abstractStateMachineModel.getOwnerNonStaticAttributesExceptPorts(stateMachine);
        EList ownerDefines = this.abstractSystemModel.getDefines(nearestOwnerComponent);
        EList ownerUninterpretedFunctions = this.abstractSystemModel.getUninterpretedFunctions(nearestOwnerComponent);
        BasicEList ownerWriteAttributes = new BasicEList();
        ownerWriteAttributes.addAll((Collection)ownerAttributes);
        ownerWriteAttributes.addAll((Collection)ownerOutputPorts);
        EList ownerStaticAttributes = this.abstractStateMachineModel.getOwnerStaticAttributes(stateMachine);
        switch (timeSpecification) {
            case 0: {
                throw new Exception("Hybrid option not supported");
            }
            case 1: {
                if (!this.hasTimedAttribute(ownerOutputPorts) && !this.hasTimedAttribute(ownerInputPorts) && !this.hasTimedAttribute(ownerAttributes)) break;
                throw new Exception("Clock types are not supported in discrete mode");
            }
            case 2: {
                TimeAnnotation timeAnnotation = this.smvFactory.createTimeAnnotation();
                timeAnnotation.setValue("continuous");
                smvModel.setAnnotation(timeAnnotation);
            }
        }
        Module mainModule = this.smvFactory.createModule();
        mainModule.setIdentifier("main");
        Module componentModule = mainModule;
        if (!useOldSmvModel) {
            componentModule = this.createComponentModule(componentName, ownerStaticAttributes, ownerInputEvents, ownerInputPorts, ownerUninterpretedFunctions);
            VariableDeclaration smvCompInstanceModule = this.createComponentInstanceDeclarationModule(componentName, ownerStaticAttributes, ownerInputEvents, ownerInputPorts, ownerUninterpretedFunctions);
            mainModule.getModuleElements().add((Object)smvCompInstanceModule);
        }
        EList statesNameList = this.abstractStateMachineModel.getIntermediateStatesNameList(stateMachine);
        VariableDeclaration smvVarModule = this.createOrEnrichSmvVariableDeclarationModule(null, null, ownerInputPorts);
        if (useOldSmvModel) {
            smvCompVarModule2 = this.createOrEnrichSmvVariableDeclarationModule(smvVarModule, (EList<String>)statesNameList, (EList<?>)ownerWriteAttributes);
            if (smvCompVarModule2 != null && smvCompVarModule2.getVariables().size() != 0) {
                logger.debug((Object)"add single VAR section");
                componentModule.getModuleElements().add((Object)smvCompVarModule2);
            }
        } else {
            if (smvVarModule != null && smvVarModule.getVariables().size() != 0) {
                logger.debug((Object)"add main VAR section");
                mainModule.getModuleElements().add((Object)smvVarModule);
            }
            if ((smvCompVarModule2 = this.createOrEnrichSmvVariableDeclarationModule(null, (EList<String>)statesNameList, (EList<?>)ownerWriteAttributes)) != null && smvCompVarModule2.getVariables().size() != 0) {
                logger.debug((Object)"add component VAR section");
                componentModule.getModuleElements().add((Object)smvCompVarModule2);
            }
        }
        EList initTransitionsNameList = this.abstractStateMachineModel.getInitTransitionsNameList(stateMachine);
        FrozenVariableDeclaration frozenVarModule = this.createOrEnrichSmvFrozenVarModule(null, null, ownerStaticAttributes);
        if (useOldSmvModel) {
            smvCompVarModule = this.createOrEnrichSmvFrozenVarModule(frozenVarModule, (EList<String>)initTransitionsNameList, null);
            if (smvCompVarModule != null && smvCompVarModule.getVariables().size() != 0) {
                logger.debug((Object)"add unique FROZEN VAR section");
                componentModule.getModuleElements().add((Object)smvCompVarModule);
            }
        } else {
            if (frozenVarModule != null && frozenVarModule.getVariables().size() != 0) {
                logger.debug((Object)"add main FROZEN VAR section");
                mainModule.getModuleElements().add((Object)frozenVarModule);
            }
            if ((smvCompVarModule = this.createOrEnrichSmvFrozenVarModule(null, (EList<String>)initTransitionsNameList, null)) != null && smvCompVarModule.getVariables().size() != 0) {
                logger.debug((Object)"add component FROZEN VAR section");
                componentModule.getModuleElements().add((Object)smvCompVarModule);
            }
        }
        if ((ltlSpecModules = this.createLtlSpecModules(ltlSpecs = this.abstractSystemModel.getInterfaceAssertions(nearestOwnerComponent))) != null && ltlSpecModules.size() != 0) {
            logger.debug((Object)"add LTLSPEC section");
            componentModule.getModuleElements().addAll(ltlSpecModules);
        }
        EList nonInitTransitionsNameList = this.abstractStateMachineModel.getNonInitTransitionsNameList(stateMachine);
        EList danglingPorts = this.abstractStateMachineModel.getOwnerDanglingInputPorts(stateMachine);
        IVariableDeclaration smvIVarModule = this.createOrEnrichSmvIVariableDeclarationModule(null, ownerInputEvents, null, danglingPorts);
        if (useOldSmvModel) {
            smvComponentIVarModule = this.createOrEnrichSmvIVariableDeclarationModule(smvIVarModule, ownerOutputEvents, (EList<String>)nonInitTransitionsNameList, danglingPorts);
            if (smvComponentIVarModule != null && smvComponentIVarModule.getVariables().size() != 0) {
                logger.debug((Object)"add unique IVAR section");
                componentModule.getModuleElements().add((Object)smvComponentIVarModule);
            }
        } else {
            if (smvIVarModule != null && smvIVarModule.getVariables().size() != 0) {
                logger.debug((Object)"add main IVAR section");
                mainModule.getModuleElements().add((Object)smvIVarModule);
            }
            if ((smvComponentIVarModule = this.createOrEnrichSmvIVariableDeclarationModule(null, ownerOutputEvents, (EList<String>)nonInitTransitionsNameList, danglingPorts)) != null && smvComponentIVarModule.getVariables().size() != 0) {
                logger.debug((Object)"add component IVAR section");
                componentModule.getModuleElements().add((Object)smvComponentIVarModule);
            }
        }
        if (!useOldSmvModel) {
            DefineBody defineBody;
            DefineDeclaration defineDecl = this.smvFactory.createDefineDeclaration();
            for (Object outputEvent : ownerOutputEvents) {
                String eventName = this.abstractStateMachineModel.getAttributeName(outputEvent);
                defineBody = this.createDefineBody(componentName, eventName);
                defineDecl.getBodies().add((Object)defineBody);
            }
            for (Object variable : ownerOutputPorts) {
                String variableName = this.abstractStateMachineModel.getAttributeName(variable);
                defineBody = this.createDefineBody(componentName, variableName);
                defineDecl.getBodies().add((Object)defineBody);
            }
            if (!defineDecl.getBodies().isEmpty()) {
                mainModule.getModuleElements().add((Object)defineDecl);
            }
            DefineDeclaration defineBodyFunctions = this.smvFactory.createDefineDeclaration();
            for (Iterator define : ownerDefines) {
                defineBody = this.createDefineBodyFunction(define);
                defineBodyFunctions.getBodies().add((Object)defineBody);
            }
            if (!defineBodyFunctions.getBodies().isEmpty()) {
                componentModule.getModuleElements().add((Object)defineBodyFunctions);
            }
        }
        if (ownerUninterpretedFunctions != null && ownerUninterpretedFunctions.size() > 0) {
            FunctionDeclaration funDecl = this.smvFactory.createFunctionDeclaration();
            for (Object uninterpretedFunction : ownerUninterpretedFunctions) {
                Object outputType = this.abstractSystemModel.getUninterpretedFunctionOutputType(uninterpretedFunction);
                EList inputTypes = this.abstractSystemModel.getUninterpretedFunctionInputTypes(uninterpretedFunction);
                FunBody body = this.smvFactory.createFunBody();
                body.setIdentifier(this.createComplexIdentifier(this.abstractSystemModel.getUninterpretedFunctionName(uninterpretedFunction)));
                body.setTargetType((SimpleType)this.getSmvType(outputType));
                body.getTypes().addAll(this.compileUninterpretedFunctionParameters(inputTypes));
                funDecl.getVariables().add((Object)body);
            }
            mainModule.getModuleElements().add((Object)funDecl);
        }
        if ((invariants = this.getInvariants(stateMachine)) != null) {
            logger.debug((Object)"add INVAR section");
            for (eu.fbk.tools.editor.basetype.baseType.Expression exp : invariants) {
                InvarConstraint Invar = this.smvFactory.createInvarConstraint();
                Invar.setExpression(exp);
                componentModule.getModuleElements().add((Object)Invar);
            }
        }
        if ((smvInitModules = this.createSmvInitConstraintModules(initTransitions = this.abstractStateMachineModel.getInitTransitions(stateMachine))) != null && smvInitModules.size() != 0) {
            logger.debug((Object)"add INIT section");
            componentModule.getModuleElements().addAll(smvInitModules);
        }
        EList nonInitTransitions = this.abstractStateMachineModel.getNonInitTransitions(stateMachine);
        this.computeTransCleanCGuards(nonInitTransitions, this.transMapCleanCGuard);
        EList<TransConstraint> smvTransModules = this.createSmvTransConstraintModules(nonInitTransitions);
        if (smvTransModules != null && smvTransModules.size() != 0) {
            logger.debug((Object)"add TRANS section");
            componentModule.getModuleElements().addAll(smvTransModules);
        }
        if ((smvAssignModule = this.createSmvAssignConstraintModule((EList<Object>)ownerWriteAttributes, initTransitions, nonInitTransitions)) != null && smvAssignModule.getBodies().size() != 0) {
            logger.debug((Object)"add ASSIGN section");
            componentModule.getModuleElements().add((Object)smvAssignModule);
        }
        smvModel.getModules().add((Object)mainModule);
        if (!useOldSmvModel) {
            smvModel.getModules().add((Object)componentModule);
        }
        this.smvModelUtil.getSmvElementAsString((EObject)smvModel, true, false);
        return smvModel;
    }

    private EList<LtlSpecification> createLtlSpecModules(EList<?> ltlSpecs) throws Exception {
        BasicEList specs = null;
        if (ltlSpecs != null && ltlSpecs.size() != 0) {
            specs = new BasicEList();
            for (Object ltlSpec : ltlSpecs) {
                LtlSpecification spec = this.smvFactory.createLtlSpecification();
                eu.fbk.tools.editor.basetype.baseType.Expression ltlExpr = this.createSimpleExpressionFromString(this.abstractSystemModel.getInterfaceAssertionBody(ltlSpec, "LTLSMV"));
                spec.setExpression(ltlExpr);
                String idName = this.abstractSystemModel.getInterfaceAssertionName(ltlSpec);
                spec.setIdentifier(this.createComplexIdentifier(idName));
                specs.add((Object)spec);
            }
        }
        return specs;
    }

    private EList<SimpleType> compileUninterpretedFunctionParameters(EList<?> inputTypes) throws Exception {
        BasicEList parameters = new BasicEList();
        for (Object simpleType : inputTypes) {
            parameters.add((Object)((SimpleType)this.getSmvType(simpleType)));
        }
        return parameters;
    }

    private DefineBody createDefineBody(String componentName, String outputEvent) {
        DefineBody defineBody = this.smvFactory.createDefineBody();
        defineBody.setVariable(this.createComplexIdentifier(outputEvent));
        defineBody.setExpression((eu.fbk.tools.editor.basetype.baseType.Expression)this.createComplexIdentifier(componentName, outputEvent));
        return defineBody;
    }

    private DefineBody createDefineBodyFunction(Object define) throws Exception {
        DefineBody defineBody = this.smvFactory.createDefineBody();
        defineBody.setVariable(this.createComplexIdentifier(this.abstractSystemModel.getDefineName(define)));
        defineBody.setExpression(this.createSimpleExpressionFromString(this.abstractSystemModel.getDefineBody(define, "LTLSMV")));
        return defineBody;
    }

    private VariableDeclaration createComponentInstanceDeclarationModule(String componentName, EList<?> ownerStaticAttributes, EList<?> inputEvents, EList<?> ownerInputPorts, EList<?> ownerUninterpretedFunctions) {
        VarBody instance = this.smvFactory.createVarBody();
        instance.setIdentifier(this.createComplexIdentifier(componentName));
        ModuleType type = this.createComponentType(componentName, ownerStaticAttributes, inputEvents, ownerInputPorts, ownerUninterpretedFunctions);
        instance.setType((EObject)type);
        VariableDeclaration decl = this.smvFactory.createVariableDeclaration();
        decl.getVariables().add((Object)instance);
        return decl;
    }

    private ModuleType createComponentType(String componentName, EList<?> ownerStaticAttributes, EList<?> inputEvents, EList<?> ownerInputPorts, EList<?> ownerUninterpretedFunctions) {
        String attrName;
        ArrayList<String> argsNames = new ArrayList<String>();
        for (Object attribute : ownerStaticAttributes) {
            attrName = this.abstractStateMachineModel.getAttributeName(attribute);
            argsNames.add(attrName);
        }
        for (Object attribute : inputEvents) {
            attrName = this.abstractStateMachineModel.getAttributeName(attribute);
            argsNames.add(attrName);
        }
        for (Object attribute : ownerInputPorts) {
            attrName = this.abstractStateMachineModel.getAttributeName(attribute);
            argsNames.add(attrName);
        }
        for (Object uninterpretedFunction : ownerUninterpretedFunctions) {
            String funName = this.abstractSystemModel.getUninterpretedFunctionName(uninterpretedFunction);
            argsNames.add(funName);
        }
        ModuleType type = this.smvFactory.createModuleType();
        type.setIdentifier(componentName);
        for (String arg : argsNames) {
            type.getParams().add((Object)this.createComplexIdentifier(arg));
        }
        return type;
    }

    private Module createComponentModule(String componentName, EList<?> ownerStaticAttributes, EList<?> inputEvents, EList<?> ownerInputPorts, EList<?> ownerUninterpretedFunctions) {
        String attrName;
        ArrayList<String> argsNames = new ArrayList<String>();
        for (Object attribute : ownerStaticAttributes) {
            attrName = this.abstractStateMachineModel.getAttributeName(attribute);
            argsNames.add(attrName);
        }
        for (Object attribute : inputEvents) {
            attrName = this.abstractStateMachineModel.getAttributeName(attribute);
            argsNames.add(attrName);
        }
        for (Object attribute : ownerInputPorts) {
            attrName = this.abstractStateMachineModel.getAttributeName(attribute);
            argsNames.add(attrName);
        }
        for (Object uninterpretedFunction : ownerUninterpretedFunctions) {
            String funName = this.abstractSystemModel.getUninterpretedFunctionName(uninterpretedFunction);
            argsNames.add(funName);
        }
        Module module = this.smvFactory.createModule();
        module.setIdentifier(componentName);
        for (String arg : argsNames) {
            module.getModuleParameters().add((Object)this.createModuleParameter(arg));
        }
        return module;
    }

    private EList<InitConstraint> createSmvInitConstraintModules(EList<?> initTransitions) throws Exception {
        BasicEList initConstraints = null;
        if (initTransitions != null && initTransitions.size() != 0) {
            initConstraints = new BasicEList();
            for (Object transition : initTransitions) {
                InitConstraint initConstraint = this.smvFactory.createInitConstraint();
                ImpliesExpression impliesExpr = this.createInitTransitionExpression(transition);
                initConstraint.setExpression((eu.fbk.tools.editor.basetype.baseType.Expression)this.addParentheses((eu.fbk.tools.editor.basetype.baseType.Expression)impliesExpr));
                initConstraints.add((Object)initConstraint);
            }
        }
        return initConstraints;
    }

    private FrozenVariableDeclaration createOrEnrichSmvFrozenVarModule(FrozenVariableDeclaration frozenVarModule, EList<String> initTransitionsNameList, EList<?> staticAttributes) throws Exception {
        if (frozenVarModule == null) {
            frozenVarModule = this.smvFactory.createFrozenVariableDeclaration();
        }
        if (initTransitionsNameList != null) {
            VarBody initTransVar = this.createSmvInitTransitions(initTransitionsNameList);
            frozenVarModule.getVariables().add((Object)initTransVar);
        }
        if (staticAttributes != null) {
            frozenVarModule.getVariables().addAll(this.createSMVVaribles(staticAttributes));
        }
        return frozenVarModule;
    }

    private IVariableDeclaration createOrEnrichSmvIVariableDeclarationModule(IVariableDeclaration iVarDeclaration, EList<?> events, EList<String> transitionsNameList, EList<?> danglingPorts) throws Exception {
        VarBody transBody;
        if (iVarDeclaration == null) {
            iVarDeclaration = this.smvFactory.createIVariableDeclaration();
        }
        if ((transBody = this.createSmvTransitions(transitionsNameList)) != null) {
            iVarDeclaration.getVariables().add((Object)transBody);
        }
        if (events != null) {
            for (Object event : events) {
                String eventName = this.abstractStateMachineModel.getAttributeName(event);
                iVarDeclaration.getVariables().add((Object)this.createEventVar(eventName));
            }
        }
        if (danglingPorts != null) {
            for (Object danglingPort : danglingPorts) {
                String name = this.abstractStateMachineModel.getAttributeName(danglingPort);
                Object type = this.abstractStateMachineModel.getAttributeType(danglingPort);
                VarBody var = this.smvFactory.createVarBody();
                var.setIdentifier(this.createComplexIdentifier(name));
                var.setType(this.getSmvType(type));
                iVarDeclaration.getVariables().add((Object)var);
            }
        }
        return iVarDeclaration;
    }

    private VarBody createEventVar(String eventName) {
        VarBody eventVar = this.smvFactory.createVarBody();
        eventVar.setIdentifier(this.createComplexIdentifier(eventName));
        eventVar.setType((EObject)this.baseTypeFactory.createBooleanType());
        return eventVar;
    }

    private EObject stringToBaseTypeElement(String baseTypeElement) throws Exception {
        if (baseTypeElement == null || baseTypeElement.isEmpty()) {
            return null;
        }
        EObject result = this.xtextResourceUtil.deserializeBaseType(baseTypeElement);
        return result;
    }

    private ComplexIdentifier createComplexIdentifier(String value) {
        ComplexIdentifier complIdentifier = this.smvFactory.createComplexIdentifier();
        complIdentifier.setIdentifier(this.createIdentifier(value));
        return complIdentifier;
    }

    private ComplexIdentifier createComplexIdentifier(String prefix, String value) {
        ComplexIdentifier res = this.smvFactory.createComplexIdentifier();
        ComplexIdentifier prefixIdentifier = this.createComplexIdentifier(prefix);
        ComplexIdentifier valueIdentifier = this.createComplexIdentifier(value);
        res.setLeft(prefixIdentifier);
        res.setRight((EObject)valueIdentifier);
        return res;
    }

    private ModuleParameter createModuleParameter(String value) {
        ModuleParameter param = this.smvFactory.createModuleParameter();
        param.setIdentifier(value);
        return param;
    }

    private Identifier createIdentifier(String value) {
        Identifier identifier = this.baseTypeFactory.createIdentifier();
        identifier.setValue(value);
        return identifier;
    }

    private IntegerLiteral createIntegerLiteral(String value) {
        IntegerLiteral identifier = this.baseTypeFactory.createIntegerLiteral();
        identifier.setValue(value);
        return identifier;
    }
}

