/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.serializers;

import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.FreeMarkerUtil;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.visitors.ast2K2.ASTToK2;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.visitors.ast2K2.ASTToK2PreAction;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.visitors.ast2Python.ASTToPython;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.visitors.ast2Python.ASTtoPythonPreAction;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.visitors.cleanC2ast.CleanCExprToAST;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.visitors.cleanC2ast.CleanCStmtToAST;
import eu.fbk.eclipse.standardtools.ast.utils.AstElementExtractor;
import eu.fbk.eclipse.standardtools.ast.visitors.ast.AstVisitor;
import eu.fbk.eclipse.standardtools.ast.visitors.ast.IAstGenericVisitorAction;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.core.utils.SysMLElementExtractor;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XTextResourceUtil;
import eu.fbk.tools.editor.c.expression.expression.Expression;
import eu.fbk.tools.editor.c.visitor.CleanCVisitor;
import eu.fbk.tools.editor.c.visitor.ICleanCVisitorAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class SysMLSerializer {
    public static final Logger logger = Logger.getLogger(SysMLSerializer.class);
    private SupportedLanguage inputLanguage;
    private FreeMarkerUtil.SupportedLanguage outputLanguage;
    private String blockName;
    private ArrayList<Exception> errors = new ArrayList();
    private EMap<Object, Map<String, Object>> transitions_serializedTransitionsMap;
    private AbstractSystemModel abstractSystemModel;
    private AbstractStateMachineModel abstractStateMachineModel;
    private SysMLElementExtractor sysMLElementExtractor;

    public SysMLSerializer(AbstractSystemModel abstractSystemModel, AbstractStateMachineModel abstractStateMachineModel) {
        this.abstractSystemModel = abstractSystemModel;
        this.abstractStateMachineModel = abstractStateMachineModel;
    }

    public Map<String, Object> serializeBlock(Object blockAsClass, SupportedLanguage inputLanguage, FreeMarkerUtil.SupportedLanguage outputLanguage, TransactionalEditingDomain domain) throws Exception {
        this.blockName = this.abstractSystemModel.getName(blockAsClass);
        logger.trace((Object)("serializing Block: " + this.blockName));
        this.transitions_serializedTransitionsMap = new BasicEMap();
        HashMap<String, Object> blockDescriptorMap = new HashMap<String, Object>();
        this.inputLanguage = inputLanguage;
        this.outputLanguage = outputLanguage;
        if (!inputLanguage.equals((Object)SupportedLanguage.CLEAN_C)) {
            throw new Exception("Language not supported");
        }
        this.putName(blockAsClass, blockDescriptorMap);
        Object stateMachine = this.abstractStateMachineModel.getFirstNominalStateMachine(blockAsClass);
        if (stateMachine != null) {
            blockDescriptorMap.put("stateMachine", this.serializeStateMachine(stateMachine, this.blockName, domain));
            ArrayList<Object> enums = new ArrayList<Object>();
            this.serializeInputPorts(blockDescriptorMap, stateMachine, enums);
            this.serializeOutputPorts(blockDescriptorMap, stateMachine, enums);
            this.serializeAttributes(blockDescriptorMap, stateMachine, enums);
            this.serializeEnums(blockDescriptorMap, enums);
        }
        EList faultyStateMachines = this.abstractStateMachineModel.getFaultyStateMachines(blockAsClass);
        ArrayList<Object> faultyStateMachinesList = new ArrayList<Object>();
        blockDescriptorMap.put("faultyStateMachines", faultyStateMachinesList);
        if (faultyStateMachines != null) {
            for (Object sm : faultyStateMachines) {
                faultyStateMachinesList.add(this.serializeFaultyStateMachine(sm));
            }
        }
        return blockDescriptorMap;
    }

    private Object serializeFaultyStateMachine(Object stateMachine) throws Exception {
        HashMap<String, Object> descriptor = new HashMap<String, Object>();
        descriptor.put("name", this.abstractStateMachineModel.getStateMachineName(stateMachine));
        ArrayList<Object> errorStatesList = new ArrayList<Object>();
        descriptor.put("errorStates", errorStatesList);
        for (Object errorState : this.abstractStateMachineModel.getErrorStates(stateMachine)) {
            errorStatesList.add(this.serializeErrorState(errorState));
        }
        return descriptor;
    }

    private Object serializeErrorState(Object errorState) throws Exception {
        HashMap<String, Object> descriptor = new HashMap<String, Object>();
        descriptor.put("name", this.abstractSystemModel.getName(errorState));
        descriptor.put("probability", this.abstractStateMachineModel.getErrorStateProbability(errorState));
        ArrayList<String> incomingFaultTransitionList = new ArrayList<String>();
        descriptor.put("incomingFaultTransitions", incomingFaultTransitionList);
        for (Object incomingFaultTransition : this.abstractStateMachineModel.getIncomingFaultTransitions(errorState)) {
            incomingFaultTransitionList.add(this.abstractStateMachineModel.getTransitionName(incomingFaultTransition));
        }
        Object attribute = this.abstractStateMachineModel.getFailureModeAttribute(errorState);
        descriptor.put("attribute", this.serializeAttribute(attribute));
        descriptor.put("errorType", this.abstractStateMachineModel.getFailureModeType(errorState));
        EList fields = this.abstractStateMachineModel.getFailureModeFields(errorState);
        HashMap<String, String> fieldsDescriptor = new HashMap<String, String>();
        for (String fieldKey : fields) {
            fieldsDescriptor.put(fieldKey, this.abstractStateMachineModel.getFailureModeValue(errorState, fieldKey));
        }
        descriptor.put("fields", fieldsDescriptor);
        return descriptor;
    }

    private void serializeEnums(Map<String, Object> blockDescriptorMap, List<Object> enums) {
        ArrayList<Object> enumsList = new ArrayList<Object>();
        blockDescriptorMap.put("enums", enumsList);
        for (Object enumType : enums) {
            enumsList.add(this.serializeEnum(enumType));
        }
    }

    private Object serializeEnum(Object enumType) {
        HashMap<String, String> descriptor = new HashMap<String, String>();
        descriptor.put("name", this.abstractStateMachineModel.getEnumTypeName(enumType));
        descriptor.put("values", (String)this.abstractStateMachineModel.getEnumValues(enumType));
        return descriptor;
    }

    private void serializeInputPorts(Map<String, Object> blockDescriptorMap, Object stateMachine, List<Object> enums) throws Exception {
        ArrayList<Map<String, String>> simpleAttributes = new ArrayList<Map<String, String>>();
        blockDescriptorMap.put("inputPorts", simpleAttributes);
        for (Object attribute : this.abstractStateMachineModel.getOwnerInputPortsExceptEvents(stateMachine)) {
            logger.trace((Object)("--- inputPorts: " + this.abstractSystemModel.getName(attribute)));
            simpleAttributes.add(this.serializeAttribute(attribute));
            this.addEnum(enums, attribute);
        }
    }

    private void serializeOutputPorts(Map<String, Object> blockDescriptorMap, Object stateMachine, List<Object> enums) throws Exception {
        ArrayList<Map<String, String>> simpleAttributes = new ArrayList<Map<String, String>>();
        blockDescriptorMap.put("outputPorts", simpleAttributes);
        for (Object attribute : this.abstractStateMachineModel.getOwnerOutputPortsExceptEvents(stateMachine)) {
            logger.trace((Object)("--- outputPorts: " + this.abstractSystemModel.getName(attribute)));
            simpleAttributes.add(this.serializeAttribute(attribute));
            this.addEnum(enums, attribute);
        }
    }

    private void addEnum(List<Object> enums, Object attribute) {
        Object attrType = this.abstractSystemModel.getAttributeType(attribute);
        if (this.abstractSystemModel.isEnumType(attrType)) {
            this.addToSet(attrType, enums);
        }
    }

    private void addToSet(Object enumType, List<Object> enums) {
        if (!enums.contains(enumType)) {
            enums.add(enumType);
        }
    }

    private void serializeAttributes(Map<String, Object> blockDescriptorMap, Object stateMachine, List<Object> enums) throws Exception {
        ArrayList<Map<String, String>> staticAttributes = new ArrayList<Map<String, String>>();
        blockDescriptorMap.put("attributes", staticAttributes);
        for (Object staticAttribute : this.abstractStateMachineModel.getOwnerNonStaticAttributesExceptPorts(stateMachine)) {
            logger.trace((Object)("--- attributes: " + this.abstractSystemModel.getName(staticAttribute)));
            staticAttributes.add(this.serializeAttribute(staticAttribute));
            this.addEnum(enums, staticAttribute);
        }
    }

    private Object serializeStateMachine(Object stateMachine, String className, TransactionalEditingDomain domain) throws Exception {
        HashMap stateMachineMap = new HashMap();
        logger.debug((Object)"Serializing State Machine..");
        this.sysMLElementExtractor = new SysMLElementExtractor(this.abstractSystemModel, this.abstractStateMachineModel, this.abstractSystemModel.getNearestOwnerComponent(stateMachine), stateMachine, null);
        String stateMachineName = this.abstractStateMachineModel.getStateMachineName(stateMachine);
        logger.debug((Object)"Serializing Init Transitions..");
        EList initTransitionsToSerialize = null;
        try {
            initTransitionsToSerialize = this.abstractStateMachineModel.getInitTransitions(stateMachine);
        }
        catch (Exception e) {
            this.addError("serializeStateMachine: " + e.getMessage(), e);
        }
        ArrayList<Map<String, Object>> initTransitions = new ArrayList<Map<String, Object>>();
        if (initTransitionsToSerialize != null) {
            stateMachineMap.put("initTransitions", initTransitions);
            for (Object initTransition : initTransitionsToSerialize) {
                String transName = this.abstractStateMachineModel.getTransitionName(initTransition);
                try {
                    Map<String, Object> currTransition = this.serializeSmTransition(initTransition, className, domain);
                    this.transitions_serializedTransitionsMap.put(initTransition, currTransition);
                    initTransitions.add(currTransition);
                }
                catch (Exception e) {
                    this.addError("Error in serializing Init Transition '" + (String)transName + "' of " + stateMachineName + ": " + e.getMessage(), e);
                    return null;
                }
            }
        } else {
            this.addError("serializeStateMachine: The state machine " + stateMachineName + " has no initial Transition associated", null);
        }
        logger.debug((Object)"Init Transitions Serialization Done.");
        logger.debug((Object)"Serializing Transitions..");
        ArrayList<Map<String, Object>> transitions = new ArrayList<Map<String, Object>>();
        stateMachineMap.put("transitions", transitions);
        for (Object transition : this.abstractStateMachineModel.getNonInitTransitions(stateMachine)) {
            String transName = this.abstractStateMachineModel.getTransitionName(transition);
            logger.trace((Object)("Transition " + (String)transName));
            try {
                Map<String, Object> currTransition = this.serializeSmTransition(transition, className, domain);
                this.transitions_serializedTransitionsMap.put(transition, currTransition);
                transitions.add(currTransition);
            }
            catch (Exception e) {
                this.addError("Error in serializing Transition '" + (String)transName + "' of " + stateMachineName + ": " + e.getMessage(), e);
                return null;
            }
            logger.trace((Object)("Transition " + (String)transName + "... DONE"));
        }
        logger.debug((Object)"Transitions Serialization Done..");
        logger.debug((Object)"Serializing Init States..");
        ArrayList<Object> initStates = new ArrayList<Object>();
        stateMachineMap.put("initStates", initStates);
        for (Object state : this.abstractStateMachineModel.getNonInitStates(stateMachine)) {
            System.out.println("state: " + state);
            initStates.add(this.serializeSmState(state));
        }
        logger.debug((Object)"Init States Serialization Done.");
        logger.debug((Object)"Serializing States..");
        ArrayList<Object> states = new ArrayList<Object>();
        stateMachineMap.put("states", states);
        for (Object state : this.abstractStateMachineModel.getNonInitStates(stateMachine)) {
            states.add(this.serializeSmState(state));
        }
        logger.debug((Object)"States Serialization Done..");
        logger.debug((Object)"State Machine Serialization Done.");
        return stateMachineMap;
    }

    private Object serializeSmState(Object state) {
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        String stateName = null;
        try {
            stateName = this.removeNotAllowedChars(this.abstractSystemModel.getName(state), true);
        }
        catch (Exception e) {
            this.addError("serializeSmState removeNotAllowedChars: " + e.getMessage(), e);
        }
        if (stateName == null) {
            this.addError("serializeSmState: State with no name", null);
        }
        stateMap.put("name", stateName);
        ArrayList<Map> transitions = new ArrayList<Map>();
        stateMap.put("outTransitions", transitions);
        for (Object transition : this.abstractStateMachineModel.getOutTransitions(state)) {
            try {
                Map serializedTransition = (Map)this.transitions_serializedTransitionsMap.get(transition);
                if (serializedTransition == null) {
                    this.throwException("serialized transition of " + this.abstractStateMachineModel.getTransitionName(transition) + " not found");
                }
                transitions.add(serializedTransition);
            }
            catch (Exception e) {
                this.addError("serializeSmState transitions_serializedTransitionsMap: " + e.getMessage(), e);
            }
        }
        return stateMap;
    }

    private Map<String, Object> serializeSmTransition(Object transition, String className, TransactionalEditingDomain domain) throws Exception {
        HashMap<String, Object> transMap = new HashMap<String, Object>();
        logger.debug((Object)"serializeSmTransition..");
        String transitionName = this.abstractStateMachineModel.getTransitionName(transition);
        try {
            transitionName = this.removeNotAllowedChars(transitionName, false);
        }
        catch (Exception e) {
            this.addError("serializeSmTransition removeNotAllowedChars: " + e.getMessage(), e);
        }
        logger.debug((Object)"transitionName..");
        if (transitionName == null) {
            this.addError("serializeSmTransition: Transition with no name", null);
        }
        transMap.put("name", transitionName);
        String guardCondition = this.abstractStateMachineModel.getTransitionGuardCondition(transition, "CleanC");
        String effectText = this.abstractStateMachineModel.getTransitionEffectText(transition, "CleanC");
        transMap.put("guardBody", this.processTransitionBody(guardCondition, domain, true));
        transMap.put("effectBody", this.processTransitionBody(effectText, domain, false));
        logger.debug((Object)"processTransitionGuard..");
        logger.debug((Object)"processTransitionEffect..DONE");
        try {
            String nextStateName = this.abstractStateMachineModel.getTransitionNextStateName(transition);
            String prevStateName = this.abstractStateMachineModel.getTransitionStartStateName(transition);
            transMap.put("outState", this.removeNotAllowedChars(nextStateName, true));
            transMap.put("inState", this.removeNotAllowedChars(prevStateName, true));
            logger.debug((Object)"processTransitionEffect, scheduler directive..DONE ");
        }
        catch (Exception e) {
            String message = "serializeSmTransition removeNotAllowedChars nextStateName: " + transitionName + ". message:" + e.getMessage();
            logger.error((Object)message);
            this.addError(message, e);
        }
        return transMap;
    }

    private Map<String, String> serializeAttribute(Object attribute) throws Exception {
        HashMap<String, String> descriptor = new HashMap<String, String>();
        this.putName(attribute, descriptor);
        this.putType(attribute, descriptor);
        this.putIsEnum(attribute, descriptor);
        return descriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String processTransitionBody(String transitionBodyText, TransactionalEditingDomain domain, boolean isGuardBody) throws Exception {
        AstVisitor visitorPreOrder;
        EObject ast;
        CleanCVisitor exprVisitor;
        Expression cleanCEffectStmt;
        logger.debug((Object)"----------------------------");
        logger.debug((Object)("transitionBodyText: '" + transitionBodyText + "'"));
        logger.debug((Object)("inputLanguage: " + (Object)((Object)this.inputLanguage)));
        logger.debug((Object)("outputLanguage: " + (Object)((Object)this.outputLanguage)));
        if (this.inputLanguage.equals((Object)SupportedLanguage.CLEAN_C) && transitionBodyText == null) {
            if (this.outputLanguage.equals((Object)FreeMarkerUtil.SupportedLanguage.K2)) {
                if (!isGuardBody) return "(locals)(assume (const |true| bool))";
                transitionBodyText = "true";
            } else if (this.outputLanguage.equals((Object)FreeMarkerUtil.SupportedLanguage.PYTHON)) {
                if (!isGuardBody) return "pass";
                transitionBodyText = "true";
            }
        }
        if (transitionBodyText == null || transitionBodyText.equals("")) return "";
        String operationBodyText = "";
        if (!this.inputLanguage.equals((Object)SupportedLanguage.CLEAN_C)) throw new Exception("Language '" + (Object)((Object)this.inputLanguage) + "' not supported");
        logger.debug((Object)("processOperationBody: '" + transitionBodyText + "'"));
        if (isGuardBody) {
            cleanCEffectStmt = XTextResourceUtil.getInstance().deserializeCleanCExpression(transitionBodyText);
            logger.debug((Object)("c expression: " + cleanCEffectStmt));
            CleanCExprToAST exprToASTTranslator = new CleanCExprToAST(this.sysMLElementExtractor);
            exprVisitor = new CleanCVisitor((ICleanCVisitorAction)exprToASTTranslator);
            exprVisitor.run((EObject)cleanCEffectStmt);
            ast = exprToASTTranslator.getTransitionGuard((EObject)cleanCEffectStmt);
        } else {
            cleanCEffectStmt = XTextResourceUtil.getInstance().deserializeCleanCStatement(transitionBodyText);
            logger.debug((Object)("c statement: " + cleanCEffectStmt));
            CleanCStmtToAST stmtToASTTranslator = new CleanCStmtToAST(this.sysMLElementExtractor);
            exprVisitor = new CleanCVisitor((ICleanCVisitorAction)stmtToASTTranslator);
            exprVisitor.run((EObject)cleanCEffectStmt);
            ast = stmtToASTTranslator.getTransitionEffect((EObject)cleanCEffectStmt);
        }
        if (this.outputLanguage.equals((Object)FreeMarkerUtil.SupportedLanguage.K2)) {
            ASTToK2PreAction astToK2PreAction = new ASTToK2PreAction();
            visitorPreOrder = new AstVisitor((IAstGenericVisitorAction)astToK2PreAction, AstVisitor.Order.PREORDER);
            visitorPreOrder.run(ast);
            AstElementExtractor astElementExtractor = new AstElementExtractor(this.sysMLElementExtractor);
            ASTToK2 astToK2Action = new ASTToK2(astElementExtractor, astToK2PreAction.getAstNameResolutor());
            AstVisitor visitorPostOrder = new AstVisitor((IAstGenericVisitorAction)astToK2Action, AstVisitor.Order.POSTORDER);
            visitorPostOrder.run(ast);
            operationBodyText = (String)astToK2Action.getOutputObject(ast);
        } else if (this.outputLanguage.equals((Object)FreeMarkerUtil.SupportedLanguage.PYTHON)) {
            ASTtoPythonPreAction astToPythonPreAction = new ASTtoPythonPreAction(ast);
            visitorPreOrder = new AstVisitor((IAstGenericVisitorAction)astToPythonPreAction, AstVisitor.Order.PREORDER);
            visitorPreOrder.run(ast);
            ASTToPython astToPythonAction = new ASTToPython(this.sysMLElementExtractor, astToPythonPreAction.getObjectIndentation());
            AstVisitor visitorPostOrder = new AstVisitor((IAstGenericVisitorAction)astToPythonAction, AstVisitor.Order.POSTORDER);
            visitorPostOrder.run(ast);
            operationBodyText = (String)astToPythonAction.getOutputObject(ast);
        }
        logger.debug((Object)"----------------------------");
        logger.debug((Object)("generated operation Body Text: " + operationBodyText));
        return operationBodyText;
    }

    private void putName(Object element, Map descriptor) {
        descriptor.put("name", this.abstractSystemModel.getName(element));
    }

    private void putType(Object element, Map descriptor) throws Exception {
        Object type = this.abstractSystemModel.getAttributeType(element);
        descriptor.put("type", this.abstractSystemModel.getName(type));
        if (this.abstractSystemModel.isRangeType(type)) {
            String[] bounds = this.abstractSystemModel.getLowerUpperBoundsForRangeType(type);
            descriptor.put("type", "int");
            descriptor.put("lowerRangeBound", bounds[0]);
            descriptor.put("upperRangeBound", bounds[1]);
        } else if (this.abstractSystemModel.isEnumType(type)) {
            descriptor.put("literals", this.abstractSystemModel.getValuesForEnumeratorType(type));
        }
        descriptor.put("isEvent", this.abstractSystemModel.isEventType(type));
        String[] multiplicity = this.abstractSystemModel.getPortMultiplicityBoundaries(element);
        if (multiplicity[0] != null) {
            descriptor.put("lowerArrayBound", multiplicity[0]);
            descriptor.put("upperArrayBound", multiplicity[1]);
        }
        descriptor.put("isArray", multiplicity[0] != null);
    }

    private void putIsEnum(Object element, Map descriptor) {
        Object attrType = this.abstractSystemModel.getAttributeType(element);
        boolean isEnum = this.abstractSystemModel.isEnumType(attrType);
        descriptor.put("isEnum", isEnum ? "true" : "false");
    }

    private void throwException(String message) throws Exception {
        Exception e = new Exception(message);
        this.errors.add(e);
        throw e;
    }

    private void addError(String message, Exception e) {
        logger.debug((Object)("adding to the errors: " + this.blockName + ": " + message));
        Exception newExc = new Exception("Block " + this.blockName + ": " + message);
        if (e != null) {
            newExc.setStackTrace(e.getStackTrace());
            e.printStackTrace();
        }
        this.errors.add(newExc);
    }

    public ArrayList<Exception> getErrors() {
        logger.debug((Object)("getErrors: " + this.errors.size()));
        return this.errors;
    }

    public void resetErrors() {
        this.errors = new ArrayList();
    }

    private String removeNotAllowedChars(String name, boolean raiseException) throws Exception {
        if (raiseException & (name.contains(".") || name.contains("@") || name.contains("/") || name.contains(" "))) {
            throw new Exception("The string " + name + " is not valid");
        }
        String ret = name.replace(".", "_").replace("@", "_").replace("/", "_").replace(" ", "_");
        if (ret.indexOf("__") == 0) {
            ret = "_M" + ret;
        }
        return ret;
    }

    public static enum SupportedLanguage {
        AST,
        CLEAN_C;

    }
}

