/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.utils;

import eu.fbk.eclipse.standardtools.ast.ASTElements.Atom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.DeclarationStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForAllPredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForAllStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ParameterListIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class AstNameResolutor {
    HashMap<EObject, String> mapNames = new HashMap();
    List<String> names = new ArrayList<String>();
    HashMap<EObject, String> mapResultVariablesNames = new HashMap();

    public String getUniqueName(EObject o) throws Exception {
        if (this.mapNames.containsKey(o)) {
            return this.mapNames.get(o);
        }
        String name = this.generateUniqueName(o);
        this.mapNames.put(o, name);
        this.names.add(name);
        return name;
    }

    public String getUniqueLocalVariableName(Atom localVariable) throws Exception {
        EObject var = localVariable.eContainer();
        while (true) {
            ParameterListIterator declLocalVariable;
            for (EObject child : var.eContents()) {
                Atom declLocalVariable2;
                if (!(child instanceof DeclarationStatement) || !(declLocalVariable2 = ((DeclarationStatement)child).getVariable().getAtom()).getName().equals(localVariable.getName()) || !this.mapNames.containsKey(declLocalVariable2)) continue;
                return this.mapNames.get(declLocalVariable2);
            }
            if (var instanceof ForAllPredicate && (declLocalVariable = ((ForAllPredicate)var).getIter()).getName().equals(localVariable.getName()) && this.mapNames.containsKey(declLocalVariable)) {
                return this.mapNames.get(declLocalVariable);
            }
            if (var instanceof ForAllStatement && (declLocalVariable = ((ForAllStatement)var).getIter()).getName().equals(localVariable.getName()) && this.mapNames.containsKey(declLocalVariable)) {
                return this.mapNames.get(declLocalVariable);
            }
            if (var.eContainer() == null) {
                return null;
            }
            var = var.eContainer();
        }
    }

    private String generateUniqueName(EObject o) throws Exception {
        return this.generateUniqueName(this.getClassName(o));
    }

    private String generateUniqueLocalVariableName(Atom localAttribute) throws Exception {
        return this.generateUniqueName(localAttribute.getName());
    }

    private String getClassName(EObject o) {
        Class<?> enclosingClass = o.getClass().getEnclosingClass();
        if (enclosingClass != null) {
            return enclosingClass.getSimpleName();
        }
        return o.getClass().getSimpleName();
    }

    private String generateUniqueName(String name) {
        int index = 0;
        String uniqueName;
        while (this.names.contains(uniqueName = this.composeName(name, index))) {
            ++index;
        }
        return uniqueName;
    }

    private String composeName(String name, int index) {
        return String.valueOf(name) + "_" + index;
    }

    public String createResultVariableName(EObject o) throws Exception {
        String elemName = this.getUniqueName(o);
        String res = String.valueOf(elemName) + "_res";
        this.mapResultVariablesNames.put(o, res);
        return res;
    }

    public String createLocalVariableName(Atom localAttribute) throws Exception {
        if (this.mapNames.containsKey(localAttribute)) {
            return this.mapNames.get(localAttribute);
        }
        String name = this.generateUniqueLocalVariableName(localAttribute);
        this.mapNames.put((EObject)localAttribute, name);
        this.names.add(name);
        return name;
    }

    public void setResultVariableName(EObject o, String varName) {
        this.mapResultVariablesNames.put(o, varName);
    }

    public String getResultVariableName(EObject o) {
        if (this.mapResultVariablesNames.containsKey(o)) {
            return this.mapResultVariablesNames.get(o);
        }
        return null;
    }
}

