/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.contract.expression.validation;

import eu.fbk.tools.editor.contract.expression.expression.BigLogicalExpression;
import eu.fbk.tools.editor.contract.expression.expression.ComponentId;
import eu.fbk.tools.editor.contract.expression.expression.FullVariableId;
import eu.fbk.tools.editor.contract.expression.expression.IterativeCountFunction;
import eu.fbk.tools.editor.contract.expression.expression.IteratorBounds;
import eu.fbk.tools.editor.contract.expression.expression.ParameterId;
import eu.fbk.tools.editor.contract.expression.expression.PortId;
import eu.fbk.tools.editor.contract.expression.expression.VariableId;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;

public class ModelUtil {
    private static String serialize(EObject object) {
        XtextResource resource = (XtextResource)object.eResource();
        return resource.getSerializer().serialize(object).trim();
    }

    protected static String getComponentIdAsStr(ComponentId subComponentId) {
        if (subComponentId.getIndexes().isEmpty()) {
            return subComponentId.getName();
        }
        return ModelUtil.serialize(subComponentId);
    }

    protected static String getVariableIdAsStr(VariableId variableId) {
        if (variableId instanceof PortId ? !((PortId)variableId).getIndexes().isEmpty() : variableId instanceof ParameterId && !((ParameterId)variableId).getIndexes().isEmpty()) {
            return ModelUtil.serialize(variableId);
        }
        return variableId.getName();
    }

    public static String getPartialVariableIdAsStr(VariableId variableId) {
        return variableId.getName().trim();
    }

    public static String getPartialComponentIdAsStr(ComponentId subComponentId) {
        return subComponentId.getName();
    }

    public static String[] getVariableComponentPrefixNames(FullVariableId fullVariableId) {
        if (fullVariableId.getFullComponentIds() != null && !fullVariableId.getFullComponentIds().isEmpty()) {
            EList<ComponentId> prefixComponentNames = fullVariableId.getFullComponentIds();
            String[] componentPrefixNames = new String[prefixComponentNames.size()];
            int i = 0;
            for (ComponentId compId : prefixComponentNames) {
                componentPrefixNames[i] = ModelUtil.getComponentIdAsStr(compId);
                ++i;
            }
            return componentPrefixNames;
        }
        return null;
    }

    public static String[] getVariableComponentPrefixPartialNames(FullVariableId fullVariableId) {
        if (fullVariableId.getFullComponentIds() != null && !fullVariableId.getFullComponentIds().isEmpty()) {
            EList<ComponentId> prefixComponentNames = fullVariableId.getFullComponentIds();
            String[] componentPrefixNames = new String[prefixComponentNames.size()];
            int i = 0;
            for (ComponentId compId : prefixComponentNames) {
                componentPrefixNames[i] = ModelUtil.getPartialComponentIdAsStr(compId);
                ++i;
            }
            return componentPrefixNames;
        }
        return null;
    }

    public static ArrayList<String> getAllPossibleComponentIds(FullVariableId fullVariableId) {
        String[] componentPrefixPartialNames = ModelUtil.getVariableComponentPrefixPartialNames(fullVariableId);
        String[] componentPrefixNames = ModelUtil.getVariableComponentPrefixNames(fullVariableId);
        return ModelUtil.getAllPossibleComponentIds(componentPrefixPartialNames, componentPrefixNames);
    }

    private static ArrayList<String> getAllPossibleComponentIds(String[] componentPrefixPartialNames, String[] componentPrefixNames) {
        if (componentPrefixPartialNames == null || componentPrefixNames == null) {
            return null;
        }
        int size = componentPrefixPartialNames.length;
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            res = ModelUtil.composeComponentId(res, componentPrefixPartialNames[i], componentPrefixNames[i]);
            ++i;
        }
        return res;
    }

    private static ArrayList<String> composeComponentId(ArrayList<String> prevCompIds, String string, String string2) {
        ArrayList<String> res = new ArrayList<String>();
        if (prevCompIds.isEmpty()) {
            res.add(string);
            if (string.compareTo(string2) != 0) {
                res.add(string2);
            }
        } else {
            for (String compId : prevCompIds) {
                res.add(String.valueOf(compId) + "." + string);
                if (string.compareTo(string2) == 0) continue;
                res.add(String.valueOf(compId) + "." + string2);
            }
        }
        return res;
    }

    public static String[] getVariableComponentPrefixNamesWithPartialOwnerName(FullVariableId fullVariableId) {
        if (fullVariableId.getFullComponentIds() != null && !fullVariableId.getFullComponentIds().isEmpty()) {
            EList<ComponentId> prefixComponentNames = fullVariableId.getFullComponentIds();
            String[] componentPrefixNames = new String[prefixComponentNames.size()];
            int i = 0;
            for (ComponentId compId : prefixComponentNames) {
                componentPrefixNames[i] = i < prefixComponentNames.size() - 1 ? ModelUtil.getComponentIdAsStr(compId) : ModelUtil.getPartialComponentIdAsStr(compId);
                ++i;
            }
            return componentPrefixNames;
        }
        return null;
    }

    public static boolean belongsToBigLogicalExpression(EObject item) {
        if (item == null) {
            return false;
        }
        if (item instanceof BigLogicalExpression || item.eContainer() instanceof BigLogicalExpression) {
            return true;
        }
        return ModelUtil.belongsToBigLogicalExpression(item.eContainer());
    }

    public static BigLogicalExpression getParentBigLogicalExpression(EObject item) {
        if (item == null) {
            return null;
        }
        if (item.eContainer() instanceof BigLogicalExpression) {
            return (BigLogicalExpression)item.eContainer();
        }
        return ModelUtil.getParentBigLogicalExpression(item.eContainer());
    }

    public static IterativeCountFunction getParentIterativeCountFunction(EObject item) {
        if (item == null) {
            return null;
        }
        if (item.eContainer() instanceof IterativeCountFunction) {
            return (IterativeCountFunction)item.eContainer();
        }
        return ModelUtil.getParentIterativeCountFunction(item.eContainer());
    }

    public static boolean belongsToIteratorBounds(EObject item) {
        if (item == null) {
            return false;
        }
        if (item.eContainer() instanceof IteratorBounds) {
            return true;
        }
        return ModelUtil.belongsToIteratorBounds(item.eContainer());
    }

    public static IteratorBounds getIteratorBoundsFromBigLogicalExpression(BigLogicalExpression item) {
        if (item == null || item.getIteratorBounds() == null) {
            return null;
        }
        return item.getIteratorBounds();
    }

    public static IteratorBounds getIteratorBoundsFromIterativeCountFunction(IterativeCountFunction item) {
        if (item == null || item.getIteratorBounds() == null) {
            return null;
        }
        return item.getIteratorBounds();
    }

    public static boolean belongsToIterativeCountFunction(EObject item) {
        if (item == null) {
            return false;
        }
        if (item instanceof IterativeCountFunction || item.eContainer() instanceof IterativeCountFunction) {
            return true;
        }
        return ModelUtil.belongsToIterativeCountFunction(item.eContainer());
    }
}

