/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.faultTreeViewer.emfta;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GateType implements Enumerator
{
    OR(0, "OR", "OR"),
    AND(1, "AND", "AND"),
    XOR(2, "XOR", "XOR"),
    PRIORITY_AND(3, "PRIORITY_AND", "PRIORITY_AND"),
    INHIBIT(4, "INHIBIT", "INHIBIT"),
    PRIORITY_OR(5, "PRIORITY_OR", "PRIORITY_OR"),
    INTERMEDIATE(6, "INTERMEDIATE", "INTERMEDIATE"),
    ORMORE(7, "ORMORE", "ORMORE"),
    ORLESS(8, "ORLESS", "ORLESS");

    public static final int OR_VALUE = 0;
    public static final int AND_VALUE = 1;
    public static final int XOR_VALUE = 2;
    public static final int PRIORITY_AND_VALUE = 3;
    public static final int INHIBIT_VALUE = 4;
    public static final int PRIORITY_OR_VALUE = 5;
    public static final int INTERMEDIATE_VALUE = 6;
    public static final int ORMORE_VALUE = 7;
    public static final int ORLESS_VALUE = 8;
    private static final GateType[] VALUES_ARRAY;
    public static final List<GateType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GateType[]{OR, AND, XOR, PRIORITY_AND, INHIBIT, PRIORITY_OR, INTERMEDIATE, ORMORE, ORLESS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GateType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GateType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GateType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GateType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GateType get(int value) {
        switch (value) {
            case 0: {
                return OR;
            }
            case 1: {
                return AND;
            }
            case 2: {
                return XOR;
            }
            case 3: {
                return PRIORITY_AND;
            }
            case 4: {
                return INHIBIT;
            }
            case 5: {
                return PRIORITY_OR;
            }
            case 6: {
                return INTERMEDIATE;
            }
            case 7: {
                return ORMORE;
            }
            case 8: {
                return ORLESS;
            }
        }
        return null;
    }

    private GateType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

