/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.ast.utils;

import eu.fbk.eclipse.standardtools.ast.ASTElements.ASTElementsFactory;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ASTElementsPackage;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AndLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AssignStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Assignable;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Atom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.BinaryProposition;
import eu.fbk.eclipse.standardtools.ast.ASTElements.BlockStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstInteger;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Context;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Equal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Expression;
import eu.fbk.eclipse.standardtools.ast.ASTElements.FalsePredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForAllPredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForAllStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.FullyQualifiedSymbol;
import eu.fbk.eclipse.standardtools.ast.ASTElements.GreaterEqualThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.GreaterThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ITEStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ITStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LessEqualThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LessThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NAryLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NotLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.OrLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ParameterListIterator;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Predicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SelfAtom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Statement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TruePredicate;
import eu.fbk.eclipse.standardtools.utils.core.utils.EObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

abstract class ASTtoASTTranslator {
    private ASTElementsFactory factory = ASTElementsFactory.eINSTANCE;
    private Map<EObject, String> relatedVariableNode = new HashMap<EObject, String>();
    private Map<ParameterListIterator, String> itListNameMap = new HashMap<ParameterListIterator, String>();
    Set<Statement> visited = new HashSet<Statement>();

    public EObject decouple(EObject ast) throws Exception {
        EObject cpy = EcoreUtil.copy((EObject)ast);
        this.preProcessStatementIterators(cpy);
        this.translateITE(cpy);
        this.stripBlocks(cpy);
        return cpy;
    }

    public static void print(EObject ast, String indent) {
        System.out.println(String.valueOf(indent) + ast.eClass().getName().toString());
        if (ast instanceof ITEStatement) {
            System.out.println(String.valueOf(indent) + ((ITEStatement)ast).getText());
        }
        if (ast instanceof ITStatement) {
            System.out.println(String.valueOf(indent) + ((ITStatement)ast).getText());
        }
        for (EObject o : ast.eContents()) {
            ASTtoASTTranslator.print(o, String.valueOf(indent) + "\t");
        }
    }

    public void resolveScalarComparison(EObject ast) {
        for (EObject o : ast.eContents()) {
            Iterator iter;
            this.resolveScalarComparison(o);
            if (o instanceof BinaryProposition) {
                Predicate newPred = this.resolveBinaryProposition((BinaryProposition)o);
                if (EcoreUtil.equals((EObject)o, (EObject)newPred)) continue;
                this.replaceElement(o, newPred);
                continue;
            }
            if (o instanceof NotLogicOP) {
                if (((NotLogicOP)o).getExpr() instanceof TruePredicate) {
                    this.replaceElement(o, this.factory.createFalsePredicate());
                    continue;
                }
                if (!(((NotLogicOP)o).getExpr() instanceof FalsePredicate)) continue;
                this.replaceElement(o, this.factory.createTruePredicate());
                continue;
            }
            if (o instanceof OrLogicOP) {
                boolean isResultCertain = false;
                for (Predicate p : ((OrLogicOP)o).getOperands()) {
                    boolean bl = isResultCertain = isResultCertain || p instanceof TruePredicate;
                }
                if (isResultCertain) {
                    this.replaceElement(o, this.factory.createTruePredicate());
                    return;
                }
                isResultCertain = true;
                for (Predicate p : ((OrLogicOP)o).getOperands()) {
                    boolean bl = isResultCertain = isResultCertain && p instanceof FalsePredicate;
                }
                if (isResultCertain) {
                    this.replaceElement(o, this.factory.createFalsePredicate());
                    return;
                }
                iter = ((OrLogicOP)o).getOperands().iterator();
                while (iter.hasNext()) {
                    if (!(iter.next() instanceof FalsePredicate)) continue;
                    iter.remove();
                }
                continue;
            }
            if (!(o instanceof AndLogicOP)) continue;
            boolean isResultCertain = false;
            for (Predicate p : ((AndLogicOP)o).getOperands()) {
                boolean bl = isResultCertain = isResultCertain || p instanceof FalsePredicate;
            }
            if (isResultCertain) {
                this.replaceElement(o, this.factory.createFalsePredicate());
                return;
            }
            isResultCertain = true;
            for (Predicate p : ((AndLogicOP)o).getOperands()) {
                boolean bl = isResultCertain = isResultCertain && p instanceof TruePredicate;
            }
            if (isResultCertain) {
                this.replaceElement(o, this.factory.createTruePredicate());
                return;
            }
            iter = ((AndLogicOP)o).getOperands().iterator();
            while (iter.hasNext()) {
                if (!(iter.next() instanceof TruePredicate)) continue;
                iter.remove();
            }
        }
    }

    private Predicate resolveBinaryProposition(BinaryProposition o) {
        Expression left = o.getLeft();
        Expression right = o.getRight();
        boolean isNonFqsTerminal = this.isNonFqsTerminal(left, right);
        boolean isBoolTerminal = this.isBoolTerminal(left, right);
        if (isNonFqsTerminal || isBoolTerminal) {
            if ((o instanceof Equal || o instanceof GreaterEqualThan || o instanceof LessEqualThan) && EcoreUtil.equals((EObject)o.getLeft(), (EObject)o.getRight())) {
                return this.factory.createTruePredicate();
            }
            if ((o instanceof GreaterEqualThan || o instanceof GreaterThan) && left instanceof ConstInteger && right instanceof ConstInteger && ((ConstInteger)left).getValue() > ((ConstInteger)right).getValue()) {
                return this.factory.createTruePredicate();
            }
            if ((o instanceof LessEqualThan || o instanceof LessThan) && left instanceof ConstInteger && right instanceof ConstInteger && ((ConstInteger)left).getValue() < ((ConstInteger)right).getValue()) {
                return this.factory.createTruePredicate();
            }
            return this.factory.createFalsePredicate();
        }
        return o;
    }

    protected abstract boolean isNonFqsTerminal(EObject var1, EObject var2);

    protected abstract boolean isBoolTerminal(EObject var1, EObject var2);

    public void stripBlocks(EObject ast) {
        for (EObject o : ast.eContents()) {
            this.stripBlocks(o);
            if (!(o instanceof BlockStatement)) continue;
            ArrayList<Statement> statementsCpy = new ArrayList<Statement>();
            for (Statement e : ((BlockStatement)o).getStatements()) {
                if (e instanceof BlockStatement) {
                    for (Statement s : ((BlockStatement)e).getStatements()) {
                        statementsCpy.add((Statement)EcoreUtil.copy((EObject)s));
                    }
                    continue;
                }
                statementsCpy.add((Statement)EcoreUtil.copy((EObject)e));
            }
            ((BlockStatement)o).getStatements().clear();
            ((BlockStatement)o).getStatements().addAll(statementsCpy);
        }
    }

    private void preProcessStatementIterators(EObject ast) throws Exception {
        for (EObject o : ast.eContents()) {
            this.preProcessStatementIterators(o);
            if (o instanceof ForAllStatement) {
                for (Object i : EObjectUtil.getAllElements((EClass)ASTElementsPackage.Literals.PARAMETER_LIST_ITERATOR, (EObject)o)) {
                    if (!((ParameterListIterator)i).getName().equals(((ForAllStatement)o).getIter().getName())) continue;
                    this.itListNameMap.put((ParameterListIterator)i, ((ForAllStatement)o).getList().getName());
                }
            }
            if (!(o instanceof ForAllPredicate)) continue;
            for (Object i : EObjectUtil.getAllElements((EClass)ASTElementsPackage.Literals.PARAMETER_LIST_ITERATOR, (EObject)o)) {
                if (!((ParameterListIterator)i).getName().equals(((ForAllPredicate)o).getIter().getName())) continue;
                this.itListNameMap.put((ParameterListIterator)i, ((ForAllPredicate)o).getList().getName());
            }
        }
    }

    private void translateITE(EObject ast) throws Exception {
        for (EObject o : ast.eContents()) {
            BlockStatement its;
            EObject first;
            Statement it;
            this.translateITE(o);
            if (o instanceof AssignStatement && ((AssignStatement)o).getLhs() instanceof Assignable) {
                this.relatedVariableNode.put(o, this.extractVarName(((AssignStatement)o).getLhs()));
            }
            if (o instanceof ForAllStatement) {
                ITStatement first2 = ((ForAllStatement)o).getStatement();
                this.relatedVariableNode.put(o, this.relatedVariableNode.get(first2));
            }
            if (o instanceof ITEStatement) {
                it = (ITEStatement)o;
                if (this.isITEonSameVar((ITEStatement)it)) {
                    first = (EObject)it.getThen().getStatements().get(0);
                    if (this.relatedVariableNode.containsKey(first)) {
                        this.relatedVariableNode.put(it, this.relatedVariableNode.get(first));
                    }
                } else {
                    its = this.splitITEStmtOnVar((ITEStatement)it);
                    this.replaceElement(o, its);
                }
            }
            if (!(o instanceof ITStatement)) continue;
            it = (ITStatement)o;
            if (it.getThen().getStatements().size() > 1) {
                its = this.splitITStmtOnVar((ITStatement)it);
                this.replaceElement(o, its);
                continue;
            }
            if (it.getThen().getStatements().size() != 1 || !this.relatedVariableNode.containsKey(first = (EObject)it.getThen().getStatements().get(0))) continue;
            this.relatedVariableNode.put(it, this.relatedVariableNode.get(first));
        }
    }

    private boolean isITEonSameVar(ITEStatement it) {
        String v = this.relatedVariableNode.get(it.getThen().getStatements().get(0));
        for (Statement s : this.createStripStatementList(it.getThen().getStatements())) {
            if (this.relatedVariableNode.get(s).equals(v)) continue;
            return false;
        }
        for (Statement s : this.createStripStatementList(it.getElse().getStatements())) {
            if (this.relatedVariableNode.get(s).equals(v)) continue;
            return false;
        }
        return true;
    }

    private String extractVarName(FullyQualifiedSymbol lhs) {
        String out = "";
        for (Atom a : lhs.getCtx().getAtoms()) {
            out = a instanceof ParameterListIterator ? String.valueOf(out) + this.itListNameMap.get(a) + "." : String.valueOf(out) + a.getName() + ".";
        }
        out = String.valueOf(out) + lhs.getAtom().getName();
        return out;
    }

    private BlockStatement splitITStmtOnVar(ITStatement it) throws Exception {
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        this.visited.clear();
        List<Statement> strip = this.createStripStatementList(it.getThen().getStatements());
        for (Statement s : strip) {
            if (this.visited.contains(s)) continue;
            this.visited.add(s);
            ArrayList<Statement> thenStmts = new ArrayList<Statement>();
            thenStmts.add(s);
            thenStmts.addAll(this.collectConnectedStmts(s, strip));
            BlockStatement newBlock = this.factory.createBlockStatement();
            ITStatement newStmt = this.createITStatement((Predicate)EcoreUtil.copy((EObject)it.getCondition()), newBlock);
            newBlock.getStatements().addAll(thenStmts);
            this.relatedVariableNode.put(newStmt, this.relatedVariableNode.get(s));
            stmts.add(newStmt);
        }
        return this.createBlockStatement(stmts);
    }

    private void checkCondition(EObject obj, String senderMethod) throws Exception {
        if (obj == null) {
            throw new Exception("Trying to insert a null condition " + senderMethod);
        }
        if (obj instanceof NAryLogicOP && ((NAryLogicOP)obj).getOperands().isEmpty()) {
            throw new Exception("Trying to insert an empty NAryLogicOp as a condition " + senderMethod);
        }
        if (obj instanceof Equal) {
            if (((Equal)obj).getLeft() instanceof FullyQualifiedSymbol) {
                this.checkFullyQualified((FullyQualifiedSymbol)((Equal)obj).getLeft(), senderMethod);
            }
            if (((Equal)obj).getRight() instanceof FullyQualifiedSymbol) {
                this.checkFullyQualified((FullyQualifiedSymbol)((Equal)obj).getRight(), senderMethod);
            }
        }
    }

    private void checkFullyQualified(FullyQualifiedSymbol o, String senderMethod) throws Exception {
        this.checkAtom(o.getAtom(), "in FullyQualifiedSymbol from " + senderMethod);
        this.checkContext(o.getCtx(), "in FullyQualifiedSymbol from " + senderMethod);
    }

    private void checkAtom(Atom o, String senderMethod) throws Exception {
        if (!(o instanceof SelfAtom)) {
            if (o == null) {
                throw new Exception("Found null atom " + senderMethod);
            }
            if (o.getName() == null) {
                throw new Exception("Found Atom with null name " + senderMethod);
            }
            this.checkString(o.getName(), "of atom " + senderMethod);
        }
    }

    private void checkContext(Context o, String senderMethod) throws Exception {
        if (o.getAtoms().isEmpty()) {
            throw new Exception("Found empty Context " + senderMethod + "\n " + StringUtils.join((Object[])Thread.currentThread().getStackTrace(), (String)"\n"));
        }
        for (Atom atom : o.getAtoms()) {
            this.checkAtom(atom, "for element of context " + senderMethod);
        }
    }

    private void checkString(String string, String senderMethod) throws Exception {
        if (string == null) {
            throw new Exception("Found null string or name " + senderMethod);
        }
        if (string.equals("")) {
            throw new Exception("Found empty String or name " + senderMethod);
        }
    }

    private BlockStatement splitITEStmtOnVar(ITEStatement it) throws Exception {
        Statement newStmt;
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        this.visited.clear();
        List<Statement> stripThen = this.createStripStatementList(it.getThen().getStatements());
        List<Statement> stripElse = this.createStripStatementList(it.getElse().getStatements());
        for (Statement s : stripThen) {
            if (this.visited.contains(s)) continue;
            this.visited.add(s);
            ArrayList<Statement> thenStmts = new ArrayList<Statement>();
            thenStmts.add(s);
            thenStmts.addAll(this.collectConnectedStmts(s, stripThen));
            BlockStatement thenBlock = this.createBlockStatement(thenStmts);
            newStmt = null;
            List<Statement> elseStmts = this.collectConnectedStmts(s, stripElse);
            if (!elseStmts.isEmpty()) {
                BlockStatement elseBlock = this.createBlockStatement(elseStmts);
                newStmt = this.createITEStatement((Predicate)EcoreUtil.copy((EObject)it.getCondition()), thenBlock, elseBlock);
            } else {
                newStmt = this.createITStatement((Predicate)EcoreUtil.copy((EObject)it.getCondition()), thenBlock);
            }
            this.relatedVariableNode.put(newStmt, this.relatedVariableNode.get(s));
            stmts.add(newStmt);
        }
        for (Statement s : stripElse) {
            if (this.visited.contains(s)) continue;
            this.visited.add(s);
            ArrayList<Statement> elseStmts = new ArrayList<Statement>();
            elseStmts.add(s);
            elseStmts.addAll(this.collectConnectedStmts(s, stripElse));
            BlockStatement newBlock = this.createBlockStatement(elseStmts);
            newStmt = this.createITStatement(this.createNotLogicOP((Expression)EcoreUtil.copy((EObject)it.getCondition())), newBlock);
            this.relatedVariableNode.put(newStmt, this.relatedVariableNode.get(s));
            stmts.add(newStmt);
        }
        return this.createBlockStatement(stmts);
    }

    private NotLogicOP createNotLogicOP(Expression expr) {
        NotLogicOP ret = this.factory.createNotLogicOP();
        ret.setExpr(expr);
        return ret;
    }

    private ITStatement createITStatement(Predicate condition, BlockStatement then) throws Exception {
        ITStatement stmt = this.factory.createITStatement();
        this.checkCondition(condition, "createITStatement");
        stmt.setCondition(condition);
        stmt.setThen(then);
        return stmt;
    }

    private ITEStatement createITEStatement(Predicate condition, BlockStatement then, BlockStatement elseStmt) throws Exception {
        ITEStatement stmt = this.factory.createITEStatement();
        this.checkCondition(condition, "createITStatement");
        stmt.setCondition(condition);
        stmt.setThen(then);
        stmt.setElse(elseStmt);
        return stmt;
    }

    private BlockStatement createBlockStatement(List<Statement> statements) throws Exception {
        BlockStatement blockStmt = this.factory.createBlockStatement();
        blockStmt.getStatements().addAll(statements);
        return blockStmt;
    }

    private List<Statement> createStripStatementList(EList<Statement> stmts) {
        ArrayList<Statement> out = new ArrayList<Statement>();
        for (Statement s : stmts) {
            if (s instanceof BlockStatement) {
                out.addAll(this.createStripStatementList(((BlockStatement)s).getStatements()));
                continue;
            }
            out.add(s);
        }
        return out;
    }

    private List<Statement> collectConnectedStmts(Statement sample, List<Statement> pool) {
        ArrayList<Statement> out = new ArrayList<Statement>();
        if (this.relatedVariableNode.containsKey(sample)) {
            for (Statement s : pool) {
                if (this.visited.contains(s) || !this.relatedVariableNode.containsKey(s) || !this.relatedVariableNode.get(s).equals(this.relatedVariableNode.get(sample))) continue;
                this.visited.add(s);
                out.add((Statement)EcoreUtil.copy((EObject)s));
            }
        }
        return out;
    }

    public void replaceElement(EObject oldElement, EObject newElement) {
        try {
            EObject parent = oldElement.eContainer();
            if (parent != null) {
                EStructuralFeature feature = oldElement.eContainingFeature();
                if (feature.isMany()) {
                    List list = (List)parent.eGet(feature);
                    int index = list.indexOf(oldElement);
                    if (index != -1) {
                        list.set(index, newElement);
                    }
                } else {
                    parent.eSet(feature, (Object)newElement);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Attempt to replace " + oldElement.eClass().getName() + " with " + newElement.eClass().getName());
        }
    }
}

