/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.ast.visitors.ast;

import eu.fbk.eclipse.standardtools.ast.ASTElements.AbsOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AdditionOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AndLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AndOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AssertStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AssignStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Atom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Attribute;
import eu.fbk.eclipse.standardtools.ast.ASTElements.BinaryProposition;
import eu.fbk.eclipse.standardtools.ast.ASTElements.BlockExpression;
import eu.fbk.eclipse.standardtools.ast.ASTElements.BlockStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Boolean;
import eu.fbk.eclipse.standardtools.ast.ASTElements.CaseStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.CastExpression;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ComplementOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstHexadecimal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstInteger;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstOctal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstReal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Context;
import eu.fbk.eclipse.standardtools.ast.ASTElements.CountOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.DeclarationStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.DivisionOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ElementOfList;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Equal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Event;
import eu.fbk.eclipse.standardtools.ast.ASTElements.EventCall;
import eu.fbk.eclipse.standardtools.ast.ASTElements.EventRecept;
import eu.fbk.eclipse.standardtools.ast.ASTElements.FalsePredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForAllPredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForAllStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.FullyQualifiedSymbol;
import eu.fbk.eclipse.standardtools.ast.ASTElements.GreaterEqualThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.GreaterThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ITEStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ITStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ImpliesLogicOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.InputPort;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Integer;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LeftShiftOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LessEqualThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LessThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LocalAtom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LocalVariable;
import eu.fbk.eclipse.standardtools.ast.ASTElements.MaxOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.MinOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ModuleOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.MultiplicationOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NAryLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NegativeOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NotEqual;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NotLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.OrLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.OrOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.OutputPort;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Parameter;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ParameterList;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ParameterListIterator;
import eu.fbk.eclipse.standardtools.ast.ASTElements.PositiveOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Predicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Real;
import eu.fbk.eclipse.standardtools.ast.ASTElements.RigthShiftOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SelfAtom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SetLiteral;
import eu.fbk.eclipse.standardtools.ast.ASTElements.StateLiteral;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SubComponent;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SubtractionOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SwitchCaseStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Symbol;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TransitionEffect;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TransitionGuard;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TruePredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Variable;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Void;
import eu.fbk.eclipse.standardtools.ast.ASTElements.XorOp;
import eu.fbk.eclipse.standardtools.ast.visitors.ast.CachedAstVisitorAction;
import org.eclipse.emf.ecore.EObject;

public class AstSerializerAction
extends CachedAstVisitorAction {
    @Override
    public String getOutputObject(EObject inputObject) throws Exception {
        return (String)super.getOutputObject(inputObject);
    }

    @Override
    public void action(Attribute o) throws Exception {
        this.action((Atom)o);
    }

    @Override
    public void action(Context o) throws Exception {
        String res = "";
        boolean isFirst = true;
        int i = o.getAtoms().size() - 1;
        while (i >= 0) {
            Atom a = (Atom)o.getAtoms().get(i);
            if (!(a instanceof SelfAtom)) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    res = this.addPrefix(res, a);
                }
                res = res.concat(this.getOutputObject(a));
            }
            --i;
        }
        this.putOutputObject(o, res);
    }

    private String addPrefix(String res, Atom a) {
        res = res.concat(" di ");
        return res;
    }

    @Override
    public void action(SelfAtom o) throws Exception {
        this.putOutputObject(o, "self");
    }

    public void action(Atom o) throws Exception {
        this.putOutputObject(o, o.getName());
    }

    public void action(FullyQualifiedSymbol o) throws Exception {
        String atomStr = this.getOutputObject(o.getAtom());
        String ctxStr = this.getOutputObject(o.getCtx());
        String res = atomStr;
        if (!ctxStr.equals("")) {
            res = String.valueOf(this.addPrefix(res, this.getLastAtom(o.getCtx()))) + ctxStr;
        }
        this.putOutputObject(o, res);
    }

    private Atom getLastAtom(Context ctx) {
        int ind = ctx.getAtoms().size() - 1;
        return (Atom)ctx.getAtoms().get(ind);
    }

    @Override
    public void action(ConstInteger o) throws Exception {
        this.putOutputObject(o, String.valueOf(o.getValue()));
    }

    @Override
    public void action(SetLiteral o) throws Exception {
        this.action((Symbol)o);
    }

    @Override
    public void action(StateLiteral o) throws Exception {
        this.action((Symbol)o);
    }

    public void action(Symbol o) throws Exception {
        this.putOutputObject(o, this.getOutputObject(o.getAtom()));
    }

    @Override
    public void action(Parameter o) throws Exception {
        this.action((FullyQualifiedSymbol)o);
    }

    @Override
    public void action(Variable o) throws Exception {
        this.action((FullyQualifiedSymbol)o);
    }

    @Override
    public void action(TruePredicate o) throws Exception {
        this.putOutputObject(o, "True");
    }

    @Override
    public void action(FalsePredicate o) throws Exception {
        this.putOutputObject(o, "False");
    }

    @Override
    public void action(NotLogicOP o) throws Exception {
        String res = "negazione di (" + this.getOutputObject(o.getExpr()) + ")";
        this.putOutputObject(o, res);
    }

    @Override
    public void action(ImpliesLogicOp o) throws Exception {
        String rightStr = this.getOutputObject(o.getRight());
        String res = "";
        if (!(o.getLeft() instanceof TruePredicate)) {
            String leftStr = this.getOutputObject(o.getLeft());
            res = res.concat("se (" + leftStr + ") allora ");
        }
        res = res.concat("(" + rightStr + ")");
        this.putOutputObject(o, res);
    }

    public void action(NAryLogicOP o, String term) throws Exception {
        boolean isFirst = true;
        String res = "";
        for (Predicate predicate : o.getOperands()) {
            if (isFirst) {
                isFirst = false;
            } else {
                res = res.concat(" " + term + " ");
                if (this.isTopLevelAndLogicOp(o)) {
                    res = res.concat("\n");
                }
            }
            res = res.concat("( " + this.getOutputObject(predicate) + " )");
        }
        this.putOutputObject(o, res);
    }

    private boolean isTopLevelAndLogicOp(EObject o) {
        if (o.eContainer() != null) {
            if (o.eContainer() instanceof AndLogicOP) {
                return false;
            }
            return this.isTopLevelAndLogicOp(o.eContainer());
        }
        return true;
    }

    @Override
    public void action(AndLogicOP o) throws Exception {
        this.action(o, " e ");
    }

    @Override
    public void action(OrLogicOP o) throws Exception {
        this.action(o, " o ");
    }

    public void action(BinaryProposition o, String term) throws Exception {
        String leftStr = "(" + this.getOutputObject(o.getLeft()) + ")";
        String rightStr = "(" + this.getOutputObject(o.getRight()) + ")";
        String res = String.valueOf(leftStr) + " " + term + " " + rightStr;
        this.putOutputObject(o, res);
    }

    @Override
    public void action(Equal o) throws Exception {
        this.action(o, " \u00e8 uguale a ");
    }

    @Override
    public void action(LessThan o) throws Exception {
        this.action(o, " \u00e8 minore di ");
    }

    @Override
    public void action(LessEqualThan o) throws Exception {
        this.action(o, " \u00e8 minore o uguale a ");
    }

    @Override
    public void action(GreaterThan o) throws Exception {
        this.action(o, " \u00e8 maggiore di ");
    }

    @Override
    public void action(GreaterEqualThan o) throws Exception {
        this.action(o, " \u00e8 maggiore o uguale a ");
    }

    @Override
    public void action(AssignStatement o) throws Exception {
        String leftStr = this.getOutputObject(o.getLhs());
        String rightStr = this.getOutputObject(o.getRhs());
        String res = "assegna a '" + leftStr + "' il valore di '" + rightStr + "'";
        this.putOutputObject(o, res);
    }

    @Override
    public void action(TransitionGuard o) throws Exception {
        this.putOutputObject(o, "");
    }

    @Override
    public void action(TransitionEffect o) throws Exception {
        this.putOutputObject(o, "");
    }

    @Override
    public void action(ConstReal o) throws Exception {
    }

    @Override
    public void action(ConstHexadecimal o) throws Exception {
    }

    @Override
    public void action(ConstOctal o) throws Exception {
    }

    @Override
    public void action(AbsOp o) throws Exception {
    }

    @Override
    public void action(CountOp o) throws Exception {
    }

    @Override
    public void action(MinOp o) throws Exception {
    }

    @Override
    public void action(MaxOp o) throws Exception {
    }

    @Override
    public void action(AdditionOp o) throws Exception {
    }

    @Override
    public void action(SubtractionOp o) throws Exception {
    }

    @Override
    public void action(MultiplicationOp o) throws Exception {
    }

    @Override
    public void action(DivisionOp o) throws Exception {
    }

    @Override
    public void action(ModuleOp o) throws Exception {
    }

    @Override
    public void action(LeftShiftOp o) throws Exception {
    }

    @Override
    public void action(RigthShiftOp o) throws Exception {
    }

    @Override
    public void action(ComplementOp o) throws Exception {
    }

    @Override
    public void action(AndOp o) throws Exception {
    }

    @Override
    public void action(OrOp o) throws Exception {
    }

    @Override
    public void action(XorOp o) throws Exception {
    }

    @Override
    public void action(NotEqual o) throws Exception {
    }

    @Override
    public void action(PositiveOp o) throws Exception {
    }

    @Override
    public void action(NegativeOp o) throws Exception {
    }

    @Override
    public void action(InputPort o) throws Exception {
    }

    @Override
    public void action(OutputPort o) throws Exception {
    }

    @Override
    public void action(SubComponent o) throws Exception {
    }

    @Override
    public void action(Event o) throws Exception {
    }

    @Override
    public void action(EventCall o) throws Exception {
    }

    @Override
    public void action(EventRecept o) throws Exception {
    }

    @Override
    public void action(ITStatement o) throws Exception {
    }

    @Override
    public void action(ITEStatement o) throws Exception {
    }

    @Override
    public void action(AssertStatement o) throws Exception {
    }

    @Override
    public void action(ForAllPredicate o) throws Exception {
    }

    @Override
    public void action(CastExpression o) throws Exception {
    }

    @Override
    public void action(ElementOfList o) throws Exception {
    }

    @Override
    public void action(LocalVariable o) throws Exception {
    }

    @Override
    public void action(DeclarationStatement o) throws Exception {
    }

    @Override
    public void action(LocalAtom o) throws Exception {
    }

    @Override
    public void action(ForStatement o) throws Exception {
    }

    @Override
    public void action(ForAllStatement o) throws Exception {
    }

    @Override
    public void action(SwitchCaseStatement o) throws Exception {
    }

    @Override
    public void action(CaseStatement o) throws Exception {
    }

    @Override
    public void action(ParameterListIterator o) throws Exception {
    }

    @Override
    public void action(ParameterList o) throws Exception {
    }

    @Override
    public void action(Boolean o) throws Exception {
    }

    @Override
    public void action(Real o) throws Exception {
    }

    @Override
    public void action(Void o) throws Exception {
    }

    @Override
    public void action(Integer o) throws Exception {
    }

    @Override
    public void action(BlockStatement o) throws Exception {
    }

    @Override
    public void action(BlockExpression o) throws Exception {
    }
}

