/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.api.core;

import eu.fbk.eclipse.explodtwin.api.core.SysMLv2StateMachineModel;
import eu.fbk.eclipse.explodtwin.api.core.SysMLv2SystemModel;
import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.explodtwin.api.util.SysMLv2ToSMVExpression;
import eu.fbk.eclipse.standardtools.utils.core.utils.Pair;
import eu.fbk.sysmlv2.sysMLv2.ActionUsage;
import eu.fbk.sysmlv2.sysMLv2.Assignment;
import eu.fbk.sysmlv2.sysMLv2.AttributeUsage;
import eu.fbk.sysmlv2.sysMLv2.Calculation;
import eu.fbk.sysmlv2.sysMLv2.CalculationUsage;
import eu.fbk.sysmlv2.sysMLv2.ConnectionElement;
import eu.fbk.sysmlv2.sysMLv2.ConstraintUsage;
import eu.fbk.sysmlv2.sysMLv2.Container;
import eu.fbk.sysmlv2.sysMLv2.Definition;
import eu.fbk.sysmlv2.sysMLv2.DirectedElement;
import eu.fbk.sysmlv2.sysMLv2.Direction;
import eu.fbk.sysmlv2.sysMLv2.EnumDefinition;
import eu.fbk.sysmlv2.sysMLv2.Expression;
import eu.fbk.sysmlv2.sysMLv2.Feature;
import eu.fbk.sysmlv2.sysMLv2.Model;
import eu.fbk.sysmlv2.sysMLv2.NamedElement;
import eu.fbk.sysmlv2.sysMLv2.Part;
import eu.fbk.sysmlv2.sysMLv2.PartDefinition;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.sysmlv2.sysMLv2.ReferenceExpression;
import eu.fbk.sysmlv2.sysMLv2.SendUsage;
import eu.fbk.sysmlv2.sysMLv2.StateUsage;
import eu.fbk.sysmlv2.sysMLv2.Transition;
import eu.fbk.sysmlv2.sysMLv2.TypedElement;
import eu.fbk.sysmlv2.sysMLv2.Usage;
import eu.fbk.sysmlv2.sysMLv2.Value;
import eu.fbk.sysmlv2.sysMLv2.impl.PartUsageImpl;
import eu.fbk.sysmlv2.util.SysMLv2FeatureChainSwitch;
import eu.fbk.sysmlv2.util.SysMLv2Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class ModelLibrary {
    private static final SysMLv2SystemModel SYSTEM_MODEL = new SysMLv2SystemModel();
    private static final SysMLv2StateMachineModel STATE_MACHINE_MODEL = new SysMLv2StateMachineModel();
    private static final String PREEFFECT = "preeffect";
    private static final String POSTEFFECT = "posteffect";
    private static final String PRECONDITION = "precondition";
    private static final String POSTCONDITION = "postcondition";
    private static final String REAL_ASSET = "realAsset";
    private static final String ENVIRONMENT = "env";
    private static final String ACTIVITY_PARAM = "ActivityParam";
    private static final String INVARIANT = "invariant";
    private static final String GET_LOWER_BOUND_DURATION = "getLowerBoundDuration";
    private static final String GET_UPPER_BOUND_DURATION = "getUpperBoundDuration";
    private static final String UNPLANNABLE = "Unplannable";

    public List<Resource.Diagnostic> validateModel(PartUsage systemComponent) {
        ResourceSet resourceSet = EcoreUtil2.getResourceSet((Notifier)systemComponent);
        ArrayList<Resource.Diagnostic> errors = new ArrayList<Resource.Diagnostic>();
        resourceSet.getResources().forEach(resource -> {
            boolean bl = errors.addAll((Collection<Resource.Diagnostic>)resource.getErrors());
        });
        return errors;
    }

    public List<String> getSubComponentsNames(PartUsage component) {
        return this.getSubComponents(component).stream().map(NamedElement::getName).toList();
    }

    public List<Transition> getNonInitTransitions(StateUsage stateMachine) {
        return STATE_MACHINE_MODEL.getNonInitTransitions(stateMachine);
    }

    public List<String> getNonInitTransitionsNameList(StateUsage stateMachine) {
        return STATE_MACHINE_MODEL.getNonInitTransitionsNameList(stateMachine);
    }

    public List<Transition> getInitTransitions(StateUsage stateMachine) {
        return STATE_MACHINE_MODEL.getInitTransitions(stateMachine);
    }

    public List<StateUsage> getNonInitStates(StateUsage stateMachine) {
        return STATE_MACHINE_MODEL.getNonInitStates(stateMachine);
    }

    public List<String> getNonInitStatesNameList(StateUsage stateMachine) {
        return STATE_MACHINE_MODEL.getIntermediateStatesNameList(stateMachine);
    }

    public List<String> getInitTransitionsNameList(StateUsage stateMachine) {
        return STATE_MACHINE_MODEL.getInitTransitionsNameList(stateMachine);
    }

    public StateUsage getFirstNominalStateMachine(PartUsage component) {
        return (StateUsage)STATE_MACHINE_MODEL.getFirstNominalStateMachine(component);
    }

    public PartUsage getSubComponent(PartUsage component, String subCompName) {
        return (PartUsage)SYSTEM_MODEL.getSubComponent(component, subCompName);
    }

    public String getTransitionName(Transition transition) {
        return STATE_MACHINE_MODEL.getTransitionName(transition);
    }

    public List<String> getTransitionsNameList(StateUsage stateMachine) {
        return STATE_MACHINE_MODEL.getTransitionsNameList(stateMachine);
    }

    public String getTransitionSourceStateName(Transition transition) {
        return transition.getSource().getName();
    }

    public String getTransitionTargetStateName(Transition transition) {
        return transition.getDestination().getName();
    }

    public String getStateInvariant(StateUsage state) {
        return STATE_MACHINE_MODEL.getStateInvariant(state, null);
    }

    public String getStateMachineName(StateUsage stateMachine) {
        return stateMachine.getName();
    }

    public PartDefinition getStateMachineOwner(StateUsage stateMachine) {
        return (PartDefinition)stateMachine.eContainer();
    }

    public String getStateMachineOwnerName(StateUsage stateMachine) {
        return this.getStateMachineOwner(stateMachine).getName();
    }

    public String getTransitionGuardText(Transition transition) {
        return STATE_MACHINE_MODEL.getTransitionGuardCondition(transition, "CleanC");
    }

    public String getTransitionEffectText(Transition transition) {
        return STATE_MACHINE_MODEL.getTransitionEffectText(transition, "CleanC");
    }

    public List<PartUsage> getSubComponents(PartUsage component) {
        return SYSTEM_MODEL.getSubComponentsInstances(component);
    }

    public List<String> getAttributesNames(Object component) {
        return SYSTEM_MODEL.getAttributesNames(component);
    }

    @Deprecated
    public String getAttributeName(AttributeUsage attribute) {
        return attribute.getName();
    }

    @Deprecated
    public Definition getAttributeType(Usage attribute) {
        return SysMLv2Util.getType((TypedElement)attribute);
    }

    public Definition getType(TypedElement element) {
        return SysMLv2Util.getType((TypedElement)element);
    }

    @Deprecated
    public String getPartUsageName(PartUsage component) {
        return component.getName();
    }

    @Deprecated
    public String getPartUsageTypeName(PartUsage component) {
        return this.getComponentTypeName((Part)component);
    }

    public String getComponentName(Part component) {
        return this.getName((EObject)component);
    }

    public List<PartDefinition> getAllComponentsFromModel(Model model) {
        return SYSTEM_MODEL.getComponents(model);
    }

    public Set<StateUsage> getAllStateMachinesFromModel(Model model) {
        return STATE_MACHINE_MODEL.getAllStateMachinesFromModel(model).stream().map(StateUsage.class::cast).collect(Collectors.toSet());
    }

    public PartDefinition getComponentType(Part part) {
        return ModelUtil.getComponentType(part);
    }

    public String getComponentTypeName(Part part) {
        return this.getName((EObject)this.getComponentType(part));
    }

    public List<ConnectionElement> getConnections(PartUsage component) {
        List<ConnectionElement> allConnections = ModelUtil.getAllContentsOfTypeFromModel(EcoreUtil2.getResourceSet((Notifier)component), ConnectionElement.class);
        allConnections.removeIf(connection -> !EcoreUtil2.equals((EObject)component, (EObject)this.getSourceEndOwner((ConnectionElement)connection)) && !EcoreUtil2.equals((EObject)component, (EObject)this.getTargetEndOwner((ConnectionElement)connection)));
        return allConnections;
    }

    public PartUsage getSourceEndOwner(ConnectionElement connection) {
        return (PartUsage)ModelUtil.getConnectorEndOwner(connection.getSource());
    }

    public PartUsage getTargetEndOwner(ConnectionElement connection) {
        return (PartUsage)ModelUtil.getConnectorEndOwner(connection.getTarget());
    }

    public NamedElement getConnectionSource(ConnectionElement connection) {
        return ((ReferenceExpression)connection.getSource()).getReferencedElement();
    }

    public NamedElement getConnectionTarget(ConnectionElement connection) {
        return connection.getTarget().getReferencedElement();
    }

    public String getName(EObject element) {
        String string;
        if (element instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)element;
            string = namedElement.getName();
        } else {
            string = null;
        }
        return string;
    }

    public Set<StateUsage> getNominalStateMachinesIncludingFromSubComponents(PartUsage component) {
        return STATE_MACHINE_MODEL.getNominalStateMachinesIncludingFromSubComponents(component).stream().map(StateUsage.class::cast).collect(Collectors.toSet());
    }

    public PartDefinition getNearestOwnerComponent(PartUsage component) {
        return (PartDefinition)EcoreUtil2.getContainerOfType((EObject)component, PartDefinition.class);
    }

    public List<DirectedElement> getNonStaticPorts(EObject component) {
        return ModelUtil.getAttributeUsagesInPart(component).stream().filter(DirectedElement.class::isInstance).map(DirectedElement.class::cast).filter(usage -> !Direction.NONE.equals((Object)usage.getDirection())).toList();
    }

    @Deprecated
    public String getPortName(Usage port) {
        return port.getName();
    }

    @Deprecated
    public Definition getPortType(Usage port) {
        return SysMLv2Util.getType((TypedElement)port);
    }

    public List<DirectedElement> getStaticPorts(Object component) {
        return List.of();
    }

    public boolean isBooleanType(Definition type) {
        return ModelUtil.isBooleanType(type);
    }

    public boolean isClockType(Definition type) {
        return ModelUtil.isClockType(type);
    }

    public boolean isEnumType(Definition type) {
        return ModelUtil.isEnumType(type);
    }

    public boolean isIntType(Definition type) {
        return ModelUtil.isIntegerType(type);
    }

    public boolean isRealType(Definition type) {
        return ModelUtil.isRealType(type);
    }

    public boolean isIntervalType(Definition type) {
        return ModelUtil.isIntervalType(type);
    }

    public boolean isBoundedIntType(Definition type) {
        return ModelUtil.isBoundedIntType(type);
    }

    public boolean isBoundedRealType(Definition type) {
        return ModelUtil.isBoundedRealType(type);
    }

    public String[] getBounds(Container element) {
        return new String[]{ModelUtil.getBoundValue(element, ModelUtil.Bound.MIN), ModelUtil.getBoundValue(element, ModelUtil.Bound.MAX)};
    }

    public List<String> getLiteralsFromAttributes(PartDefinition component) {
        return SYSTEM_MODEL.getEnumValuesFromAttributes(component);
    }

    public List<String> getLiteralsForEnumeratorType(EnumDefinition enumerator) {
        return ModelUtil.getEnumValues(enumerator, false);
    }

    private PartUsage getPartUsageRedefining(PartUsage instance, String redefinedInstanceName) {
        PartDefinition definition = ModelUtil.getComponentType((Part)instance);
        return (PartUsage)EcoreUtil2.typeSelect((List)definition.getMembers(), PartUsageImpl.class).stream().filter(partUsage -> partUsage.getRedefinitionName().equals(redefinedInstanceName)).findAny().orElseThrow(() -> new RuntimeException("No " + redefinedInstanceName + " in component instance " + instance.getName() + "."));
    }

    public PartUsage getRealAsset(PartUsage rootComponent) {
        return this.getPartUsageRedefining(rootComponent, REAL_ASSET);
    }

    public PartUsage getEnvironment(PartUsage rootComponent) {
        return this.getPartUsageRedefining(rootComponent, ENVIRONMENT);
    }

    private List<AttributeUsage> getAndFilterAttributes(Container container, Predicate<? super AttributeUsage> predicate) {
        List attributes = EcoreUtil2.typeSelect((List)container.getMembers(), AttributeUsage.class);
        attributes.removeIf(Predicate.not(predicate));
        return attributes;
    }

    public List<AttributeUsage> getStateVariables(PartUsage component) {
        return this.getAndFilterAttributes((Container)ModelUtil.getComponentType((Part)component), ModelUtil::isStateVariable);
    }

    public List<AttributeUsage> getObservableVariables(PartUsage component) {
        return this.getAndFilterAttributes((Container)ModelUtil.getComponentType((Part)component), SysMLv2Util::isObservableVariable);
    }

    public List<String> getObservablesFeatureChains(PartUsage systemComponent) {
        return new SysMLv2FeatureChainSwitch().getObservablesFeatureChains(systemComponent);
    }

    public List<AttributeUsage> getCalibrationParameters(PartUsage component) {
        return this.getAndFilterAttributes((Container)ModelUtil.getComponentType((Part)component), ModelUtil::isCalibrationParameter);
    }

    public Expression getStateVariableDefault(AttributeUsage stateVariable) {
        Value value = stateVariable.getValue();
        if (value != null && value.isDefault()) {
            return value.getExpression();
        }
        return null;
    }

    public List<PartUsage> getSubsystems(PartUsage realAsset) {
        PartDefinition definition = ModelUtil.getComponentType((Part)realAsset);
        List partUsages = EcoreUtil2.typeSelect((List)definition.getMembers(), PartUsage.class);
        partUsages.removeIf(Predicate.not(ModelUtil::isSubsystem));
        return partUsages;
    }

    public boolean isObservable(AttributeUsage variable) {
        return SysMLv2Util.isObservableVariable((AttributeUsage)variable);
    }

    public boolean isUnplannable(PartUsage activity) {
        PartDefinition definition = ModelUtil.getComponentType((Part)activity);
        return SysMLv2Util.containsMetadataUsagesOfType((Container)definition, (String)UNPLANNABLE);
    }

    public List<PartUsage> getActivities(PartUsage subsystem) {
        PartDefinition definition = ModelUtil.getComponentType((Part)subsystem);
        List partUsages = EcoreUtil2.typeSelect((List)definition.getMembers(), PartUsage.class);
        partUsages.removeIf(Predicate.not(ModelUtil::isActivity));
        return partUsages;
    }

    public List<Usage> getActivityParameters(PartUsage activity) {
        PartDefinition definition = ModelUtil.getComponentType((Part)activity);
        List usages = EcoreUtil2.typeSelect((List)definition.getMembers(), Usage.class);
        usages.removeIf(usage -> !SysMLv2Util.containsMetadataUsagesOfType((Container)usage, (String)ACTIVITY_PARAM));
        return usages;
    }

    public StateUsage getPlatformStateMachine(PartUsage subsystem) {
        return ModelUtil.getPlatformStateMachine((Part)subsystem);
    }

    public StateUsage getMissionStateMachine(PartUsage subsystem) {
        return ModelUtil.getMissionStateMachine((Part)subsystem);
    }

    public List<Transition> getDurativeTransitions(StateUsage stateMachine) {
        List<Transition> transitions = this.getTransitions(stateMachine);
        transitions.removeIf(Predicate.not(SysMLv2Util::isDurative));
        return transitions;
    }

    public List<Transition> getTransitions(StateUsage stateMachine) {
        return STATE_MACHINE_MODEL.getTransitions(stateMachine);
    }

    public StateUsage getTransitionSource(Transition transition) {
        return transition.getSource();
    }

    public StateUsage getTransitionDestination(Transition transition) {
        return transition.getDestination();
    }

    public PartUsage getTransitionActivity(Transition durativeTransition) {
        ReferenceExpression referenceExpression;
        NamedElement called;
        Feature feature;
        Expression expression;
        EObject act = (EObject)durativeTransition.getMembers().get(0);
        if (act instanceof Feature && (expression = (feature = (Feature)act).getValue().getExpression()) instanceof ReferenceExpression && (called = (referenceExpression = (ReferenceExpression)expression).getReferencedElement()) instanceof PartUsage) {
            PartUsage partUsage = (PartUsage)called;
            return partUsage;
        }
        throw new RuntimeException("Ill-formed DurativeTransition " + durativeTransition.getName());
    }

    public ConstraintUsage getPreCondition(PartUsage activity) {
        return (ConstraintUsage)SysMLv2Util.getMemberByName((Container)ModelUtil.getComponentType((Part)activity), ConstraintUsage.class, (String)PRECONDITION);
    }

    public ConstraintUsage getPostCondition(PartUsage activity) {
        return (ConstraintUsage)SysMLv2Util.getMemberByName((Container)ModelUtil.getComponentType((Part)activity), ConstraintUsage.class, (String)POSTCONDITION);
    }

    public ActionUsage getPreEffect(PartUsage activity) {
        return (ActionUsage)SysMLv2Util.getMemberByName((Container)ModelUtil.getComponentType((Part)activity), ActionUsage.class, (String)PREEFFECT);
    }

    public ActionUsage getPostEffect(PartUsage activity) {
        return (ActionUsage)SysMLv2Util.getMemberByName((Container)ModelUtil.getComponentType((Part)activity), ActionUsage.class, (String)POSTEFFECT);
    }

    public List<EObject> getEffectMembers(ActionUsage effect) {
        return effect.getMembers();
    }

    public boolean isAssignment(EObject member) {
        return member instanceof Assignment;
    }

    public boolean isSetter(EObject member) {
        SendUsage sendUsage;
        return member instanceof SendUsage && (sendUsage = (SendUsage)member).getTransport().getReferencedElement().getName().startsWith("set_");
    }

    public Pair<NamedElement, Expression> getVariableAndValue(Assignment assignment) {
        return new Pair((Object)assignment.getElement().getReferencedElement(), (Object)assignment.getValue().getExpression());
    }

    public Pair<String, Expression> getVariableAndValue(SendUsage sendUsage) {
        return new Pair((Object)sendUsage.getTransport().getReferencedElement().getName().substring(4), (Object)sendUsage.getPayload());
    }

    public ConstraintUsage getInvariant(PartUsage activity) {
        return (ConstraintUsage)SysMLv2Util.getMemberByName((Container)ModelUtil.getComponentType((Part)activity), ConstraintUsage.class, (String)INVARIANT);
    }

    private Expression getExpression(Calculation calculation) {
        EObject eObject;
        if (calculation != null && (eObject = calculation.getResult()) instanceof Expression) {
            Expression expression = (Expression)eObject;
            return expression;
        }
        return null;
    }

    public Expression getLowerDuration(PartUsage activity) {
        CalculationUsage calculation = (CalculationUsage)SysMLv2Util.getMemberByName((Container)ModelUtil.getComponentType((Part)activity), CalculationUsage.class, (String)GET_LOWER_BOUND_DURATION);
        return this.getExpression((Calculation)calculation);
    }

    public Object getUpperDuration(PartUsage activity) {
        CalculationUsage calculation = (CalculationUsage)SysMLv2Util.getMemberByName((Container)ModelUtil.getComponentType((Part)activity), CalculationUsage.class, (String)GET_UPPER_BOUND_DURATION);
        return this.getExpression((Calculation)calculation);
    }

    public List<Pair<NamedElement, Expression>> getAssignments(ActionUsage action) {
        List assignments = EcoreUtil2.typeSelect((List)action.getMembers(), Assignment.class);
        ArrayList<Pair<NamedElement, Expression>> pairs = new ArrayList<Pair<NamedElement, Expression>>();
        assignments.forEach(assignment -> {
            Pair pair = new Pair((Object)assignment.getElement().getReferencedElement(), (Object)assignment.getValue().getExpression());
            pairs.add(pair);
        });
        return pairs;
    }

    public String serialize(Expression expression) {
        return NodeModelUtils.findActualNodeFor((EObject)expression).getText();
    }

    public String serializeSMVCompatible(Expression expression) {
        return SysMLv2ToSMVExpression.getLTLSMVInstanceWithoutEnumMapping().serialize(expression);
    }

    public List<Calculation> getUninterpretedFunctions(PartUsage component) {
        EList<Calculation> functions = SYSTEM_MODEL.getUninterpretedFunctions(component);
        this.getActivities(component).forEach(activity -> {
            boolean bl = functions.addAll(this.getUninterpretedFunctions((PartUsage)activity));
        });
        return functions;
    }

    public List<Calculation> getInterpretedFunctions(PartUsage component) {
        PartDefinition partDefinition = ModelUtil.getComponentType((Part)component);
        List<Calculation> functions = EcoreUtil2.getAllContentsOfType((EObject)partDefinition, ReferenceExpression.class).stream().map(ReferenceExpression::getReferencedElement).filter(Calculation.class::isInstance).map(Calculation.class::cast).filter(ModelUtil::isInterpretedFunction).collect(Collectors.toList());
        this.getActivities(component).forEach(activity -> {
            boolean bl = functions.addAll(this.getInterpretedFunctions((PartUsage)activity));
        });
        return functions;
    }

    public List<String> getUninterpretedFunctionInputNames(Object uninterpretedFunction) {
        return SYSTEM_MODEL.getUninterpretedFunctionInputs(uninterpretedFunction).map(this::getName).toList();
    }

    public List<Definition> getUninterpretedFunctionInputTypes(Calculation uninterpretedFunction) {
        return SYSTEM_MODEL.getUninterpretedFunctionInputs(uninterpretedFunction).map(ModelUtil::getUnboundedType).toList();
    }

    public List<String[]> getUninterpretedFunctionInputMultiplicities(Calculation uninterpretedFunction) {
        return SYSTEM_MODEL.getUninterpretedFunctionInputMultiplicities(uninterpretedFunction);
    }

    public Definition getUninterpretedFunctionOutputType(Calculation uninterpretedFunction) {
        return SYSTEM_MODEL.getUninterpretedFunctionOutputType(uninterpretedFunction);
    }

    public String[] getUninterpretedFunctionOutputMultiplicity(Calculation uninterpretedFunction) {
        return SYSTEM_MODEL.getUninterpretedFunctionOutputMultiplicity(uninterpretedFunction);
    }
}

