/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.api.core;

import com.google.common.base.Predicates;
import eu.fbk.eclipse.explodtwin.api.exception.NotAPartException;
import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.explodtwin.api.util.SysMLv2ToSMVExpression;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModelClass;
import eu.fbk.eclipse.standardtools.utils.core.utils.Pair;
import eu.fbk.sysmlv2.sysMLv2.ActionUsage;
import eu.fbk.sysmlv2.sysMLv2.AssertionAction;
import eu.fbk.sysmlv2.sysMLv2.Assignment;
import eu.fbk.sysmlv2.sysMLv2.Calculation;
import eu.fbk.sysmlv2.sysMLv2.Definition;
import eu.fbk.sysmlv2.sysMLv2.DirectedElement;
import eu.fbk.sysmlv2.sysMLv2.Direction;
import eu.fbk.sysmlv2.sysMLv2.Effect;
import eu.fbk.sysmlv2.sysMLv2.EntryAction;
import eu.fbk.sysmlv2.sysMLv2.EntryTransition;
import eu.fbk.sysmlv2.sysMLv2.EnumDefinition;
import eu.fbk.sysmlv2.sysMLv2.Expression;
import eu.fbk.sysmlv2.sysMLv2.Guard;
import eu.fbk.sysmlv2.sysMLv2.ItemDefinition;
import eu.fbk.sysmlv2.sysMLv2.NamedElement;
import eu.fbk.sysmlv2.sysMLv2.OperatorExpression;
import eu.fbk.sysmlv2.sysMLv2.Part;
import eu.fbk.sysmlv2.sysMLv2.PartDefinition;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.sysmlv2.sysMLv2.PerformActionReference;
import eu.fbk.sysmlv2.sysMLv2.PortUsage;
import eu.fbk.sysmlv2.sysMLv2.ReferenceExpression;
import eu.fbk.sysmlv2.sysMLv2.SendUsage;
import eu.fbk.sysmlv2.sysMLv2.StateUsage;
import eu.fbk.sysmlv2.sysMLv2.SysMLv2Factory;
import eu.fbk.sysmlv2.sysMLv2.TernaryOperatorExpression;
import eu.fbk.sysmlv2.sysMLv2.Transition;
import eu.fbk.sysmlv2.sysMLv2.TriggerAction;
import eu.fbk.sysmlv2.sysMLv2.TypedElement;
import eu.fbk.sysmlv2.sysMLv2.Usage;
import eu.fbk.sysmlv2.sysMLv2.Value;
import eu.fbk.sysmlv2.sysMLv2.impl.UsageImplCustom;
import eu.fbk.sysmlv2.util.SysMLv2Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;

public class SysMLv2StateMachineModel
extends AbstractStateMachineModelClass {
    private final Map<Pair<String, String>, Integer> disambiguationCounterMap = new HashMap<Pair<String, String>, Integer>();
    private final Map<Transition, String> transitionNamesMap = new HashMap<Transition, String>();

    public Set<StateUsage> getAllStateMachinesFromModel(Object model) {
        if (model instanceof XtextResource) {
            XtextResource xtextResource = (XtextResource)model;
            EList rootContents = xtextResource.getContents();
            if (rootContents.isEmpty()) {
                return null;
            }
            List stateUsageList = EcoreUtil2.getAllContentsOfType((EObject)((EObject)rootContents.get(0)), StateUsage.class);
            if (stateUsageList.isEmpty()) {
                return null;
            }
            return stateUsageList.stream().filter(SysMLv2Util::isStateMachine).filter(Predicate.not(ModelUtil::isNominalStateMachine)).collect(Collectors.toSet());
        }
        return null;
    }

    public String getStateMachineName(Object stateMachine) {
        if (stateMachine instanceof StateUsage) {
            StateUsage stateUsage = (StateUsage)stateMachine;
            return stateUsage.getName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Object getFirstNominalStateMachine(Object component) {
        void part;
        if (!(component instanceof Part)) {
            throw new NotAPartException(component.getClass());
        }
        Part part2 = (Part)component;
        return ModelUtil.getNominalStateMachinesOfComponent((Part)part).stream().findFirst().orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    public Object getStateMachineOwner(Object stateMachine) {
        void stateUsage;
        if (!(stateMachine instanceof StateUsage)) {
            throw new IllegalArgumentException("Argument is not a state machine.");
        }
        StateUsage stateUsage2 = (StateUsage)stateMachine;
        return EcoreUtil2.getContainerOfType((EObject)stateUsage, PartDefinition.class);
    }

    public String getStateMachineOwnerName(Object stateMachine) {
        String string;
        Object owner = this.getStateMachineOwner(stateMachine);
        if (owner instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)owner;
            string = namedElement.getName();
        } else {
            string = null;
        }
        return string;
    }

    public EList<String> getIntermediateStatesNameList(Object stateMachine) {
        if (stateMachine instanceof StateUsage) {
            StateUsage stateUsage = (StateUsage)stateMachine;
            return (EList)EcoreUtil2.typeSelect((List)stateUsage.getMembers(), StateUsage.class).stream().map(NamedElement::getName).collect(Collectors.toCollection(ECollections::newBasicEList));
        }
        return null;
    }

    public EList<String> getTransitionsNameList(Object stateMachine) {
        if (stateMachine instanceof StateUsage) {
            StateUsage stateUsage = (StateUsage)stateMachine;
            return (EList)this.getTransitions(stateUsage).stream().map(this::getTransitionName).collect(Collectors.toCollection(ECollections::newBasicEList));
        }
        throw new RuntimeException("Unexpected argument type");
    }

    public EList<Transition> getInitTransitions(Object stateMachine) {
        if (stateMachine instanceof StateUsage) {
            StateUsage stateUsage = (StateUsage)stateMachine;
            EList<Transition> transitions = this.getTransitions(stateUsage);
            transitions.removeIf(Predicate.not(EntryTransition.class::isInstance));
            if (transitions.isEmpty()) {
                throw new RuntimeException("No entry transitions in state machine " + stateUsage.getName());
            }
            return transitions;
        }
        throw new RuntimeException("Unexpected argument type");
    }

    public EList<Transition> getNonInitTransitions(Object stateMachine) {
        if (stateMachine instanceof StateUsage) {
            StateUsage stateUsage = (StateUsage)stateMachine;
            EList<Transition> transitions = this.getTransitions(stateUsage);
            transitions.removeIf(EntryTransition.class::isInstance);
            if (transitions.isEmpty()) {
                throw new RuntimeException("No transitions in state machine " + stateUsage.getName());
            }
            return transitions;
        }
        throw new RuntimeException("Unexpected argument type");
    }

    public EList<Transition> getTransitions(Object stateMachine) {
        if (stateMachine instanceof StateUsage) {
            StateUsage stateUsage = (StateUsage)stateMachine;
            return ECollections.toEList((Iterable)EcoreUtil2.typeSelect((List)stateUsage.getMembers(), Transition.class));
        }
        throw new RuntimeException("Unexpected argument type");
    }

    public EList<String> getInitTransitionsNameList(Object stateMachine) {
        return (EList)this.getInitTransitions(stateMachine).stream().map(this::getTransitionName).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public EList<String> getNonInitTransitionsNameList(Object stateMachine) {
        return (EList)this.getNonInitTransitions(stateMachine).stream().map(this::getTransitionName).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public EList<StateUsage> getNonInitStates(Object stateMachine) {
        if (stateMachine instanceof StateUsage) {
            StateUsage stateUsage = (StateUsage)stateMachine;
            EList states = ECollections.toEList((Iterable)EcoreUtil2.typeSelect((List)stateUsage.getMembers(), StateUsage.class));
            if (states.isEmpty()) {
                throw new RuntimeException("No states in state machine " + stateUsage.getName());
            }
            return states;
        }
        throw new RuntimeException("Unexpected argument type.");
    }

    public String getTransitionName(Object element) {
        if (element instanceof Transition) {
            Transition transition = (Transition)element;
            if (transition.getName() == null) {
                if (this.transitionNamesMap.get(transition) == null) {
                    String sourceStateName = transition.getSource().getName();
                    String destinationStateName = transition.getDestination().getName();
                    String name = "_" + sourceStateName + "_to_" + destinationStateName + "_";
                    String componentName = ((PartDefinition)EcoreUtil2.getContainerOfType((EObject)transition, PartDefinition.class)).getName();
                    Pair key = new Pair((Object)componentName, (Object)name);
                    Integer counter = this.disambiguationCounterMap.get(key);
                    if (counter == null) {
                        this.disambiguationCounterMap.put((Pair<String, String>)key, 0);
                    } else {
                        counter = counter + 1;
                        this.disambiguationCounterMap.put((Pair<String, String>)key, counter);
                        name = name + String.valueOf(counter) + "_";
                    }
                    this.transitionNamesMap.put(transition, name);
                    return name;
                }
                return this.transitionNamesMap.get(transition);
            }
            String originalName = transition.getName();
            if (originalName.startsWith("'")) {
                String unquotedName = originalName.substring(1, originalName.length() - 1);
                unquotedName.replace("\\s+", "_");
                return unquotedName;
            }
            return originalName;
        }
        return null;
    }

    public String getTransitionNextStateName(Object element) {
        if (element instanceof Transition) {
            Transition transition = (Transition)element;
            return transition.getDestination().getName();
        }
        return null;
    }

    public String getTransitionStartStateName(Object element) {
        if (element instanceof Transition) {
            Transition transition = (Transition)element;
            return transition.getSource().getName();
        }
        return null;
    }

    public String getTransitionGuardCondition(Object element, String language) {
        if (element instanceof Transition) {
            Transition transition = (Transition)element;
            StringBuilder serializedCondition = new StringBuilder();
            int i = 0;
            while (i < transition.getTriggers().size()) {
                TriggerAction trigger = (TriggerAction)transition.getTriggers().get(i);
                PortUsage portUsage = (PortUsage)trigger.getPort().getReferencedElement();
                Definition portDefinition = SysMLv2Util.getType((TypedElement)portUsage);
                Definition payload = SysMLv2Util.getType((TypedElement)trigger.getPayload());
                DirectedElement eventMember = EcoreUtil2.typeSelect((List)portDefinition.getMembers(), DirectedElement.class).stream().filter(member -> SysMLv2Util.isEvent((Usage)member) && SysMLv2Util.getType((TypedElement)member).getName().equals(payload.getName())).findAny().orElseThrow(() -> new RuntimeException("Port usage " + portUsage.getName() + " is typed by port definition " + portDefinition.getName() + ", that does not contain a member of type " + payload.getName()));
                DirectedElement flattenedPort = ModelUtil.flattenNestedMember(eventMember, portUsage);
                serializedCondition.append(flattenedPort.getName() + " == true");
                if (i != transition.getTriggers().size() - 1) {
                    if (flattenedPort.getName().startsWith("performed")) {
                        serializedCondition.append(" && (");
                    } else {
                        serializedCondition.append(" || ");
                    }
                } else {
                    serializedCondition.append(")");
                }
                ++i;
            }
            Guard guard = transition.getGuard();
            if (guard != null) {
                if (!serializedCondition.isEmpty()) {
                    serializedCondition.append(" && ");
                }
                serializedCondition.append(SysMLv2ToSMVExpression.getInstance(language).serialize(guard.getExpression()));
            }
            if (transition.isStutter()) {
                StateUsage stateMachine = (StateUsage)EcoreUtil2.getContainerOfType((EObject)transition, StateUsage.class);
                boolean isMission = stateMachine.getSubsetting() != null && ((ReferenceExpression)stateMachine.getSubsetting().getReferences().get(0)).getReferencedElement().getName().equals("missionStateMachines");
                String eventsGuard = this.getOwnerInputEvents(stateMachine).stream().map(NamedElement::getName).filter(name -> !isMission || !name.startsWith("startEvent")).collect(Collectors.joining(" || "));
                serializedCondition.append("!(").append(eventsGuard).append(")");
            }
            if (!serializedCondition.isEmpty()) {
                return serializedCondition.toString();
            }
        }
        return null;
    }

    private String translateActionElement(EObject element, String language) {
        StringBuilder text = new StringBuilder();
        if (element instanceof Assignment) {
            Assignment assignmentInAction = (Assignment)element;
            text.append(this.extractAssignment(assignmentInAction, language));
        } else if (element instanceof SendUsage) {
            SendUsage sendUsageInAction = (SendUsage)element;
            text.append(this.translateSendUsage(sendUsageInAction));
        } else if (element instanceof PerformActionReference) {
            PerformActionReference performInAction = (PerformActionReference)element;
            NamedElement performedAction = performInAction.getReference().getReferencedElement();
            if (performedAction instanceof ActionUsage) {
                ActionUsage actionUsage = (ActionUsage)performedAction;
                text.append(this.translateActionElement((EObject)actionUsage, language));
            }
        } else if (element instanceof ActionUsage) {
            ActionUsage actionUsage = (ActionUsage)element;
            actionUsage.getMembers().stream().filter(member -> member instanceof Assignment || member instanceof SendUsage || member instanceof PerformActionReference).forEach(member -> {
                StringBuilder stringBuilder2 = text.append(this.translateActionElement((EObject)member, language));
            });
        } else {
            throw new RuntimeException("Unexpected argument type.");
        }
        return text.toString();
    }

    private String translateEffect(Effect effect, String language) {
        return this.translateActionElement(effect.getAction(), language);
    }

    public String getTransitionEffectText(Object object, String language) {
        List destinationEntryActions;
        StateUsage destinationState;
        Object effect;
        if (object instanceof EntryTransition) {
            EntryTransition entryTransition = (EntryTransition)object;
            List entryActions = EcoreUtil2.getSiblingsOfType((EObject)entryTransition, EntryAction.class);
            effect = !entryActions.isEmpty() ? ((EntryAction)entryActions.get(0)).getEffect() : null;
            destinationState = entryTransition.getDestination();
        } else if (object instanceof Transition) {
            Transition transition = (Transition)object;
            effect = transition.getEffect();
            destinationState = transition.getDestination();
        } else {
            throw new IllegalArgumentException("Unexpected argument type.");
        }
        StringBuilder effectText = new StringBuilder();
        if (effect != null) {
            effectText.append(this.translateEffect((Effect)effect, language));
        }
        if (!(destinationEntryActions = EcoreUtil2.typeSelect((List)destinationState.getMembers(), EntryAction.class)).isEmpty()) {
            effectText.append(this.translateEffect(((EntryAction)destinationEntryActions.get(0)).getEffect(), language));
        }
        return effectText.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String translateSendUsage(SendUsage sendUsage) {
        void port;
        ReferenceExpression payloadAsReference;
        NamedElement namedElement;
        Expression expression = sendUsage.getPayload();
        if (expression instanceof ReferenceExpression && (namedElement = (payloadAsReference = (ReferenceExpression)expression).getReferencedElement()) instanceof ItemDefinition) {
            ItemDefinition payload = (ItemDefinition)namedElement;
            PortUsage portUsage = (PortUsage)sendUsage.getTransport().getReferencedElement();
            Definition portDefinition = SysMLv2Util.getType((TypedElement)portUsage);
            DirectedElement eventMemberToFlatten = SysMLv2Util.getEventMemberFromPort((PortUsage)portUsage);
            if (!SysMLv2Util.getType((TypedElement)eventMemberToFlatten).getName().equals(payload.getName())) {
                throw new RuntimeException("Port usage " + portUsage.getName() + " is typed by port definition " + portDefinition.getName() + ", that does not contain a member of type " + payload.getName());
            }
            DirectedElement flattenedPort = ModelUtil.flattenNestedMember(eventMemberToFlatten, portUsage);
            return flattenedPort.getName() + " = ! ( " + flattenedPort.getName() + " ) ;";
        }
        Expression expression2 = sendUsage.getPayload();
        SysMLv2ToSMVExpression serializer = SysMLv2ToSMVExpression.getInstance(SysMLv2ToSMVExpression.Language.CLEANC);
        NamedElement namedElement2 = sendUsage.getTransport().getReferencedElement();
        if (!(namedElement2 instanceof PortUsage)) {
            throw new RuntimeException("Invalid SendUsage sending " + serializer.serialize(expression2) + " in component " + ((PartDefinition)EcoreUtil2.getContainerOfType((EObject)sendUsage, PartDefinition.class)).getName() + ". The transport should be a PortUsage, instead it is " + String.valueOf(sendUsage.getTransport().getReferencedElement()));
        }
        PortUsage eventMemberToFlatten = (PortUsage)namedElement2;
        DirectedElement dataPort = SysMLv2Util.getDataMemberFromPort((PortUsage)port);
        DirectedElement flattenedDataPort = ModelUtil.flattenNestedMember(dataPort, (PortUsage)port);
        DirectedElement eventPort = SysMLv2Util.getEventMemberFromPort((PortUsage)port);
        DirectedElement flattenedEventPort = ModelUtil.flattenNestedMember(eventPort, (PortUsage)port);
        Assignment dataAssignment = SysMLv2Factory.eINSTANCE.createAssignment();
        ReferenceExpression elementReference = SysMLv2Factory.eINSTANCE.createReferenceExpression();
        elementReference.setReferencedElement((NamedElement)flattenedDataPort);
        dataAssignment.setElement(elementReference);
        Value value = SysMLv2Factory.eINSTANCE.createValue();
        value.setExpression((Expression)EcoreUtil.copy((EObject)expression2));
        dataAssignment.setValue(value);
        return this.extractAssignment(dataAssignment, "CleanC") + flattenedEventPort.getName() + " = ! ( " + flattenedEventPort.getName() + " ) ; ";
    }

    private String extractAssignment(Assignment assignment, String language) {
        Calculation calculation;
        ReferenceExpression reference;
        NamedElement namedElement;
        Expression expression = assignment.getValue().getExpression();
        if (expression instanceof ReferenceExpression && (namedElement = (reference = (ReferenceExpression)expression).getReferencedElement()) instanceof Calculation && (calculation = (Calculation)namedElement).isAbstract()) {
            return "";
        }
        SysMLv2ToSMVExpression serializer = SysMLv2ToSMVExpression.getInstance(language);
        String referenceUsageName = serializer.serialize((Expression)assignment.getElement());
        Expression expression2 = assignment.getValue().getExpression();
        if (expression2 instanceof TernaryOperatorExpression) {
            TernaryOperatorExpression ternaryOperatorExpression = (TernaryOperatorExpression)expression2;
            StringBuilder complexAssignment = new StringBuilder();
            Expression guardExpression = ternaryOperatorExpression.getGuard().getExpression();
            OperatorExpression trueExpression = ternaryOperatorExpression.getLeft();
            OperatorExpression falseExpression = ternaryOperatorExpression.getRight();
            complexAssignment.append("if (").append(serializer.serialize(guardExpression)).append(") {").append(referenceUsageName).append(" = ").append(serializer.serialize((Expression)trueExpression)).append(";").append("} else {").append(referenceUsageName).append(" = ").append(serializer.serialize((Expression)falseExpression)).append(";").append("}");
            return complexAssignment.toString();
        }
        String value = serializer.serialize(assignment.getValue().getExpression());
        return referenceUsageName + "=" + value + ";";
    }

    public String getStateInvariant(Object state, String language) {
        if (state instanceof StateUsage) {
            StateUsage stateUsage = (StateUsage)state;
            List assertions = EcoreUtil2.typeSelect((List)stateUsage.getMembers(), AssertionAction.class);
            return switch (assertions.size()) {
                case 0 -> null;
                case 1 -> this.assertionToString((AssertionAction)assertions.get(0), language);
                default -> throw new RuntimeException("Too many state invariants for state: " + stateUsage.getName());
            };
        }
        return null;
    }

    private String assertionToString(AssertionAction assertionAction, String language) {
        Expression expression = assertionAction.getConstraint() != null ? assertionAction.getConstraint().getExpression() : assertionAction.getInlineConstraint().getExpression();
        return SysMLv2ToSMVExpression.getInstance(language).serialize(expression);
    }

    /*
     * WARNING - void declaration
     */
    public Set<StateUsage> getNominalStateMachinesIncludingFromSubComponents(Object component) {
        void part;
        if (!(component instanceof Part)) {
            throw new NotAPartException(component.getClass());
        }
        Part part2 = (Part)component;
        Set<StateUsage> stateMachines = ModelUtil.getNominalStateMachinesOfComponent((Part)part);
        PartDefinition partDefinition = ModelUtil.getComponentType((Part)part);
        EcoreUtil2.typeSelect((List)partDefinition.getMembers(), PartUsage.class).forEach(subComponent -> {
            boolean bl = stateMachines.addAll(this.getNominalStateMachinesIncludingFromSubComponents(subComponent));
        });
        return stateMachines;
    }

    public boolean isInputPort(Object port) {
        return ModelUtil.isInputParameter(port);
    }

    public EList<DirectedElement> getOwnerNonStaticAttributesExceptPorts(Object stateMachine) {
        PartDefinition owner = (PartDefinition)this.getStateMachineOwner(stateMachine);
        EList<Usage> attributeUsages = ModelUtil.getAttributeUsagesInPart(owner);
        return (EList)EcoreUtil2.typeSelect(attributeUsages, DirectedElement.class).stream().filter(Predicate.not(Predicates.or((com.google.common.base.Predicate[])new com.google.common.base.Predicate[]{ModelUtil::isOfContractType, ModelUtil::isInterfaceAssertion, ModelUtil::isOfClockType, ModelUtil::isInvariant}))).filter(directedElement -> directedElement.getDirection().equals((Object)Direction.NONE)).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public EList<?> getOwnerStaticAttributesExceptPorts(Object stateMachine) {
        return ModelUtil.getDefines((Part)((PartDefinition)this.getStateMachineOwner(stateMachine)));
    }

    public EList<?> getOwnerStaticAttributes(Object stateMachine) {
        return ECollections.emptyEList();
    }

    public boolean isIdealClockType(Object type) {
        return ModelUtil.isClockType(type);
    }

    public EList<DirectedElement> getOwnerOutputPortsExceptEvents(Object stateMachine) {
        return this.getOwnerNonStaticPortsFiltering(stateMachine, ModelUtil::isOutputParameter, Predicate.not(SysMLv2Util::isEvent));
    }

    public EList<DirectedElement> getOwnerInputPortsExceptEvents(Object stateMachine) {
        return this.getOwnerNonStaticPortsFiltering(stateMachine, ModelUtil::isInputParameter, Predicate.not(SysMLv2Util::isEvent), Predicate.not(ModelUtil::isHavocGeneratedAttribute));
    }

    public EList<DirectedElement> getOwnerInputEvents(Object stateMachine) {
        return this.getOwnerNonStaticPortsFiltering(stateMachine, ModelUtil::isInputParameter, SysMLv2Util::isEvent);
    }

    public EList<DirectedElement> getOwnerOutputEvents(Object stateMachine) {
        return this.getOwnerNonStaticPortsFiltering(stateMachine, ModelUtil::isOutputParameter, SysMLv2Util::isEvent);
    }

    @SafeVarargs
    private EList<DirectedElement> getOwnerNonStaticPortsFiltering(Object stateMachineOrComponent, Predicate<? super DirectedElement> ... predicates) {
        PartDefinition owner = null;
        if (stateMachineOrComponent instanceof StateUsage) {
            StateUsage stateMachine = (StateUsage)stateMachineOrComponent;
            owner = (PartDefinition)this.getStateMachineOwner(stateMachine);
        } else if (stateMachineOrComponent instanceof PartDefinition) {
            PartDefinition partDefinition;
            owner = partDefinition = (PartDefinition)stateMachineOrComponent;
        }
        Stream<? super DirectedElement> portsStream = ModelUtil.getNonStaticPorts(owner).stream();
        Predicate<? super DirectedElement>[] predicateArray = predicates;
        int n = predicates.length;
        int n2 = 0;
        while (n2 < n) {
            Predicate<? super DirectedElement> predicate = predicateArray[n2];
            portsStream = portsStream.filter(predicate);
            ++n2;
        }
        return (EList)portsStream.collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public Object getAttributeType(Object property) {
        if (property instanceof Usage) {
            Usage usage = (Usage)property;
            return ModelUtil.getUnboundedType((TypedElement)usage);
        }
        return null;
    }

    public boolean isBooleanType(Object type) {
        return ModelUtil.isBooleanType(type);
    }

    public boolean isIntegerType(Object type) {
        return ModelUtil.isIntegerType(type);
    }

    public boolean isRealType(Object type) {
        return ModelUtil.isRealType(type);
    }

    public boolean isIntervalType(Object type) {
        return false;
    }

    public boolean isEnumType(Object type) {
        return ModelUtil.isEnumType(type);
    }

    public String getEnumTypeName(Object type) {
        return this.getAttributeName(type);
    }

    public EList<String> getEnumValues(Object enumType) {
        return ModelUtil.getEnumValues((EnumDefinition)enumType, true);
    }

    public String getAttributeName(Object property) {
        String string;
        if (property instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)property;
            string = namedElement.getName();
        } else {
            string = null;
        }
        return string;
    }

    public EList<StateUsage> getErrorStates(Object stateMachine) {
        if (stateMachine instanceof StateUsage) {
            StateUsage stateUsage = (StateUsage)stateMachine;
            return (EList)EcoreUtil2.typeSelect((List)stateUsage.getMembers(), StateUsage.class).stream().filter(ModelUtil::isErrorState).collect(Collectors.toCollection(ECollections::newBasicEList));
        }
        return ECollections.emptyEList();
    }

    /*
     * WARNING - void declaration
     */
    public EList<StateUsage> getFaultyStateMachines(Object component) {
        void part;
        if (!(component instanceof Part)) {
            throw new NotAPartException(component.getClass());
        }
        Part part2 = (Part)component;
        PartDefinition partDefinition = ModelUtil.getComponentType((Part)part);
        return (EList)EcoreUtil2.typeSelect((List)partDefinition.getMembers(), StateUsage.class).stream().filter(Predicate.not(ModelUtil::isNominalStateMachine)).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public String getErrorStateProbability(Object stateMachine) {
        Usage probabilityUsage;
        StateUsage stateUsage;
        if (stateMachine instanceof StateUsage && ModelUtil.isErrorState(stateUsage = (StateUsage)stateMachine) && (probabilityUsage = (Usage)EcoreUtil2.typeSelect((List)stateUsage.getMembers(), UsageImplCustom.class).stream().filter(usage -> "probability".equals(usage.getRedefinitionName())).findFirst().orElse(null)) != null && probabilityUsage.getValue() != null) {
            return SysMLv2ToSMVExpression.getInstance(SysMLv2ToSMVExpression.Language.LTL).serialize(probabilityUsage.getValue().getExpression());
        }
        return null;
    }

    public EList<Transition> getIncomingFaultTransitions(Object errorState) {
        StateUsage stateUsage;
        if (errorState instanceof StateUsage && ModelUtil.isErrorState(stateUsage = (StateUsage)errorState)) {
            StateUsage stateMachine = (StateUsage)EcoreUtil2.getContainerOfType((EObject)stateUsage.eContainer(), StateUsage.class);
            return (EList)this.getTransitions(stateMachine).stream().filter(transition -> EcoreUtil.equals((EObject)transition.getDestination(), (EObject)stateUsage)).collect(Collectors.toCollection(ECollections::newBasicEList));
        }
        return ECollections.emptyEList();
    }

    public String getFailureModeType(Object errorState) {
        StateUsage stateUsage;
        if (errorState instanceof StateUsage && (stateUsage = (StateUsage)errorState).getTyping() != null) {
            return SysMLv2Util.getType((TypedElement)stateUsage).getName();
        }
        return null;
    }

    public Object getFailureModeAttribute(Object errorState) {
        Expression expression;
        Usage probabilityUsage;
        StateUsage stateUsage;
        if (errorState instanceof StateUsage && ModelUtil.isErrorState(stateUsage = (StateUsage)errorState) && (probabilityUsage = (Usage)EcoreUtil2.typeSelect((List)stateUsage.getMembers(), UsageImplCustom.class).stream().filter(usage -> "property".equals(usage.getRedefinitionName())).findFirst().orElse(null)) != null && probabilityUsage.getValue() != null && (expression = probabilityUsage.getValue().getExpression()) instanceof ReferenceExpression) {
            ReferenceExpression reference = (ReferenceExpression)expression;
            return reference.getReferencedElement();
        }
        return null;
    }

    public EList<String> getFailureModeFields(Object errorState) {
        StateUsage stateUsage;
        if (errorState instanceof StateUsage && ModelUtil.isErrorState(stateUsage = (StateUsage)errorState)) {
            return (EList)EcoreUtil2.typeSelect((List)stateUsage.getMembers(), UsageImplCustom.class).stream().filter(usage -> !"probability".equals(usage.getRedefinitionName()) && !"probability".equals(usage.getRedefinitionName())).map(NamedElement::getName).collect(Collectors.toCollection(ECollections::newBasicEList));
        }
        return ECollections.emptyEList();
    }

    public String getFailureModeValue(Object errorState, String field) {
        Usage fieldUsage;
        StateUsage stateUsage;
        if (errorState instanceof StateUsage && ModelUtil.isErrorState(stateUsage = (StateUsage)errorState) && (fieldUsage = (Usage)EcoreUtil2.typeSelect((List)stateUsage.getMembers(), UsageImplCustom.class).stream().filter(usage -> field.equals(usage.getRedefinitionName())).findFirst().orElse(null)) != null && fieldUsage.getValue() != null) {
            return SysMLv2ToSMVExpression.getInstance(SysMLv2ToSMVExpression.Language.LTL).serialize(fieldUsage.getValue().getExpression());
        }
        return null;
    }

    public EList<?> getOwnerDanglingInputPorts(Object stateMachine) {
        return this.getOwnerNonStaticPortsFiltering(stateMachine, ModelUtil::isInputParameter, ModelUtil::isHavocGeneratedAttribute);
    }
}

