/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.api.core;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.graph.Traverser;
import eu.fbk.eclipse.explodtwin.api.exception.NotAPartException;
import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.explodtwin.api.util.SysMLv2ToSMVExpression;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModelClass;
import eu.fbk.eclipse.standardtools.utils.core.utils.Pair;
import eu.fbk.sysmlv2.sysMLv2.AssertionAction;
import eu.fbk.sysmlv2.sysMLv2.AttributeUsage;
import eu.fbk.sysmlv2.sysMLv2.Binding;
import eu.fbk.sysmlv2.sysMLv2.BoundedExpression;
import eu.fbk.sysmlv2.sysMLv2.Calculation;
import eu.fbk.sysmlv2.sysMLv2.ConnectionElement;
import eu.fbk.sysmlv2.sysMLv2.ConnectionUsage;
import eu.fbk.sysmlv2.sysMLv2.ConstraintUsage;
import eu.fbk.sysmlv2.sysMLv2.Container;
import eu.fbk.sysmlv2.sysMLv2.Definition;
import eu.fbk.sysmlv2.sysMLv2.DirectedElement;
import eu.fbk.sysmlv2.sysMLv2.Direction;
import eu.fbk.sysmlv2.sysMLv2.EnumDefinition;
import eu.fbk.sysmlv2.sysMLv2.Expression;
import eu.fbk.sysmlv2.sysMLv2.Feature;
import eu.fbk.sysmlv2.sysMLv2.ListExpression;
import eu.fbk.sysmlv2.sysMLv2.Model;
import eu.fbk.sysmlv2.sysMLv2.Multiplicity;
import eu.fbk.sysmlv2.sysMLv2.NamedElement;
import eu.fbk.sysmlv2.sysMLv2.Part;
import eu.fbk.sysmlv2.sysMLv2.PartDefinition;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.sysmlv2.sysMLv2.PortUsage;
import eu.fbk.sysmlv2.sysMLv2.ReferenceExpression;
import eu.fbk.sysmlv2.sysMLv2.ReturnStatement;
import eu.fbk.sysmlv2.sysMLv2.TypedElement;
import eu.fbk.sysmlv2.sysMLv2.Usage;
import eu.fbk.sysmlv2.sysMLv2.UsageChainExpression;
import eu.fbk.sysmlv2.sysMLv2.UsageExpression;
import eu.fbk.sysmlv2.sysMLv2.UsageReferenceExpression;
import eu.fbk.sysmlv2.sysMLv2.Value;
import eu.fbk.sysmlv2.util.SysMLv2Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;

public class SysMLv2SystemModel
extends AbstractSystemModelClass {
    private final Map<String, Calculation> defineTransformationMap = new HashMap<String, Calculation>();
    private final Map<ReferenceExpression, Pair<Calculation, List<Expression>>> referenceMap = new HashMap<ReferenceExpression, Pair<Calculation, List<Expression>>>();

    public Object getNearestOwnerComponent(Object element) {
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            return EcoreUtil2.getContainerOfType((EObject)eObject, PartDefinition.class);
        }
        return null;
    }

    public EList<String> getEnumValuesFromAttributes(Object component) {
        return (EList)ModelUtil.getAttributeUsagesInPart(component).stream().map(usage -> EcoreUtil2.typeSelect((List)SysMLv2Util.getAllTypes((TypedElement)usage), EnumDefinition.class).stream().findFirst().orElse(null)).filter(Objects::nonNull).mapMulti((enumDef, consumer) -> ModelUtil.getEnumValues(enumDef, true).forEach(consumer::accept)).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public String[] getValuesForEnumeratorType(Object object) {
        if (object instanceof EnumDefinition) {
            EnumDefinition enumDefinition = (EnumDefinition)object;
            return (String[])ModelUtil.getEnumValues(enumDefinition, true).toArray(String[]::new);
        }
        return null;
    }

    public String getComponentTypeName(Object component) {
        return this.getName(this.getComponentType(component));
    }

    public String getComponentInstanceName(Object component) {
        if (component instanceof PartUsage) {
            PartUsage partUsage = (PartUsage)component;
            return this.getName(partUsage);
        }
        throw new RuntimeException("Unexpected argument type");
    }

    /*
     * WARNING - void declaration
     */
    public Object getComponentType(Object component) {
        void part;
        if (!(component instanceof Part)) {
            throw new NotAPartException(component.getClass());
        }
        Part part2 = (Part)component;
        return ModelUtil.getComponentType((Part)part);
    }

    public String getComponentInstanceTypeName(Object component) {
        return this.getComponentTypeName(component);
    }

    public String[] getSubComponentsName(Object component) {
        return (String[])this.getSubComponentsInstances(component).stream().map(this::getName).distinct().toArray(String[]::new);
    }

    public Object getSubComponent(Object component, String subCompName) {
        if (component instanceof Container) {
            Container container = (Container)component;
            return SysMLv2Util.getMemberByName((Container)container, PartUsage.class, (String)subCompName);
        }
        return null;
    }

    public String getComponentName(Object component) {
        return this.getName(component);
    }

    /*
     * WARNING - void declaration
     */
    public EList<PartUsage> getSubComponentsInstances(Object component) {
        void part;
        if (!(component instanceof Part)) {
            throw new NotAPartException(component.getClass());
        }
        Part part2 = (Part)component;
        PartDefinition partDefinition = ModelUtil.getComponentType((Part)part);
        List instances = EcoreUtil2.typeSelect((List)partDefinition.getMembers(), PartUsage.class);
        instances.removeIf(ModelUtil::isActivity);
        return ECollections.toEList((Iterable)instances);
    }

    private List<String> getInvariantsForBoundedAttributes(Object component, String language) {
        ArrayList<String> invariants = new ArrayList<String>();
        String and = SysMLv2ToSMVExpression.Language.fromString(language) == SysMLv2ToSMVExpression.Language.CLEANC ? " && " : " & ";
        ModelUtil.getAttributeUsagesInPart(component).stream().filter(attribute -> ModelUtil.isIntervalType(SysMLv2Util.getType((TypedElement)attribute))).forEach(attribute -> {
            String name = attribute.getName();
            String minValue = ModelUtil.getBoundValue((Container)attribute, ModelUtil.Bound.MIN);
            String maxValue = ModelUtil.getBoundValue((Container)attribute, ModelUtil.Bound.MAX);
            String lowerBound = name + " >= " + minValue;
            String upperBound = name + " <= " + maxValue;
            invariants.add(lowerBound + and + upperBound);
        });
        return invariants;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getExplicitInvariants(Object component, String language) {
        void part;
        if (!(component instanceof Part)) {
            throw new NotAPartException(component.getClass());
        }
        Part part2 = (Part)component;
        PartDefinition definition = ModelUtil.getComponentType((Part)part);
        return EcoreUtil2.typeSelect((List)definition.getMembers(), AttributeUsage.class).stream().filter(ModelUtil::isInvariant).map(attribute -> (ConstraintUsage)EcoreUtil2.typeSelect((List)attribute.getMembers(), ConstraintUsage.class).get(0)).map(assertion -> assertion.getValue().getExpression()).map(expression -> SysMLv2ToSMVExpression.getInstance(language).serialize((Expression)expression)).toList();
    }

    public String[] getComponentInvariants(Object component, String language) {
        List<String> invariants = this.getInvariantsForBoundedAttributes(component, language);
        invariants.addAll(this.getExplicitInvariants(component, language));
        return (String[])invariants.toArray(String[]::new);
    }

    public EList<DirectedElement> getNonStaticInputPorts(Object component) {
        return (EList)this.getNonStaticPorts(component).stream().filter(ModelUtil::isInputParameter).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public EList<DirectedElement> getNonStaticOutputPorts(Object component) {
        return (EList)this.getNonStaticPorts(component).stream().filter(ModelUtil::isOutputParameter).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public EList<DirectedElement> getNonStaticGenericPorts(Object component) {
        return (EList)this.getNonStaticPorts(component).stream().filter(ModelUtil::isBidirectionalParameter).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    /*
     * WARNING - void declaration
     */
    public EList<DirectedElement> getNonStaticPorts(Object component) {
        void part;
        if (!(component instanceof Part)) {
            throw new NotAPartException(component.getClass());
        }
        Part part2 = (Part)component;
        EList<DirectedElement> ports = ModelUtil.getNonStaticPorts((Part)part);
        ports.removeIf(port -> port.getName().endsWith("_done_input"));
        return ports;
    }

    public EList<DirectedElement> getStaticPorts(Object component) {
        return ECollections.emptyEList();
    }

    public String getName(Object object) {
        NamedElement namedElement;
        String name = null;
        if (object instanceof Model) {
            name = "Model";
        } else if (object instanceof NamedElement && (name = (namedElement = (NamedElement)object).getName()) != null) {
            name = name.replace("~", "Conjugate");
        }
        return name;
    }

    public String getPortName(Object port) {
        return this.getName(port);
    }

    public Object getPortType(Object port) {
        if (port instanceof Usage) {
            Usage usage = (Usage)port;
            return ModelUtil.getUnboundedType((TypedElement)usage);
        }
        return null;
    }

    public boolean isBooleanType(Object type) {
        return ModelUtil.isBooleanType(type);
    }

    public boolean isIntType(Object type) {
        return ModelUtil.isIntegerType(type);
    }

    public boolean isIdealClockType(Object type) {
        return ModelUtil.isClockType(type);
    }

    public boolean isRealType(Object type) {
        return ModelUtil.isRealType(type);
    }

    public boolean isEnumType(Object type) {
        return ModelUtil.isEnumType(type);
    }

    public boolean isEventType(Object type) {
        Definition definition;
        return type instanceof Definition && SysMLv2Util.isEventDefinition((Definition)(definition = (Definition)type));
    }

    public boolean isRangeType(Object object) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public EList<ConnectionElement> getConnectionsPorts(Object component) {
        void part;
        if (!(component instanceof Part)) {
            throw new NotAPartException(component.getClass());
        }
        Part part2 = (Part)component;
        PartDefinition partDefinition = ModelUtil.getComponentType((Part)part);
        return (EList)EcoreUtil2.typeSelect((List)partDefinition.getMembers(), ConnectionElement.class).stream().filter(connection -> Stream.of(connection.getSource(), connection.getTarget()).map(this::getConnectorEndOwner).filter(Part.class::isInstance).map(Part.class::cast).noneMatch(ModelUtil::isActivity)).mapMulti((connection, acceptor) -> {
            ReferenceExpression reference;
            Expression expression = connection.getSource();
            if (expression instanceof ReferenceExpression && (reference = (ReferenceExpression)expression).getReferencedElement() instanceof PortUsage) {
                ModelUtil.generateConnectionsForFlattenedPort(connection).forEach(acceptor::accept);
            } else {
                acceptor.accept(connection);
            }
        }).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public String getConnectorEndName(Object connectorEnd) {
        if (connectorEnd instanceof ReferenceExpression) {
            ReferenceExpression reference = (ReferenceExpression)connectorEnd;
            return this.getName(reference.getReferencedElement());
        }
        if (connectorEnd instanceof Expression) {
            Expression expression = (Expression)connectorEnd;
            return SysMLv2ToSMVExpression.getInstance(SysMLv2ToSMVExpression.Language.LTL).serialize(expression);
        }
        throw new RuntimeException("Unexpected argument type");
    }

    public Object getConnectorEndOwner(Object connectorEnd) {
        return ModelUtil.getConnectorEndOwner(connectorEnd);
    }

    private ReferenceExpression getBindingEnd(Binding binding, ConnectorEnd end) {
        ReferenceExpression sourceReference = (ReferenceExpression)binding.getSource();
        ReferenceExpression targetReference = binding.getTarget();
        NamedElement source = sourceReference.getReferencedElement();
        NamedElement target = targetReference.getReferencedElement();
        Direction direction = ((DirectedElement)source).getDirection();
        PartDefinition sourceOwner = (PartDefinition)EcoreUtil2.getContainerOfType((EObject)source, PartDefinition.class);
        PartDefinition targetOwner = (PartDefinition)EcoreUtil2.getContainerOfType((EObject)target, PartDefinition.class);
        ModelUtil.ComponentsRelationship relationship = ModelUtil.compareComponents(sourceOwner, targetOwner);
        return switch (end) {
            case ConnectorEnd.SOURCE -> {
                switch (relationship) {
                    case FIRST_CONTAINS_SECOND: {
                        if (direction == Direction.IN) {
                            yield sourceReference;
                        }
                        yield targetReference;
                    }
                    case SECOND_CONTAINS_FIRST: {
                        if (direction == Direction.OUT) {
                            yield sourceReference;
                        }
                        yield targetReference;
                    }
                    case SAME: {
                        yield null;
                    }
                }
                throw new IncompatibleClassChangeError();
            }
            case ConnectorEnd.TARGET -> {
                switch (relationship) {
                    case FIRST_CONTAINS_SECOND: {
                        if (direction == Direction.OUT) {
                            yield sourceReference;
                        }
                        yield targetReference;
                    }
                    case SECOND_CONTAINS_FIRST: {
                        if (direction == Direction.IN) {
                            yield sourceReference;
                        }
                        yield targetReference;
                    }
                    case SAME: {
                        yield null;
                    }
                }
                throw new IncompatibleClassChangeError();
            }
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Object getConnectorSource(Object object) {
        if (object instanceof ConnectionUsage) {
            ConnectionUsage connection = (ConnectionUsage)object;
            return connection.getSource();
        }
        if (object instanceof Binding) {
            Binding binding = (Binding)object;
            return this.getBindingEnd(binding, ConnectorEnd.SOURCE);
        }
        throw new IllegalArgumentException("Unexpected argument type");
    }

    public Object getConnectorTarget(Object object) {
        if (object instanceof ConnectionUsage) {
            ConnectionUsage connection = (ConnectionUsage)object;
            return connection.getTarget();
        }
        if (object instanceof Binding) {
            Binding binding = (Binding)object;
            return this.getBindingEnd(binding, ConnectorEnd.TARGET);
        }
        throw new IllegalArgumentException("Unexpected argument type");
    }

    public EList<String> getAttributesNames(Object component) {
        return (EList)ModelUtil.getAttributeUsagesInPart(component).stream().map(this::getName).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public Object getAttributeType(Object property) {
        Definition definition;
        if (property instanceof Usage) {
            Usage usage = (Usage)property;
            definition = ModelUtil.getUnboundedType((TypedElement)usage);
        } else {
            definition = null;
        }
        return definition;
    }

    public EList<PartDefinition> getComponents(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            return (EList)ModelUtil.getAllContentsOfTypeFromModel(EcoreUtil2.getResourceSet((Notifier)eObject), PartUsage.class).stream().map(ModelUtil::getComponentType).filter(Predicate.not(ModelUtil::isActivity)).distinct().collect(Collectors.toCollection(ECollections::newBasicEList));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public EList<Feature> getFormulaConstraints(Object component) {
        void part;
        if (!(component instanceof Part)) {
            throw new NotAPartException(component.getClass());
        }
        Part part2 = (Part)component;
        PartDefinition partDefinition = ModelUtil.getComponentType((Part)part);
        return (EList)EcoreUtil2.typeSelect((List)partDefinition.getMembers(), Feature.class).stream().filter(Predicate.not(ModelUtil::isOfContractType)).filter(feature -> feature.getValue() != null && feature.getRedefinition() != null).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public String getFormulaConstraintText(Object constraint) {
        if (constraint instanceof Feature) {
            Feature feature = (Feature)constraint;
            StringBuilder buffer = new StringBuilder();
            String featureName = feature.getName();
            Value featureValue = feature.getValue();
            String value = SysMLv2ToSMVExpression.getInstance(SysMLv2ToSMVExpression.Language.LTL).serialize(featureValue.getExpression());
            buffer.append(featureName).append(":=").append(value);
            return buffer.toString();
        }
        throw new RuntimeException("Unexpected argument type");
    }

    public EList<Usage> getContractsOfComponent(Object component) {
        if (component instanceof PartUsage) {
            PartUsage partUsage = (PartUsage)component;
            return ModelUtil.getContractUsages(ModelUtil.getPartDefinition(partUsage));
        }
        if (component instanceof PartDefinition) {
            PartDefinition partDefinition = (PartDefinition)component;
            return ModelUtil.getContractUsages(partDefinition);
        }
        throw new RuntimeException("Unexpected argument type");
    }

    /*
     * WARNING - void declaration
     */
    public String getContractDefinitionsText(Object component) {
        void part;
        if (!(component instanceof Part)) {
            throw new NotAPartException(component.getClass());
        }
        Part part2 = (Part)component;
        PartDefinition partDefinition = ModelUtil.getComponentType((Part)part);
        EList<Usage> contracts = ModelUtil.getContractUsages(partDefinition);
        StringBuilder buffer = new StringBuilder();
        contracts.forEach(contract -> {
            StringBuilder stringBuilder2 = buffer.append(this.convertContractToString((Usage)contract));
        });
        return buffer.toString();
    }

    private String convertContractToString(Usage contract) {
        String name = contract.getName();
        String assume = this.getFormalPropertyStrFromSysMLContract(contract, ConstraintType.ASSUMPTION);
        String guarantee = this.getFormalPropertyStrFromSysMLContract(contract, ConstraintType.GUARANTEE);
        String contractBody = "CONTRACT " + name + " assume : " + assume + " ; guarantee : " + guarantee + " ;";
        return contractBody;
    }

    private String getFormalPropertyStrFromSysMLContract(Usage contract, ConstraintType constraintType) {
        return EcoreUtil2.typeSelect((List)contract.getMembers(), AssertionAction.class).stream().map(assertion -> assertion.getInlineConstraint() != null ? assertion.getInlineConstraint() : assertion.getConstraint()).filter(constraintUsage -> constraintType.toString().equals(this.getName(constraintUsage))).map(this::getConstraintAsText).findFirst().orElse(null);
    }

    private String getConstraintAsText(ConstraintUsage constraint) {
        Expression expression = constraint.getExpression();
        if (expression != null) {
            return SysMLv2ToSMVExpression.getInstance(SysMLv2ToSMVExpression.Language.LTL).serialize(expression);
        }
        return "true";
    }

    /*
     * WARNING - void declaration
     */
    public Object getContract(Object component, String contractName) {
        void part;
        if (!(component instanceof Part)) {
            throw new NotAPartException(component.getClass());
        }
        Part part2 = (Part)component;
        PartDefinition definition = ModelUtil.getComponentType((Part)part);
        return ModelUtil.getContractUsages(definition).stream().filter(usage -> contractName.equals(this.getName(usage))).findFirst().orElse(null);
    }

    public EList<Expression> getContractRefinements(Object contract) {
        if (contract instanceof Usage) {
            Usage usage = (Usage)contract;
            Feature refinement = EcoreUtil2.typeSelect((List)usage.getMembers(), Feature.class).stream().filter(feature -> "refinedBy".equals(this.getName(feature))).findFirst().orElse(null);
            if (refinement == null) {
                return ECollections.emptyEList();
            }
            Expression valueExpression = refinement.getValue().getExpression();
            if (valueExpression instanceof ListExpression) {
                ListExpression listExpression = (ListExpression)valueExpression;
                return listExpression.getExpressions();
            }
            if (valueExpression instanceof BoundedExpression) {
                BoundedExpression boundedExpression = (BoundedExpression)valueExpression;
                return ECollections.asEList((Object[])new Expression[]{boundedExpression.getExpression()});
            }
        }
        return null;
    }

    public EList<Usage> getComponentInstancesOfContractRefinement(Object contractRefinement) {
        BasicEList refinements = ECollections.newBasicEList();
        if (contractRefinement instanceof UsageChainExpression) {
            UsageChainExpression usageChainExpression = (UsageChainExpression)contractRefinement;
            UsageExpression body = usageChainExpression.getBody();
            if (body instanceof UsageReferenceExpression) {
                UsageReferenceExpression usageReferenceExpression = (UsageReferenceExpression)body;
                refinements.add((Object)((Usage)usageReferenceExpression.getReferencedElement()));
            } else if (body instanceof UsageChainExpression) {
                UsageChainExpression usageChainExpression2 = (UsageChainExpression)body;
                refinements.addAll(this.extractAllUsages(usageChainExpression2));
            }
        }
        return refinements;
    }

    private List<Usage> extractAllUsages(UsageChainExpression usageChainExpression) {
        UsageExpression usageExpression;
        ArrayList<Usage> list = new ArrayList<Usage>();
        while ((usageExpression = usageChainExpression.getBody()) instanceof UsageChainExpression) {
            UsageChainExpression bodyChain = (UsageChainExpression)usageExpression;
            list.add((Usage)usageChainExpression.getReferencedElement());
            usageChainExpression = bodyChain;
        }
        list.add((Usage)usageChainExpression.getReferencedElement());
        list.add((Usage)usageChainExpression.getBody().getReferencedElement());
        return list;
    }

    public Object getContractInstanceOfContractRefinement(Object contractRefinement) {
        if (contractRefinement instanceof UsageChainExpression) {
            UsageChainExpression usageChainExpression = (UsageChainExpression)contractRefinement;
            return usageChainExpression.getReferencedElement();
        }
        return null;
    }

    public String getContractInstanceName(Object contractInstance) {
        return this.getName(contractInstance);
    }

    public boolean isAsyncComponent(Object component) {
        return this.getSubComponentsInstances(component).stream().anyMatch(ModelUtil::isAsyncPartUsage);
    }

    /*
     * WARNING - void declaration
     */
    public EList<Calculation> getUninterpretedFunctions(Object component) {
        void part;
        if (!(component instanceof Part)) {
            throw new NotAPartException(component.getClass());
        }
        Part part2 = (Part)component;
        PartDefinition partDefinition = ModelUtil.getComponentType((Part)part);
        return (EList)EcoreUtil2.getAllContentsOfType((EObject)partDefinition, ReferenceExpression.class).stream().map(ReferenceExpression::getReferencedElement).filter(Calculation.class::isInstance).map(Calculation.class::cast).filter(ModelUtil::isUninterpretedFunction).distinct().collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public String getUninterpretedFunctionName(Object uninterpretedFunction) {
        if (uninterpretedFunction instanceof Calculation) {
            Calculation calculation = (Calculation)uninterpretedFunction;
            return this.getName(calculation);
        }
        throw new RuntimeException("Unexpected argument type");
    }

    public Feature getUninterpretedFunctionReturnedFeature(Object uninterpretedFunction) {
        Calculation calculation;
        EObject result;
        if (uninterpretedFunction instanceof Calculation && (result = (calculation = (Calculation)uninterpretedFunction).getResult()) instanceof ReturnStatement) {
            ReturnStatement returnStatement = (ReturnStatement)result;
            return returnStatement.getFeature();
        }
        throw new RuntimeException("Unexpected argument type");
    }

    public Definition getUninterpretedFunctionOutputType(Object uninterpretedFunction) {
        Feature feature = this.getUninterpretedFunctionReturnedFeature(uninterpretedFunction);
        return SysMLv2Util.getType((TypedElement)feature);
    }

    public Stream<DirectedElement> getUninterpretedFunctionInputs(Object uninterpretedFunction) {
        if (uninterpretedFunction instanceof Calculation) {
            Calculation calculation = (Calculation)uninterpretedFunction;
            return EcoreUtil2.typeSelect((List)calculation.getMembers(), DirectedElement.class).stream().filter(Predicates.and(ModelUtil::isInputParameter, directedElement -> directedElement.getTyping() != null));
        }
        throw new RuntimeException("Unexpected argument type");
    }

    public EList<Definition> getUninterpretedFunctionInputTypes(Object uninterpretedFunction) {
        return (EList)this.getUninterpretedFunctionInputs(uninterpretedFunction).map(input -> {
            Definition type = ModelUtil.getUnboundedType((TypedElement)input);
            return type instanceof EnumDefinition ? ModelUtil.INTEGER_DEFINITION : type;
        }).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    private String[] multiplicityAsStringArray(Multiplicity multiplicity) {
        if (multiplicity == null) {
            return new String[]{"1", "1"};
        }
        Integer lowerBound = multiplicity.getLowerBound();
        Integer upperBound = multiplicity.getUpperBound();
        return new String[]{lowerBound.toString(), upperBound != null ? upperBound.toString() : lowerBound.toString()};
    }

    public String[] getUninterpretedFunctionOutputMultiplicity(Object uninterpretedFunction) {
        Feature feature = this.getUninterpretedFunctionReturnedFeature(uninterpretedFunction);
        Multiplicity multiplicity = feature.getMultiplicity();
        return this.multiplicityAsStringArray(multiplicity);
    }

    public EList<String[]> getUninterpretedFunctionInputMultiplicities(Object uninterpretedFunction) {
        return (EList)this.getUninterpretedFunctionInputs(uninterpretedFunction).map(Usage::getMultiplicity).map(this::multiplicityAsStringArray).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public String[] getPortMultiplicityBoundaries(Object port) {
        if (port instanceof Usage) {
            Usage usage = (Usage)port;
            return this.multiplicityAsStringArray(usage.getMultiplicity());
        }
        return null;
    }

    public boolean isInputPort(Object port) {
        return ModelUtil.isInputParameter(port);
    }

    public boolean isOutputPort(Object port) {
        return ModelUtil.isOutputParameter(port);
    }

    public boolean isInOutPort(Object port) {
        return ModelUtil.isBidirectionalParameter(port);
    }

    /*
     * WARNING - void declaration
     */
    public EList<?> getInterfaceAssertions(Object component) {
        void part;
        if (!(component instanceof Part)) {
            throw new NotAPartException(component.getClass());
        }
        Part part2 = (Part)component;
        PartDefinition partDefinition = ModelUtil.getComponentType((Part)part);
        return (EList)EcoreUtil2.typeSelect((List)partDefinition.getMembers(), AttributeUsage.class).stream().filter(this::isInterfaceAssertion).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public boolean isInterfaceAssertion(Object object) {
        return ModelUtil.isInterfaceAssertion(object);
    }

    public String getInterfaceAssertionName(Object interfaceAssertion) {
        if (interfaceAssertion instanceof AttributeUsage) {
            AttributeUsage attributeUsage = (AttributeUsage)interfaceAssertion;
            return this.getName(attributeUsage);
        }
        throw new RuntimeException("Invalid interface assertion, AttributeUsage expected");
    }

    public String getInterfaceAssertionBody(Object interfaceAssertion, String language) {
        if (interfaceAssertion instanceof AttributeUsage) {
            AttributeUsage attributeUsage = (AttributeUsage)interfaceAssertion;
            Usage formula = EcoreUtil2.typeSelect((List)attributeUsage.getMembers(), Usage.class).stream().filter(member -> "formula".equals(this.getName(member))).findAny().orElseThrow(() -> new RuntimeException("No constraint found in interface assertion"));
            return SysMLv2ToSMVExpression.getInstance(language).serialize(formula.getValue().getExpression());
        }
        throw new RuntimeException("Invalid interface assertion, AttributeUsage expected");
    }

    public String getDefineName(Object define) {
        if (define instanceof Calculation || define instanceof ConstraintUsage) {
            return ((NamedElement)define).getName();
        }
        throw new IllegalArgumentException("Unexpected argument type");
    }

    public String getDefineBody(Object define, String language) {
        Expression expression = null;
        if (define instanceof Calculation) {
            Calculation calculation = (Calculation)define;
            EObject result = calculation.getResult();
            if (result instanceof Expression) {
                Expression resultExpression;
                expression = resultExpression = (Expression)result;
            }
        } else if (define instanceof ConstraintUsage) {
            ConstraintUsage constraintUsage = (ConstraintUsage)define;
            expression = constraintUsage.getExpression();
        }
        if (expression != null) {
            return SysMLv2ToSMVExpression.getInstance(language).serialize(expression);
        }
        throw new IllegalArgumentException("Unexpected argument type");
    }

    private static boolean isReferenceToInterpretedFunction(ReferenceExpression reference) {
        Calculation calculation;
        NamedElement namedElement = reference.getReferencedElement();
        return namedElement instanceof Calculation && ModelUtil.isInterpretedFunction(calculation = (Calculation)namedElement);
    }

    private String computeProcessedCalculationName(Calculation calculation, List<Expression> arguments) {
        SysMLv2ToSMVExpression serializer = SysMLv2ToSMVExpression.getInstance(SysMLv2ToSMVExpression.Language.LTLSMV);
        StringBuilder newNameBuilder = new StringBuilder(calculation.getName());
        arguments.forEach(arg -> {
            newNameBuilder.append("_");
            newNameBuilder.append(serializer.serialize((Expression)arg).replaceAll("[^a-zA-Z0-9]", ""));
        });
        return newNameBuilder.toString();
    }

    private Calculation invocationToCalculation(InvocationTreeNode node) {
        String cloneName = this.computeProcessedCalculationName(node.invokedCalculation, node.effectiveArguments);
        Calculation clone = (Calculation)EcoreUtil.copy((EObject)node.invokedCalculation);
        clone.setName(cloneName);
        EcoreUtil2.getAllContentsOfType((EObject)clone.getResult(), ReferenceExpression.class).stream().forEach(reference -> {
            int index = EcoreUtil2.typeSelect((List)clone.getMembers(), NamedElement.class).indexOf(reference.getReferencedElement());
            if (index != -1) {
                Expression effectiveArgument = invocationTreeNode.effectiveArguments.get(index);
                if (effectiveArgument instanceof ReferenceExpression) {
                    ReferenceExpression effectiveArgumentAsReference = (ReferenceExpression)effectiveArgument;
                    reference.setReferencedElement(effectiveArgumentAsReference.getReferencedElement());
                } else {
                    Object container = reference.eContainer().eGet(reference.eContainingFeature());
                    if (container instanceof List) {
                        List arguments;
                        List argumentsList = arguments = (List)container;
                        int effectiveArgumentIndex = argumentsList.indexOf(reference);
                        argumentsList.set(effectiveArgumentIndex, effectiveArgument);
                    } else {
                        reference.eContainer().eSet(reference.eContainingFeature(), (Object)effectiveArgument);
                    }
                }
            }
        });
        node.processedCalculation = clone;
        this.defineTransformationMap.put(clone.getName(), clone);
        return clone;
    }

    private void populateEffectiveArguments(InvocationTreeNode node) {
        EList argumentsFromParseTree = node.reference.getArguments();
        node.effectiveArguments = new ArrayList<Expression>(argumentsFromParseTree.size());
        InvocationTreeNode parent = node.parent;
        if (parent == null) {
            argumentsFromParseTree.forEach(argument -> {
                boolean bl = invocationTreeNode.effectiveArguments.add((Expression)EcoreUtil.copy((EObject)argument));
            });
        } else {
            List parentParameters = EcoreUtil2.typeSelect((List)parent.invokedCalculation.getMembers(), NamedElement.class);
            int i = 0;
            while (i < argumentsFromParseTree.size()) {
                Expression argument2 = (Expression)argumentsFromParseTree.get(i);
                if (argument2 instanceof ReferenceExpression) {
                    ReferenceExpression argumentAsReference = (ReferenceExpression)argument2;
                    int indexInParentParameters = parentParameters.indexOf(argumentAsReference.getReferencedElement());
                    node.effectiveArguments.add((Expression)EcoreUtil.copy((EObject)parent.effectiveArguments.get(indexInParentParameters)));
                } else {
                    node.effectiveArguments.add((Expression)EcoreUtil.copy((EObject)argument2));
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public EList<EObject> getDefines(Object component) {
        void part;
        if (!(component instanceof Part)) {
            throw new NotAPartException(component.getClass());
        }
        Part part2 = (Part)component;
        PartDefinition definition = ModelUtil.getComponentType((Part)part);
        List<ReferenceExpression> interpretedFunctionsCallsWithoutArguments = EcoreUtil2.getAllContentsOfType((EObject)definition, ReferenceExpression.class).stream().filter(SysMLv2SystemModel::isReferenceToInterpretedFunction).filter(call -> call.getArguments().isEmpty()).toList();
        List<ReferenceExpression> interpretedFunctionsCallsWithArguments = EcoreUtil2.getAllContentsOfType((EObject)definition, ReferenceExpression.class).stream().filter(SysMLv2SystemModel::isReferenceToInterpretedFunction).filter(call -> !call.getArguments().isEmpty()).toList();
        EList defines = (EList)interpretedFunctionsCallsWithoutArguments.stream().map(ReferenceExpression::getReferencedElement).filter(Calculation.class::isInstance).map(Calculation.class::cast).collect(Collectors.toCollection(ECollections::newBasicEList));
        List<InvocationTreeNode> invocationTreesRoots = interpretedFunctionsCallsWithArguments.stream().map(InvocationTreeNode::new).toList();
        Traverser traverser = Traverser.forTree(InvocationTreeNode::access$0);
        invocationTreesRoots.forEach(rootNode -> traverser.breadthFirst(rootNode).forEach(this::populateEffectiveArguments));
        invocationTreesRoots.forEach(rootNode -> {
            traverser.depthFirstPostOrder(rootNode).forEach(treeNode -> {
                Calculation clone = (Calculation)EcoreUtil.copy((EObject)this.invocationToCalculation((InvocationTreeNode)treeNode));
                EcoreUtil2.getAllContentsOfType((EObject)clone.getResult(), ReferenceExpression.class).stream().filter(ReferenceExpression::isInvocation).filter(SysMLv2SystemModel::isReferenceToInterpretedFunction).forEach(reference -> {
                    String mapKey = this.computeProcessedCalculationName((Calculation)reference.getReferencedElement(), (List<Expression>)reference.getArguments());
                    Calculation targetCalculation = this.defineTransformationMap.get(mapKey);
                    this.setReferenceToProcessedCalculation((ReferenceExpression)reference, targetCalculation);
                });
                if (defines.stream().noneMatch(define -> define.getName().equals(clone.getName()))) {
                    defines.add((Object)clone);
                }
            });
            this.referenceMap.put(rootNode.reference, (Pair<Calculation, List<Expression>>)new Pair((Object)((Calculation)rootNode.reference.getReferencedElement()), List.copyOf(rootNode.reference.getArguments())));
            this.setReferenceToProcessedCalculation(rootNode.reference, rootNode.processedCalculation);
        });
        EList constraints = ECollections.toEList((Iterable)EcoreUtil2.typeSelect((List)definition.getMembers(), ConstraintUsage.class));
        constraints.removeIf(constraint -> !"precondition".equals(constraint.getName()) && !"postcondition".equals(constraint.getName()) || constraint.isAbstract());
        EList definesList = ECollections.toEList((Iterable)Iterables.concat((Iterable)defines, (Iterable)constraints));
        ModelUtil.DEFINES_MAP.put(definition.getName(), (EList<EObject>)definesList);
        return definesList;
    }

    private void setReferenceToProcessedCalculation(ReferenceExpression reference, Calculation calculation) {
        reference.setReferencedElement((NamedElement)calculation);
        reference.getArguments().clear();
        reference.setInvocation(false);
    }

    static /* synthetic */ boolean access$1(ReferenceExpression referenceExpression) {
        return SysMLv2SystemModel.isReferenceToInterpretedFunction(referenceExpression);
    }

    private static enum ConnectorEnd {
        SOURCE,
        TARGET;

    }

    private static enum ConstraintType {
        ASSUMPTION,
        GUARANTEE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    private static final class InvocationTreeNode {
        private final ReferenceExpression reference;
        private final Calculation invokedCalculation;
        private final List<InvocationTreeNode> nestedInvocations;
        private List<Expression> effectiveArguments;
        private InvocationTreeNode parent = null;
        private Calculation processedCalculation;

        public InvocationTreeNode(ReferenceExpression reference) {
            this.reference = reference;
            this.invokedCalculation = (Calculation)this.reference.getReferencedElement();
            this.nestedInvocations = EcoreUtil2.getAllContentsOfType((EObject)this.invokedCalculation.getResult(), ReferenceExpression.class).stream().filter(SysMLv2SystemModel::access$1).map(InvocationTreeNode::new).toList();
            this.nestedInvocations.forEach(invocation -> {
                InvocationTreeNode invocationTreeNode = invocation.parent = this;
            });
        }

        private List<InvocationTreeNode> getNestedInvocations() {
            return this.nestedInvocations;
        }

        static /* synthetic */ List access$0(InvocationTreeNode invocationTreeNode) {
            return invocationTreeNode.getNestedInvocations();
        }
    }
}

