/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.api.ui;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import eu.fbk.eclipse.explodtwin.api.core.ModelLibrary;
import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.sysmlv2.SysMLv2StandaloneSetup;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.sysmlv2.sysMLv2.StateUsage;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class Wrapper {
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private IResourceValidator validator;
    private static Wrapper instance = null;

    @Inject
    private Wrapper() {
    }

    public static Wrapper getInstance() {
        if (instance == null) {
            Injector injector = new SysMLv2StandaloneSetup().createInjectorAndDoEMFRegistration();
            instance = (Wrapper)injector.getInstance(Wrapper.class);
        }
        return instance;
    }

    public static void main(String[] args) throws Exception {
        Wrapper wrapper = Wrapper.getInstance();
        String inputFilePath = "resources/in.sysml";
        if (args.length != 0) {
            inputFilePath = args[0];
        } else {
            System.err.println("No path to EMF resource provided, using default: " + inputFilePath);
        }
        PartUsage systemComponent = wrapper.loadModel(inputFilePath);
        wrapper.navigateModel(systemComponent);
    }

    private void navigateModel(PartUsage systemComponent) {
        ModelLibrary modelLibrary = new ModelLibrary();
        System.out.println("root = " + String.valueOf(systemComponent));
        System.out.println("Subcomponents names = " + String.valueOf(modelLibrary.getSubComponentsNames(systemComponent)));
        List<PartUsage> comps = modelLibrary.getSubComponents(systemComponent);
        for (PartUsage comp : comps) {
            System.out.println("subComp = " + String.valueOf(comp));
        }
        StateUsage mainST = modelLibrary.getFirstNominalStateMachine(systemComponent);
        System.out.println("mainST = " + String.valueOf(mainST));
        StateUsage st = modelLibrary.getFirstNominalStateMachine(comps.get(0));
        System.out.println("ST = " + String.valueOf(st));
    }

    public PartUsage loadModel(String fileName) {
        Resource resource = this.getResource(fileName);
        ArrayList<Issue> issues = new ArrayList<Issue>();
        EcoreUtil2.getResourceSet((Notifier)resource).getResources().forEach(res -> {
            boolean bl = issues.addAll(this.validator.validate(res, CheckMode.ALL, CancelIndicator.NullImpl));
        });
        issues.removeIf(issue -> !issue.getSeverity().equals((Object)Severity.ERROR));
        if (!issues.isEmpty()) {
            StringBuilder builder = new StringBuilder("Invalid model. Errors:\n");
            issues.forEach(error -> {
                StringBuilder stringBuilder2 = builder.append(error.toString() + "\n");
            });
            throw new RuntimeException(builder.toString());
        }
        EObject top = (EObject)resource.getContents().get(0);
        return ModelUtil.getSystemPart(EcoreUtil2.getResourceSet((Notifier)top));
    }

    public static List<Path> findSysMLFiles(String directory) {
        BiPredicate<Path, BasicFileAttributes> matcher = (path, attributes) -> attributes.isRegularFile() && path.getFileName().toString().endsWith(".sysml");
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Stream<Path> pathsStream = Files.find(Paths.get(directory, new String[0]), Integer.MAX_VALUE, matcher, new FileVisitOption[0]);){
                return pathsStream.toList();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return List.of();
        }
    }

    private Resource getResource(String inputFilePath) {
        ResourceSet set = (ResourceSet)this.resourceSetProvider.get();
        int index = inputFilePath.lastIndexOf("/");
        String userModelFolder = index == -1 ? "." : inputFilePath.substring(0, index);
        Wrapper.findSysMLFiles(userModelFolder).forEach(path -> {
            Resource resource = set.getResource(URI.createFileURI((String)path.toAbsolutePath().toString()), true);
        });
        return set.getResources().stream().filter(resource -> resource.getURI().toFileString().endsWith(inputFilePath)).findAny().orElseThrow();
    }
}

