/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.api.util;

import com.google.common.base.Predicates;
import com.google.common.collect.Streams;
import eu.fbk.eclipse.explodtwin.api.util.SysMLv2ToSMVExpression;
import eu.fbk.eclipse.standardtools.utils.core.utils.Pair;
import eu.fbk.sysmlv2.sysMLv2.AttributeDefinition;
import eu.fbk.sysmlv2.sysMLv2.AttributeUsage;
import eu.fbk.sysmlv2.sysMLv2.Binding;
import eu.fbk.sysmlv2.sysMLv2.Calculation;
import eu.fbk.sysmlv2.sysMLv2.CalculationDefinition;
import eu.fbk.sysmlv2.sysMLv2.ConnectionElement;
import eu.fbk.sysmlv2.sysMLv2.Container;
import eu.fbk.sysmlv2.sysMLv2.Definition;
import eu.fbk.sysmlv2.sysMLv2.DirectedElement;
import eu.fbk.sysmlv2.sysMLv2.Direction;
import eu.fbk.sysmlv2.sysMLv2.EnumDefinition;
import eu.fbk.sysmlv2.sysMLv2.EnumUsage;
import eu.fbk.sysmlv2.sysMLv2.EqualityExpression;
import eu.fbk.sysmlv2.sysMLv2.Expression;
import eu.fbk.sysmlv2.sysMLv2.Feature;
import eu.fbk.sysmlv2.sysMLv2.ItemUsage;
import eu.fbk.sysmlv2.sysMLv2.Model;
import eu.fbk.sysmlv2.sysMLv2.NamedElement;
import eu.fbk.sysmlv2.sysMLv2.Operator;
import eu.fbk.sysmlv2.sysMLv2.OperatorExpression;
import eu.fbk.sysmlv2.sysMLv2.Package;
import eu.fbk.sysmlv2.sysMLv2.Part;
import eu.fbk.sysmlv2.sysMLv2.PartDefinition;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.sysmlv2.sysMLv2.PortDefinition;
import eu.fbk.sysmlv2.sysMLv2.PortUsage;
import eu.fbk.sysmlv2.sysMLv2.ReferenceExpression;
import eu.fbk.sysmlv2.sysMLv2.StateUsage;
import eu.fbk.sysmlv2.sysMLv2.SysMLv2Factory;
import eu.fbk.sysmlv2.sysMLv2.Transition;
import eu.fbk.sysmlv2.sysMLv2.TypedElement;
import eu.fbk.sysmlv2.sysMLv2.Usage;
import eu.fbk.sysmlv2.sysMLv2.UsageChainExpression;
import eu.fbk.sysmlv2.util.SysMLv2Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;

public class ModelUtil {
    public static final String BOUNDED_REAL = "BoundedReal";
    public static final String BOUNDED_INT = "BoundedInt";
    public static final Map<String, EList<EObject>> DEFINES_MAP = new HashMap<String, EList<EObject>>();
    public static final Map<Pair<DirectedElement, PortUsage>, DirectedElement> NESTED_TO_FLATTENED = new HashMap<Pair<DirectedElement, PortUsage>, DirectedElement>();
    private static final AttributeDefinition BOOLEAN_DEFINITION = SysMLv2Factory.eINSTANCE.createAttributeDefinition();
    public static final AttributeDefinition INTEGER_DEFINITION = SysMLv2Factory.eINSTANCE.createAttributeDefinition();
    private static final AttributeDefinition REAL_DEFINITION = SysMLv2Factory.eINSTANCE.createAttributeDefinition();
    public static final CalculationDefinition NEXT = SysMLv2Factory.eINSTANCE.createCalculationDefinition();

    static {
        BOOLEAN_DEFINITION.setName("Boolean");
        INTEGER_DEFINITION.setName("Integer");
        REAL_DEFINITION.setName("Real");
        NEXT.setName("next");
    }

    private ModelUtil() {
        throw new AssertionError();
    }

    public static boolean isInvariant(DirectedElement element) {
        AttributeUsage attribute;
        return element instanceof AttributeUsage && SysMLv2Util.getType((TypedElement)(attribute = (AttributeUsage)element)).getName().equals("Invar");
    }

    public static PartDefinition getPartDefinition(PartUsage partUsage) {
        try {
            return (PartDefinition)EcoreUtil2.typeSelect((List)SysMLv2Util.getAllTypes((TypedElement)partUsage), PartDefinition.class).get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public static boolean isBooleanType(Object type) {
        AttributeDefinition datatype;
        return type instanceof AttributeDefinition && (datatype = (AttributeDefinition)type).getName().equals("Boolean");
    }

    public static boolean isIntegerType(Object type) {
        AttributeDefinition datatype;
        return type instanceof AttributeDefinition && ((datatype = (AttributeDefinition)type).getName().equals("Integer") || datatype.getName().equals("Natural"));
    }

    public static boolean isRealType(Object type) {
        AttributeDefinition datatype;
        return type instanceof AttributeDefinition && (datatype = (AttributeDefinition)type).getName().equals("Real");
    }

    public static boolean isEnumType(Object type) {
        return type instanceof EnumDefinition;
    }

    public static boolean isClockType(Object type) {
        AttributeDefinition datatype;
        return type instanceof AttributeDefinition && (datatype = (AttributeDefinition)type).getName().equals("Clock");
    }

    public static EList<Usage> getAttributeUsagesInPart(Object object) {
        if (object instanceof PartDefinition) {
            PartDefinition partDefinition = (PartDefinition)object;
            EList<Usage> attributes = ModelUtil.getAttributeUsagesInContainer((Container)partDefinition);
            if (!ModelUtil.isActivity((Part)partDefinition) && partDefinition.getSpecialization() != null) {
                partDefinition.getSpecialization().getReferences().forEach(reference -> {
                    boolean bl = attributes.addAll(ModelUtil.getAttributeUsagesInPart(reference.getReferencedElement()));
                });
            }
            return attributes;
        }
        if (object instanceof PartUsage) {
            PartUsage partUsage = (PartUsage)object;
            return ModelUtil.getAttributeUsagesInContainer((Container)ModelUtil.getPartDefinition(partUsage));
        }
        return ECollections.emptyEList();
    }

    private static EList<ItemUsage> getEventsInPart(Object object) {
        if (object instanceof PartDefinition) {
            PartDefinition partDefinition = (PartDefinition)object;
            EList<ItemUsage> events = ModelUtil.getEventsInContainer((Container)partDefinition);
            if (!ModelUtil.isActivity((Part)partDefinition) && partDefinition.getSpecialization() != null) {
                partDefinition.getSpecialization().getReferences().forEach(reference -> {
                    boolean bl = events.addAll(ModelUtil.getEventsInPart(reference.getReferencedElement()));
                });
            }
            return events;
        }
        if (object instanceof PartUsage) {
            PartUsage partUsage = (PartUsage)object;
            return ModelUtil.getEventsInContainer((Container)ModelUtil.getPartDefinition(partUsage));
        }
        return ECollections.emptyEList();
    }

    private static EList<Usage> getAttributeUsagesInContainer(Container container) {
        return (EList)container.getMembers().stream().filter(Predicates.or(AttributeUsage.class::isInstance, Feature.class::isInstance)).map(Usage.class::cast).filter(usage -> usage.getValue() == null || usage.getRedefinition() == null).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    private static EList<ItemUsage> getEventsInContainer(Container container) {
        return (EList)container.getMembers().stream().filter(ItemUsage.class::isInstance).map(ItemUsage.class::cast).filter((Predicate<ItemUsage>)Predicates.or(SysMLv2Util::isEvent, ModelUtil::isBooleanParameter)).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public static List<PortUsage> getPortUsagesInPart(Part part) {
        return EcoreUtil2.typeSelect((List)ModelUtil.getComponentType(part).getMembers(), PortUsage.class);
    }

    public static EList<String> getEnumValues(EnumDefinition enumDefinition, boolean mapToIntegers) {
        return (EList)EcoreUtil2.typeSelect((List)enumDefinition.getMembers(), EnumUsage.class).stream().map(enumUsage -> {
            if (enumUsage.getValue() != null && mapToIntegers) {
                return SysMLv2ToSMVExpression.getInstance(SysMLv2ToSMVExpression.Language.CLEANC).serialize(enumUsage.getValue().getExpression());
            }
            return enumUsage.getName();
        }).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public static <T extends EObject> List<T> getAllContentsOfTypeFromModel(ResourceSet resourceSet, Class<T> type) {
        PartUsage systemComponent = ModelUtil.getSystemPart(resourceSet);
        return Streams.stream((Iterator)EcoreUtil.getAllContents((ResourceSet)resourceSet, (boolean)true)).filter(type::isInstance).map(type::cast).filter(eObject -> ModelUtil.eObjectsBelongToSameProject(eObject, (EObject)systemComponent) && !((Package)EcoreUtil2.getContainerOfType((EObject)eObject, Package.class)).isLibrary()).collect(Collectors.toList());
    }

    private static boolean eObjectsBelongToSameProject(EObject eObject1, EObject eObject2) {
        URI uri1 = eObject1.eResource().getURI();
        URI uri2 = eObject2.eResource().getURI();
        if (uri1.isPlatform() && uri2.isPlatform()) {
            String projectName1 = uri1.toPlatformString(false).split("/")[1];
            String projectName2 = uri2.toPlatformString(false).split("/")[1];
            return projectName2.equals(projectName1);
        }
        return uri1.isFile() && uri2.isFile();
    }

    public static EList<Usage> getContractUsages(PartDefinition partDefinition) {
        return (EList)ModelUtil.getAttributeUsagesInContainer((Container)partDefinition).stream().filter(ModelUtil::isOfContractType).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    private static boolean isOfSpecialType(Usage usage, SpecialType type) {
        if (usage instanceof Feature || usage instanceof AttributeUsage) {
            if (usage.getRedefinition() != null) {
                usage = (Usage)((ReferenceExpression)usage.getRedefinition().getReferences().get(0)).getReferencedElement();
            } else if (usage.getTyping() == null) {
                throw new IllegalArgumentException("Usage " + usage.getName() + " does not redefine anything and is not typed.");
            }
            return type == SpecialType.CLOCK ? ModelUtil.isClockType(SysMLv2Util.getAllTypes((TypedElement)usage)) : ModelUtil.isContractType(SysMLv2Util.getAllTypes((TypedElement)usage));
        }
        return false;
    }

    public static boolean isOfContractType(Usage usage) {
        return ModelUtil.isOfSpecialType(usage, SpecialType.CONTRACT);
    }

    public static boolean isOfClockType(Usage usage) {
        return ModelUtil.isOfSpecialType(usage, SpecialType.CLOCK);
    }

    public static Set<StateUsage> getNominalStateMachinesOfComponent(Part part) {
        PartDefinition partDefinition = ModelUtil.getComponentType(part);
        return EcoreUtil2.typeSelect((List)partDefinition.getMembers(), StateUsage.class).stream().filter(ModelUtil::isNominalStateMachine).collect(Collectors.toSet());
    }

    public static Model getModel(EObject element) {
        return (Model)EcoreUtil2.getRootContainer((EObject)element);
    }

    public static boolean isContractType(List<Definition> definitions) {
        return ModelUtil.isOfTypeName(definitions, "Contract");
    }

    private static boolean isOfTypeName(List<Definition> types, String typeName) {
        return types.stream().anyMatch(type -> typeName.equals(type.getName()));
    }

    public static boolean isAsyncPartUsage(PartUsage partUsage) {
        return ModelUtil.isOfTypeName(SysMLv2Util.getAllTypes((TypedElement)partUsage), "Asynchronous");
    }

    public static boolean isNominalStateMachine(StateUsage stateMachine) {
        return EcoreUtil2.typeSelect((List)stateMachine.getMembers(), StateUsage.class).stream().noneMatch(ModelUtil::isErrorState);
    }

    public static boolean isErrorState(StateUsage state) {
        return SysMLv2Util.getAllTypes((TypedElement)state).stream().anyMatch(ModelUtil::isErrorStateType);
    }

    public static boolean isErrorStateType(Definition type) {
        if (!"ErrorState".equals(type.getName())) {
            if (!type.getSpecialization().getReferences().stream().map(ReferenceExpression::getReferencedElement).filter(Definition.class::isInstance).map(Definition.class::cast).anyMatch(ModelUtil::isErrorStateType)) {
                return false;
            }
        }
        return true;
    }

    private static boolean portHasDirection(Object port, Direction direction) {
        DirectedElement usage;
        return port instanceof DirectedElement && direction.equals((Object)(usage = (DirectedElement)port).getDirection());
    }

    public static boolean isInputParameter(Object port) {
        return ModelUtil.portHasDirection(port, Direction.IN);
    }

    public static boolean isOutputParameter(Object port) {
        return ModelUtil.portHasDirection(port, Direction.OUT);
    }

    public static boolean isBidirectionalParameter(Object port) {
        return ModelUtil.portHasDirection(port, Direction.INOUT);
    }

    public static boolean isBooleanParameter(Usage port) {
        return ModelUtil.isBooleanType(SysMLv2Util.getType((TypedElement)port));
    }

    public static PartUsage getSystemPart(ResourceSet resourceSet) {
        return Streams.stream((Iterator)EcoreUtil2.getAllContents((ResourceSet)resourceSet, (boolean)true)).filter(PartUsage.class::isInstance).map(PartUsage.class::cast).filter(SysMLv2Util::isSystemPartUsage).findAny().orElseThrow(() -> new NoSuchElementException("No SystemComponent found."));
    }

    public static boolean usesInfiniteDomainVariables(EObject eObject) {
        return ModelUtil.getAllContentsOfTypeFromModel(EcoreUtil2.getResourceSet((Notifier)eObject), Usage.class).stream().filter(Predicates.or(AttributeUsage.class::isInstance, Feature.class::isInstance)).anyMatch(ModelUtil::isInfiniteDomainVariable);
    }

    public static boolean isInfiniteDomainVariable(Usage usage) {
        return ModelUtil.isIntegerType(ModelUtil.getUnboundedType((TypedElement)usage)) || ModelUtil.isRealType(ModelUtil.getUnboundedType((TypedElement)usage));
    }

    public static boolean isUninterpretedFunction(Calculation calculation) {
        return SysMLv2Util.containsMetadataUsagesOfType((Container)calculation, (String)"UninterpretedFunction");
    }

    public static boolean isInterpretedFunction(Calculation calculation) {
        return !ModelUtil.isUninterpretedFunction(calculation) && EcoreUtil2.getContainerOfType((EObject)calculation, Package.class) != null && !((Package)EcoreUtil2.getContainerOfType((EObject)calculation, Package.class)).isLibrary();
    }

    public static boolean isStateVariable(AttributeUsage attributeUsage) {
        return !ModelUtil.isCalibrationParameter(attributeUsage) && ModelUtil.isOutputParameter(attributeUsage);
    }

    public static boolean isCalibrationParameter(AttributeUsage attributeUsage) {
        return SysMLv2Util.containsMetadataUsagesOfType((Container)attributeUsage, (String)"CalibrationParam");
    }

    public static Definition getUnboundedType(TypedElement element) {
        Definition type = SysMLv2Util.getType((TypedElement)element);
        if (type == null) {
            return type;
        }
        if (ModelUtil.isBoundedIntType(type)) {
            return INTEGER_DEFINITION;
        }
        if (ModelUtil.isBoundedRealType(type)) {
            return REAL_DEFINITION;
        }
        return type;
    }

    public static boolean isInterfaceAssertion(Object object) {
        if (object instanceof AttributeUsage) {
            AttributeUsage attribute = (AttributeUsage)object;
            return ModelUtil.isOfTypeName(SysMLv2Util.getAllTypes((TypedElement)attribute), "LTLSpec");
        }
        return false;
    }

    public static boolean isActivity(Part part) {
        PartDefinition partDefinition = ModelUtil.getComponentType(part);
        return SysMLv2Util.partDefinitionIsActivity((PartDefinition)partDefinition);
    }

    public static PartDefinition getComponentType(Part part) {
        if (part instanceof PartUsage) {
            PartUsage partUsage = (PartUsage)part;
            return ModelUtil.getPartDefinition(partUsage);
        }
        return (PartDefinition)part;
    }

    public static EList<EObject> getDefines(Part part) {
        PartDefinition definition = ModelUtil.getComponentType(part);
        return DEFINES_MAP.get(definition.getName());
    }

    public static DirectedElement flattenNestedMember(DirectedElement member, PortUsage portUsage) {
        Pair key = new Pair((Object)member, (Object)portUsage);
        DirectedElement flattenedMember = NESTED_TO_FLATTENED.get(key);
        if (flattenedMember == null) {
            flattenedMember = (DirectedElement)EcoreUtil.copy((EObject)member);
            String flattenedName = flattenedMember.getName() + "__in__" + portUsage.getName();
            flattenedMember.setName(flattenedName);
            if (ModelUtil.isOutputParameter(flattenedMember) && SysMLv2Util.isEvent((Usage)flattenedMember)) {
                ((ReferenceExpression)flattenedMember.getTyping().getReferences().get(0)).setReferencedElement((NamedElement)BOOLEAN_DEFINITION);
            }
            NESTED_TO_FLATTENED.put((Pair<DirectedElement, PortUsage>)key, flattenedMember);
        }
        return flattenedMember;
    }

    public static EList<DirectedElement> getNonStaticPorts(Part part) {
        ModelUtil.getPortUsagesInPart(part).forEach(portUsage -> EcoreUtil2.typeSelect((List)SysMLv2Util.getType((TypedElement)portUsage).getMembers(), DirectedElement.class).stream().map(element -> ModelUtil.flattenNestedMember(element, portUsage)).filter(flattenedMember -> flattenedMember.eContainer() == null).forEach(flattenedMember -> {
            boolean bl = ((PartDefinition)EcoreUtil2.getContainerOfType((EObject)portUsage, PartDefinition.class)).getMembers().add(flattenedMember);
        }));
        EList<Usage> attributeUsages = ModelUtil.getAttributeUsagesInPart(part);
        EList directedAttributes = (EList)EcoreUtil2.typeSelect(attributeUsages, DirectedElement.class).stream().filter(Predicate.not(ModelUtil::isOfContractType)).filter(usage -> !Direction.NONE.equals((Object)usage.getDirection())).collect(Collectors.toCollection(ECollections::newBasicEList));
        directedAttributes.addAll(ModelUtil.getEventsInPart(part));
        return directedAttributes;
    }

    public static boolean isSubsystem(Part part) {
        PartDefinition partDefinition = ModelUtil.getComponentType(part);
        return SysMLv2Util.partDefinitionIsSubsystem((PartDefinition)partDefinition);
    }

    private static StateUsage getStateMachineOfType(Part part, StateMachineType type) {
        PartDefinition definition = ModelUtil.getComponentType(part);
        return EcoreUtil2.typeSelect((List)definition.getMembers(), StateUsage.class).stream().filter(state -> state.getSubsetting() != null && ((ReferenceExpression)state.getSubsetting().getReferences().get(0)).getReferencedElement().getName().equals(stateMachineType.name)).findAny().orElse(null);
    }

    public static StateUsage getPlatformStateMachine(Part part) {
        return ModelUtil.getStateMachineOfType(part, StateMachineType.PLATFORM);
    }

    public static StateUsage getMissionStateMachine(Part part) {
        return ModelUtil.getStateMachineOfType(part, StateMachineType.MISSION);
    }

    public static EList<ConnectionElement> getConnectionsPorts(Part part) {
        PartDefinition partDefinition = ModelUtil.getComponentType(part);
        return (EList)EcoreUtil2.typeSelect((List)partDefinition.getMembers(), ConnectionElement.class).stream().mapMulti((connection, acceptor) -> {
            ReferenceExpression reference;
            Expression expression = connection.getSource();
            if (expression instanceof ReferenceExpression && (reference = (ReferenceExpression)expression).getReferencedElement() instanceof PortUsage) {
                ModelUtil.generateConnectionsForFlattenedPort(connection).forEach(acceptor::accept);
            } else {
                acceptor.accept(connection);
            }
        }).collect(Collectors.toCollection(ECollections::newBasicEList));
    }

    public static List<ConnectionElement> generateConnectionsForFlattenedPort(ConnectionElement connection) {
        PortUsage source = (PortUsage)((ReferenceExpression)connection.getSource()).getReferencedElement();
        PortUsage target = (PortUsage)connection.getTarget().getReferencedElement();
        List<Pair<DirectedElement, DirectedElement>> memberPairs = ModelUtil.buildPortMemberPairs(source, target);
        ArrayList<ConnectionElement> generatedConnections = new ArrayList<ConnectionElement>();
        memberPairs.forEach(pair -> {
            DirectedElement flattenedSource = ModelUtil.flattenNestedMember((DirectedElement)pair.getLeft(), source);
            DirectedElement flattenedTarget = ModelUtil.flattenNestedMember((DirectedElement)pair.getRight(), target);
            ConnectionElement clone = (ConnectionElement)EcoreUtil.copy((EObject)connection);
            ReferenceExpression sourceReference = (ReferenceExpression)clone.getSource();
            ReferenceExpression targetReference = clone.getTarget();
            sourceReference.setReferencedElement((NamedElement)flattenedSource);
            targetReference.setReferencedElement((NamedElement)flattenedTarget);
            if (connection instanceof Binding) {
                if ((!ModelUtil.isInputParameter(flattenedSource) || !ModelUtil.isInputParameter(flattenedTarget)) && (!ModelUtil.isOutputParameter(flattenedSource) || !ModelUtil.isOutputParameter(flattenedTarget))) throw new RuntimeException("Port members " + flattenedSource.getName() + " and " + flattenedTarget.getName() + " in a Binding must have equal direction.");
                clone.setSource((Expression)sourceReference);
                clone.setTarget(targetReference);
            } else {
                Usage usage;
                if (!ModelUtil.isOutputParameter(flattenedSource) || !ModelUtil.isInputParameter(flattenedTarget)) {
                    throw new RuntimeException("Port members " + flattenedSource.getName() + " and " + flattenedTarget.getName() + " must be an output and an input port respectively.");
                }
                clone.setSource((Expression)sourceReference);
                clone.setTarget(targetReference);
                NamedElement namedElement = clone.getTarget().getReferencedElement();
                if (namedElement instanceof Usage && SysMLv2Util.isEvent((Usage)(usage = (Usage)namedElement))) {
                    EqualityExpression equalityExpression = SysMLv2Factory.eINSTANCE.createEqualityExpression();
                    Operator notEqual = SysMLv2Factory.eINSTANCE.createOperator();
                    notEqual.setName("!=");
                    equalityExpression.setOperator(notEqual);
                    ReferenceExpression callToNext = SysMLv2Factory.eINSTANCE.createReferenceExpression();
                    callToNext.setReferencedElement((NamedElement)NEXT);
                    callToNext.setInvocation(true);
                    Expression targetclone1 = (Expression)EcoreUtil.copy((EObject)clone.getSource());
                    callToNext.getArguments().add((Object)targetclone1);
                    equalityExpression.setLeft((OperatorExpression)callToNext);
                    ReferenceExpression targetclone2 = (ReferenceExpression)EcoreUtil.copy((EObject)clone.getSource());
                    equalityExpression.setRight((OperatorExpression)targetclone2);
                    clone.setSource((Expression)equalityExpression);
                }
            }
            generatedConnections.add(clone);
        });
        return generatedConnections;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Pair<DirectedElement, DirectedElement>> buildPortMemberPairs(PortUsage port1, PortUsage port2) {
        PortDefinition definition1 = (PortDefinition)SysMLv2Util.getType((TypedElement)port1);
        PortDefinition definition2 = (PortDefinition)SysMLv2Util.getType((TypedElement)port2);
        EList definitionMembers1 = definition1.getMembers();
        EList definitionMembers2 = definition2.getMembers();
        if (definitionMembers1.size() != definitionMembers2.size()) {
            throw new RuntimeException("Port Usages " + port1.getName() + " and " + port2.getName() + " are not compatible as they are typed by Port Definitions containing a different number of members.");
        }
        LinkedList<Pair<DirectedElement, DirectedElement>> memberPairs = new LinkedList<Pair<DirectedElement, DirectedElement>>();
        int i = 0;
        while (i < definitionMembers1.size()) {
            void directedElement2;
            EObject eObject;
            DirectedElement directedElement1;
            block8: {
                block7: {
                    EObject eObject2 = (EObject)definitionMembers1.get(i);
                    if (!(eObject2 instanceof DirectedElement)) break block7;
                    directedElement1 = (DirectedElement)eObject2;
                    eObject = (EObject)definitionMembers2.get(i);
                    if (eObject instanceof DirectedElement) break block8;
                }
                throw new RuntimeException("Members at position " + i + " in " + definition1.getName() + " and " + definition2.getName() + " are not elements that can have a direction.");
            }
            DirectedElement directedElement = (DirectedElement)eObject;
            memberPairs.add((Pair<DirectedElement, DirectedElement>)new Pair((Object)directedElement1, (Object)directedElement2));
            ++i;
        }
        i = 0;
        while (i < memberPairs.size()) {
            String rightType;
            Pair pair = (Pair)memberPairs.get(i);
            String leftType = SysMLv2Util.getType((TypedElement)((TypedElement)pair.getLeft())).getName();
            if (!leftType.equals(rightType = SysMLv2Util.getType((TypedElement)((TypedElement)pair.getRight())).getName())) {
                throw new RuntimeException("Members at position " + i + " in " + definition1.getName() + " and " + definition2.getName() + " have mismatching types: " + leftType + " and " + rightType + " respectively.");
            }
            ++i;
        }
        return memberPairs;
    }

    public static ComponentsRelationship compareComponents(PartDefinition partDefinition1, PartDefinition partDefinition2) {
        if (EcoreUtil2.typeSelect((List)partDefinition1.getMembers(), PartUsage.class).stream().filter(partUsage -> partUsage.getTyping() != null && partDefinition2.getName().equals(SysMLv2Util.getType((TypedElement)partUsage).getName())).count() != 0L) {
            return ComponentsRelationship.FIRST_CONTAINS_SECOND;
        }
        if (EcoreUtil2.typeSelect((List)partDefinition2.getMembers(), PartUsage.class).stream().filter(partUsage -> partUsage.getTyping() != null && partDefinition1.getName().equals(SysMLv2Util.getType((TypedElement)partUsage).getName())).count() != 0L) {
            return ComponentsRelationship.SECOND_CONTAINS_FIRST;
        }
        return ComponentsRelationship.SAME;
    }

    public static NamedElement getConnectorEndOwner(Object connectorEnd) {
        if (connectorEnd instanceof UsageChainExpression) {
            UsageChainExpression chainExpression = (UsageChainExpression)connectorEnd;
            return chainExpression.getBody().getReferencedElement();
        }
        return null;
    }

    public static PartUsage getDurativeTransitionActivity(Transition transition) {
        Usage actFeature = (Usage)SysMLv2Util.getMemberByName((Container)transition, Usage.class, (String)"act");
        ReferenceExpression activityReference = (ReferenceExpression)actFeature.getValue().getExpression();
        return (PartUsage)activityReference.getReferencedElement();
    }

    public static List<PartUsage> getDurativeTransitionsActivities(PartDefinition component) {
        return EcoreUtil2.typeSelect((List)ModelUtil.getMissionStateMachine((Part)component).getMembers(), Transition.class).stream().filter(SysMLv2Util::isDurative).map(ModelUtil::getDurativeTransitionActivity).toList();
    }

    private static boolean isOrSpecializesBoundedType(Definition type, String boundedType) {
        if (boundedType.equals(type.getName())) {
            return true;
        }
        return type.getSpecialization() != null && type.getSpecialization().getReferences().stream().map(ReferenceExpression::getReferencedElement).anyMatch(element -> element.getName().equals(boundedType));
    }

    public static boolean isIntervalType(Definition type) {
        return ModelUtil.isBoundedIntType(type) || ModelUtil.isBoundedRealType(type);
    }

    public static boolean isBoundedIntType(Definition type) {
        return ModelUtil.isOrSpecializesBoundedType(type, BOUNDED_INT);
    }

    public static boolean isBoundedRealType(Definition type) {
        return ModelUtil.isOrSpecializesBoundedType(type, BOUNDED_REAL);
    }

    public static String getBoundValue(Container container, Bound boundType) {
        Usage bound = (Usage)SysMLv2Util.getMemberByName((Container)container, Usage.class, (String)boundType.name);
        if (bound == null) {
            String string;
            Usage usage;
            if (container instanceof Usage && (usage = (Usage)container).getTyping() != null) {
                return ModelUtil.getBoundValue((Container)SysMLv2Util.getType((TypedElement)usage), boundType);
            }
            if (container instanceof NamedElement) {
                NamedElement namedElement = (NamedElement)container;
                string = namedElement.getName();
            } else {
                string = "";
            }
            throw new RuntimeException("Ill-formed bounded type " + string + " : missing " + boundType.name);
        }
        return SysMLv2ToSMVExpression.getInstance(SysMLv2ToSMVExpression.Language.CLEANC).serialize(bound.getValue().getExpression());
    }

    public static boolean isExplodtwin(ResourceSet resourceSet) {
        return resourceSet.getResources().stream().map(Resource::getURI).anyMatch(uri -> uri.toString().contains("explodtwin"));
    }

    public static boolean isHavocGeneratedAttribute(Usage usage) {
        return usage.getName().startsWith("generated_") && usage.getName().endsWith("_havoc");
    }

    public static enum Bound {
        MIN("minValue"),
        MAX("maxValue");

        public final String name;

        private Bound(String name) {
            this.name = name;
        }
    }

    public static enum ComponentsRelationship {
        FIRST_CONTAINS_SECOND,
        SAME,
        SECOND_CONTAINS_FIRST;

    }

    static enum SpecialType {
        CLOCK,
        CONTRACT;

    }

    private static enum StateMachineType {
        MISSION("mission"),
        PLATFORM("platform");

        public final String name;

        private StateMachineType(String name) {
            this.name = name + "StateMachines";
        }
    }
}

