/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.api.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.standardtools.utils.core.utils.Pair;
import eu.fbk.sysmlv2.sysMLv2.ActionUsage;
import eu.fbk.sysmlv2.sysMLv2.AssertionAction;
import eu.fbk.sysmlv2.sysMLv2.Assignment;
import eu.fbk.sysmlv2.sysMLv2.AttributeUsage;
import eu.fbk.sysmlv2.sysMLv2.BooleanLiteral;
import eu.fbk.sysmlv2.sysMLv2.Calculation;
import eu.fbk.sysmlv2.sysMLv2.CalculationDefinition;
import eu.fbk.sysmlv2.sysMLv2.ConnectionElement;
import eu.fbk.sysmlv2.sysMLv2.ConnectionUsage;
import eu.fbk.sysmlv2.sysMLv2.ConstraintUsage;
import eu.fbk.sysmlv2.sysMLv2.Container;
import eu.fbk.sysmlv2.sysMLv2.Definition;
import eu.fbk.sysmlv2.sysMLv2.DirectedElement;
import eu.fbk.sysmlv2.sysMLv2.Direction;
import eu.fbk.sysmlv2.sysMLv2.Effect;
import eu.fbk.sysmlv2.sysMLv2.EqualityExpression;
import eu.fbk.sysmlv2.sysMLv2.Expression;
import eu.fbk.sysmlv2.sysMLv2.Guard;
import eu.fbk.sysmlv2.sysMLv2.ItemDefinition;
import eu.fbk.sysmlv2.sysMLv2.ItemUsage;
import eu.fbk.sysmlv2.sysMLv2.NamedElement;
import eu.fbk.sysmlv2.sysMLv2.Operator;
import eu.fbk.sysmlv2.sysMLv2.OperatorExpression;
import eu.fbk.sysmlv2.sysMLv2.Package;
import eu.fbk.sysmlv2.sysMLv2.Part;
import eu.fbk.sysmlv2.sysMLv2.PartDefinition;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.sysmlv2.sysMLv2.Payload;
import eu.fbk.sysmlv2.sysMLv2.PerformActionReference;
import eu.fbk.sysmlv2.sysMLv2.PortDefinition;
import eu.fbk.sysmlv2.sysMLv2.PortUsage;
import eu.fbk.sysmlv2.sysMLv2.QualifiedNameExpression;
import eu.fbk.sysmlv2.sysMLv2.ReferenceExpression;
import eu.fbk.sysmlv2.sysMLv2.SendUsage;
import eu.fbk.sysmlv2.sysMLv2.StateUsage;
import eu.fbk.sysmlv2.sysMLv2.SuccessionNode;
import eu.fbk.sysmlv2.sysMLv2.SysMLv2Factory;
import eu.fbk.sysmlv2.sysMLv2.TernaryOperatorExpression;
import eu.fbk.sysmlv2.sysMLv2.Transition;
import eu.fbk.sysmlv2.sysMLv2.TriggerAction;
import eu.fbk.sysmlv2.sysMLv2.TypedElement;
import eu.fbk.sysmlv2.sysMLv2.Typing;
import eu.fbk.sysmlv2.sysMLv2.UsageChainExpression;
import eu.fbk.sysmlv2.sysMLv2.UsageExpression;
import eu.fbk.sysmlv2.sysMLv2.UsageReferenceExpression;
import eu.fbk.sysmlv2.util.SysMLv2Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;

public class PostProcessor {
    private final ResourceSet resourceSet;
    private ItemDefinition eventDefinition = null;
    private PartDefinition activityDefinition = null;
    private PortDefinition conjugatedActivityPerformedPort = null;
    private ItemDefinition activityPerformed = null;
    private final boolean isExplodtwin;

    public PostProcessor(ResourceSet resourceSet, boolean isExplodtwin) {
        this.resourceSet = resourceSet;
        this.isExplodtwin = isExplodtwin;
        if (isExplodtwin) {
            this.eventDefinition = this.getFromIndex(ItemDefinition.class, "Event");
            this.activityDefinition = this.getFromIndex(PartDefinition.class, "Activity");
            this.conjugatedActivityPerformedPort = this.getFromIndex(PortDefinition.class, "~ActivityPerformedPort");
            this.activityPerformed = this.getFromIndex(ItemDefinition.class, "ActivityPerformed");
        }
    }

    private <T extends NamedElement> T getFromIndex(Class<T> type, String name) {
        return (T)Streams.stream((Iterator)this.resourceSet.getAllContents()).filter(type::isInstance).map(type::cast).filter(namedElement -> ((Package)EcoreUtil2.getContainerOfType((EObject)namedElement, Package.class)).isLibrary() && name.equals(namedElement.getName())).findAny().orElseThrow(() -> new RuntimeException("Could not retrieve " + type.getSimpleName() + " " + name));
    }

    private void process(Resource resource) {
        this.installAdditionalEventMembers(resource);
        this.installStutterTransitions(resource);
        this.installActivities(resource);
        this.flattenPorts(resource);
        this.installDurativeTransitions(resource);
        this.installDanglingPorts(resource);
    }

    public void flattenPorts(Resource resource) {
        if (!SysMLv2Util.resourceBelongsToLibrary((Resource)resource)) {
            EcoreUtil2.typeSelect((List)EcoreUtil2.eAllContentsAsList((Resource)resource), PartDefinition.class).forEach(ModelUtil::getNonStaticPorts);
        }
    }

    public void performPostProcessing() {
        if (!this.isExplodtwin) {
            return;
        }
        ArrayList<Resource> libraryResources = new ArrayList<Resource>((Collection<Resource>)this.resourceSet.getResources());
        libraryResources.removeIf(Predicate.not(SysMLv2Util::resourceBelongsToLibrary));
        ArrayList<Resource> modelResources = new ArrayList<Resource>((Collection<Resource>)this.resourceSet.getResources());
        modelResources.removeIf(SysMLv2Util::resourceBelongsToLibrary);
        libraryResources.forEach(this::process);
        modelResources.forEach(this::process);
        modelResources.forEach(this::installSetterTransitions);
    }

    private static Transition createLoopTransition(StateUsage state) {
        Transition transition = SysMLv2Factory.eINSTANCE.createTransition();
        transition.setSource(state);
        transition.setDestination(state);
        return transition;
    }

    private static void createTypingForUsage(TypedElement usageOrPayload, Definition definition) {
        Typing typing = SysMLv2Factory.eINSTANCE.createTyping();
        QualifiedNameExpression expression = SysMLv2Factory.eINSTANCE.createQualifiedNameExpression();
        expression.setReferencedElement((NamedElement)definition);
        typing.getReferences().add((Object)expression);
        usageOrPayload.setTyping(typing);
    }

    private void installAdditionalEventMembers(Resource resource) {
        EcoreUtil2.typeSelect((List)EcoreUtil2.eAllContentsAsList((Resource)resource), SendUsage.class).forEach(sendUsage -> {
            void transport;
            ReferenceExpression reference;
            Expression expression = sendUsage.getPayload();
            if (expression instanceof ReferenceExpression && (reference = (ReferenceExpression)expression).getReferencedElement() instanceof ItemDefinition) {
                return;
            }
            if (sendUsage.getTransport() == null) {
                return;
            }
            NamedElement namedElement = sendUsage.getTransport().getReferencedElement();
            if (!(namedElement instanceof PortUsage)) {
                return;
            }
            PortUsage portUsage = (PortUsage)namedElement;
            PortDefinition portDefinition = (PortDefinition)SysMLv2Util.getType((TypedElement)transport);
            boolean installOutputEventPort = EcoreUtil2.typeSelect((List)portDefinition.getMembers(), ItemUsage.class).stream().noneMatch(SysMLv2Util::itemUsageIsEvent);
            boolean installInputEventPort = EcoreUtil2.typeSelect((List)portDefinition.getConjugatedPortDefinition().getMembers(), ItemUsage.class).stream().noneMatch(SysMLv2Util::itemUsageIsEvent);
            if (installOutputEventPort) {
                portDefinition.getMembers().add((Object)this.generateEventPort(Direction.OUT));
            }
            if (installInputEventPort) {
                portDefinition.getConjugatedPortDefinition().getMembers().add((Object)this.generateEventPort(Direction.IN));
            }
        });
    }

    private ItemUsage generateEventPort(Direction direction) {
        ItemUsage eventPort = SysMLv2Factory.eINSTANCE.createItemUsage();
        eventPort.setName("generatedEventPort");
        eventPort.setDirection(direction);
        PostProcessor.createTypingForUsage((TypedElement)eventPort, (Definition)this.eventDefinition);
        return eventPort;
    }

    private void installStutterTransitions(Resource resource) {
        EcoreUtil2.typeSelect((List)EcoreUtil2.eAllContentsAsList((Resource)resource), StateUsage.class).stream().filter(stateUsage -> SysMLv2Util.isStateMachine((StateUsage)stateUsage) && !"Environment".equals(SysMLv2Util.getSpecializedDefinitionName((Definition)((Definition)EcoreUtil2.getContainerOfType((EObject)stateUsage, PartDefinition.class))))).forEach(stateMachine -> EcoreUtil2.typeSelect((List)stateMachine.getMembers(), StateUsage.class).stream().map(PostProcessor::createLoopTransition).forEach(transition -> {
            transition.setStutter(true);
            stateMachine.getMembers().add(transition);
        }));
    }

    private void installActivities(Resource resource) {
        StateUsage activityStateMachine = (StateUsage)EcoreUtil2.typeSelect((List)this.activityDefinition.getMembers(), StateUsage.class).get(0);
        List portUsages = EcoreUtil2.typeSelect((List)this.activityDefinition.getMembers(), PortUsage.class);
        List attributeUsages = EcoreUtil2.typeSelect((List)this.activityDefinition.getMembers(), AttributeUsage.class);
        EcoreUtil2.typeSelect((List)EcoreUtil2.eAllContentsAsList((Resource)resource), PartDefinition.class).stream().filter(SysMLv2Util::partDefinitionIsActivity).forEach(partDefinition -> {
            StateUsage stateMachine = (StateUsage)EcoreUtil.copy((EObject)activityStateMachine);
            stateMachine.setName(stateMachine.getName() + "_" + partDefinition.getName());
            partDefinition.getMembers().add((Object)stateMachine);
            List<PortUsage> portsClones = portUsages.stream().map(EcoreUtil::copy).toList();
            partDefinition.getMembers().addAll(portsClones);
            attributeUsages.stream().map(EcoreUtil::copy).forEach(arg_0 -> partDefinition.getMembers().add(arg_0));
            EcoreUtil2.getAllContentsOfType((EObject)stateMachine, ReferenceExpression.class).forEach(reference -> {
                NamedElement namedElement = reference.getReferencedElement();
                if (namedElement instanceof PortUsage) {
                    PortUsage portUsage = (PortUsage)namedElement;
                    String name = portUsage.getName();
                    PortUsage clone = portsClones.stream().filter(portClone -> portClone.getName().equals(name)).findFirst().orElse(null);
                    if (clone == null) {
                        return;
                    }
                    reference.setReferencedElement((NamedElement)clone);
                    EcoreUtil2.typeSelect((List)Lists.newArrayList((Iterator)resource.getAllContents()), ReferenceExpression.class).forEach(reference2 -> {
                        PortUsage portUsage22;
                        NamedElement namedElement = reference2.getReferencedElement();
                        if (namedElement instanceof PortUsage && portUsage == (portUsage22 = (PortUsage)namedElement)) {
                            reference2.setReferencedElement((NamedElement)clone);
                        }
                    });
                } else {
                    NamedElement namedElement2 = reference.getReferencedElement();
                    if (namedElement2 instanceof Calculation) {
                        Calculation calculation = (Calculation)namedElement2;
                        String name = calculation.getName();
                        Calculation redefinedCalculation = (Calculation)SysMLv2Util.getMemberByName((Container)partDefinition, Calculation.class, (String)name);
                        if (redefinedCalculation == null) {
                            return;
                        }
                        reference.setReferencedElement((NamedElement)redefinedCalculation);
                    }
                }
            });
            EcoreUtil2.getAllContentsOfType((EObject)stateMachine, PerformActionReference.class).forEach(performAction -> {
                String name = performAction.getReference().getReferencedElement().getName();
                ActionUsage redefinedAction = (ActionUsage)SysMLv2Util.getMemberByName((Container)partDefinition, ActionUsage.class, (String)name);
                if (redefinedAction == null) {
                    return;
                }
                performAction.getReference().setReferencedElement((NamedElement)redefinedAction);
            });
            List.of("precondition", "postcondition").forEach(constraintName -> {
                if (SysMLv2Util.getMemberByName((Container)partDefinition, ConstraintUsage.class, (String)constraintName) == null) {
                    ConstraintUsage stub = (ConstraintUsage)SysMLv2Util.getMemberByName((Container)this.activityDefinition, ConstraintUsage.class, (String)constraintName);
                    ConstraintUsage nonAbstractStub = (ConstraintUsage)EcoreUtil2.copy((EObject)stub);
                    nonAbstractStub.setAbstract(false);
                    partDefinition.getMembers().add((Object)nonAbstractStub);
                }
            });
            ConstraintUsage invariant = (ConstraintUsage)SysMLv2Util.getMemberByName((Container)partDefinition, ConstraintUsage.class, (String)"invariant");
            if (invariant != null) {
                StateUsage progressState = (StateUsage)SysMLv2Util.getMemberByName((Container)stateMachine, StateUsage.class, (String)"Progress");
                AssertionAction assertionAction = SysMLv2Factory.eINSTANCE.createAssertionAction();
                assertionAction.setConstraint(invariant);
                progressState.getMembers().add((Object)assertionAction);
            }
        });
    }

    private void installDurativeTransitions(Resource resource) {
        EcoreUtil2.typeSelect((List)EcoreUtil2.eAllContentsAsList((Resource)resource), Transition.class).stream().filter(SysMLv2Util::isDurative).forEach(durativeTransition -> {
            PartUsage activity = ModelUtil.getDurativeTransitionActivity(durativeTransition);
            PartDefinition subsystem = (PartDefinition)EcoreUtil2.getContainerOfType((EObject)durativeTransition, PartDefinition.class);
            if (SysMLv2Util.getMemberByName((Container)subsystem, PortUsage.class, (String)(activity.getName() + "_done_input")) != null) {
                return;
            }
            PortUsage activityPerformedInputPort = SysMLv2Factory.eINSTANCE.createPortUsage();
            PostProcessor.createTypingForUsage((TypedElement)activityPerformedInputPort, (Definition)this.conjugatedActivityPerformedPort);
            activityPerformedInputPort.setName(activity.getName() + "_done_input");
            subsystem.getMembers().add((Object)activityPerformedInputPort);
            ConnectionUsage connection = SysMLv2Factory.eINSTANCE.createConnectionUsage();
            UsageChainExpression output = SysMLv2Factory.eINSTANCE.createUsageChainExpression();
            UsageReferenceExpression outputBody = SysMLv2Factory.eINSTANCE.createUsageReferenceExpression();
            outputBody.setReferencedElement((NamedElement)activity);
            output.setBody((UsageExpression)outputBody);
            PortUsage referenceTarget = (PortUsage)SysMLv2Util.getMemberByName((Container)this.activityDefinition, PortUsage.class, (String)"activityPerformedPort");
            output.setReferencedElement((NamedElement)referenceTarget);
            connection.setSource((Expression)output);
            QualifiedNameExpression input = SysMLv2Factory.eINSTANCE.createQualifiedNameExpression();
            input.setReferencedElement((NamedElement)activityPerformedInputPort);
            connection.setTarget((ReferenceExpression)input);
            subsystem.getMembers().add((Object)connection);
            Payload payload = SysMLv2Factory.eINSTANCE.createPayload();
            PostProcessor.createTypingForUsage((TypedElement)payload, (Definition)this.activityPerformed);
            TriggerAction trigger = SysMLv2Factory.eINSTANCE.createTriggerAction();
            trigger.setPayload(payload);
            QualifiedNameExpression referenceToInputPort = SysMLv2Factory.eINSTANCE.createQualifiedNameExpression();
            referenceToInputPort.setReferencedElement((NamedElement)activityPerformedInputPort);
            trigger.setPort((ReferenceExpression)referenceToInputPort);
            durativeTransition.getTriggers().add((Object)trigger);
        });
    }

    private void installSetterTransitions(Resource resource) {
        if (SysMLv2Util.resourceBelongsToLibrary((Resource)resource)) {
            return;
        }
        EcoreUtil2.typeSelect((List)EcoreUtil2.eAllContentsAsList((Resource)resource), PartUsage.class).forEach(this::installSetterTransitionsForComponentInstance);
    }

    private static PartUsage getSetterSender(PartUsage receivingInstance, PortUsage receivingPort) {
        List<ConnectionElement> allConnections = ModelUtil.getAllContentsOfTypeFromModel(EcoreUtil2.getResourceSet((Notifier)receivingInstance), ConnectionElement.class);
        PortUsage sendingPort = receivingPort;
        PortUsage tmp = null;
        Pair<PortUsage, ConnectionElement> pair = null;
        ConnectionElement lastConnection = null;
        while (sendingPort != tmp) {
            tmp = sendingPort;
            pair = PostProcessor.findConnectionAndEnd(sendingPort, receivingInstance, allConnections);
            sendingPort = (PortUsage)pair.getLeft();
            if (pair.getRight() == null) continue;
            lastConnection = (ConnectionElement)pair.getRight();
        }
        boolean landedOnSource = true;
        if (lastConnection.getTarget().getReferencedElement() == sendingPort) {
            landedOnSource = false;
        }
        return (PartUsage)ModelUtil.getConnectorEndOwner(landedOnSource ? lastConnection.getSource() : lastConnection.getTarget());
    }

    private void installSettersIntoTransitions(List<ActionUsage> setters, List<Transition> transitions) {
        transitions.forEach(transition -> {
            Effect effect = SysMLv2Factory.eINSTANCE.createEffect();
            ActionUsage effectAction = SysMLv2Factory.eINSTANCE.createActionUsage();
            int i = 0;
            while (i < setters.size()) {
                void usageChainExpression;
                void setterAssignment;
                SuccessionNode successionNode;
                EObject eObject;
                ActionUsage setter = (ActionUsage)setters.get(i);
                ActionUsage action = (ActionUsage)setter.getMembers().get(0);
                TriggerAction trigger = (TriggerAction)action.getMembers().get(0);
                PortUsage port = (PortUsage)trigger.getPort().getReferencedElement();
                TriggerAction transitionTrigger = SysMLv2Factory.eINSTANCE.createTriggerAction();
                Payload payload = SysMLv2Factory.eINSTANCE.createPayload();
                PostProcessor.createTypingForUsage((TypedElement)payload, (Definition)this.eventDefinition);
                transitionTrigger.setPayload(payload);
                UsageChainExpression portReference = SysMLv2Factory.eINSTANCE.createUsageChainExpression();
                portReference.setReferencedElement((NamedElement)port);
                transitionTrigger.setPort((ReferenceExpression)portReference);
                transition.getTriggers().add((Object)transitionTrigger);
                EObject eObject2 = (EObject)setter.getMembers().get(1);
                if (!(eObject2 instanceof SuccessionNode) || !((eObject = (successionNode = (SuccessionNode)eObject2).getNode()) instanceof Assignment)) {
                    return;
                }
                Assignment assignment = (Assignment)eObject;
                Assignment assignment2 = (Assignment)EcoreUtil.copy((EObject)setterAssignment);
                Expression expression = assignment2.getValue().getExpression();
                if (!(expression instanceof UsageChainExpression)) {
                    return;
                }
                UsageChainExpression usageChainExpression2 = (UsageChainExpression)expression;
                usageChainExpression.getBody().setReferencedElement((NamedElement)port);
                usageChainExpression.setReferencedElement((NamedElement)SysMLv2Util.getDataMemberFromPort((PortUsage)port));
                TernaryOperatorExpression ternaryOperatorExpression = SysMLv2Factory.eINSTANCE.createTernaryOperatorExpression();
                Guard guard = SysMLv2Factory.eINSTANCE.createGuard();
                EqualityExpression eventOccurredExpression = SysMLv2Factory.eINSTANCE.createEqualityExpression();
                UsageChainExpression referenceToEventMember = SysMLv2Factory.eINSTANCE.createUsageChainExpression();
                UsageReferenceExpression body = SysMLv2Factory.eINSTANCE.createUsageReferenceExpression();
                body.setReferencedElement((NamedElement)port);
                referenceToEventMember.setBody((UsageExpression)body);
                referenceToEventMember.setReferencedElement((NamedElement)SysMLv2Util.getEventMemberFromPort((PortUsage)port));
                eventOccurredExpression.setLeft((OperatorExpression)referenceToEventMember);
                Operator operator = SysMLv2Factory.eINSTANCE.createOperator();
                operator.setName("==");
                eventOccurredExpression.setOperator(operator);
                BooleanLiteral trueLiteral = SysMLv2Factory.eINSTANCE.createBooleanLiteral();
                trueLiteral.setValue("true");
                eventOccurredExpression.setRight((OperatorExpression)trueLiteral);
                guard.setExpression((Expression)eventOccurredExpression);
                ternaryOperatorExpression.setGuard(guard);
                ReferenceExpression callToNext = SysMLv2Factory.eINSTANCE.createReferenceExpression();
                callToNext.setReferencedElement((NamedElement)ModelUtil.NEXT);
                callToNext.setInvocation(true);
                callToNext.getArguments().add((Object)usageChainExpression);
                ternaryOperatorExpression.setLeft((OperatorExpression)callToNext);
                Operator elseOperator = SysMLv2Factory.eINSTANCE.createOperator();
                elseOperator.setName("else");
                ternaryOperatorExpression.setOperator(elseOperator);
                UsageReferenceExpression referenceToTargetVariable = SysMLv2Factory.eINSTANCE.createUsageReferenceExpression();
                referenceToTargetVariable.setReferencedElement(setterAssignment.getElement().getReferencedElement());
                ternaryOperatorExpression.setRight((OperatorExpression)referenceToTargetVariable);
                assignment2.getValue().setExpression((Expression)ternaryOperatorExpression);
                effectAction.getMembers().add((Object)assignment2);
                ++i;
            }
            effect.setAction((EObject)effectAction);
            transition.setEffect(effect);
        });
    }

    private void installSetterTransitionsForComponentInstance(PartUsage componentInstance) {
        PartDefinition component = ModelUtil.getComponentType((Part)componentInstance);
        HashMap settersSourceMap = new HashMap();
        EcoreUtil2.typeSelect((List)component.getMembers(), ActionUsage.class).stream().filter(SysMLv2Util::isSetterAction).forEach(setter -> {
            void trigger;
            List actionMembers = EcoreUtil2.typeSelect((List)setter.getMembers(), ActionUsage.class);
            if (actionMembers.isEmpty()) {
                throw new RuntimeException("No trigger in Setter action " + setter.getName() + ", inside component " + component.getName());
            }
            ActionUsage action = (ActionUsage)actionMembers.get(0);
            EObject eObject = (EObject)action.getMembers().get(0);
            if (!(eObject instanceof TriggerAction)) {
                throw new RuntimeException("Ill-formed trigger action in Setter " + setter.getName() + ". No 'accept' action found.");
            }
            TriggerAction triggerAction = (TriggerAction)eObject;
            PortUsage portUsage = (PortUsage)trigger.getPort().getReferencedElement();
            PartUsage sender = PostProcessor.getSetterSender(componentInstance, portUsage);
            settersSourceMap.putIfAbsent(sender, new ArrayList());
            ((List)settersSourceMap.get(sender)).add(setter);
        });
        List stateMachines = EcoreUtil2.typeSelect((List)component.getMembers(), StateUsage.class);
        if (stateMachines.isEmpty()) {
            return;
        }
        StateUsage targetStateMachine = (StateUsage)stateMachines.get(0);
        List states = EcoreUtil2.typeSelect((List)targetStateMachine.getMembers(), StateUsage.class);
        settersSourceMap.entrySet().stream().sorted(Comparator.comparing(entry -> ((PartUsage)entry.getKey()).getName())).forEach(entry -> {
            PartUsage sender = (PartUsage)entry.getKey();
            List actions = (List)entry.getValue();
            if (ModelUtil.isActivity((Part)sender) && component.getMembers().contains((Object)sender)) {
                List<Transition> durativeTransitions = EcoreUtil2.typeSelect((List)targetStateMachine.getMembers(), Transition.class).stream().filter(SysMLv2Util::isDurative).filter(transition -> ModelUtil.getDurativeTransitionActivity(transition) == sender).toList();
                this.installSettersIntoTransitions(actions, durativeTransitions);
            } else {
                List<Transition> loops = states.stream().map(PostProcessor::createLoopTransition).toList();
                loops.forEach(loop -> loop.setName(loop.getSource().getName() + "_setter_from_" + sender.getName()));
                this.installSettersIntoTransitions(actions, loops);
                targetStateMachine.getMembers().addAll(loops);
            }
        });
    }

    private static Pair<PortUsage, ConnectionElement> findConnectionAndEnd(PortUsage portUsage, PartUsage owningComponentInstance, List<ConnectionElement> connections) {
        return List.copyOf(connections).stream().mapMulti((connection, acceptor) -> {
            ReferenceExpression sourceReference;
            Expression expression = connection.getSource();
            if (expression instanceof ReferenceExpression && (sourceReference = (ReferenceExpression)expression).getReferencedElement() == portUsage && (ModelUtil.getConnectorEndOwner(connection.getSource()) == null || ModelUtil.getConnectorEndOwner(connection.getSource()) == owningComponentInstance)) {
                connections.remove(connection);
                PortUsage rawTarget = (PortUsage)connection.getTarget().getReferencedElement();
                acceptor.accept(new Pair((Object)rawTarget, connection));
            } else if (connection.getTarget().getReferencedElement() == portUsage && (ModelUtil.getConnectorEndOwner(connection.getTarget()) == null || ModelUtil.getConnectorEndOwner(connection.getTarget()) == owningComponentInstance)) {
                connections.remove(connection);
                PortUsage rawSource = (PortUsage)((ReferenceExpression)connection.getSource()).getReferencedElement();
                acceptor.accept(new Pair((Object)rawSource, connection));
            }
        }).findAny().orElse(new Pair((Object)portUsage, null));
    }

    private void installDanglingPorts(Resource resource) {
        EcoreUtil2.typeSelect((List)EcoreUtil2.eAllContentsAsList((Resource)resource), ReferenceExpression.class).stream().filter(reference -> {
            CalculationDefinition calculation;
            NamedElement namedElement = reference.getReferencedElement();
            return namedElement instanceof CalculationDefinition && (calculation = (CalculationDefinition)namedElement).getName().equals("havoc");
        }).forEach(reference -> {
            PartDefinition partDefinition = (PartDefinition)EcoreUtil2.getContainerOfType((EObject)reference, PartDefinition.class);
            SendUsage sendUsage = (SendUsage)EcoreUtil2.getContainerOfType((EObject)reference, SendUsage.class);
            PortUsage sendUsagePort = (PortUsage)sendUsage.getTransport().getReferencedElement();
            DirectedElement dataMember = SysMLv2Util.getDataMemberFromPort((PortUsage)sendUsagePort);
            String assignedElementName = sendUsagePort.getName().substring(4);
            AttributeUsage havocPort = SysMLv2Factory.eINSTANCE.createAttributeUsage();
            havocPort.setName("generated_" + assignedElementName + "_havoc");
            Typing typing = (Typing)EcoreUtil.copy((EObject)dataMember.getTyping());
            havocPort.setTyping(typing);
            havocPort.setDirection(Direction.IN);
            partDefinition.getMembers().add((Object)havocPort);
            reference.setReferencedElement((NamedElement)havocPort);
        });
    }
}

