/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.api.util;

import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.standardtools.utils.core.utils.Pair;
import eu.fbk.sysmlv2.sysMLv2.BooleanLiteral;
import eu.fbk.sysmlv2.sysMLv2.BoundedExpression;
import eu.fbk.sysmlv2.sysMLv2.DirectedElement;
import eu.fbk.sysmlv2.sysMLv2.EmptyExpression;
import eu.fbk.sysmlv2.sysMLv2.EnumUsage;
import eu.fbk.sysmlv2.sysMLv2.Expression;
import eu.fbk.sysmlv2.sysMLv2.ListExpression;
import eu.fbk.sysmlv2.sysMLv2.Literal;
import eu.fbk.sysmlv2.sysMLv2.NamedElement;
import eu.fbk.sysmlv2.sysMLv2.OperatorExpression;
import eu.fbk.sysmlv2.sysMLv2.PortUsage;
import eu.fbk.sysmlv2.sysMLv2.PrimaryExpression;
import eu.fbk.sysmlv2.sysMLv2.ReferenceExpression;
import eu.fbk.sysmlv2.sysMLv2.TernaryOperatorExpression;
import eu.fbk.sysmlv2.sysMLv2.UnevaluatedExpression;
import eu.fbk.sysmlv2.sysMLv2.UsageChainExpression;
import eu.fbk.sysmlv2.sysMLv2.UsageExpression;
import eu.fbk.sysmlv2.sysMLv2.UsageReferenceExpression;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class SysMLv2ToSMVExpression {
    private final Language language;
    private boolean mapEnumsToInts = true;
    private static final SysMLv2ToSMVExpression CLEANC_INSTANCE = new SysMLv2ToSMVExpression(Language.CLEANC);
    private static final SysMLv2ToSMVExpression LTL_INSTANCE = new SysMLv2ToSMVExpression(Language.LTL);
    private static final SysMLv2ToSMVExpression LTLSMV_INSTANCE = new SysMLv2ToSMVExpression(Language.LTLSMV);
    private static final SysMLv2ToSMVExpression LTLSMV_INSTANCE_WITHOUT_ENUM_MAPPING = new SysMLv2ToSMVExpression(Language.LTLSMV);
    private static final Set<String> BINARY_LTL_OPERATORS;

    static {
        SysMLv2ToSMVExpression.LTLSMV_INSTANCE_WITHOUT_ENUM_MAPPING.mapEnumsToInts = false;
        BINARY_LTL_OPERATORS = Set.of("iff", "until", "U", "releases", "V", "since", "S", "triggered", "T", "at_next", "at_last");
    }

    private SysMLv2ToSMVExpression(Language language) {
        this.language = language;
    }

    public static SysMLv2ToSMVExpression getInstance(Language language) {
        return switch (language) {
            case Language.CLEANC -> CLEANC_INSTANCE;
            case Language.LTL -> LTL_INSTANCE;
            case Language.LTLSMV -> LTLSMV_INSTANCE;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public static SysMLv2ToSMVExpression getInstance(String language) {
        return SysMLv2ToSMVExpression.getInstance(Language.fromString(language));
    }

    public static SysMLv2ToSMVExpression getLTLSMVInstanceWithoutEnumMapping() {
        return LTLSMV_INSTANCE_WITHOUT_ENUM_MAPPING;
    }

    private String serialize(UsageChainExpression expression) {
        NamedElement referencedElement = expression.getReferencedElement();
        if (referencedElement instanceof DirectedElement) {
            PortUsage portUsage;
            DirectedElement flattened;
            DirectedElement referencedDirectedElement = (DirectedElement)referencedElement;
            NamedElement namedElement = expression.getBody().getReferencedElement();
            if (namedElement instanceof PortUsage && (flattened = ModelUtil.NESTED_TO_FLATTENED.get(new Pair((Object)referencedDirectedElement, (Object)(portUsage = (PortUsage)namedElement)))) != null) {
                UsageExpression clone = (UsageExpression)EcoreUtil.copy((EObject)expression.getBody());
                clone.setReferencedElement((NamedElement)flattened);
                return this.serialize(clone);
            }
        }
        return this.serialize(expression.getBody()) + "." + expression.getReferencedElement().getName();
    }

    private String serialize(UsageExpression expression) {
        if (expression instanceof UsageReferenceExpression) {
            UsageReferenceExpression ure = (UsageReferenceExpression)expression;
            return ure.getReferencedElement().getName();
        }
        if (expression instanceof UsageChainExpression) {
            UsageChainExpression uce = (UsageChainExpression)expression;
            return this.serialize(uce);
        }
        return null;
    }

    private String serialize(PrimaryExpression expression) {
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            return this.serialize(literal);
        }
        if (expression instanceof ReferenceExpression) {
            ReferenceExpression referenceExpression = (ReferenceExpression)expression;
            return this.serialize(referenceExpression);
        }
        if (expression instanceof BoundedExpression) {
            BoundedExpression boundedExpression = (BoundedExpression)expression;
            return this.serialize(boundedExpression);
        }
        if (expression instanceof ListExpression) {
            ListExpression listExpression = (ListExpression)expression;
            return this.serialize(listExpression);
        }
        return null;
    }

    private String serialize(OperatorExpression expression) {
        if (expression instanceof PrimaryExpression) {
            PrimaryExpression primaryExpression = (PrimaryExpression)expression;
            return this.serialize(primaryExpression);
        }
        if (expression instanceof EmptyExpression) {
            return "";
        }
        if (expression.getLeft() instanceof EmptyExpression) {
            return this.serializeUnaryExpression(expression);
        }
        if (expression instanceof TernaryOperatorExpression) {
            TernaryOperatorExpression ternaryOperatorExpression = (TernaryOperatorExpression)expression;
            return this.serialize(ternaryOperatorExpression);
        }
        return this.serializeBinaryExpression(expression);
    }

    private String serialize(TernaryOperatorExpression expression) {
        return "(" + this.serialize(expression.getGuard().getExpression()) + ")" + this.translateOperator((OperatorExpression)expression) + "(" + this.serialize(expression.getLeft()) + ")" + " : " + "(" + this.serialize(expression.getRight()) + ")";
    }

    private String serializeUnaryExpression(OperatorExpression expression) {
        return this.translateOperator(expression) + this.serialize(expression.getRight());
    }

    private String serializeBinaryExpression(OperatorExpression expression) {
        StringBuilder buffer = new StringBuilder();
        String operator = this.translateOperator(expression);
        String leftExpression = this.serialize(expression.getLeft());
        String rightExpression = this.serialize(expression.getRight());
        if (" -> ".equals(operator) && this.language == Language.CLEANC) {
            String conjugatedAntecedent = "(!(" + leftExpression + "))";
            String consequent = rightExpression;
            return conjugatedAntecedent + " || " + consequent;
        }
        if (" ^ ".equals(operator)) {
            return String.format("pow(%s,%s)", leftExpression, rightExpression);
        }
        buffer.append("( ").append(leftExpression).append(operator).append(rightExpression).append(" )");
        return buffer.toString();
    }

    private String serialize(UnevaluatedExpression expression) {
        return this.serialize(expression.getExpression());
    }

    private String serialize(Literal expression) {
        String string;
        if (expression instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)expression;
            string = this.serialize(booleanLiteral);
        } else {
            string = expression.getValue();
        }
        return string;
    }

    private String serialize(BooleanLiteral booleanLiteral) {
        return this.language == Language.CLEANC ? booleanLiteral.getValue() : booleanLiteral.getValue().toUpperCase();
    }

    private String serialize(ReferenceExpression referenceExpression) {
        EnumUsage enumUsage;
        NamedElement namedElement;
        StringBuilder buffer = new StringBuilder();
        String calledElementName = referenceExpression.getReferencedElement().getName();
        if (BINARY_LTL_OPERATORS.contains(calledElementName)) {
            return buffer.append("(" + this.serialize((Expression)referenceExpression.getArguments().get(0))).append(" " + calledElementName.replace("_", " ") + " ").append(this.serialize((Expression)referenceExpression.getArguments().get(1)) + " )").toString();
        }
        if (this.mapEnumsToInts && (namedElement = referenceExpression.getReferencedElement()) instanceof EnumUsage && (enumUsage = (EnumUsage)namedElement).getValue() != null) {
            return buffer.append(this.serialize(enumUsage.getValue().getExpression())).toString();
        }
        if (referenceExpression instanceof UsageChainExpression) {
            UsageChainExpression usageChainExpression = (UsageChainExpression)referenceExpression;
            buffer.append(this.serialize(usageChainExpression));
        } else {
            buffer.append(this.transformLTLOperatorNames(calledElementName));
        }
        if (referenceExpression.isInvocation() && !referenceExpression.getArguments().isEmpty()) {
            buffer.append(this.serializeArguments(referenceExpression));
        }
        return buffer.toString();
    }

    private String transformLTLOperatorNames(String name) {
        return switch (name) {
            case "always" -> {
                if (this.language == Language.LTL) {
                    yield " always ";
                }
                yield " G ";
            }
            case "in_the_future" -> {
                if (this.language == Language.LTL) {
                    yield " in the future ";
                }
                yield " F ";
            }
            case "then" -> {
                if (this.language == Language.LTL) {
                    yield " then ";
                }
                yield " X ";
            }
            case "in_the_past" -> {
                if (this.language == Language.LTL) {
                    yield " in the past ";
                }
                yield " O ";
            }
            case "historically" -> {
                if (this.language == Language.LTL) {
                    yield " historically ";
                }
                yield " H ";
            }
            case "previously" -> {
                if (this.language == Language.LTL) {
                    yield " previously ";
                }
                yield " Y ";
            }
            case "until" -> {
                if (this.language == Language.LTL) {
                    yield " until ";
                }
                yield " U ";
            }
            case "releases" -> {
                if (this.language == Language.LTL) {
                    yield " releases ";
                }
                yield " V ";
            }
            case "since" -> {
                if (this.language == Language.LTL) {
                    yield " since ";
                }
                yield " S ";
            }
            case "triggered" -> {
                if (this.language == Language.LTL) {
                    yield " triggered ";
                }
                yield " T ";
            }
            default -> name;
        };
    }

    private String serializeArguments(ReferenceExpression expression) {
        return "(" + expression.getArguments().stream().map(this::serialize).collect(Collectors.joining(",")) + ")";
    }

    private String serialize(BoundedExpression expression) {
        return "(" + this.serialize(expression.getExpression()) + ")";
    }

    private String serialize(ListExpression expression) {
        return "(" + expression.getExpressions().stream().map(this::serialize).collect(Collectors.joining(",")) + ")";
    }

    public String serialize(Expression expression) {
        if (expression instanceof OperatorExpression) {
            OperatorExpression operatorExpression = (OperatorExpression)expression;
            return this.serialize(operatorExpression);
        }
        if (expression instanceof UnevaluatedExpression) {
            UnevaluatedExpression unevaluatedExpression = (UnevaluatedExpression)expression;
            return this.serialize(unevaluatedExpression);
        }
        return null;
    }

    private String translateOperator(OperatorExpression expression) {
        String operatorString;
        return switch (operatorString = expression.getOperator().getName().trim()) {
            case "not" -> "!";
            case "and" -> {
                if (this.language == Language.CLEANC) {
                    yield " && ";
                }
                yield " & ";
            }
            case "or" -> {
                if (this.language == Language.CLEANC) {
                    yield " || ";
                }
                yield " | ";
            }
            case "==" -> {
                if (this.language == Language.CLEANC) {
                    yield " == ";
                }
                yield " = ";
            }
            case "implies" -> {
                if (this.language == Language.LTL) {
                    yield " implies ";
                }
                yield " -> ";
            }
            default -> " " + operatorString + " ";
        };
    }

    public static enum Language {
        CLEANC,
        LTL,
        LTLSMV;

        public static final String LTL_STRING = "OCRA";
        public static final String CLEANC_STRING = "CleanC";
        public static final String LTLSMV_STRING = "LTLSMV";

        public static Language fromString(String value) {
            return switch (value) {
                case LTL_STRING -> LTL;
                case CLEANC_STRING -> CLEANC;
                case LTLSMV_STRING -> LTLSMV;
                default -> throw new IllegalArgumentException("Unexpected value for language: " + value);
            };
        }
    }
}

