/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ui;

import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.explodtwin.util.AdapterUtil;
import eu.fbk.sysmlv2.SysMLv2Activator;
import eu.fbk.sysmlv2.SysMLv2StandaloneSetup;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.xtext.EcoreUtil2;

public class ExploDTwin
implements IApplication {
    private static final String FILE_NAME = "in.sysml";
    private static final String PROJECT_NAME = "TestProject";

    public Object start(IApplicationContext context) throws Exception {
        SysMLv2StandaloneSetup.doSetup();
        System.out.println("ExploDTwin application!");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        if (!project.exists()) {
            project.create((IProgressMonitor)new NullProgressMonitor());
        }
        project.open(null);
        Path filePath = new Path(FILE_NAME);
        IFile iFile = project.getFile((IPath)filePath);
        Resource resource = AdapterUtil.getResource(iFile);
        SysMLv2Activator.populateResourceSet((ResourceSet)resource.getResourceSet());
        if (resource.getContents().size() != 1) {
            System.out.println("Resource not has a root element");
            return IApplication.EXIT_OK;
        }
        EObject top = (EObject)resource.getContents().get(0);
        PartUsage systemComponent = ModelUtil.getSystemPart((ResourceSet)EcoreUtil2.getResourceSet((Notifier)top));
        System.out.println("root = " + String.valueOf(systemComponent));
        AdapterUtil.generateOCRA(systemComponent, 1);
        AdapterUtil.generateSMV(systemComponent, 1);
        ResourcesPlugin.getWorkspace().save(true, null);
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }
}

