/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ui.commands;

import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.explodtwin.api.util.PostProcessor;
import eu.fbk.eclipse.standardtools.utils.ui.utils.CommandBuilder;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.tools.adapter.ui.commands.AbstractBaseCommand;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;

public abstract class AbstractBaseCheck
extends AbstractBaseCommand {
    public AbstractBaseCheck() {
        super("");
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.preprocessEvent(event);
        IWorkbenchPart part = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getActivePart();
        if (part instanceof XtextEditor) {
            IXtextDocument xtextDocument = EditorUtils.getActiveXtextEditor().getDocument();
            xtextDocument.readOnly(xtextResource -> {
                this.processSysMLModel((Resource)xtextResource);
                return true;
            });
        }
        return null;
    }

    protected void openVResults() {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(() -> {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    page.showView("eu.fbk.tools.adapter.ui.views.request.RequestView");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public void showResult(String functionName, String fileName) {
        String commandId = "eu.fbk.tools.adapter.ui.commands.ShowVVResultCommand";
        String functionNameParam = "function_name";
        String fileNameParam = "result_file";
        try {
            CommandBuilder computeFaultTree = CommandBuilder.build((String)commandId);
            computeFaultTree.setParameter(functionNameParam, functionName);
            computeFaultTree.setParameter(fileNameParam, fileName);
            computeFaultTree.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected PartUsage getSystemPart(ResourceSet resourceSet) {
        try {
            return ModelUtil.getSystemPart((ResourceSet)resourceSet);
        }
        catch (Exception e) {
            DialogUtil.getInstance().showMessage_ExceptionError(e);
            return null;
        }
    }

    protected ResourceSet createWorkingCopy(ResourceSet resourceSet) {
        XtextResourceSet newResourceSet = new XtextResourceSet();
        resourceSet.getResources().forEach(arg_0 -> AbstractBaseCheck.lambda$2((ResourceSet)newResourceSet, arg_0));
        boolean isExplodtwin = ModelUtil.isExplodtwin((ResourceSet)newResourceSet);
        new PostProcessor((ResourceSet)newResourceSet, isExplodtwin).performPostProcessing();
        return newResourceSet;
    }

    protected abstract void processSysMLModel(Resource var1);

    private static /* synthetic */ void lambda$2(ResourceSet resourceSet, Resource originalResource) {
        EObject rootEObject = (EObject)originalResource.getContents().get(0);
        String originalResourceText = NodeModelUtils.getNode((EObject)rootEObject).getText();
        XtextResource newResource = (XtextResource)resourceSet.createResource(originalResource.getURI());
        try {
            newResource.reparse(originalResourceText);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

