/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ui.commands;

import eu.fbk.eclipse.explodtwin.api.core.SysMLv2StateMachineModel;
import eu.fbk.eclipse.explodtwin.api.core.SysMLv2SystemModel;
import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.explodtwin.ui.commands.AbstractBaseToolCommand;
import eu.fbk.eclipse.explodtwin.util.AdapterUtil;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.ui.services.OSSTranslatorServiceUI;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.ui.services.SmvExportServiceUI;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ocra.CheckContractImplementation;
import eu.fbk.tools.adapter.ocra.OcraFunction;
import eu.fbk.tools.adapter.ui.Activator;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;

public class CheckContractImplementationEATA
extends AbstractBaseToolCommand {
    private static final Logger logger = Logger.getLogger(CheckContractImplementationEATA.class);
    private SysMLv2SystemModel systemModel = new SysMLv2SystemModel();
    private final SmvExportServiceUI smvExportService = SmvExportServiceUI.getInstance((AbstractSystemModel)this.systemModel, (AbstractStateMachineModel)new SysMLv2StateMachineModel());
    private final OSSTranslatorServiceUI ossTranslatorService = OSSTranslatorServiceUI.getInstance((AbstractSystemModel)this.systemModel);
    private CheckContractImplementation function;
    private String behaviourFileName = null;
    private String ossModelFileName = null;
    private boolean processResult = false;

    public CheckContractImplementationEATA() {
        super("OCRA", "Check Contract Implementation", "tools.ocra.executable", "tools.ocra.timeout");
    }

    protected boolean initialize() {
        this.behaviourFileName = null;
        this.ossModelFileName = null;
        this.function = new CheckContractImplementation();
        return super.initialize();
    }

    public boolean preprocessEvent(ExecutionEvent event) {
        IWorkbenchPart part = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getActivePart();
        if (part instanceof XtextEditor) {
            IXtextDocument xtextDocument = EditorUtils.getActiveXtextEditor().getDocument();
            xtextDocument.readOnly(xtextResource -> {
                this.processResult = this.processSysMLModel((Resource)xtextResource);
                return this.processResult;
            });
        }
        return this.processResult;
    }

    private boolean processSysMLModel(Resource resource) {
        PartUsage system;
        if (resource.getContents().isEmpty()) {
            logger.error((Object)"Resource hasn't got a root element.");
            return false;
        }
        EObject model = (EObject)resource.getContents().get(0);
        ResourceSet workingCopy = this.createWorkingCopy(EcoreUtil2.getResourceSet((Notifier)model));
        List partUsages = ModelUtil.getAllContentsOfTypeFromModel((ResourceSet)workingCopy, PartUsage.class);
        partUsages.sort((part1, part2) -> part1.getName().compareTo(part2.getName()));
        try {
            system = ModelUtil.getSystemPart((ResourceSet)workingCopy);
        }
        catch (Exception e) {
            DialogUtil.getInstance().showMessage_ExceptionError(e);
            return false;
        }
        partUsages.add(0, system);
        PartUsage selectedPartUsage = AdapterUtil.getSelectedPart(this.activeShell, partUsages);
        if (selectedPartUsage == null) {
            return false;
        }
        int timeSpecification = MessageTimeModelDialog.openQuestion((boolean)true);
        if (timeSpecification < 0) {
            return false;
        }
        String workspaceDir = Activator.getDefault().getPreferenceStore().getString("tools.workspace");
        SubMonitor monitorSub = SubMonitor.convert((IProgressMonitor)new NullProgressMonitor(), (String)"Executing compositional verification ...", (int)100);
        try {
            this.behaviourFileName = this.smvExportService.exportSingleSmv((Object)selectedPartUsage, false, workspaceDir, (IProgressMonitor)monitorSub, timeSpecification);
            File ossFile = this.ossTranslatorService.exportRootComponentToOssFile((Object)selectedPartUsage, resource, timeSpecification, true, true, false, workspaceDir, (IProgressMonitor)monitorSub);
            this.ossModelFileName = ossFile.getAbsolutePath();
        }
        catch (Exception e) {
            DialogUtil.getInstance().showMessage_ExceptionError(e);
            e.printStackTrace();
            return false;
        }
        this.function.setBehaviourModel(FileUtils.stringToURI((String)this.behaviourFileName));
        this.function.setContractModel(FileUtils.stringToURI((String)this.ossModelFileName));
        this.function.setOldSmvFormat(Boolean.valueOf(false));
        this.function.setComponentName(this.systemModel.getComponentTypeName((Object)selectedPartUsage));
        OcraFunction.TimeModel timeModel = OcraFunction.TimeModel.discrete;
        switch (timeSpecification) {
            case 0: {
                timeModel = OcraFunction.TimeModel.hybrid;
                break;
            }
            case 1: {
                timeModel = OcraFunction.TimeModel.discrete;
                break;
            }
            case 2: {
                timeModel = OcraFunction.TimeModel.timed;
            }
        }
        this.function.setTimeModel(timeModel);
        return true;
    }

    protected ToolFunction getFunction() {
        return this.function;
    }
}

