/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ui.commands;

import eu.fbk.eclipse.explodtwin.api.core.SysMLv2SystemModel;
import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.explodtwin.ui.commands.AbstractBaseCheck;
import eu.fbk.eclipse.explodtwin.util.AdapterUtil;
import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services.OCRAExecService;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADirectoryUtil;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;

public class CheckContractRefinement
extends AbstractBaseCheck {
    private static final Logger logger = Logger.getLogger(CheckContractRefinement.class);
    private SysMLv2SystemModel systemModel = new SysMLv2SystemModel();
    private final OCRAExecService ocraService = OCRAExecService.getInstance((AbstractSystemModel)this.systemModel);
    final OCRADirectoryUtil ocraDirectoryUtil = OCRADirectoryUtil.getInstance();

    @Override
    protected void processSysMLModel(Resource resource) {
        if (resource.getContents().isEmpty()) {
            logger.error((Object)"Resource hasn't got a root element.");
            return;
        }
        EObject model = (EObject)resource.getContents().get(0);
        ResourceSet workingCopy = this.createWorkingCopy(EcoreUtil2.getResourceSet((Notifier)model));
        List partUsages = ModelUtil.getAllContentsOfTypeFromModel((ResourceSet)workingCopy, PartUsage.class);
        partUsages.sort((part1, part2) -> part1.getName().compareTo(part2.getName()));
        PartUsage system = this.getSystemPart(workingCopy);
        if (system == null) {
            return;
        }
        partUsages.add(0, system);
        PartUsage selectedPartUsage = AdapterUtil.getSelectedPart(this.activeShell, partUsages);
        if (selectedPartUsage == null) {
            return;
        }
        int timeSpecification = MessageTimeModelDialog.openQuestion((boolean)true);
        if (timeSpecification < 0) {
            return;
        }
        try {
            String ossDirPath = this.ocraDirectoryUtil.getOSSDirPath();
            String resultFile = this.ocraDirectoryUtil.getCommandCheckRefinementResultPath(selectedPartUsage.getName());
            SubMonitor monitorSub = SubMonitor.convert((IProgressMonitor)new NullProgressMonitor(), (String)"Executing compositional verification ...", (int)100);
            this.ocraService.executeCheckContractRefinement((Object)selectedPartUsage, null, null, resource, timeSpecification, true, true, false, ossDirPath, resultFile, (IProgressMonitor)monitorSub.split(60, 0), true, true, false);
        }
        catch (Exception e) {
            DialogUtil.getInstance().showMessage_ExceptionError(e);
            e.printStackTrace();
            return;
        }
        this.openVResults();
    }
}

