/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ui.commands;

import eu.fbk.eclipse.explodtwin.api.core.ModelLibrary;
import eu.fbk.eclipse.explodtwin.api.core.SysMLv2SystemModel;
import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.explodtwin.ui.commands.AbstractBaseCheck;
import eu.fbk.eclipse.explodtwin.ui.dialogs.CheckDiagnosabilityParametersDialog;
import eu.fbk.eclipse.explodtwin.util.AdapterUtil;
import eu.fbk.eclipse.standardTools.XSapExecService.services.XSapExecService;
import eu.fbk.eclipse.standardtools.nuXmvService.ui.utils.NuXmvDirectoryUtil;
import eu.fbk.eclipse.standardtools.utils.core.utils.FileSystemUtil;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.ErrorsDialogUtil;
import eu.fbk.sysmlv2.sysMLv2.AttributeUsage;
import eu.fbk.sysmlv2.sysMLv2.NamedElement;
import eu.fbk.sysmlv2.sysMLv2.Part;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.sysmlv2.sysMLv2.Usage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;

public class CheckDiagnosability
extends AbstractBaseCheck {
    private static final Logger logger = Logger.getLogger(CheckDiagnosability.class);
    private static final String OBS_NAME = "observables.obs";
    private static final String ALARM_NAME = "alarm.asl";
    private final XSapExecService xSapExecService = XSapExecService.getInstance();
    private final SysMLv2SystemModel sysML2SystemModel = new SysMLv2SystemModel();
    protected final NuXmvDirectoryUtil nuXmvDirectoryUtil = NuXmvDirectoryUtil.getInstance();
    private final ModelLibrary modelLibrary = new ModelLibrary();

    @Override
    protected void processSysMLModel(Resource resource) {
        if (resource.getContents().isEmpty()) {
            logger.error((Object)"Resource hasn't got a root element.");
            return;
        }
        EObject rootElement = (EObject)resource.getContents().get(0);
        int timeSpecification = MessageTimeModelDialog.openQuestion((boolean)true);
        if (timeSpecification < 0) {
            return;
        }
        ResourceSet workingCopy = this.createWorkingCopy(EcoreUtil2.getResourceSet((Notifier)rootElement));
        PartUsage system = this.getSystemPart(workingCopy);
        if (system == null) {
            ErrorsDialogUtil.getInstance().showMessage_GenericError("No system components are defined in the model, please define one.");
            return;
        }
        String smvPath = AdapterUtil.generateSMV(system, timeSpecification);
        AdapterUtil.GeneratedFiles files = null;
        try {
            files = AdapterUtil.prepareExpandedFiles(system, smvPath);
            if (files == null) {
                return;
            }
        }
        catch (Exception e) {
            DialogUtil.getInstance().showMessage_ExceptionError(e);
            e.printStackTrace();
        }
        String rootName = ModelUtil.getPartDefinition((PartUsage)system).getName();
        List<String> observablesList = this.computeObservables(system, null);
        if (observablesList == null) {
            return;
        }
        CheckDiagnosabilityParametersDialog dialog = new CheckDiagnosabilityParametersDialog(this.activeShell, observablesList);
        dialog.open();
        if (dialog.goAhead()) {
            String engine = dialog.getAlgorithmType();
            String alarmPattern = dialog.getType();
            String alarmPath = null;
            String condition = dialog.getCondition();
            int delayBound = dialog.getDelayBound();
            int bmcLength = dialog.getBoundLength();
            String context = dialog.getContext();
            List<String> observables = this.addRootName(dialog.getObservables(), rootName);
            File obsFile = null;
            File alarmFile = null;
            try {
                obsFile = this.createObservablesFile(this.nuXmvDirectoryUtil.getSmvTempDirectory(), OBS_NAME, observables);
                alarmFile = this.createAlarmFile(this.nuXmvDirectoryUtil.getSmvTempDirectory(), ALARM_NAME, condition, alarmPattern, context, delayBound);
            }
            catch (Exception e) {
                DialogUtil.getInstance().showMessage_ExceptionError(e);
                e.printStackTrace();
            }
            String filesMessage = "Alarm file is stored in: " + alarmFile.getAbsolutePath() + System.lineSeparator() + System.lineSeparator() + "Observables file is stored in: " + obsFile.getAbsolutePath();
            DialogUtil.getInstance().showMessage_GenericMessage("Check Diagnosability", filesMessage);
            String observablesPath = obsFile.getAbsolutePath();
            boolean needMsat = ModelUtil.usesInfiniteDomainVariables((EObject)rootElement);
            this.xSapExecService.checkDiagnosability(files.extendedSmvFileName(), engine, bmcLength, alarmPattern, alarmPath, observablesPath, condition, delayBound, context, needMsat, true);
            this.openVResults();
        }
    }

    private List<String> addRootName(List<String> observables, String rootName) {
        ArrayList<String> qualObservables = new ArrayList<String>();
        for (String observable : observables) {
            qualObservables.add((String)(observable.contains(".") ? rootName + "." + observable : observable));
        }
        return qualObservables;
    }

    private File createAlarmFile(String smvTempDirectory, String alarmName, String condition, String alarmPattern, String context, int delayBound) throws IOException {
        Object content = "NAME: alarm1" + System.lineSeparator();
        content = ((String)content).concat("CONDITION: " + condition + System.lineSeparator());
        if (alarmPattern != null && !alarmPattern.isBlank()) {
            content = ((String)content).concat("TYPE: " + alarmPattern + System.lineSeparator());
        }
        if (context != null && !context.isBlank()) {
            content = ((String)content).concat("CONTEXT: " + context + System.lineSeparator());
        }
        if (delayBound > 0) {
            content = ((String)content).concat("DELAY: " + delayBound + System.lineSeparator());
        }
        File alarmFile = new File(smvTempDirectory + File.separator + alarmName);
        FileSystemUtil.writeFile((File)alarmFile, (String)content);
        return alarmFile;
    }

    private File createObservablesFile(String smvTempDirectory, String obsName, List<String> observables) throws IOException {
        String content = "";
        for (String observable : observables) {
            content = content.concat(observable + System.lineSeparator());
        }
        File obsFile = new File(smvTempDirectory + File.separator + obsName);
        FileSystemUtil.writeFile((File)obsFile, (String)content);
        return obsFile;
    }

    private List<String> computeObservables(PartUsage component, String prefix) {
        ArrayList<String> observables = new ArrayList<String>();
        for (AttributeUsage observable : this.modelLibrary.getObservableVariables(component)) {
            if (ModelUtil.isInfiniteDomainVariable((Usage)observable)) {
                this.displayError("CheckDiagnosability", "The variable \"" + ((NamedElement)observable.eContainer()).getName() + ":" + observable.getName() + "\" is of infinite domain type and cannot be observed.");
                return null;
            }
            observables.add(this.addToPrefix(prefix, observable.getName()));
        }
        if (ModelUtil.getNominalStateMachinesOfComponent((Part)component).size() != 0) {
            observables.add(this.addToPrefix(prefix, "State"));
        }
        for (Object instance : this.sysML2SystemModel.getSubComponentsInstances((Object)component)) {
            String newPrefix = this.addToPrefix(prefix, this.sysML2SystemModel.getName(instance));
            observables.addAll(this.computeObservables((PartUsage)instance, newPrefix));
        }
        return observables;
    }

    private String addToPrefix(String prefix, String instance) {
        return prefix != null ? prefix + "." + instance : instance;
    }
}

