/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ui.commands;

import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.explodtwin.ui.commands.AbstractBaseToolCommand;
import eu.fbk.eclipse.explodtwin.ui.dialogs.ModelCheckingParametersDialog;
import eu.fbk.eclipse.explodtwin.util.AdapterUtil;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.nuxmv.CheckModel;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;

public class CheckFaultSmvModelEATA
extends AbstractBaseToolCommand {
    private CheckModel function;
    private String behaviourFileName;
    private boolean useFaultyModel;
    private EObject rootElement;
    private PartUsage selectedPartUsage;
    private PartUsage system;

    public CheckFaultSmvModelEATA() {
        super("nuXmv", "", "tools.nuxmv.executable", "tools.nuxmv.timeout");
    }

    protected boolean initialize() {
        this.behaviourFileName = null;
        this.function = new CheckModel();
        return super.initialize();
    }

    protected ToolFunction getFunction() {
        return this.function;
    }

    public boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        IWorkbenchPart part = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getActivePart();
        int timeSpecification = MessageTimeModelDialog.openQuestion((boolean)true);
        if (timeSpecification < 0) {
            return false;
        }
        if (part instanceof XtextEditor) {
            IXtextDocument xtextDocument = EditorUtils.getActiveXtextEditor().getDocument();
            this.behaviourFileName = (String)xtextDocument.readOnly(xtextResource -> {
                this.rootElement = (EObject)xtextResource.getContents().get(0);
                ResourceSet workingCopy = this.createWorkingCopy(EcoreUtil2.getResourceSet((Notifier)this.rootElement));
                List partUsages = ModelUtil.getAllContentsOfTypeFromModel((ResourceSet)workingCopy, PartUsage.class);
                partUsages.sort((part1, part2) -> part1.getName().compareTo(part2.getName()));
                try {
                    this.system = ModelUtil.getSystemPart((ResourceSet)workingCopy);
                }
                catch (Exception e) {
                    DialogUtil.getInstance().showMessage_ExceptionError(e);
                    return null;
                }
                partUsages.add(0, this.system);
                this.selectedPartUsage = AdapterUtil.getSelectedPart(this.activeShell, partUsages);
                if (this.selectedPartUsage == null) {
                    return null;
                }
                return AdapterUtil.generateSMV(this.selectedPartUsage, timeSpecification);
            });
        }
        if (this.behaviourFileName == null) {
            return false;
        }
        this.function.setBehaviourModel(FileUtils.stringToURI((String)this.behaviourFileName));
        if (timeSpecification == 2) {
            this.function.setTimed(true);
        }
        this.function.enableAbstraction(ModelUtil.usesInfiniteDomainVariables((EObject)this.rootElement));
        Display display = PlatformUI.getWorkbench().getDisplay();
        ModelCheckingParametersDialog dialog = new ModelCheckingParametersDialog(this.activeShell, "Model Checking Analysis Parameters", this.function, this.asyncExecution, this.selectedPartUsage, this.system);
        display.syncExec(() -> ((ModelCheckingParametersDialog)dialog).open());
        if (!dialog.goAhead()) {
            return false;
        }
        this.asyncExecution = dialog.getAsyncExecution();
        this.useFaultyModel = dialog.isFaultModel();
        if (this.selectedPartUsage == this.system && this.useFaultyModel) {
            AdapterUtil.GeneratedFiles files;
            block10: {
                files = AdapterUtil.prepareExpandedFiles(this.system, this.behaviourFileName);
                if (files != null) break block10;
                return false;
            }
            try {
                this.behaviourFileName = files.extendedSmvFileName();
                this.function.setBehaviourModel(FileUtils.stringToURI((String)this.behaviourFileName));
            }
            catch (Exception e) {
                DialogUtil.getInstance().showMessage_ExceptionError(e);
                e.printStackTrace();
            }
        }
        this.function.setFormula(this.function.getFormula() + " IN " + ModelUtil.getPartDefinition((PartUsage)this.selectedPartUsage).getName());
        return true;
    }
}

