/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ui.commands;

import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.explodtwin.ui.commands.AbstractBaseCheck;
import eu.fbk.eclipse.explodtwin.ui.dialogs.ComputeFaultTreeParametersDialog;
import eu.fbk.eclipse.explodtwin.util.AdapterUtil;
import eu.fbk.eclipse.standardTools.XSapExecService.services.XSapExecService;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.ErrorsDialogUtil;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;

public class FaultTreeAnalysis
extends AbstractBaseCheck {
    private static final Logger logger = Logger.getLogger(FaultTreeAnalysis.class);
    private final XSapExecService xSapExecService = XSapExecService.getInstance();

    @Override
    protected void processSysMLModel(Resource resource) {
        if (resource.getContents().isEmpty()) {
            logger.error((Object)"Resource hasn't got a root element.");
            return;
        }
        EObject model = (EObject)resource.getContents().get(0);
        int timeSpecification = MessageTimeModelDialog.openQuestion((boolean)true);
        if (timeSpecification < 0) {
            return;
        }
        ResourceSet workingCopy = this.createWorkingCopy(EcoreUtil2.getResourceSet((Notifier)model));
        PartUsage system = this.getSystemPart(workingCopy);
        if (system == null) {
            ErrorsDialogUtil.getInstance().showMessage_GenericError("No system components are defined in the model, please define one.");
            return;
        }
        String smvPath = AdapterUtil.generateSMV(system, timeSpecification);
        AdapterUtil.GeneratedFiles files = null;
        try {
            files = AdapterUtil.prepareExpandedFiles(system, smvPath);
            if (files == null) {
                return;
            }
        }
        catch (Exception e) {
            DialogUtil.getInstance().showMessage_ExceptionError(e);
            e.printStackTrace();
        }
        ComputeFaultTreeParametersDialog dialog = new ComputeFaultTreeParametersDialog(this.activeShell);
        dialog.open();
        if (dialog.goAhead()) {
            this.xSapExecService.computeFt(files.extendedSmvFileName(), files.fmsFileName(), dialog.getProperties(), files.ftFileName(), true, ModelUtil.getPartDefinition((PartUsage)system).getName(), dialog.getAlgorithmType(), dialog.getBoundLength());
            this.showResult("xsap_compute_fault_tree", files.ftFileName());
        }
    }
}

