/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ui.commands;

import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.explodtwin.ui.commands.AbstractBaseCheck;
import eu.fbk.eclipse.explodtwin.util.AdapterUtil;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.sysmlv2.sysMLv2.Model;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;

public class GenerateSmvModel
extends AbstractBaseCheck {
    private static final Logger logger = Logger.getLogger(GenerateSmvModel.class);

    @Override
    protected void processSysMLModel(Resource resource) {
        if (resource.getContents().isEmpty()) {
            logger.error((Object)"Resource hasn't got a root element.");
            return;
        }
        Model model = (Model)resource.getContents().get(0);
        ResourceSet workingCopy = this.createWorkingCopy(EcoreUtil2.getResourceSet((Notifier)model));
        List partUsages = ModelUtil.getAllContentsOfTypeFromModel((ResourceSet)workingCopy, PartUsage.class);
        partUsages.sort((part1, part2) -> part1.getName().compareTo(part2.getName()));
        PartUsage system = this.getSystemPart(workingCopy);
        if (system == null) {
            return;
        }
        partUsages.add(0, system);
        int timeSpecification = MessageTimeModelDialog.openQuestion((boolean)true);
        if (timeSpecification < 0) {
            return;
        }
        PartUsage selectedPartUsage = AdapterUtil.getSelectedPart(this.activeShell, partUsages);
        if (selectedPartUsage == null) {
            return;
        }
        String behaviourFileName = AdapterUtil.generateSMV(selectedPartUsage, timeSpecification);
        if (behaviourFileName != null) {
            DialogUtil.getInstance().showMessage_ExportBehaviourDone(behaviourFileName, "smv");
        } else {
            DialogUtil.getInstance().showMessage_GenericMessage("Export error", "The selected component does not have a state machine.");
        }
    }
}

