/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ui.dialogs;

import eu.fbk.tools.adapter.xsap.XsapFunction;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CheckDiagnosabilityParametersDialog
extends Dialog {
    private Combo algorithmTypeCombo;
    private Combo alarmTypeCombo;
    private Text conditionText;
    private Text contextText;
    private Spinner delayBoundSpinner;
    private Spinner boundLengthSpinner;
    private List<String> observableList;
    private Table observables;
    private Button allObservables;
    private String[] algorithmTypes = new String[]{"bdd", "bmc", "ic3", "msat_bmc"};
    private String[] alarmTypes = new String[]{"finite", "exact", "bounded"};
    private boolean goAhead = false;
    private String condition;
    private String context;
    private String alarmType;
    private int boundLength;
    private int delayBound;
    private XsapFunction.AlgorithmType algorithmType;
    private List<String> selectedObservables;

    public CheckDiagnosabilityParametersDialog(Shell parentShell, List<String> observableList) {
        super(parentShell);
        this.setShellStyle(48);
        this.observableList = observableList;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Check Diagnosability Parameters");
    }

    protected void okPressed() {
        this.condition = this.conditionText.getText();
        this.alarmType = this.alarmTypeCombo.getItem(this.alarmTypeCombo.getSelectionIndex());
        this.context = this.contextText.getText();
        this.delayBound = this.delayBoundSpinner.getSelection();
        this.algorithmType = XsapFunction.AlgorithmType.valueOf((String)this.algorithmTypeCombo.getItems()[this.algorithmTypeCombo.getSelectionIndex()]);
        this.boundLength = this.boundLengthSpinner.getSelection();
        this.selectedObservables = new ArrayList<String>();
        TableItem[] tableItemArray = this.observables.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                this.selectedObservables.add(item.getText());
            }
            ++n2;
        }
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite dialogContainer = new Composite(container, 0);
        dialogContainer.setLayout((Layout)new GridLayout(2, false));
        dialogContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        Label title1 = new Label(dialogContainer, 0);
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)title1.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)title1.getDisplay());
        title1.setFont(boldFont);
        title1.setText("Configure the alarm:");
        title1.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        Label lblProperties = new Label(dialogContainer, 0);
        lblProperties.setText("Condition");
        this.conditionText = new Text(dialogContainer, 2052);
        this.conditionText.setLayoutData((Object)new GridData(768));
        this.conditionText.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                CheckDiagnosabilityParametersDialog.this.getButton(0).setEnabled(!CheckDiagnosabilityParametersDialog.this.conditionText.getText().equals(""));
            }
        });
        Label lblAlarmType = new Label(dialogContainer, 0);
        lblAlarmType.setText("Type");
        this.alarmTypeCombo = new Combo(dialogContainer, 8);
        this.alarmTypeCombo.setLayoutData((Object)new GridData(768));
        this.setComboValues(this.alarmTypeCombo, this.alarmTypes);
        this.alarmTypeCombo.select(0);
        Label lblContext = new Label(dialogContainer, 0);
        lblContext.setText("Context");
        this.contextText = new Text(dialogContainer, 2052);
        this.contextText.setLayoutData((Object)new GridData(768));
        Label lblDelayBound = new Label(dialogContainer, 0);
        lblDelayBound.setText("Delay Bound");
        this.delayBoundSpinner = new Spinner(dialogContainer, 2048);
        this.delayBoundSpinner.setLayoutData((Object)new GridData(768));
        this.delayBoundSpinner.setMinimum(0);
        this.delayBoundSpinner.setMaximum(100);
        this.delayBoundSpinner.setIncrement(1);
        this.delayBoundSpinner.setPageIncrement(10);
        Label emptyLine1 = new Label(dialogContainer, 256);
        emptyLine1.setLayoutData((Object)new GridData(768, 1040, true, false, 2, 1));
        Label title2 = new Label(dialogContainer, 0);
        title2.setFont(boldFont);
        title2.setText("Configure the engine:");
        title2.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        Label lblAlgorithm = new Label(dialogContainer, 0);
        lblAlgorithm.setText("Algorithm Type");
        this.algorithmTypeCombo = new Combo(dialogContainer, 8);
        this.algorithmTypeCombo.setLayoutData((Object)new GridData(768));
        this.setComboValues(this.algorithmTypeCombo, this.algorithmTypes);
        this.algorithmTypeCombo.select(3);
        Label lblBoundLength = new Label(dialogContainer, 0);
        lblBoundLength.setText("Bound Length");
        this.boundLengthSpinner = new Spinner(dialogContainer, 2048);
        this.boundLengthSpinner.setLayoutData((Object)new GridData(768));
        this.boundLengthSpinner.setMinimum(0);
        this.boundLengthSpinner.setMaximum(100);
        this.boundLengthSpinner.setSelection(10);
        this.boundLengthSpinner.setIncrement(1);
        this.boundLengthSpinner.setPageIncrement(10);
        Label emptyLine2 = new Label(dialogContainer, 256);
        emptyLine2.setLayoutData((Object)new GridData(768, 1040, true, false, 2, 1));
        Label title3 = new Label(dialogContainer, 0);
        title3.setFont(boldFont);
        title3.setText("Select the observable variables:");
        title3.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.allObservables = new Button(dialogContainer, 32);
        this.allObservables.setText("Select all observables");
        this.allObservables.setSelection(false);
        this.allObservables.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (CheckDiagnosabilityParametersDialog.this.allObservables.getSelection()) {
                    this.setSelected(CheckDiagnosabilityParametersDialog.this.observables, true);
                } else {
                    this.setSelected(CheckDiagnosabilityParametersDialog.this.observables, false);
                }
            }

            private void setSelected(Table observables, boolean selected) {
                TableItem[] tableItemArray = observables.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(selected);
                    ++n2;
                }
            }
        });
        GridData tableGridData = new GridData(4, 4, true, true, 2, 1);
        tableGridData.heightHint = 145;
        this.observables = new Table(dialogContainer, 2848);
        this.observables.setLayoutData((Object)tableGridData);
        for (String observable : this.observableList) {
            TableItem item = new TableItem(this.observables, 0);
            item.setText(observable);
        }
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(false);
    }

    protected Point getInitialSize() {
        return new Point(500, 560);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    private void setComboValues(Combo combo, String[] admittedValues) {
        combo.setItems(admittedValues);
    }

    public String getCondition() {
        return this.condition;
    }

    public int getBoundLength() {
        return this.boundLength;
    }

    public String getAlgorithmType() {
        return this.algorithmType.toString();
    }

    public String getType() {
        return this.alarmType;
    }

    public int getDelayBound() {
        return this.delayBound;
    }

    public String getContext() {
        return this.context;
    }

    public List<String> getObservables() {
        return this.selectedObservables;
    }
}

